/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sed.repay;

import com.irdstudio.basic.framework.core.exception.ExternalSysException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToLocal;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqLoanBalanceBean;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqLoanInfoQueryBean;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqRepaymentDetailsInfoQueryBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.AcctDtlInfBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespLoanBalanceQueryBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespLoanInfoQueryBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespRepaymentPlanListQueryBean;
import com.irdstudio.efp.esb.service.facade.hj.LoanInfoQueryService;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayPlanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayPlanVO;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.service.impl.sed.repay.RepaySoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="synInfoAfterRepayService")
public class SynInfoAfterRepayServiceImpl
extends RepaySoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(SynInfoAfterRepayServiceImpl.class);
    private static final Map<String, String> openDayMap = new HashMap<String, String>();
    private static final Map<String, String> termIsOverDueMap = new HashMap<String, String>();
    @Autowired
    @Qualifier(value="loanInfoQueryService")
    LoanInfoQueryService loanInfoQueryService;
    @Autowired
    @Qualifier(value="accLoanService")
    AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="accLoanRepayPlanService")
    LoanRepayPlanService loanRepayPlanService;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, LoanRepayDetailVO loanRepayDetailVO) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        String loanNo = loanRepayDetailVO.getLoanNo();
        RespLoanInfoQueryBean respLoanInfo = null;
        RespRepaymentPlanListQueryBean respRepayPlan = null;
        RespLoanBalanceQueryBean respLoanBalanceQueryBean = null;
        String exceptionLocation = loanRepayDetailVO.getExceptionLocation();
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        try {
            if (StringUtil.isNotEmpty((String)exceptionLocation)) {
                logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u91cd\u8dd1\u5f00\u59cb,\u5f02\u5e38\u6807\u8bc6\u4e3a:" + exceptionLocation + "<======");
            }
            AccLoanVO accLoanVO = new AccLoanVO();
            accLoanVO.setBillNo(loanNo);
            accLoanVO = this.accLoanService.queryByPk(accLoanVO);
            if (Objects.isNull(accLoanVO)) {
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u901a\u8fc7\u501f\u636e\u53f7\u3010" + loanNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String loanSeq = accLoanVO.getLoanSeq();
            String distrNo = accLoanVO.getDistrNo();
            ReqLoanInfoQueryBean reqLoanInfoQueryBean = new ReqLoanInfoQueryBean();
            ReqRepaymentDetailsInfoQueryBean reqRepaymentDetailsInfoQueryBean = new ReqRepaymentDetailsInfoQueryBean();
            ReqLoanBalanceBean reqLoanBalanceBean = new ReqLoanBalanceBean();
            try {
                logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u501f\u636e\u4fe1\u606f\u5f00\u59cb---------------------");
                reqLoanInfoQueryBean.setLoanNo(loanSeq);
                reqLoanInfoQueryBean.setDistrNo(distrNo);
                logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u501f\u636e\u4fe1\u606f\u7ed3\u675f---------------------");
                logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8fd8\u6b3e\u8ba1\u5212\u660e\u7ec6\u5f00\u59cb---------------------");
                reqRepaymentDetailsInfoQueryBean.setAcctNo(loanSeq);
                reqRepaymentDetailsInfoQueryBean.setDistrNo(distrNo);
                logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8fd8\u6b3e\u8ba1\u5212\u660e\u7ec6\u7ed3\u675f---------------------");
                logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8d37\u6b3e\u4f59\u989d\u5f00\u59cb---------------------");
                reqLoanBalanceBean.setLoanNo(loanSeq);
                reqLoanBalanceBean.setDistrNo(distrNo);
                logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8d37\u6b3e\u4f59\u989d\u7ed3\u675f---------------------");
            }
            catch (Exception e) {
                throw new ExternalSysException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u540c\u6b65\u501f\u636e\u3001\u8fd8\u6b3e\u8ba1\u5212\uff0c\u8c03\u7528\u4e92\u91d1\u63a5\u53e3\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            }
            if (StringUtil.isNullorBank((String)exceptionLocation) || SedNlsEnum.ExceptionLocation.INSERT_LOAN_PLAN_AFTER_REPAY.getValue().equals(exceptionLocation)) {
                this.synLoanRepayPlan(respRepayPlan, accLoanVO);
            }
            this.synAccLoan(accLoanVO, respLoanInfo, respLoanBalanceQueryBean);
        }
        catch (Exception e) {
            logger.error("--------\u6267\u884c\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            logger.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
        finally {
            logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        }
    }

    private void synLoanRepayPlan(RespRepaymentPlanListQueryBean respRepayPlan, AccLoanVO accLoanVO) throws OcmSystemException {
        String loanNo = accLoanVO.getBillNo();
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u5f00\u59cb,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        try {
            List localLRPVoLists = this.loanRepayPlanService.qryAllByLoanNo(loanNo);
            if (null == localLRPVoLists || localLRPVoLists.isEmpty()) {
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u901a\u8fc7\u501f\u636e\u53f7\u3010" + loanNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            HashMap<String, String> termClearDateMap = new HashMap<String, String>();
            for (LoanRepayPlanVO lRepPlanVO : localLRPVoLists) {
                termIsOverDueMap.put(lRepPlanVO.getTerm().toString(), lRepPlanVO.getIsOverDue());
                termClearDateMap.put(lRepPlanVO.getTerm().toString(), lRepPlanVO.getClearDate());
            }
            int deleteNum = this.loanRepayPlanService.deleteByLoanNo(loanNo);
            if (deleteNum < 0) {
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u6839\u636e\u501f\u636e\u53f7\u3010" + loanNo + "\u3011\uff0c\u5220\u9664\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList<LoanRepayPlanVO> insertLists = new ArrayList<LoanRepayPlanVO>(respRepayPlan.getAcctDtlInfArry().size());
            for (int i = 0; i < respRepayPlan.getAcctDtlInfArry().size(); ++i) {
                AcctDtlInfBean acctDtlInfBean = (AcctDtlInfBean)respRepayPlan.getAcctDtlInfArry().get(i);
                LoanRepayPlanVO loanRepayPlan = new LoanRepayPlanVO();
                loanRepayPlan.setRefNbr(acctDtlInfBean.getAcctKwd());
                loanRepayPlan.setTerm(Integer.valueOf(Integer.parseInt(acctDtlInfBean.getRpyTime())));
                loanRepayPlan.setBeginDate(DateUtility.format8To10((String)acctDtlInfBean.getStartDt()));
                loanRepayPlan.setStmtDate(DateUtility.format8To10((String)acctDtlInfBean.getEndDt()));
                loanRepayPlan.setStatus(this.getTermStatus(acctDtlInfBean));
                double principal = acctDtlInfBean.getPlanPrin();
                double interest = acctDtlInfBean.getPlanInt();
                double penaltyDue = acctDtlInfBean.getIssuePnyInt();
                double comIntDue = acctDtlInfBean.getIssueCmpdInt();
                loanRepayPlan.setPrincipal(new BigDecimal(principal));
                loanRepayPlan.setPrincipalPaid(new BigDecimal(acctDtlInfBean.getActRpyPrin()));
                loanRepayPlan.setInterest(new BigDecimal(interest));
                loanRepayPlan.setInterestPaid(new BigDecimal(acctDtlInfBean.getActRpyInt()));
                loanRepayPlan.setPenaltyDue(new BigDecimal(penaltyDue));
                loanRepayPlan.setPenaltyPaid(new BigDecimal(acctDtlInfBean.getActRpyPnyInt()));
                loanRepayPlan.setComIntDue(new BigDecimal(comIntDue));
                loanRepayPlan.setComIntPaid(new BigDecimal(acctDtlInfBean.getActRpyCmpdInt()));
                loanRepayPlan.setFeeDue(BigDecimal.ZERO);
                loanRepayPlan.setFeePaid(BigDecimal.ZERO);
                loanRepayPlan.setPerAmt(new BigDecimal(principal + interest + penaltyDue + comIntDue));
                loanRepayPlan.setProductCd(accLoanVO.getPrdId());
                loanRepayPlan.setIsOverDue(this.getIsOverDueMethod(acctDtlInfBean.getRpyTime(), loanRepayPlan.getStatus()));
                loanRepayPlan.setInitTerm(Integer.valueOf(respRepayPlan.getAcctDtlInfArry().size()));
                loanRepayPlan.setClearDate(this.getClearDate(acctDtlInfBean, termClearDateMap));
                insertLists.add(loanRepayPlan);
            }
            int num = this.loanRepayPlanService.batchInsert(insertLists);
            if (num < 0) {
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.INSERT_LOAN_PLAN_AFTER_REPAY.getValue(), "\u66f4\u65b0\u8fd8\u6b3e\u8ba1\u5212\u5931\u8d25\uff0c\u501f\u636e\u53f7\u3010" + loanNo + "\u3011");
            }
        }
        catch (Exception e) {
            throw new OcmSystemException((Throwable)e);
        }
        finally {
            logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u7ed3\u675f,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        }
    }

    private String getTermStatus(AcctDtlInfBean acctDtlInfBean) {
        String termStatus = null;
        String endDate = acctDtlInfBean.getEndDt();
        String sysDate = this.getSysOpenDay();
        double principal = acctDtlInfBean.getPlanPrin();
        double principalPaid = acctDtlInfBean.getActRpyPrin();
        try {
            if (TimeUtil.compareDates((String)endDate, (String)sysDate) == -1) {
                termStatus = principal == principalPaid ? "P" : "O";
            } else if (TimeUtil.compareDates((String)endDate, (String)sysDate) == 0) {
                termStatus = principal == principalPaid ? "P" : "N";
            } else if (TimeUtil.compareDates((String)endDate, (String)sysDate) == 1) {
                termStatus = "N";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u540c\u6b65\u8fd8\u6b3e\u8ba1\u5212\u65f6\uff0c\u83b7\u53d6\u671f\u6570\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
        return termStatus;
    }

    private String getClearDate(AcctDtlInfBean acctDtlInfBean, Map<String, String> termClearDateMap) {
        String clearDate = null;
        if (StringUtil.isStrNotEmpty((String)termClearDateMap.get(acctDtlInfBean.getRpyTime()))) {
            clearDate = termClearDateMap.get(acctDtlInfBean.getRpyTime());
        } else if (acctDtlInfBean.getPlanPrin() == acctDtlInfBean.getActRpyPrin() && acctDtlInfBean.getPlanInt() == acctDtlInfBean.getActRpyInt() && acctDtlInfBean.getIssuePnyInt() == acctDtlInfBean.getActRpyPnyInt() && acctDtlInfBean.getIssueCmpdInt() == acctDtlInfBean.getActRpyCmpdInt()) {
            clearDate = this.getSysOpenDay();
        }
        return clearDate;
    }

    private String getIsOverDueMethod(String term, String termStatus) {
        String isOverDue = SedNlsEnum.YesOrNo.NO.getValue();
        if (SedNlsEnum.YesOrNo.YES.getValue().equals(termIsOverDueMap.get(term))) {
            isOverDue = termIsOverDueMap.get(term);
        }
        if (SedNlsEnum.YesOrNo.NO.getValue().equals(termIsOverDueMap.get(term)) && "O".equals(termStatus)) {
            isOverDue = SedNlsEnum.YesOrNo.YES.getValue();
            termIsOverDueMap.put(term, isOverDue);
        }
        return isOverDue;
    }

    private void synAccLoan(AccLoanVO accLoanVO, RespLoanInfoQueryBean respLoanInfoQueryBean, RespLoanBalanceQueryBean respLoanBalanceQueryBean) throws OcmSystemException {
        String loanNo = accLoanVO.getBillNo();
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u501f\u636e\u4fe1\u606f\u5f00\u59cb,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        try {
            accLoanVO.setLoanBalance(respLoanBalanceQueryBean.getLoanBal());
            accLoanVO.setReceIntCumu(respLoanBalanceQueryBean.getDstrInfArry()[0].getIssueInt());
            accLoanVO.setActualIntCumu(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpydInt());
            accLoanVO.setDelayIntCumu(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpyblInt_1());
            accLoanVO.setUnpdArrPrnBal(respLoanBalanceQueryBean.getLoanBal());
            accLoanVO.setActArrsIntBal(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpydPnyInt());
            accLoanVO.setActArrPrnBal(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpydCmpdInt());
            accLoanVO.setUnpdArrsIntBal1(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpyblPnyInt_1());
            accLoanVO.setUnpdArrPrnBal1(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpyblCmpdInt_1());
            accLoanVO.setDelayIntCumu1(respLoanBalanceQueryBean.getDstrInfArry()[0].getIssuePnyInt());
            String rulingIr = respLoanInfoQueryBean.getBnchmrkRate();
            accLoanVO.setRulingIr(StringUtil.isNotEmpty((String)rulingIr) ? new BigDecimal(rulingIr).divide(new BigDecimal("100")) : BigDecimal.ZERO);
            accLoanVO.setRealityIrY(null == respLoanInfoQueryBean.getComIntRate() ? BigDecimal.ZERO : respLoanInfoQueryBean.getComIntRate().divide(new BigDecimal("100")));
            accLoanVO.setSettlDate(DateUtility.format8To10((String)respLoanInfoQueryBean.getCldDt()));
            String accSts = "";
            try {
                accSts = SDicToLocal.getLocalSysDicVal((String)"AccStatus", (String)respLoanInfoQueryBean.getAcctLdgrSt());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u66f4\u65b0\u501f\u636e\u8868\u4fe1\u606f\u65f6,\u53f0\u8d26\u72b6\u6001\u8f6c\u6362\u51fa\u9519,\u501f\u636e\u53f7\u3010" + accLoanVO.getBillNo() + "\u3011");
            }
            accLoanVO.setAccountStatus(accSts);
            if ("1".equals(accSts)) {
                accLoanVO.setNormalBalance(respLoanBalanceQueryBean.getLoanBal());
                accLoanVO.setUnpdPrinBal(BigDecimal.ZERO);
            } else if ("10".equals(accSts) || "12".equals(accSts)) {
                accLoanVO.setUnpdPrinBal(respLoanInfoQueryBean.getOduePrin());
                accLoanVO.setNormalBalance(BigDecimal.ZERO);
            }
            accLoanVO.setGraceDay(StringUtil.isStrNotEmpty((String)respLoanInfoQueryBean.getGrcDay()) ? new BigDecimal(respLoanInfoQueryBean.getGrcDay()) : BigDecimal.ZERO);
            List loanRepayPlanVOs = this.loanRepayPlanService.qryAllByLoanNo(loanNo);
            if (null == loanRepayPlanVOs || loanRepayPlanVOs.isEmpty()) {
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u901a\u8fc7\u501f\u636e\u53f7\u3010" + accLoanVO.getBillNo() + "\u3011\uff0c\u67e5\u8be2\u5230\u7684\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            accLoanVO.setCapOverdueDate(this.getMinOverdueDate(loanRepayPlanVOs));
            accLoanVO.setOverTimesCurrent(this.getOverTimesCurrent(loanRepayPlanVOs));
            accLoanVO.setOverTimesTotal(this.getOverTimesTotal(loanRepayPlanVOs));
            accLoanVO.setMaxTimesTotal(this.getMaxTimesTotal(loanRepayPlanVOs));
            accLoanVO.setCurrTerm(this.getCurTerm(loanRepayPlanVOs));
            accLoanVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            accLoanVO.setLastUpdateUser("admin");
            int num = this.accLoanService.updateByPk(accLoanVO);
            if (num < 0) {
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u66f4\u65b0\u501f\u636e\u8868\u4fe1\u606f\u51fa\u9519------------\u501f\u636e\u53f7\u3010" + accLoanVO.getBillNo() + "\u3011");
            }
        }
        catch (Exception e) {
            throw new OcmSystemException((Throwable)e);
        }
        finally {
            logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u501f\u636e\u4fe1\u606f\u7ed3\u675f,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        }
    }

    private String getAccLoanSts(String acctSts, String setledDate, BigDecimal loanBalance) {
        String accLoanSts = "1";
        try {
            String openDay;
            if (StringUtil.isStrNotEmpty((String)setledDate) && TimeUtil.compareDates((String)(openDay = this.getSysOpenDay()), (String)setledDate) > -1) {
                accLoanSts = "4";
            }
            if (loanBalance.compareTo(BigDecimal.ZERO) < 1) {
                accLoanSts = "4";
            }
            if (!"4".equals(accLoanSts)) {
                accLoanSts = SDicToLocal.getLocalSysDicVal((String)"AccStatus", (String)acctSts);
            }
        }
        catch (Exception e) {
            logger.error("\u8fd8\u6b3e\u6210\u529f\u66f4\u65b0\u501f\u636e\u4fe1\u606f\u65f6\uff0c\u83b7\u53d6\u53f0\u8d26\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
        return accLoanSts;
    }

    private String getMinOverdueDate(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        List resultList = loanRepayPlanVOs.stream().filter(lrpvo -> "O".equals(lrpvo.getStatus())).sorted(Comparator.comparing(LoanRepayPlanVO::getTerm)).collect(Collectors.toList());
        if (null == resultList || resultList.isEmpty()) {
            return null;
        }
        return ((LoanRepayPlanVO)resultList.get(0)).getStmtDate();
    }

    private BigDecimal getOverTimesCurrent(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        long result = loanRepayPlanVOs.stream().filter(lrpvo -> "O".equals(lrpvo.getStatus())).count();
        return new BigDecimal(result);
    }

    private BigDecimal getOverTimesTotal(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        long overTimeTotal = loanRepayPlanVOs.stream().map(LoanRepayPlanVO::getIsOverDue).filter(val -> SedNlsEnum.YesOrNo.YES.getValue().equals(val)).count();
        return new BigDecimal(overTimeTotal);
    }

    private BigDecimal getMaxTimesTotal(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        int max = 1;
        int count = 1;
        for (int i = 0; i < loanRepayPlanVOs.size(); ++i) {
            if (loanRepayPlanVOs.get(i).getTerm() + 1 == loanRepayPlanVOs.get(i + 1).getTerm()) {
                max = max > ++count ? max : count;
                continue;
            }
            count = 1;
        }
        return new BigDecimal(max);
    }

    private BigDecimal getCurTerm(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        String openDay = this.getSysOpenDay();
        List termList = loanRepayPlanVOs.stream().filter(lrp -> TimeUtil.compareDate((String)lrp.getBeginDate(), (String)openDay) == -1 && TimeUtil.compareDate((String)lrp.getStmtDate(), (String)openDay) != -1).map(LoanRepayPlanVO::getTerm).sorted().collect(Collectors.toList());
        if (null == termList || termList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal((Integer)termList.get(0));
    }

    private String getSysOpenDay() {
        if (openDayMap.containsKey("1001")) {
            return openDayMap.get("1001");
        }
        String openDayStr = this.pubSysInfoService.getOpenday("1001");
        openDayMap.put("1001", openDayStr);
        return openDayStr;
    }
}

