/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.signature;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.Base64;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.FileUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.UUIDUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.esb.service.bo.req.dzqz.ReqElectronicSignature3203Bean;
import com.irdstudio.efp.esb.service.bo.req.dzqz.ReqElectronicSignatureDL01Bean;
import com.irdstudio.efp.esb.service.bo.req.dzqz.info.ElectronicSignature3001ReqPersonInfo;
import com.irdstudio.efp.esb.service.bo.req.dzqz.info.ElectronicSignature3203BaseInfo;
import com.irdstudio.efp.esb.service.bo.req.dzqz.info.ElectronicSignature3203SignInfo;
import com.irdstudio.efp.esb.service.bo.req.dzqz.info.ElectronicSignature3203SignKeyWord;
import com.irdstudio.efp.esb.service.bo.req.dzqz.info.ElectronicSignature3203SignKeyWord2;
import com.irdstudio.efp.esb.service.bo.req.sed.cfca.ReqSedCfcaOpenAccountBean;
import com.irdstudio.efp.esb.service.bo.resp.dzqz.RspElectronicSignature3203Bean;
import com.irdstudio.efp.esb.service.bo.resp.dzqz.RspElectronicSignatureDL01Bean;
import com.irdstudio.efp.esb.service.bo.resp.dzqz.info.ElectronicSignature3203Signatory;
import com.irdstudio.efp.esb.service.bo.resp.dzqz.info.RspElectronicSignature3203BaseBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.cfca.RespSedCfcaOpenAccountBean;
import com.irdstudio.efp.esb.service.facade.sed.cfca.SedCfcaService;
import com.irdstudio.efp.nls.service.dao.NlsApplyInfoDao;
import com.irdstudio.efp.nls.service.dao.signature.SignatureConfigurationDAO;
import com.irdstudio.efp.nls.service.dao.signature.SignatureRecordDAO;
import com.irdstudio.efp.nls.service.dao.signature.SignatureStamUploadRecordDAO;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.signature.SignatureConfiguration;
import com.irdstudio.efp.nls.service.domain.signature.SignatureRecord;
import com.irdstudio.efp.nls.service.domain.signature.SignatureStamUploadRecord;
import com.irdstudio.efp.nls.service.facade.signature.SignatureService;
import com.irdstudio.efp.nls.service.impl.signature.NlsSignatureInfo;
import com.irdstudio.efp.nls.service.vo.signature.SignatureRecordVO;
import com.irdstudio.efp.nls.service.vo.signature.SignatureStamUploadRecordVO;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="signatureService")
public class SignatureServiceImpl
implements SignatureService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SignatureServiceImpl.class);
    @Autowired
    private SignatureConfigurationDAO signatureConfigurationDAO;
    @Autowired
    private SignatureRecordDAO signatureRecordDAO;
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;
    @Autowired
    private NlsApplyInfoDao nlsApplyInfoDao;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="sedCfcaService")
    private SedCfcaService sedCfcaService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    private SignatureStamUploadRecordDAO signatureStamUploadRecordDAO;
    @Autowired
    private SCfgParamService sCfgParamService;
    @Value(value="${gzcb.authaddr}")
    private String authaddr;
    public static ArrayList<String> prdIds = new ArrayList();

    public Boolean signature() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5728\u7ebf\u7b7e\u7ae0");
        for (String prdId : prdIds) {
            List<SignatureConfiguration> configurations = this.signatureConfigurationDAO.selectByPrdId(prdId);
            if (configurations == null || configurations.isEmpty()) {
                logger.info("\u4ea7\u54c1\uff1a", (Object)prdId, (Object)"\u83b7\u53d6\u5230\u7684\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a");
                continue;
            }
            int[] handleNumArr = this.getHandleNumArr();
            for (SignatureConfiguration configuration : configurations) {
                List<NlsSignatureInfo> nlsSignatureInfos;
                List<BaseInfo> signatureNlsList;
                if (configuration.getLinkType() == 1) {
                    signatureNlsList = this.nlsCreditInfoDao.getSignatureNlsList(prdId, handleNumArr[1], configuration.getPolFileType(), handleNumArr[0]);
                    if (signatureNlsList == null || signatureNlsList.isEmpty()) {
                        logger.info("\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a");
                        continue;
                    }
                    nlsSignatureInfos = signatureNlsList.stream().map(nlsCreditInfo -> {
                        NlsSignatureInfo nlsSignatureInfo = new NlsSignatureInfo();
                        nlsSignatureInfo.setUsrNm(nlsCreditInfo.getCusName());
                        nlsSignatureInfo.setCertTp(nlsCreditInfo.getCertType());
                        nlsSignatureInfo.setCertNo(nlsCreditInfo.getCertCode());
                        nlsSignatureInfo.setUserEmail(nlsCreditInfo.getEmail());
                        nlsSignatureInfo.setMblNo(nlsCreditInfo.getIndivMobile());
                        nlsSignatureInfo.setCtcAddr(nlsCreditInfo.getIndivRsdAddr());
                        nlsSignatureInfo.setApplySeq(nlsCreditInfo.getLmtApplySeq());
                        nlsSignatureInfo.setCusId(nlsCreditInfo.getCusId());
                        return nlsSignatureInfo;
                    }).collect(Collectors.toList());
                    this.signature1(configuration, nlsSignatureInfos);
                }
                if (configuration.getLinkType() != 2) continue;
                signatureNlsList = this.nlsApplyInfoDao.getSignatureNlsList(prdId, handleNumArr[1], configuration.getPolFileType(), handleNumArr[0]);
                if (signatureNlsList == null || signatureNlsList.isEmpty()) {
                    logger.info("\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a");
                    continue;
                }
                nlsSignatureInfos = signatureNlsList.stream().map(nlsApplyInfo -> {
                    NlsSignatureInfo nlsSignatureInfo = new NlsSignatureInfo();
                    nlsSignatureInfo.setUsrNm(nlsApplyInfo.getCusName());
                    nlsSignatureInfo.setCertTp(nlsApplyInfo.getCertType());
                    nlsSignatureInfo.setCertNo(nlsApplyInfo.getCertCode());
                    nlsSignatureInfo.setUserEmail("");
                    nlsSignatureInfo.setMblNo(nlsApplyInfo.getMblTelNo());
                    nlsSignatureInfo.setCtcAddr(nlsApplyInfo.getIndivRsdAddr());
                    nlsSignatureInfo.setApplySeq(nlsApplyInfo.getApplySeq());
                    nlsSignatureInfo.setCusId(nlsApplyInfo.getCusId());
                    return nlsSignatureInfo;
                }).collect(Collectors.toList());
                this.signature1(configuration, nlsSignatureInfos);
            }
        }
        return Boolean.TRUE;
    }

    private final void signature1(SignatureConfiguration configuration, List<NlsSignatureInfo> nlsSignatureInfos) {
        if (nlsSignatureInfos == null) {
            return;
        }
        if (nlsSignatureInfos.isEmpty()) {
            return;
        }
        for (NlsSignatureInfo nlsSignatureInfo : nlsSignatureInfos) {
            SignatureRecord sigRecord = this.getSignatureRecord(configuration, nlsSignatureInfo.getApplySeq());
            if (sigRecord.getSiuSta() == 3) {
                RspElectronicSignature3203BaseBean rspElectronicSignature3203BaseBean = (RspElectronicSignature3203BaseBean)JSONObject.parseObject((String)sigRecord.getSiuRetMsg(), RspElectronicSignature3203BaseBean.class);
                boolean downFlag = this.executeDL01(rspElectronicSignature3203BaseBean.getContrNo(), sigRecord, configuration, nlsSignatureInfo.getApplySeq());
                if (!downFlag) {
                    logger.info("\u4e0b\u8f7d\u5931\u8d25", (Object)nlsSignatureInfo.getApplySeq(), (Object)rspElectronicSignature3203BaseBean.getContrNo());
                    sigRecord.setLastUpdateTime(new Date());
                    this.signatureRecordDAO.updateByPrimaryKey(sigRecord);
                    continue;
                }
                this.insertStamUp(configuration, nlsSignatureInfo, sigRecord);
                sigRecord.setSiuSta(1);
                sigRecord.setLastUpdateTime(new Date());
                this.signatureRecordDAO.updateByPrimaryKey(sigRecord);
                continue;
            }
            try {
                RspElectronicSignature3203BaseBean resp3203BaseBean;
                CusIndivVO cusIndiv = this.getCusIndiv(nlsSignatureInfo.getCusId());
                if (cusIndiv == null) {
                    throw new RuntimeException("\u83b7\u53d6\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f");
                }
                String axqUsrId = cusIndiv.getAxqUsrId();
                if (StringUtils.isEmpty((CharSequence)nlsSignatureInfo.getUserEmail())) {
                    nlsSignatureInfo.setUserEmail(cusIndiv.getEmail());
                }
                if (StringUtils.isEmpty((CharSequence)axqUsrId)) {
                    RespSedCfcaOpenAccountBean respAccountBean = this.execute3001(nlsSignatureInfo);
                    if (respAccountBean == null || StringUtils.isEmpty((CharSequence)respAccountBean.getPerson().getUsrID())) {
                        throw new RuntimeException("\u8c03\u7528\u5b89\u5fc3\u7b7e\u5f00\u6237\u5931\u8d25\uff08\u6216\u8005\u83b7\u53d6\u5230\u7684\u5b89\u5fc3\u7b7e\u5ba2\u6237\u53f7\u4e3a\u7a7a\uff09");
                    }
                    this.updateCusIndiv(cusIndiv, respAccountBean);
                    axqUsrId = respAccountBean.getPerson().getUsrID();
                }
                if ((resp3203BaseBean = this.execute3203(configuration, axqUsrId, nlsSignatureInfo.getApplySeq(), configuration.getPrdId(), configuration.getPrdCode(), configuration.getPrdName(), cusIndiv.getCusId(), cusIndiv.getCusName())) == null) {
                    throw new RuntimeException("\u8c03\u7528\u7b7e\u7ae0\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a");
                }
                sigRecord.setSiuSta(1);
                sigRecord.setLastUpdateTime(new Date());
                sigRecord.setSiuRetMsg(JSONObject.toJSONString((Object)resp3203BaseBean));
                this.signatureRecordDAO.updateByPrimaryKey(sigRecord);
                boolean downFlag = this.executeDL01(resp3203BaseBean.getContrNo(), sigRecord, configuration, nlsSignatureInfo.getApplySeq());
                if (!downFlag) {
                    sigRecord.setSiuSta(3);
                    this.signatureRecordDAO.updateByPrimaryKey(sigRecord);
                    continue;
                }
                sigRecord.setSiuSta(1);
                sigRecord.setLastUpdateTime(new Date());
                this.signatureRecordDAO.updateByPrimaryKey(sigRecord);
                this.insertStamUp(configuration, nlsSignatureInfo, sigRecord);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                sigRecord.setSiuSta(2);
                sigRecord.setErrMsg("\u53d1\u751f\u5f02\u5e38:" + e.getLocalizedMessage());
                this.signatureRecordDAO.updateByPrimaryKey(sigRecord);
            }
        }
    }

    private void insertStamUp(SignatureConfiguration configuration, NlsSignatureInfo nlsSignatureInfo, SignatureRecord sigRecord) {
        String fileUrl = configuration.getSiuFileSaveDir() + nlsSignatureInfo.getApplySeq() + "/" + configuration.getPolFileType() + "." + FilenameUtils.getExtension((String)configuration.getPolFileUrl());
        if (this.signatureStamUploadRecordDAO.selectBySiuFileUrl(fileUrl) > 0) {
            return;
        }
        SignatureStamUploadRecord stamUploadRecord = new SignatureStamUploadRecord();
        stamUploadRecord.setHdlNum(0);
        stamUploadRecord.setHdlSta(0);
        stamUploadRecord.setCreateTime(new Date());
        stamUploadRecord.setId(UUIDUtil.getUUID());
        stamUploadRecord.setSignatureRecordId(sigRecord.getId());
        stamUploadRecord.setSiuFileUrl(fileUrl);
        this.signatureStamUploadRecordDAO.insert(stamUploadRecord);
    }

    private SignatureRecord getSignatureRecord(SignatureConfiguration configuration, String applySeq) {
        SignatureRecord signatureRecord = this.signatureRecordDAO.selectByPst(configuration.getPrdId(), applySeq, configuration.getLinkType());
        if (signatureRecord == null) {
            SignatureRecord sigRecord = new SignatureRecord();
            sigRecord.setApplySeq(applySeq);
            sigRecord.setCreateTime(new Date());
            sigRecord.setId(UUIDUtil.getUUID());
            sigRecord.setLinkType(configuration.getLinkType());
            sigRecord.setPolFileType(configuration.getPolFileType());
            sigRecord.setPrdId(configuration.getPrdId());
            sigRecord.setRetryNum(1);
            sigRecord.setSiuSta(0);
            this.signatureRecordDAO.insert(sigRecord);
            return sigRecord;
        }
        signatureRecord.setRetryNum(signatureRecord.getRetryNum() + 1);
        signatureRecord.setLastUpdateTime(new Date());
        this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
        return signatureRecord;
    }

    private Integer updateCusIndiv(CusIndivVO cusIndiv, RespSedCfcaOpenAccountBean respAccountBean) {
        cusIndiv.setAxqUsrId(respAccountBean.getPerson().getUsrID());
        return this.cusIndivService.updateByPk(cusIndiv);
    }

    private CusIndivVO getCusIndiv(String cusId) {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(cusId);
        CusIndivVO targetCusIndivVo = this.cusIndivService.queryByPk(cusIndivVO);
        return targetCusIndivVo;
    }

    private RspElectronicSignature3203BaseBean execute3203(SignatureConfiguration configuration, String axqUserId, String applySeq, String prdId, String prdCode, String prdName, String cusId, String cusName) throws Exception {
        ReqElectronicSignature3203Bean req3203Bean = new ReqElectronicSignature3203Bean();
        ElectronicSignature3203BaseInfo req3203BeanBase = new ElectronicSignature3203BaseInfo();
        req3203BeanBase.setSignFlg("2");
        req3203BeanBase.setSealId(axqUserId);
        req3203BeanBase.setContrTp("17");
        req3203BeanBase.setContrNm(configuration.getPolFileName());
        ElectronicSignature3203SignKeyWord signKeyword = new ElectronicSignature3203SignKeyWord();
        signKeyword.setSignKwd(configuration.getSiuKeyWord());
        signKeyword.setXOfstCoordPosn(String.valueOf(configuration.getSiuOffsetX()));
        signKeyword.setYOfstCoordPosn(String.valueOf(configuration.getLinkType()));
        signKeyword.setSignImgWdth(String.valueOf(configuration.getSiuImgW()));
        signKeyword.setSignImgHght(String.valueOf(configuration.getSiuImgH()));
        req3203BeanBase.setSignKeyword(signKeyword);
        ArrayList<ElectronicSignature3203SignInfo> signInfos = new ArrayList<ElectronicSignature3203SignInfo>();
        ElectronicSignature3203SignInfo signInfo1 = new ElectronicSignature3203SignInfo();
        signInfo1.setUsrID(axqUserId);
        signInfo1.setAuthTm(TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmss"));
        signInfo1.setAuthAddr(this.authaddr);
        signInfo1.setPrjNo(configuration.getPrdId());
        ElectronicSignature3203SignKeyWord2 signKeyWord2 = new ElectronicSignature3203SignKeyWord2();
        signKeyWord2.setSignKwd(configuration.getSiuKeyWord());
        signKeyWord2.setXOfstCoordPosn(String.valueOf(configuration.getSiuOffsetX()));
        signKeyWord2.setYOfstCoordPosn(String.valueOf(configuration.getLinkType()));
        signKeyWord2.setSignImgHght(String.valueOf(configuration.getSiuImgH()));
        signKeyWord2.setSignImgWdth(String.valueOf(configuration.getSiuImgW()));
        signInfo1.setSignKeyword2(signKeyWord2);
        signInfo1.setAgncSignFlg("1");
        signInfos.add(signInfo1);
        req3203BeanBase.setSignBscInfArry(signInfos);
        req3203Bean.setContrFlStrm(Base64.encodeBytes((byte[])FileUtil.toByteArray((File)new File(configuration.getPolFileUrl()))));
        req3203Bean.setUploadContract(req3203BeanBase);
        RspElectronicSignature3203BaseBean resp3203BaseBean = new RspElectronicSignature3203BaseBean();
        RspElectronicSignature3203Bean resp3203Bean = this.sedCfcaService.signContract(req3203Bean);
        resp3203BaseBean = resp3203Bean.getContract();
        if (Objects.isNull(resp3203BaseBean)) {
            throw new Exception("\u8c03\u7528cfca\u5408\u540c\u6a21\u677f\u7b7e\u7ae0\u63a5\u53e3\u30103203\u3011\uff0c\u8fd4\u56de\u7684\u5408\u540c\u7b7e\u7f72\u4fe1\u606f\u4e3a\u7a7a\uff01----------\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a");
        }
        ElectronicSignature3203Signatory respSignature3203Signatory = (ElectronicSignature3203Signatory)resp3203BaseBean.getContractSignInfArry().get(0);
        if (Objects.isNull(respSignature3203Signatory)) {
            throw new Exception("\u8c03\u7528cfca\u5408\u540c\u6a21\u677f\u7b7e\u7ae0\u63a5\u53e3\u30103203\u3011\uff0c\u8fd4\u56de\u7684\u7b7e\u7f72\u4eba\u4fe1\u606f\u4e3a\u7a7a\uff01----------\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a");
        }
        this.insertCfcaSignInfo(resp3203BaseBean, applySeq, prdId, prdCode, prdName, cusId, cusName);
        return resp3203BaseBean;
    }

    private void insertCfcaSignInfo(RspElectronicSignature3203BaseBean resp3203BaseBean, String applySeq, String prdId, String prdCode, String prdName, String cusId, String cusName) {
        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
        cfcaSignInfoVO.setApplySeq(applySeq);
        cfcaSignInfoVO.setPrdId(prdId);
        cfcaSignInfoVO.setPrdCode(prdCode);
        cfcaSignInfoVO.setPrdName(prdName);
        cfcaSignInfoVO.setContNo(resp3203BaseBean.getContrNo());
        cfcaSignInfoVO.setCfcaContNo(resp3203BaseBean.getContrNo());
        cfcaSignInfoVO.setCusId(cusId);
        cfcaSignInfoVO.setCusName(cusName);
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.UNSIGN.getEnname());
        String time = "";
        for (ElectronicSignature3203Signatory elS3203Signatory : resp3203BaseBean.getContractSignInfArry()) {
            if (!"1".equals(elS3203Signatory.getSignSt())) continue;
            try {
                time = DateUtility.formatDateTime14To19((String)elS3203Signatory.getSignTm());
            }
            catch (BizException e) {
                logger.error("\u65f6\u95f4\u3010" + elS3203Signatory.getSignTm() + "\u3011\uff0c\u4e0d\u662f14\u4f4d\u683c\u5f0f\u7684\uff0c\u4e0d\u7b26\u5408\u63a5\u53e3\u7ea6\u5b9a\uff0c\u7b7e\u7f72\u65f6\u95f4\u53d6\u672c\u7cfb\u7edf\u65f6\u95f4\u3002");
                time = TimeUtil.getCurrentDateTime();
            }
        }
        cfcaSignInfoVO.setCfcaSignTime(time);
        this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
    }

    private RespSedCfcaOpenAccountBean execute3001(NlsSignatureInfo nlsSignatureInfo) throws ESBException {
        ReqSedCfcaOpenAccountBean req3001Bean = new ReqSedCfcaOpenAccountBean();
        ElectronicSignature3001ReqPersonInfo personInfo = new ElectronicSignature3001ReqPersonInfo();
        personInfo.setUsrNm(nlsSignatureInfo.getUsrNm());
        personInfo.setCertTp(nlsSignatureInfo.getCertTp());
        personInfo.setCertNo(nlsSignatureInfo.getCertNo());
        personInfo.setUserEmail(nlsSignatureInfo.getUserEmail());
        personInfo.setMblNo(nlsSignatureInfo.getMblNo());
        personInfo.setCtcAddr(nlsSignatureInfo.getCtcAddr());
        personInfo.setAuthMode("\u516c\u5b89\u90e8");
        req3001Bean.setPerson(personInfo);
        req3001Bean.setSendPswdMsgFlg(ElectronicSignatureEnums.SendEnum.NotSend.VALUE);
        RespSedCfcaOpenAccountBean resp3001Bean = this.sedCfcaService.openAccount(req3001Bean);
        return resp3001Bean;
    }

    private boolean executeDL01(String cfcaContNo, SignatureRecord sigRecord, SignatureConfiguration configuration, String applySeq) {
        ReqElectronicSignatureDL01Bean reqDL01Bean = new ReqElectronicSignatureDL01Bean();
        reqDL01Bean.setContrNo(cfcaContNo);
        try {
            RspElectronicSignatureDL01Bean respDL01Bean = this.sedCfcaService.downloadContract(reqDL01Bean);
            if (respDL01Bean == null || StringUtils.isEmpty((CharSequence)respDL01Bean.getContrFlStrm())) {
                return false;
            }
            sigRecord.setDwnRetMsg(JSONObject.toJSONString((Object)reqDL01Bean));
            logger.info("\u5408\u540c\u53f7\uff1a", new Object[]{cfcaContNo, " \u8fd4\u56de\u62a5\u6587\u4e3a\uff1a", reqDL01Bean != null ? JSONObject.toJSONString((Object)respDL01Bean) : "", " \u7533\u8bf7\u6d41\u6c34\u53f7\uff1a", applySeq});
            File file = new File(configuration.getSiuFileSaveDir() + applySeq);
            if (!file.exists()) {
                logger.info("\u5408\u540c\u4e0b\u8f7d\uff0c\u521b\u5efa\u6587\u4ef6\u8def\u5f84\uff1a", (Object)(configuration.getSiuFileSaveDir() + applySeq));
                FileUtils.forceMkdir((File)file);
            }
            logger.info("\u5408\u540c\u4e0b\u8f7d\uff0c\u5b58\u653e\u4e0b\u8f7d\u6587\u4ef6\u7684\u8def\u5f84\uff1a", (Object)(configuration.getSiuFileSaveDir() + applySeq));
            logger.info("\u5408\u540c\u4e0b\u8f7d\u6210\u529f\uff0c\u8fd4\u56de\u7684\u6587\u4ef6\u5b57\u7b26\u4e32\u4e3a\uff1a", (Object)respDL01Bean.getContrFlStrm());
            FileUtil.writeBytesToFile((byte[])Base64.decode((String)respDL01Bean.getContrFlStrm()), (String)(configuration.getSiuFileSaveDir() + applySeq + "/"), (String)(configuration.getPolFileType() + "." + FilenameUtils.getExtension((String)configuration.getPolFileUrl())));
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u5408\u540c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    public SignatureRecordVO selectByPrimaryKey(String id) {
        SignatureRecord signatureRecord = this.signatureRecordDAO.selectByPrimaryKey(id);
        if (Objects.isNull(signatureRecord)) {
            return null;
        }
        return (SignatureRecordVO)this.beanCopy(signatureRecord, new SignatureRecordVO());
    }

    public Integer updateRecordByPrimaryKey(SignatureRecordVO signatureRecordVO) {
        if (Objects.isNull(signatureRecordVO)) {
            return 0;
        }
        SignatureRecord signatureRecord = new SignatureRecord();
        this.beanCopy(signatureRecordVO, signatureRecord);
        return this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
    }

    public ArrayList<SignatureStamUploadRecordVO> selectStamRecord(Integer maxNum, Integer maxRtyNum) {
        ArrayList resultStamRecords = new ArrayList();
        List<SignatureStamUploadRecord> signatureStamUploadRecords = this.signatureStamUploadRecordDAO.selectStamRecord(maxNum, maxRtyNum);
        try {
            return (ArrayList)this.beansCopy(signatureStamUploadRecords, SignatureStamUploadRecordVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public Integer updateStamRecordByPrimaryKey(SignatureStamUploadRecordVO signatureStamUploadRecordVO) {
        if (Objects.isNull(signatureStamUploadRecordVO)) {
            return 0;
        }
        SignatureStamUploadRecord signatureStamUploadRecord = new SignatureStamUploadRecord();
        this.beanCopy(signatureStamUploadRecordVO, signatureStamUploadRecord);
        return this.signatureStamUploadRecordDAO.updateByPrimaryKey(signatureStamUploadRecord);
    }

    private int[] getHandleNumArr() {
        int[] result = new int[2];
        try {
            SCfgParamVO param = new SCfgParamVO();
            param.setParamKey("PSD_FILE_HANDLE_NUM");
            SCfgParamVO maxNumCfg = this.sCfgParamService.queryByPk(param);
            result[0] = Objects.isNull(maxNumCfg) ? 50 : Integer.parseInt(maxNumCfg.getParamValue());
            param.setParamKey("PSD_UP_RETRY_NUM");
            SCfgParamVO retryNumCfg = this.sCfgParamService.queryByPk(param);
            result[1] = Objects.isNull(retryNumCfg) ? 3 : Integer.parseInt(retryNumCfg.getParamValue());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        prdIds.add("XD050300601");
    }
}

