/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.MD5Util;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.efp.console.common.ConsoleEnums;
import com.irdstudio.efp.console.common.PrdStatEnums;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.PrdSoltRuleService;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.PrdSoltRuleVO;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.cus.service.facade.CusRelCheckService;
import com.irdstudio.efp.cus.service.facade.CusWhiteListTecService;
import com.irdstudio.efp.cus.service.vo.CusIndivRelVO;
import com.irdstudio.efp.cus.service.vo.CusRelCheckVO;
import com.irdstudio.efp.cus.service.vo.CusWhiteListTecVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.NLMHitQueryReports;
import com.irdstudio.efp.esb.service.bo.req.ZX11001QueryReports;
import com.irdstudio.efp.esb.service.bo.resp.zx.NLMHitQueryResponseReports;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.esb.service.facade.zx.ZXService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import com.irdstudio.efp.rule.common.enumeration.Rule;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import com.irdstudio.efp.rule.service.vo.ReqAccessRuleVo;
import com.irdstudio.efp.rule.service.vo.ReqRuleVo;
import com.irdstudio.efp.rule.service.vo.RespRuleVO;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="creditAccessRuleService")
public class CreditAccessRuleServiceImpl
extends CreditSoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CreditAccessRuleServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="ruleCallService")
    private RuleCallService ruleService;
    @Autowired
    @Qualifier(value="zx11001Service")
    private ZXService<ZX11001QueryReports> zx11001Service;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="cusRelCheckService")
    private CusRelCheckService cusRelCheckService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="prdSoltRuleService")
    private PrdSoltRuleService prdSoltRuleService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    @Qualifier(value="cusWhiteListTecService")
    private CusWhiteListTecService cusWhiteListTecService;
    @Autowired
    @Qualifier(value="zx11008Service")
    private EsbService<NLMHitQueryReports, NLMHitQueryResponseReports> zx11008Service;
    private static final String RELATION_BANKER = "01";
    private static final String RELATION_ASSOCIATE = "02";
    private static final String ON_WORK = "0";
    private static final String PRE_CUST_SEG_A = "A";
    private static final String PRE_CUST_SEG_B = "B";

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String slotCode = nlsProcessBizVo.getSoltCode();
        String certType = nlsCreditInfoVO.getCertType();
        String certCode = nlsCreditInfoVO.getCertCode();
        try {
            NlsQueueSoltComnService nlsQueueSoltComnService;
            boolean isGreyBlackList;
            SCfgParamVO sCfgParamVO = new SCfgParamVO();
            sCfgParamVO.setParamKey(ConsoleEnums.ParamKey.BD_TRIAL_ORDER_SWITCH.getValue());
            sCfgParamVO.setParamValue("Y");
            sCfgParamVO = this.sCfgParamService.queryByCondition(sCfgParamVO);
            if (Objects.nonNull(sCfgParamVO)) {
                CusWhiteListTecVO cusWhiteListTecVO = new CusWhiteListTecVO();
                cusWhiteListTecVO.setCertType(certType);
                cusWhiteListTecVO.setCertNo(certCode);
                cusWhiteListTecVO = this.cusWhiteListTecService.queryByCertNoAndTyp(cusWhiteListTecVO);
                if (Objects.isNull(cusWhiteListTecVO)) {
                    nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get("BdAccessRule010"));
                    nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get("BdAccessRule010"));
                    nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                    throw new BizException("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a " + certCode + "\u7684\u5ba2\u6237\u4e0d\u5b58\u5728\u767d\u540d\u5355\u4e2d\uff0c\u8fdb\u4ef6\u7533\u8bf7\u5931\u8d25\uff01");
                }
            }
            if (isGreyBlackList = (nlsQueueSoltComnService = (NlsQueueSoltComnService)SpringContextUtils.getBean((String)"nlsQueueSoltComnService")).isGreyBlackList(certType, certCode)) {
                nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get("BdAccessRule010"));
                nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get("BdAccessRule010"));
                nlsProcessBizVo.setRefuseMsg(RefuseType.ISGREY_LIST.getMsg());
                throw new BizException("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a " + certCode + "\u547d\u4e2d\u53cd\u6d17\u94b1\u540d\u5355\uff0c\u8fdb\u4ef6\u7533\u8bf7\u5931\u8d25\uff01");
            }
            NLMHitQueryReports hitQueryReports = NLMHitQueryReports.builder().custCnnm(nlsCreditInfoVO.getCusName()).identTp(nlsCreditInfoVO.getCertType()).identNo(nlsCreditInfoVO.getCertCode()).dmstFrgnFlg("1").custTp(RELATION_BANKER).build();
            NLMHitQueryResponseReports zx11008Content = null;
            boolean isConnected = true;
            try {
                zx11008Content = (NLMHitQueryResponseReports)this.zx11008Service.service((Object)hitQueryReports);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                log.error("\u8c03\u7528\u540d\u5355\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                isConnected = false;
            }
            if (isConnected) {
                log.info("\u540d\u5355\u7cfb\u7edf\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u67e5\u8be2\u540d\u5355\u7cfb\u7edf\u63a5\u53e3\u5b8c\u6210");
                Objects.requireNonNull(zx11008Content);
                if ("Y".equals(zx11008Content.getBlklistCustFlg())) {
                    log.info("\u547d\u4e2d\u540d\u5355\u7c7b\u578b\u4fe1\u606f\uff1a{}", (Object)zx11008Content.getHitInf());
                    if ("PRMT".equals(zx11008Content.getHitInf())) {
                        log.warn("\u547d\u4e2d\u63d0\u793a\u7c7b\u9ed1\u540d\u5355\uff0c\u8bc1\u4ef6\u53f7\u7801\u4e3a{}", (Object)certCode);
                    } else {
                        String msg = String.format("\u547d\u4e2d\u9ed1\u540d\u5355,\u7c7b\u578b\uff1a%s,\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a%s,\u63d0\u793a\u4fe1\u606f\uff1a%s,\u8d85\u94fe\u63a5\uff1a%s", zx11008Content.getHitInf(), certCode, zx11008Content.getSugstMsg(), zx11008Content.getHyprlnksAddr());
                        int maxLen = 500;
                        if (StringUtils.isNotBlank((CharSequence)msg) && msg.length() > maxLen) {
                            msg = msg.substring(0, maxLen - 4) + "...";
                        }
                        nlsCreditInfoVO.setBdReasonCode("MDXT_40130002_10");
                        nlsCreditInfoVO.setBdReasonMsg("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a " + certCode + "\u547d\u4e2d\u5f00\u6237\u4ea4\u6613\u540d\u5355\uff0c\u8fdb\u4ef6\u7533\u8bf7\u5931\u8d25\uff01");
                        nlsProcessBizVo.setRefuseMsg("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a " + certCode + "\u547d\u4e2d\u5f00\u6237\u4ea4\u6613\u540d\u5355\uff0c\u8fdb\u4ef6\u7533\u8bf7\u5931\u8d25\uff01");
                        throw new BizException(msg);
                    }
                }
            }
            log.info("\u5f00\u59cb\u8fdb\u884c\u51c6\u5165\u89c4\u5219\u4ea7\u54c1\u6821\u9a8c,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsCreditInfoVO);
            String prdId = Objects.requireNonNull(nlsCreditInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            PrdStatEnums prdStat = PrdStatEnums.parse((String)prdInfoVo.getPrdStatus());
            if (!Objects.equals(prdStat, PrdStatEnums.IN_USE)) {
                nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                throw new BizException("\u4ea7\u54c1\uff1a " + prdInfoVo.getPrdName() + " \u4e0d\u662f\u6709\u6548\u72b6\u6001");
            }
            BigDecimal applyAmt = nlsCreditInfoVO.getApplyAmt();
            BigDecimal maxAmt = prdInfoVo.getCrdAprvMaxAmt();
            BigDecimal minAmt = prdInfoVo.getCrdAprvMinAmt();
            int age = ValidationUtils.getAgeFromIdNumber((String)nlsCreditInfoVO.getCertCode(), (int)23, (int)55);
            int bdPreCustSeg = 0;
            String preCustSeg = nlsCreditInfoVO.getBdPreCustSeg();
            if (!Objects.equals(PRE_CUST_SEG_A, preCustSeg) && !Objects.equals(PRE_CUST_SEG_B, preCustSeg)) {
                bdPreCustSeg = 1;
            }
            int bankerHitsNum = 0;
            CusRelCheckVO cusRelCheckVO = this.cusRelCheckService.queryCusRelCheckBycertCode(MD5Util.getMD5ofStr((String)nlsCreditInfoVO.getCertCode()).toUpperCase(), nlsCreditInfoVO.getCertType());
            if (cusRelCheckVO != null && Objects.equals(RELATION_BANKER, cusRelCheckVO.getRelRelation()) && Objects.equals(cusRelCheckVO.getSts(), ON_WORK)) {
                bankerHitsNum = 1;
            }
            int relationHitsNum = 0;
            cusRelCheckVO = this.cusRelCheckService.queryCusRelCheckBycertCode(nlsCreditInfoVO.getCertCode(), nlsCreditInfoVO.getCertType());
            if (cusRelCheckVO != null && Objects.equals(RELATION_ASSOCIATE, cusRelCheckVO.getRelRelation())) {
                relationHitsNum = 1;
            }
            NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
            nlsApplyInfoVO.setCertCode(nlsCreditInfoVO.getCertCode());
            nlsApplyInfoVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
            Map<String, List<NlsApplyInfoVO>> groupMap = Optional.ofNullable(this.nlsApplyInfoService.queryCertCode(nlsApplyInfoVO)).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(NlsApplyInfoVO::getNlsApplyState));
            log.info("\u83b7\u53d6\u5ba1\u6279\u4e2d\u7684--\u7533\u8bf7\u91d1\u989d");
            BigDecimal totalAmt = BigDecimal.ZERO;
            totalAmt = Optional.ofNullable(groupMap.get(MsLoanConstant.NlsApplyStateEnum.APPR.VALUE)).orElseGet(ArrayList::new).stream().map(NlsApplyInfoVO::getApplyAmt).filter(Objects::nonNull).reduce(totalAmt, BigDecimal::add);
            log.info("\u83b7\u53d6\u5ba1\u6279\u901a\u8fc7,\u5f85\u653e\u6b3e--\u7533\u8bf7\u91d1\u989d");
            totalAmt = Optional.ofNullable(groupMap.get(MsLoanConstant.NlsApplyStateEnum.PASS.VALUE)).orElseGet(ArrayList::new).stream().filter(i -> i.getDnSts() != null && i.getDnSts().equals("3")).map(NlsApplyInfoVO::getApplyAmt).filter(Objects::nonNull).reduce(totalAmt, BigDecimal::add);
            BigDecimal totalAmt1 = BigDecimal.ZERO;
            NlsCreditInfoVO nlsCreditCode = new NlsCreditInfoVO();
            nlsCreditCode.setCertCode(nlsCreditInfoVO.getCertCode());
            nlsCreditCode.setPrdCode(nlsCreditInfoVO.getPrdCode());
            Map<String, List<NlsCreditInfoVO>> creditMap = Optional.ofNullable(this.nlsCreditInfoService.queryCertCode(nlsCreditCode)).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(NlsCreditInfoVO::getApprvSts));
            log.info("\u83b7\u53d6\u5ba1\u6279\u4e2d\u7684--\u7533\u8bf7\u91d1\u989d");
            totalAmt1 = Optional.ofNullable(creditMap.get(MsLoanConstant.NlsApplyStateEnum.APPR.VALUE)).orElseGet(ArrayList::new).stream().filter(i -> !applySeq.equals(i.getLmtApplySeq())).map(NlsCreditInfoVO::getApplyAmt).filter(Objects::nonNull).reduce(totalAmt1, BigDecimal::add);
            log.info("\u83b7\u53d6\u5ba1\u6279\u901a\u8fc7--\u7533\u8bf7\u91d1\u989d");
            NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
            nlsProcessRuleVO.setApplySeq(applySeq);
            nlsProcessRuleVO.setCreateTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setLastModifyTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setPrdCode(prdId);
            nlsProcessRuleVO.setPrdName(nlsCreditInfoVO.getPrdName());
            nlsProcessRuleVO.setCusName(nlsCreditInfoVO.getCusName());
            nlsProcessRuleVO.setCusId(nlsCreditInfoVO.getCusId());
            log.info("\u51c6\u5165\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f00\u59cb\u6267\u884c\u51c6\u5165\u89c4\u5219");
            ReqRuleVo reqRuleVo = new ReqRuleVo();
            reqRuleVo.setAppNo(applySeq);
            reqRuleVo.setPrdName(nlsCreditInfoVO.getPrdName());
            ReqAccessRuleVo param = new ReqAccessRuleVo();
            param.setBankerHitsNum(Integer.valueOf(bankerHitsNum));
            param.setRelatedHitsNum(Integer.valueOf(relationHitsNum));
            param.setAge(Integer.valueOf(age));
            param.setLoanAmt(applyAmt);
            param.setMaxLoanAmt(maxAmt);
            param.setMinLoanAmt(minAmt);
            param.setCusLoanBal(totalAmt);
            param.setMaxLoanBal(prdInfoVo.getLoanMaxAmtBalance());
            param.setPreCustSeg(Integer.valueOf(bdPreCustSeg));
            param.setBdCreditAmt(totalAmt1);
            param.setAvailApply(true);
            reqRuleVo.setReqAccessRuleVo(param);
            List list = this.ruleService.executeBatchRule(Rule.RuleType.BDACCESS, reqRuleVo);
            Map<String, List<RespRuleVO>> map = list.stream().collect(Collectors.groupingBy(RespRuleVO::getRuleId));
            String refuseMsg = "";
            String reasonCode = "";
            List prdSoltRules = this.prdSoltRuleService.queryByPrdIdAndSoltCode(prdId, slotCode);
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < prdSoltRules.size(); ++j) {
                String order = ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleOrder();
                Method methodRuleName = NlsProcessRuleVO.class.getMethod("setRuleName" + order, String.class);
                Method methodRuleState = NlsProcessRuleVO.class.getMethod("setRuleState" + order, String.class);
                Method methodRuleTime = NlsProcessRuleVO.class.getMethod("setRuleTime" + order, String.class);
                methodRuleName.invoke((Object)nlsProcessRuleVO, ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                methodRuleTime.invoke((Object)nlsProcessRuleVO, DateUtility.getCurrAppDateTimeString());
                if (map.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()) != null) {
                    methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    sb.append(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleName()).append("\u89c4\u5219\u4e0d\u901a\u8fc7;");
                    reasonCode = (String)MsLoanConstant.ReasonCodeMap.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                    refuseMsg = (String)MsLoanConstant.ReasonMsgMap.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                    break;
                }
                methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
            }
            nlsCreditInfoVO.setBdReasonCode(reasonCode);
            nlsCreditInfoVO.setBdReasonMsg(refuseMsg);
            this.nlsProcessRuleService.insertNlsProcessRule(nlsProcessRuleVO);
            if (!list.isEmpty()) {
                throw new BizException(sb.toString());
            }
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }

    private NLMHitQueryReports.RltdPrsnInfArry rltdPrsnInfArryConverter(CusIndivRelVO cusIndivRelVO) {
        return NLMHitQueryReports.RltdPrsnInfArry.builder().relaTp(cusIndivRelVO.getRelation()).lnkCustNm(cusIndivRelVO.getRelName()).rltvPrsnIdentTp(cusIndivRelVO.getCertType()).rltvPrsnIdentNo(cusIndivRelVO.getCertCode()).build();
    }
}

