/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditBasicInfo;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditExpanding;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditMessage;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditReq;
import com.irdstudio.efp.esb.service.bo.resp.sx.CreditResp;
import com.irdstudio.efp.esb.service.facade.sx.CreditService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="creditBackService")
public class CreditBackServiceImpl
extends CreditSoltServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(CreditBackServiceImpl.class);
    @Autowired
    @Qualifier(value="creditService")
    private CreditService creditService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;

    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        try {
            logger.info("\u6388\u4fe1\u7533\u8bf7\u5ba1\u6838\u901a\u77e5\u63a5\u53e3\uff0c\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsCreditInfoVO);
            CreditReq creditReq = new CreditReq();
            CreditMessage creditMessage = new CreditMessage();
            CreditBasicInfo creditBasicInfo = new CreditBasicInfo();
            CreditExpanding creditExpanding = new CreditExpanding();
            creditReq.setRqsFlg(nlsCreditInfoVO.getBdReqSn());
            creditReq.setRetCd(MsLoanConstant.RetCodeEnum.SUCCESS.VALUE);
            creditReq.setTxnMd("async");
            creditMessage.setSessionId(applySeq);
            creditMessage.setEvTp("apply");
            creditMessage.setEvID(nlsCreditInfoVO.getBdTransactionId());
            creditMessage.setRqsTmstmp(TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmss"));
            creditBasicInfo.setIDCertNo(nlsCreditInfoVO.getCertCode());
            creditBasicInfo.setBankCardNo(nlsCreditInfoVO.getRecvAccount());
            creditBasicInfo.setCustNm(nlsCreditInfoVO.getCusName());
            creditBasicInfo.setMblNo(nlsCreditInfoVO.getIndivMobile());
            creditExpanding.setCrdtLmt(nlsCreditInfoVO.getApplyAmt() + "");
            creditExpanding.setCrdtDt(nlsCreditInfoVO.getApplyTerm());
            creditExpanding.setInstRsnCd(nlsCreditInfoVO.getBdReasonCode());
            creditExpanding.setInstRsnCdRmk(nlsCreditInfoVO.getBdReasonMsg());
            creditExpanding.setInstPolcyCd(MsLoanConstant.RisCodeEnum.SUCCESS.VALUE);
            creditMessage.setBasicInfo((Object)creditBasicInfo);
            creditMessage.setExpanding((Object)creditExpanding);
            creditReq.setMessage((Object)creditMessage);
            CreditResp creditResp = this.creditService.creditNotify(creditReq);
            Objects.requireNonNull(creditResp);
            if (!MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(creditResp.getRetCd()) || !"E1001".equals(creditResp.getRetCd())) {
                logger.error("\u8c03\u7528\u6388\u4fe1\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u51fa\u9519");
            }
        }
        catch (Exception e) {
            logger.error("\u6388\u4fe1\u5ba1\u6838\u901a\u77e5\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

