/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.cdp.pboc.service.facade.BdZxInfoService;
import com.irdstudio.cdp.pboc.service.vo.BdZxInfoVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.nls.common.constant.MYDAdaptedSoltEnum;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.sx.zxruleforbd.BdZxRuleInterface;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.common.enumeration.Rule;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import com.irdstudio.efp.rule.service.vo.ReqBdCreditRuleVo;
import com.irdstudio.efp.rule.service.vo.ReqRuleVo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="creditBdZxRuleService")
public class CreditBdZxRuleServiceImpl
extends CreditSoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(CreditBdZxRuleServiceImpl.class);
    @Autowired
    Map<String, BdZxRuleInterface> bdZxRules;
    @Autowired
    @Qualifier(value="bdZxInfoService")
    private BdZxInfoService bdZxInfoService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="ruleCallService")
    private RuleCallService ruleService;
    private static final String zxRule = "CcrcRule";

    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        logger.info("======>\u767e\u5ea6\u5f81\u4fe1\u89c4\u5219\u5f00\u59cb<====== \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + nlsCreditInfoVO.getLmtApplySeq());
        try {
            String soltName = nlsProcessBizVo.getSoltName3();
            String soltCode = nlsCreditInfoVO.getSoltCode();
            String lmtApplySeq = nlsCreditInfoVO.getLmtApplySeq();
            String prdId = nlsCreditInfoVO.getPrdId();
            boolean canExecue = StringUtils.equals((CharSequence)MYDAdaptedSoltEnum.SOLT_APPLY_PBOC.getSoltName(), (CharSequence)soltName);
            if (canExecue) {
                return;
            }
            BdZxInfoVO pbocData = this.getPbocData(nlsCreditInfoVO);
            if (Objects.isNull(pbocData)) {
                throw new BizException("\u3010\u767e\u5ea6\u5f81\u4fe1\u89c4\u5219\u63d2\u69fd\u3011 \u83b7\u53d6\u767e\u5ea6\u6388\u4fe1\u63a5\u53e3\u4e2d\u7684\u5f81\u4fe1\u89c4\u5219\u5931\u8d25!!!");
            }
            ReqBdCreditRuleVo param = new ReqBdCreditRuleVo();
            for (BdZxRuleInterface rule : this.bdZxRules.values()) {
                rule.executeRule(param, pbocData);
            }
            ReqRuleVo reqRuleVo = new ReqRuleVo();
            reqRuleVo.setAppNo(nlsCreditInfoVO.getLmtApplySeq());
            reqRuleVo.setPrdCode(nlsCreditInfoVO.getPrdCode());
            reqRuleVo.setReqBdCreditRuleVo(param);
            List list = this.ruleService.executeBatchRule(Rule.RuleType.BD_CREDIT_RULE, reqRuleVo);
            this.nlsQueueSoltComnService.ruleResultDeal(list, lmtApplySeq, prdId, soltCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get(zxRule));
            nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get(zxRule));
            nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
            nlsProcessBizVo.setRefuseMsg(e.getMessage());
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }

    private BdZxInfoVO getPbocData(NlsCreditInfoVO nlsCreditInfoVO) {
        BdZxInfoVO bdZxInfoVO = new BdZxInfoVO();
        bdZxInfoVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        return this.bdZxInfoService.queryByPk(bdZxInfoVO);
    }
}

