/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.HangException;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.ZX11001QueryReports;
import com.irdstudio.efp.esb.service.bo.resp.zx.ZX11001ResponseReport;
import com.irdstudio.efp.esb.service.facade.zx.ZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="creditBlackService")
public class CreditBlackServiceImpl
extends CreditSoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CreditBlackServiceImpl.class);
    private static final String blackRule = "BdAccessRule010";
    @Autowired
    @Qualifier(value="zx11001Service")
    private ZXService<ZX11001QueryReports> zx11001Service;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        try {
            log.info("\u5f00\u59cb\u8fdb\u884c\u9ed1\u540d\u5355\u89c4\u5219\u4ea7\u54c1,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsCreditInfoVO);
            String prdId = Objects.requireNonNull(nlsCreditInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            int blackListNum = 0;
            String pbocCertTp = "0";
            ZX11001QueryReports zx11001QueryReports = new ZX11001QueryReports.Builder().withName(nlsCreditInfoVO.getCusName()).withCertNo(nlsCreditInfoVO.getCertCode()).withCertType(pbocCertTp).build();
            try {
                ZXVO zxvo = this.zx11001Service.service((Object)zx11001QueryReports, prdInfoVo.getZxOpId());
                log.info("\u9ed1\u540d\u5355\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u67e5\u8be2\u9ed1\u540d\u5355\u63a5\u53e3\u5b8c\u6210");
                ZX11001ResponseReport content = (ZX11001ResponseReport)((List)zxvo.getResp()).get(0);
                Objects.requireNonNull(content);
                Supplier<Integer> zero = () -> 0;
                blackListNum = Stream.of(content.getBankPushBlklistArry(), content.getHghCrtExecPrsnLstArry(), content.getHghCrtLsCrdblPrsnLstArry(), content.getOwnFraudBlklistArry(), content.getOwnSzRskIndBlklistArry(), content.getP2PLsCrdblPrsnLstArry(), content.getOwnRskCardIndBlklistArry(), content.getAbnTxBlklistArry(), content.getLoanRskIndBlklistArry(), content.getIndvBlklistInfArry(), content.getSmhldBlkshlistInfArry(), content.getPBCPblcInfBadBlklistArry(), content.getConsmFinBsnCustBlklistArry()).map(Optional::ofNullable).map(i -> i.map(List::size).orElseGet(zero)).reduce(0, Integer::sum);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get(blackRule));
                nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get(blackRule));
                throw new HangException("\u8c03\u7528\u9ed1\u540d\u5355\u5f02\u5e38", (Throwable)e);
            }
            if (blackListNum > 0) {
                nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get(blackRule));
                nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get(blackRule));
                nlsProcessBizVo.setRefuseMsg("\u547d\u4e2d\u9ed1\u540d\u5355\u6b21\u6570\uff1a" + blackListNum);
                throw new BizException("\u547d\u4e2d\u9ed1\u540d\u5355\u6b21\u6570\uff1a" + blackListNum);
            }
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }
}

