/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.gdrcu.efp.cus.common.CusBankRelEnum;
import com.gdrcu.efp.cus.common.CusStatusEnum;
import com.gdrcu.efp.cus.common.CusTypeEnum;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.cus.service.facade.CusIndivRelService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqCusInfoCreBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespCusInfoCreBean;
import com.irdstudio.efp.esb.service.facade.hj.CustomerInfoCreateService;
import com.irdstudio.efp.nls.service.facade.NlsApplyRelationService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="creditCusCreateService")
public class CreditCusCreateServiceImpl
extends CreditSoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CreditCusCreateServiceImpl.class);
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"CREL$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final String other = "Other";
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsApplyRelationService")
    private NlsApplyRelationService nlsApplyRelationService;
    @Autowired
    @Qualifier(value="customerInfoCreateService")
    private CustomerInfoCreateService customerInfoCreateService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusIndivRelService")
    private CusIndivRelService cusIndivRelService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        try {
            log.info("\u5f00\u59cb\u8fdb\u884c\u5ba2\u6237\u5efa\u6863\u63d2\u69fd,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsCreditInfoVO);
            String cusId = this.cusIndivService.getCusIdByCertCode(nlsCreditInfoVO.getCertType(), nlsCreditInfoVO.getCertCode());
            String usrID = "";
            boolean cusIndivExsit = true;
            try {
                if (cusId == null) {
                    log.info("\u7f51\u8d37\u4e0d\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u524d\u5f80\u4e92\u91d1\u5efa\u6863");
                    ReqCusInfoCreBean reqCusInfoCreBean = new ReqCusInfoCreBean();
                    reqCusInfoCreBean.setCustNm(nlsCreditInfoVO.getCusName());
                    reqCusInfoCreBean.setCertTp(nlsCreditInfoVO.getCertType());
                    reqCusInfoCreBean.setCertNo(nlsCreditInfoVO.getCertCode());
                    reqCusInfoCreBean.setIssueOrgNm("\u4e2d\u56fd");
                    reqCusInfoCreBean.setMblNo(nlsCreditInfoVO.getIndivMobile());
                    reqCusInfoCreBean.setCtcAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getIndivRsdAddr()));
                    reqCusInfoCreBean.setEthnic(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getEthnic()));
                    reqCusInfoCreBean.setClntEnNm("");
                    reqCusInfoCreBean.setIssueOrgAddrCd("");
                    reqCusInfoCreBean.setHighEdu(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getEdu()));
                    reqCusInfoCreBean.setNation("");
                    reqCusInfoCreBean.setCrrCd(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getProfession()));
                    reqCusInfoCreBean.setTtl(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getTtl()));
                    reqCusInfoCreBean.setBrthDt("");
                    reqCusInfoCreBean.setWrkCorpNm(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getWrkCorpNm()));
                    reqCusInfoCreBean.setWrkCorpAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getWrkCorpAddr()));
                    reqCusInfoCreBean.setWrkCorpTel("");
                    reqCusInfoCreBean.setFamAddr("");
                    reqCusInfoCreBean.setFamTelNo("");
                    reqCusInfoCreBean.setIndvIncmAmt("");
                    reqCusInfoCreBean.setFamIncmAmt("");
                    reqCusInfoCreBean.setMrgSitu(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getMrgSitu()));
                    reqCusInfoCreBean.setSpsNm(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getSpsNm()));
                    reqCusInfoCreBean.setDomcAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getCertAddr()));
                    reqCusInfoCreBean.setSpsCtcTelNo("");
                    reqCusInfoCreBean.setSpsMblTelNo("");
                    reqCusInfoCreBean.setSpsCustNo("");
                    reqCusInfoCreBean.setPstcd("");
                    reqCusInfoCreBean.setCorpChar("");
                    reqCusInfoCreBean.setWhthrFrmr("");
                    reqCusInfoCreBean.setUserGnd(nlsCreditInfoVO.getGender());
                    reqCusInfoCreBean.setInstId("00043");
                    reqCusInfoCreBean.setProdType(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"PrdType", (String)nlsCreditInfoVO.getPrdId()));
                    RespCusInfoCreBean respCusInfoCreBean = this.customerInfoCreateService.customerInfoCreate(reqCusInfoCreBean);
                    cusId = respCusInfoCreBean.getClntNo();
                    usrID = respCusInfoCreBean.getUsrID();
                    cusIndivExsit = false;
                } else {
                    log.info("\u7f51\u8d37\u5df2\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u5ba2\u6237\u53f7\uff1a" + cusId);
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u4e92\u91d1\u6838\u5fc3\u5ba2\u6237\u5efa\u6863\u5f02\u5e38", (Throwable)e);
                nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                throw new BizException("\u8c03\u7528\u4e92\u91d1\u6838\u5fc3\u5ba2\u6237\u5efa\u6863\u5f02\u5e38", (Throwable)e);
            }
            String prdId = Objects.requireNonNull(nlsCreditInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            String dateString = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
            String dateTimeString = LocalDateTime.now().format(timeStrFormatter);
            String createUser = "admin";
            CusIndivVO cusIndivVO = new CusIndivVO();
            cusIndivVO.setCusId(usrID);
            cusIndivVO.setInnerCusId(cusId);
            cusIndivVO.setCusName(nlsCreditInfoVO.getCusName());
            cusIndivVO.setIndivSex(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname());
            cusIndivVO.setCertType(nlsCreditInfoVO.getCertType());
            cusIndivVO.setCertCode(nlsCreditInfoVO.getCertCode());
            cusIndivVO.setPhone(nlsCreditInfoVO.getIndivMobile());
            cusIndivVO.setCusType(CusTypeEnum.NATURAL_MAN.getCode());
            cusIndivVO.setCusBankRel(CusBankRelEnum.NORMAL.getCode());
            cusIndivVO.setIndivHouhRegAdd(nlsCreditInfoVO.getCertAddr());
            cusIndivVO.setCusStatus(CusStatusEnum.OFFICIAL.getCode());
            cusIndivVO.setIndivNtn(nlsCreditInfoVO.getEthnic());
            cusIndivVO.setIndivEdt(nlsCreditInfoVO.getEdu());
            cusIndivVO.setIndivComName(nlsCreditInfoVO.getWrkCorpNm());
            cusIndivVO.setIndivComAddr(nlsCreditInfoVO.getWrkCorpAddr());
            cusIndivVO.setIndivSpsName(nlsCreditInfoVO.getSpsNm());
            cusIndivVO.setIndivCrtfctn(nlsCreditInfoVO.getTtl());
            cusIndivVO.setIndivOcc(nlsCreditInfoVO.getProfession());
            cusIndivVO.setIndivHouhRegAdd(nlsCreditInfoVO.getCertAddr());
            cusIndivVO.setIndivRsdAddr(nlsCreditInfoVO.getIndivRsdAddr());
            cusIndivVO.setFstAppChannel(prdInfoVo.getPrdType());
            cusIndivVO.setIndivMarSt(nlsCreditInfoVO.getMrgSitu());
            cusIndivVO.setInputId("admin");
            cusIndivVO.setLastUpdateTime(dateTimeString);
            cusIndivVO.setLastUpdateUser("admin");
            if (cusIndivExsit) {
                int num1 = this.cusIndivService.updateByPk(cusIndivVO);
                if (num1 == -1) {
                    throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u66f4\u65b0\u5f02\u5e38!");
                }
            } else {
                cusIndivVO.setComInitLoanDate(dateString);
                cusIndivVO.setInputDate(dateString);
                cusIndivVO.setCreateTime(dateTimeString);
                int num2 = this.cusIndivService.insertCusIndiv(cusIndivVO);
                if (num2 == -1) {
                    throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u589e\u52a0\u5f02\u5e38!");
                }
            }
            if (!Objects.equals(nlsCreditInfoVO.getCusId(), usrID)) {
                nlsCreditInfoVO.setCusId(usrID);
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            }
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get(other));
            nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get(other));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }
}

