/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditBasicInfo;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditExpanding;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditMessage;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditReq;
import com.irdstudio.efp.esb.service.bo.resp.sx.CreditResp;
import com.irdstudio.efp.esb.service.facade.sx.CreditService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="creditLmtService")
public class CreditLmtServiceImpl
extends CreditSoltServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(CreditLmtServiceImpl.class);
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"lmt$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final String other = "Other";
    private String expire_date = "2099-12-31";
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="creditService")
    private CreditService creditService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;

    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        logger.info("\u6388\u4fe1\u7533\u8bf7\u5ba1\u6838\u901a\u77e5\u63a5\u53e3\uff0c\u6d41\u6c34\u53f7:" + applySeq);
        try {
            Objects.requireNonNull(nlsCreditInfoVO);
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(nlsCreditInfoVO.getPrdId());
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setCertType(nlsCreditInfoVO.getCertType());
            lmtPrdContVO.setCertCode(nlsCreditInfoVO.getCertCode());
            lmtPrdContVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
            List lmtList = this.lmtPrdContService.queryLmtPrdList(lmtPrdContVO);
            if (lmtList != null && lmtList.size() > 0) {
                lmtPrdContVO.setLmtStatus("03");
                int num0 = this.lmtPrdContService.updateByPk(lmtPrdContVO);
                if (num0 == -1) {
                    throw new BizException("\u66f4\u65b0\u989d\u5ea6\u534f\u8bae\u8868\u5f02\u5e38!");
                }
            }
            lmtPrdContVO.setLmtContNo(this.generateLmtContNo());
            lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            lmtPrdContVO.setCusId(nlsCreditInfoVO.getCusId());
            lmtPrdContVO.setCusName(nlsCreditInfoVO.getCusName());
            lmtPrdContVO.setCertType(nlsCreditInfoVO.getCertType());
            lmtPrdContVO.setCertCode(nlsCreditInfoVO.getCertCode());
            lmtPrdContVO.setChannelNo(nlsCreditInfoVO.getChannelNo());
            lmtPrdContVO.setPrdId(nlsCreditInfoVO.getPrdId());
            lmtPrdContVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
            lmtPrdContVO.setPrdName(nlsCreditInfoVO.getPrdName());
            lmtPrdContVO.setLmtAmt(nlsCreditInfoVO.getApproveAmt());
            lmtPrdContVO.setCyclicFlg(nlsCreditInfoVO.getCyclicFlg() == null ? "" : nlsCreditInfoVO.getCyclicFlg());
            lmtPrdContVO.setCurrencyType(nlsCreditInfoVO.getCurrencyType());
            lmtPrdContVO.setTerm(new BigDecimal(nlsCreditInfoVO.getApplyTerm()));
            lmtPrdContVO.setTermType(nlsCreditInfoVO.getTermType());
            lmtPrdContVO.setRateY(StringUtil.isNullorBank((String)(nlsCreditInfoVO.getApplyRateY() + "")) ? BigDecimal.ZERO : nlsCreditInfoVO.getApplyRateY());
            lmtPrdContVO.setAssureMeansMain(StringUtil.isNullorBank((String)nlsCreditInfoVO.getAssureMeansMain()) ? "" : nlsCreditInfoVO.getAssureMeansMain());
            lmtPrdContVO.setAssureMeans2(StringUtil.isNullorBank((String)nlsCreditInfoVO.getAssureMeans2()) ? "" : nlsCreditInfoVO.getAssureMeans2());
            lmtPrdContVO.setAssureMeans3(StringUtil.isNullorBank((String)nlsCreditInfoVO.getAssureMeans3()) ? "" : nlsCreditInfoVO.getAssureMeans3());
            lmtPrdContVO.setRepaymentMode(StringUtil.isNullorBank((String)nlsCreditInfoVO.getRepaymentMode()) ? "" : nlsCreditInfoVO.getRepaymentMode());
            lmtPrdContVO.setRepaymentPeriod(StringUtil.isNullorBank((String)nlsCreditInfoVO.getRepaymentPeriod()) ? BigDecimal.ZERO : new BigDecimal(nlsCreditInfoVO.getRepaymentPeriod()));
            lmtPrdContVO.setRepaymentPeriodType(StringUtil.isNullorBank((String)nlsCreditInfoVO.getRepaymentPeriodType()) ? "" : nlsCreditInfoVO.getRepaymentPeriodType());
            lmtPrdContVO.setRepaymentDay(StringUtil.isNullorBank((String)nlsCreditInfoVO.getRepaymentDay()) ? BigDecimal.ZERO : new BigDecimal(nlsCreditInfoVO.getRepaymentDay()));
            lmtPrdContVO.setRepaymentDayType(StringUtil.isNullorBank((String)nlsCreditInfoVO.getRepaymentDayType()) ? "" : nlsCreditInfoVO.getRepaymentDayType());
            lmtPrdContVO.setLoanUse(StringUtil.isNullorBank((String)nlsCreditInfoVO.getLoanUseType()) ? "" : nlsCreditInfoVO.getLoanUseType());
            lmtPrdContVO.setLmtStatus("02");
            lmtPrdContVO.setStartDate(nlsCreditInfoVO.getApplyDate());
            int term_ = Integer.valueOf(nlsCreditInfoVO.getApplyTerm() == null ? "0" : nlsCreditInfoVO.getApplyTerm());
            if ("D".equals(nlsCreditInfoVO.getTermType())) {
                this.expire_date = TimeUtil.addDay((String)nlsCreditInfoVO.getApplyDate(), (int)term_);
            } else if ("M".equals(nlsCreditInfoVO.getTermType())) {
                this.expire_date = TimeUtil.addMonth((String)nlsCreditInfoVO.getApplyDate(), (int)term_);
            } else if ("Y".equals(nlsCreditInfoVO.getTermType())) {
                this.expire_date = TimeUtil.addYear((String)nlsCreditInfoVO.getApplyDate(), (int)term_);
            }
            lmtPrdContVO.setExpireDate(this.expire_date);
            lmtPrdContVO.setSignDate(nlsCreditInfoVO.getApplyDate());
            lmtPrdContVO.setValidDays(prdInfoVo.getCreditTerm());
            lmtPrdContVO.setCreateTime(DateUtility.getCurrAppDateTimeString());
            lmtPrdContVO.setCreateUser("admin");
            lmtPrdContVO.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
            lmtPrdContVO.setLastUpdateUser("admin");
            int num1 = this.lmtPrdContService.insertLmtPrdCont(lmtPrdContVO);
            if (num1 == -1) {
                throw new BizException("\u63d2\u5165\u989d\u5ea6\u534f\u8bae\u8868\u5f02\u5e38!");
            }
            nlsCreditInfoVO.setApproveRateY(nlsCreditInfoVO.getApplyRateY());
            int num2 = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            if (num2 == -1) {
                throw new BizException("\u66f4\u65b0\u6279\u590d\u6267\u884c\u5e74\u5229\u7387\u5f02\u5e38!");
            }
            this.creditLmtBack(nlsCreditInfoVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6388\u4fe1\u5ba1\u6838\u901a\u77e5\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            nlsCreditInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get(other));
            nlsCreditInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get(other));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }

    private void creditLmtBack(NlsCreditInfoVO nlsCreditInfoVO) {
        try {
            logger.info("\u6388\u4fe1\u7533\u8bf7\u5ba1\u6838\u901a\u77e5\u63a5\u53e3\uff0c\u6d41\u6c34\u53f7:" + nlsCreditInfoVO.getLmtApplySeq());
            Objects.requireNonNull(nlsCreditInfoVO);
            CreditReq creditReq = new CreditReq();
            CreditMessage creditMessage = new CreditMessage();
            CreditBasicInfo creditBasicInfo = new CreditBasicInfo();
            CreditExpanding creditExpanding = new CreditExpanding();
            creditReq.setRqsFlg(nlsCreditInfoVO.getBdReqSn());
            creditReq.setProdCd(nlsCreditInfoVO.getPrdCode());
            creditReq.setRetCd(MsLoanConstant.RetCodeEnum.SUCCESS.VALUE);
            creditReq.setTxnMd("async");
            creditReq.setRepeatRqsBss(nlsCreditInfoVO.getBdReqSn());
            creditMessage.setSessionId(nlsCreditInfoVO.getLmtApplySeq());
            creditMessage.setEvTp("apply");
            creditMessage.setEvID(nlsCreditInfoVO.getBdTransactionId());
            creditMessage.setRqsTmstmp(TimeUtil.getSeconTimestamp((Date)new Date()));
            creditBasicInfo.setIDCertNo(nlsCreditInfoVO.getCertCode());
            creditBasicInfo.setBankCardNo(nlsCreditInfoVO.getRecvAccount());
            creditBasicInfo.setCustNm(nlsCreditInfoVO.getCusName());
            creditBasicInfo.setMblNo(nlsCreditInfoVO.getIndivMobile());
            creditExpanding.setCrdtLmt(nlsCreditInfoVO.getApplyAmt() + "");
            creditExpanding.setCrdtDt(nlsCreditInfoVO.getApplyTerm());
            creditExpanding.setInstRsnCd(nlsCreditInfoVO.getBdReasonCode());
            creditExpanding.setInstRsnCdRmk(nlsCreditInfoVO.getBdReasonMsg());
            creditExpanding.setInstPolcyCd(MsLoanConstant.RisCodeEnum.SUCCESS.VALUE);
            creditMessage.setBasicInfo((Object)creditBasicInfo);
            creditMessage.setExpanding((Object)creditExpanding);
            creditReq.setMessage((Object)creditMessage);
            CreditResp creditResp = this.creditService.creditNotify(creditReq);
            if (!MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(creditResp.getRetCd()) || !"E1001".equals(creditResp.getRetCd())) {
                logger.error("\u8c03\u7528\u6388\u4fe1\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u51fa\u9519");
            } else {
                logger.error("\u8c03\u7528\u6388\u4fe1\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6388\u4fe1\u5ba1\u6279\u7ed3\u679c\u56de\u8c03\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public String generateLmtContNo() {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("LMT", pattern);
    }
}

