/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ExternalSysException;
import com.irdstudio.basic.framework.core.exception.HangException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.exception.QueuePauseException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.efp.basic.framework.mq.client.producer.MQProducerMessageClient;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.console.common.PrdBizEnums;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditBasicInfo;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditExpanding;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditMessage;
import com.irdstudio.efp.esb.service.bo.req.sx.CreditReq;
import com.irdstudio.efp.esb.service.facade.sx.CreditService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.NlsProcessBizEnums;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.common.constant.QueueTaskEnums;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.facade.queue.NlsQueueTaskService;
import com.irdstudio.efp.nls.service.facade.sx.CreditSoltService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class CreditSoltServiceImpl
implements CreditSoltService {
    private static Logger logger = LoggerFactory.getLogger(CreditSoltServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsQueueTaskService")
    private NlsQueueTaskService nlsQueueTaskService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="creditService")
    private CreditService creditService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="producerService")
    private MQProducerMessageClient producerService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO, int soltOrder) throws QueuePauseException, HangException, BizException, Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String soltCode = nlsProcessBizVo.getSoltCode();
        String soltName = nlsProcessBizVo.getSoltName();
        String soltService = nlsProcessBizVo.getSoltService();
        logger.info("*********************************************");
        logger.info("*            \u5f00\u59cb\u4e00\u4e2a\u65b0\u7684\u63d2\u69fd                 * ");
        logger.info("* \u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  *");
        logger.info("* \u63d2\u69fd\u4ee3\u7801 : \u3010" + soltCode + "\u3011  *");
        logger.info("* \u63d2\u69fd\u540d\u79f0 : \u3010" + soltName + "\u3011  *");
        logger.info("* \u63d2\u69fd\u670d\u52a1 : \u3010" + soltService + "\u3011  *");
        logger.info("*********************************************");
        try {
            Method methodSoltstate = nlsProcessBizVo.getClass().getMethod("setSoltState" + soltOrder, String.class);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u5f00\u59cb");
            methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.EXECUTING.getCode());
            this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u7ed3\u675f");
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u8c03\u7528\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u5f00\u59cb");
            this.doExecute(nlsProcessBizVo, nlsCreditInfoVO);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u8c03\u7528\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u7ed3\u675f");
            boolean exceptionFlag = nlsProcessBizVo.isExceptionFlag();
            int hangTimes = nlsProcessBizVo.getHangTimes();
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u6839\u636e\u5f02\u5e38\u6807\u5fd7\u3010" + exceptionFlag + "\u3011\u5904\u7406\u540e\u7eed\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4fe1\u606f");
            if (exceptionFlag) {
                Exception exception = nlsProcessBizVo.getExceptionMsg();
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u6839\u636e\u5f02\u5e38\u3010" + exception + "\u3011\u5904\u7406\u540e\u7eed\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4fe1\u606f");
                NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
                nlsProcessRuleVO.setApplySeq(applySeq);
                nlsProcessRuleVO = this.nlsProcessRuleService.queryByPk(nlsProcessRuleVO);
                if (exception instanceof HangException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5904\u7406\u8be5\u63d2\u69fd\u7684\u6302\u8d77\u5f02\u5e38\u5f00\u59cb");
                    if (++hangTimes <= QueueTaskEnums.QueueHangTimesEnum.MAX.getTimes()) {
                        logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5f02\u5e38\u7c7b\u578b\u4e3a\u6302\u8d77\u5f02\u5e38\u65f6\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6302\u8d77\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6302\u8d77\uff0c\u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u6302\u8d77");
                        methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.HANG.getCode());
                        nlsProcessBizVo.setHangTimes(hangTimes);
                        nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.HANG.getCode());
                        nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                        nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                        nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.HANG.getRspCode());
                        nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.HANG.getRspMsg());
                        nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.HANG.getVALUE());
                        nlsCreditInfoVO.setRefuseCause(exception.getMessage());
                        nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                        nlsCreditInfoVO.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
                        this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                        this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                        logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u6302\u8d77\u5f02\u5e38\u7ed3\u675f");
                        this.producerService.sendMsg(new Message(TopicEnums.QUEUE_TASK_HANG_CREDIT_TOPIC.getTopicId(), TagEnums.TAG_QUEUE_HANG_CREDIT_TASK.getTagId(), nlsCreditInfoVO.getLmtApplySeq().concat(".").concat(String.valueOf(hangTimes)), JSON.toJSONString((Object)nlsCreditInfoVO).getBytes("UTF-8")), 1);
                        throw exception;
                    }
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5f02\u5e38\u7c7b\u578b\u4e3a\u6302\u8d77\u5f02\u5e38\u65f6\uff0c\u8be5\u63d2\u69fd\u6302\u8d77\u6b21\u6570\u4e3a\uff1a\u3010" + hangTimes + "\u3011\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\uff0c \u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u62d2\u7edd\u5f00\u59cb");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.HANG_MAX_TIMES.getRspCode());
                    nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.HANG_MAX_TIMES.getRspMsg());
                    nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                    String message = "\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5f02\u5e38\u7c7b\u578b\u4e3a\u6302\u8d77\u5f02\u5e38\u65f6\uff0c\u8be5\u63d2\u69fd\u6302\u8d77\u6b21\u6570\u4e3a\uff1a\u3010" + hangTimes + "\u3011\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\uff0c \u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u62d2\u7edd\u7ed3\u675f";
                    logger.info(message);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u6267\u884c\u901a\u77e5\u6388\u4fe1\u5ba1\u6279\u5931\u8d25\u903b\u8f91");
                    NlsQueueSoltComnService nlsQueueSoltComnService = (NlsQueueSoltComnService)SpringContextUtils.getBean((String)"nlsQueueSoltComnService");
                    nlsQueueSoltComnService.alarmNotice(EsbBizEnums.AlarmObjectName.OCM_REAL_TIME.getValue(), EsbBizEnums.AlarmLvl.SERIOUS.getValue(), message);
                    this.noticeMSIfNecessary(nlsProcessBizVo, nlsCreditInfoVO);
                } else if (exception instanceof QueuePauseException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5f02\u5e38\u7c7b\u578b\u4e3a\u6682\u505c\u5f02\u5e38\u65f6\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6682\u505c\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6682\u505c\uff0c\u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u6682\u505c");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.PAUSE.getCode());
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.PAUSE.getCode());
                    nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.PAUSE.getRspCode());
                    nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.PAUSE.getRspMsg() + "\u3002" + exception.getMessage());
                    nlsCreditInfoVO.setApprvSts(NlsApplyInfoEnums.NlsApplyState.PAUSE.getKey());
                    nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                    nlsCreditInfoVO.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
                    this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                    this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u6682\u505c\u5f02\u5e38\u7ed3\u675f");
                } else if (exception instanceof ExternalSysException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5904\u7406\u8be5\u63d2\u69fd\u7684\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38\u5f00\u59cb");
                    if (++hangTimes <= QueueTaskEnums.QueueHangTimesEnum.MAX.getTimes()) {
                        logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5f02\u5e38\u7c7b\u578b\u4e3a\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38\u65f6\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5916\u90e8\u7cfb\u7edf\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u5916\u90e8\u7cfb\u7edf\uff0c\u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u5916\u90e8\u7cfb\u7edf");
                        methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.HANG.getCode());
                        nlsProcessBizVo.setHangTimes(hangTimes);
                        nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.HANG.getCode());
                        nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                        nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                        nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.HANG.getRspCode());
                        nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.HANG.getRspMsg());
                        nlsCreditInfoVO.setApprvSts(NlsApplyInfoEnums.NlsApplyState.HANG.getKey());
                        nlsCreditInfoVO.setRefuseCause(exception.getMessage());
                        nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                        nlsCreditInfoVO.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
                        this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                        this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                        logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38\u7ed3\u675f");
                        nlsCreditInfoVO.setExceptionLocation(((ExternalSysException)exception).getErrorCode());
                        this.producerService.sendMsg(new Message(TopicEnums.QUEUE_TASK_HANG_CREDIT_TOPIC.getTopicId(), TagEnums.TAG_QUEUE_HANG_CREDIT_TASK.getTagId(), nlsCreditInfoVO.getLmtApplySeq().concat(".").concat(String.valueOf(hangTimes)), JSON.toJSONString((Object)nlsCreditInfoVO).getBytes("UTF-8")), 5);
                        throw exception;
                    }
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5f02\u5e38\u7c7b\u578b\u4e3a\u5916\u90e8\u5f02\u5e38\u65f6\uff0c\u8be5\u63d2\u69fd\u5904\u7406\u6b21\u6570\u4e3a\uff1a\u3010" + hangTimes + "\u3011\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u201c\u5931\u8d25\u201d\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u201c\u4f5c\u5e9f\u201d\uff0c \u66f4\u65b0\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2d\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u901a\u8fc7\u201d\u5f00\u59cb");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.REVOKED.getCode());
                    nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.DEAL_MAX_TIMES.getRspCode());
                    nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.DEAL_MAX_TIMES.getRspMsg());
                    nlsCreditInfoVO.setApprvSts(NlsApplyInfoEnums.NlsApplyState.PASS.getKey());
                    String message = "\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5f02\u5e38\u7c7b\u578b\u4e3a\u5916\u90e8\u5f02\u5e38\u65f6\uff0c\u8be5\u63d2\u69fd\u5904\u7406\u6b21\u6570\u4e3a\uff1a\u3010" + hangTimes + "\u3011\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u201c\u5931\u8d25\u201d\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u201c\u4f5c\u5e9f\u201d\uff0c \u66f4\u65b0\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2d\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u901a\u8fc7\u201d\u7ed3\u675f";
                    logger.info(message);
                    this.updLmtPrdCont(applySeq);
                    NlsQueueSoltComnService nlsQueueSoltComnService = (NlsQueueSoltComnService)SpringContextUtils.getBean((String)"nlsQueueSoltComnService");
                    nlsQueueSoltComnService.alarmNotice(EsbBizEnums.AlarmObjectName.OCM_REAL_TIME.getValue(), EsbBizEnums.AlarmLvl.SERIOUS.getValue(), message);
                } else if (exception instanceof OcmSystemException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5904\u7406\u8be5\u63d2\u69fd\u7684\u7cfb\u7edf\u81ea\u8eab\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u201c\u5931\u8d25\u201d\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u201c\u5931\u8d25\u201d\uff0c \u66f4\u65b0\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2d\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u901a\u8fc7\u201d\u5f00\u59cb");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspCode());
                    nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspMsg());
                    nlsCreditInfoVO.setApprvSts(NlsApplyInfoEnums.NlsApplyState.PASS.getKey());
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u7cfb\u7edf\u81ea\u8eab\u5f02\u5e38\u7ed3\u675f");
                    this.updLmtPrdCont(applySeq);
                } else if (exception instanceof BizException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c \u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u62d2\u7edd");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspCode());
                    nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspMsg());
                    nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                    this.noticeMSIfNecessary(nlsProcessBizVo, nlsCreditInfoVO);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u5f02\u5e38\u7ed3\u675f");
                } else {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5176\u5b83\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c \u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u8bf7\u8fdb\u4ef6\u4fe1\u606f\u4e2d\u7533\u8bf7\u72b6\u6001\u4e3a\u62d2\u7edd");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    nlsCreditInfoVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    nlsCreditInfoVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    nlsCreditInfoVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspCode());
                    nlsCreditInfoVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspMsg());
                    nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                    this.noticeMSIfNecessary(nlsProcessBizVo, nlsCreditInfoVO);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5176\u5b83\u5f02\u5e38\u7ed3\u675f");
                }
                nlsCreditInfoVO.setRefuseCause(exception.getMessage());
                nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                nlsCreditInfoVO.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
                nlsCreditInfoVO.setApprvDate(DateUtility.getCurrDate());
                this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                throw exception;
            }
            if ("1".equals(nlsProcessBizVo.getSoltName30())) {
                nlsCreditInfoVO.setApprvSts("03");
                nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                nlsProcessBizVo.setSoltName30("");
                nlsCreditInfoVO.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            } else {
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8be5\u63d2\u69fd\u7684\u65e0\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6210\u529f\uff0c\u6b64\u5904\u961f\u5217\u4efb\u52a1\u8868\u548c\u8fdb\u4ef6\u7533\u8bf7\u8868\u7684\u6570\u636e\u9700\u8981\u7b49\u63d2\u69fd\u5168\u90e8\u6267\u884c\u5b8c\u6210\u540e\u624d\u66f4\u65b0");
                methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
                nlsProcessBizVo.setHangTimes(QueueTaskEnums.QueueHangTimesEnum.INITIALIZE.getTimes());
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8be5\u63d2\u69fd\u7684\u65e0\u5f02\u5e38\u7ed3\u675f");
            }
            nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
            this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
            return;
        }
        catch (QueuePauseException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5904\u7406\u6682\u505c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new QueuePauseException();
        }
        catch (HangException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5904\u7406\u6302\u8d77\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new HangException();
        }
        catch (BizException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u4e1a\u52a1\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new BizException();
        }
        catch (Exception e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5176\u4ed6\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new Exception();
        }
    }

    protected abstract void doExecute(NlsProcessBizVO var1, NlsCreditInfoVO var2) throws Exception;

    private void noticeMSIfNecessary(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        try {
            if (nlsProcessBizVo.getPrdId().equals(PrdBizEnums.PrdCodeEnum.PRD_CODE_MYD.getValue()) || nlsProcessBizVo.getPrdId().equals(PrdBizEnums.PrdCodeEnum.PRD_CODE_ZXD.getValue())) {
                CreditReq creditReq = new CreditReq();
                CreditMessage creditMessage = new CreditMessage();
                CreditBasicInfo creditBasicInfo = new CreditBasicInfo();
                CreditExpanding creditExpanding = new CreditExpanding();
                creditReq.setProdCd(nlsCreditInfoVO.getPrdCode());
                creditReq.setRqsFlg(nlsCreditInfoVO.getBdReqSn());
                creditReq.setRetCd(MsLoanConstant.RetCodeEnum.SUCCESS.VALUE);
                creditReq.setTxnMd("async");
                creditReq.setRepeatRqsBss(nlsCreditInfoVO.getBdReqSn());
                creditMessage.setSessionId(nlsCreditInfoVO.getLmtApplySeq());
                creditMessage.setEvTp("apply");
                creditMessage.setEvID(nlsCreditInfoVO.getBdTransactionId());
                creditMessage.setRqsTmstmp(new Date().getTime() + "");
                creditBasicInfo.setIDCertNo(nlsCreditInfoVO.getCertCode());
                creditBasicInfo.setBankCardNo(nlsCreditInfoVO.getRecvAccount());
                creditBasicInfo.setCustNm(nlsCreditInfoVO.getCusName());
                creditBasicInfo.setMblNo(nlsCreditInfoVO.getIndivMobile());
                creditExpanding.setCrdtLmt(nlsCreditInfoVO.getApplyAmt() + "");
                creditExpanding.setCrdtDt(nlsCreditInfoVO.getApplyTerm());
                creditExpanding.setInstRsnCd(nlsCreditInfoVO.getBdReasonCode());
                creditExpanding.setInstRsnCdRmk(nlsCreditInfoVO.getBdReasonMsg());
                creditExpanding.setInstPolcyCd(MsLoanConstant.RisCodeEnum.FAILURE.VALUE);
                creditMessage.setBasicInfo((Object)creditBasicInfo);
                creditMessage.setExpanding((Object)creditExpanding);
                creditReq.setMessage((Object)creditMessage);
                this.creditService.creditNotify(creditReq);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private void updLmtPrdCont(String lmtApplySeq) {
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
        if (Objects.isNull(lmtPrdContVO)) {
            logger.error("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\u67e5\u8be2\u5230\u7684\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        lmtPrdContVO.setLmtStatus("03");
        int num = this.lmtPrdContService.updateByPk(lmtPrdContVO);
        if (num < 0) {
            logger.error("\u66f4\u65b0\u989d\u5ea6\u72b6\u6001\u4e3a\u201c\u6709\u6548\u201d\u5931\u8d25\uff0c\u5165\u53c2\u6570\u636e\u4e3a\uff1a" + JSON.toJSONString((Object)lmtPrdContVO));
        }
    }
}

