/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditExpInfoDao;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditExpInfo;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditExpInfoService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditExpInfoVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="nlsCreditExpInfoService")
public class NlsCreditExpInfoServiceImpl
implements NlsCreditExpInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(NlsCreditExpInfoServiceImpl.class);
    @Autowired
    private NlsCreditExpInfoDao nlsCreditExpInfoDao;

    public List<NlsCreditExpInfoVO> queryAllOwner(NlsCreditExpInfoVO nlsCreditInfoVo) {
        logger.debug("\u67e5\u8be2\u5f53\u524d\u7528\u6237");
        List list = null;
        try {
            List<NlsCreditExpInfo> nlsCreditInfos = this.nlsCreditExpInfoDao.queryAllOwnerByPage(nlsCreditInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
            if (Objects.nonNull(nlsCreditInfos)) {
                this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
                list = (List)this.beansCopy(nlsCreditInfos, NlsCreditExpInfoVO.class);
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditExpInfoVO> queryAllCurrOrg(NlsCreditExpInfoVO nlsCreditInfoVo) {
        logger.debug("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u53ca\u6240\u5c5e\u673a\u6784");
        List list = null;
        try {
            List<NlsCreditExpInfo> nlsCreditInfos = this.nlsCreditExpInfoDao.queryAllCurrOrgByPage(nlsCreditInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditExpInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditExpInfoVO> queryAllCurrDownOrg(NlsCreditExpInfoVO nlsCreditInfoVo) {
        logger.debug("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u5728\u673a\u6784\u53ca\u4e0b\u5c5e\u673a\u6784");
        List<Object> nlsCreditExpInfos = new ArrayList();
        List<String> orgCodes = this.nlsCreditExpInfoDao.queryLoginUserOrgLocation(nlsCreditInfoVo);
        if (!CollectionUtils.isEmpty(orgCodes)) {
            String orgCodeInSql = String.join((CharSequence)"','", orgCodes);
            nlsCreditInfoVo.setOrgCodeInSql(orgCodeInSql);
            nlsCreditExpInfos = orgCodes.size() == 1 ? this.nlsCreditExpInfoDao.queryAllCurrDownOrgByPage(nlsCreditInfoVo) : this.nlsCreditExpInfoDao.queryAllCurrDownOrgByPage(nlsCreditInfoVo);
        }
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditExpInfos.size());
        List list = null;
        try {
            this.pageSet(nlsCreditExpInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditExpInfos, NlsCreditExpInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditExpInfoVO> queryAllCurrOwnerPrd(NlsCreditExpInfoVO nlsCreditInfoVo) {
        List<Object> orgCodes = new ArrayList();
        List<Object> nlsCreditInfos = new ArrayList();
        if (!StringUtil.isEmpty((String)nlsCreditInfoVo.getPrdCodebyBaseInfo())) {
            orgCodes = Arrays.asList(nlsCreditInfoVo.getPrdCodebyBaseInfo().split(","));
        }
        if (orgCodes.size() > 0) {
            String prdCodes = String.join((CharSequence)"','", orgCodes);
            nlsCreditInfoVo.setPrdCodebyBaseInfo(prdCodes);
            nlsCreditInfos = orgCodes.size() == 1 ? this.nlsCreditExpInfoDao.queryAllCurrOwnerPrdOneByPage(nlsCreditInfoVo) : this.nlsCreditExpInfoDao.queryAllCurrOwnerPrdByPage(nlsCreditInfoVo);
        }
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        List list = null;
        try {
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditExpInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int queryCount() {
        logger.debug("\u5f53\u524d\u67e5\u6388\u4fe1\u7533\u8bf7\u5931\u6548\u8868\u6570\u636e:");
        return this.nlsCreditExpInfoDao.queryCount();
    }
}

