/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.bean.SedSynCusManageVO;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditInfo;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="nlsCreditInfoService")
public class NlsCreditInfoServiceImpl
implements NlsCreditInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(NlsCreditInfoServiceImpl.class);
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;

    public int insertNlsCreditInfo(NlsCreditInfoVO inNlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inNlsCreditInfoVo.toString());
        int num = 0;
        try {
            NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(inNlsCreditInfoVo, (Object)nlsCreditInfo);
            num = this.nlsCreditInfoDao.insertNlsCreditInfo(nlsCreditInfo);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    public int deleteByPk(NlsCreditInfoVO inNlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inNlsCreditInfoVo);
        int num = 0;
        try {
            NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(inNlsCreditInfoVo, (Object)nlsCreditInfo);
            num = this.nlsCreditInfoDao.deleteByPk(nlsCreditInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inNlsCreditInfoVo + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateByPk(NlsCreditInfoVO inNlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inNlsCreditInfoVo.toString());
        inNlsCreditInfoVo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        int num = 0;
        try {
            NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(inNlsCreditInfoVo, (Object)nlsCreditInfo);
            num = this.nlsCreditInfoDao.updateByPk(nlsCreditInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inNlsCreditInfoVo + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public NlsCreditInfoVO queryByPk(NlsCreditInfoVO inNlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inNlsCreditInfoVo);
        try {
            NlsCreditInfo queryNlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(inNlsCreditInfoVo, (Object)queryNlsCreditInfo);
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryByPk(queryNlsCreditInfo);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public NlsCreditInfoVO queryCopy(NlsCreditInfoVO inNlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inNlsCreditInfoVo);
        try {
            NlsCreditInfo queryNlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(inNlsCreditInfoVo, (Object)queryNlsCreditInfo);
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryCopy(queryNlsCreditInfo);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<NlsCreditInfoVO> queryAllOwner(NlsCreditInfoVO nlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryAllOwnerByPage(nlsCreditInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditInfoVO> queryAllCurrOrg(NlsCreditInfoVO nlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryAllCurrOrgByPage(nlsCreditInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        List list = null;
        try {
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditInfoVO> queryAllCurrDownOrg(NlsCreditInfoVO nlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<Object> nlsCreditInfos = new ArrayList();
        List<String> orgCodes = this.nlsCreditInfoDao.queryLoginUserOrgLocation(nlsCreditInfoVo);
        if (!CollectionUtils.isEmpty(orgCodes)) {
            String orgCodeInSql = String.join((CharSequence)"','", orgCodes);
            nlsCreditInfoVo.setOrgCodeInSql(orgCodeInSql);
            nlsCreditInfos = orgCodes.size() == 1 ? this.nlsCreditInfoDao.queryAllCurrDownOrgOneByPage(nlsCreditInfoVo) : this.nlsCreditInfoDao.queryAllCurrDownOrgByPage(nlsCreditInfoVo);
        }
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        List list = null;
        try {
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditInfoVO> queryAllCurrOwnerPrd(NlsCreditInfoVO nlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<Object> orgCodes = new ArrayList();
        List<Object> nlsCreditInfos = new ArrayList();
        if (!StringUtil.isEmpty((String)nlsCreditInfoVo.getPrdCodebyBaseInfo())) {
            orgCodes = Arrays.asList(nlsCreditInfoVo.getPrdCodebyBaseInfo().split(","));
        }
        if (orgCodes.size() > 0) {
            String prdCodes = String.join((CharSequence)"','", orgCodes);
            nlsCreditInfoVo.setPrdCodebyBaseInfo(prdCodes);
            nlsCreditInfos = orgCodes.size() == 1 ? this.nlsCreditInfoDao.queryAllCurrOwnerPrdOneByPage(nlsCreditInfoVo) : this.nlsCreditInfoDao.queryAllCurrOwnerPrdByPage(nlsCreditInfoVo);
        }
        logger.debug("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        List list = null;
        try {
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditInfoVO> queryCertCode(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u67e5\u8be2\u5f53\u524d\u5ba2\u6237\u662f\u5426\u5b58\u5728\u8fdb\u4ef6\u7533\u8bf7:");
        List<NlsCreditInfoVO> nlsCreditInfos = this.nlsCreditInfoDao.queryCertCode(nlsCreditInfoVO);
        logger.debug("\u67e5\u8be2\u5f53\u524d\u5ba2\u6237\u662f\u5426\u5b58\u5728\u8fdb\u4ef6\u7533\u8bf7:" + nlsCreditInfos.size());
        List list = null;
        try {
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertOrUpdateNlsCreditInfo(List<NlsCreditInfoVO> list) {
        LocalDate today = LocalDate.now();
        String msg1 = "\u3010\u6388\u4fe1\u7533\u8bf7\u6b63\u5f0f\u8868\u3011\u6570\u636e\u540c\u6b65\u5f00\u59cb..." + today;
        logger.info(msg1, (Object)"message{}");
        ArrayList<NlsCreditInfo> nlsCreditInfoList = new ArrayList();
        int num = 0;
        try {
            nlsCreditInfoList = (List)this.beansCopy(list, NlsCreditInfo.class);
            num = this.nlsCreditInfoDao.insertOrUpdateNlsCreditInfo(nlsCreditInfoList);
            String num_msg = "\u3010\u6388\u4fe1\u7533\u8bf7\u6b63\u5f0f\u8868\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u5904\u7406\u7ed3\u679c:" + num;
            logger.info(num_msg, (Object)"message{}");
        }
        catch (Exception e) {
            String msg2 = "\u3010\u6388\u4fe1\u7533\u8bf7\u6b63\u5f0f\u8868\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u51fa\u73b0\u5f02\u5e38:" + e;
            logger.error(msg2, (Object)"message{}");
            num = -1;
        }
        finally {
            list = null;
            nlsCreditInfoList = null;
        }
        return num;
    }

    public List<NlsCreditInfoVO> queryAllByCondition(NlsCreditInfoVO nlsCreditInfoVo) {
        logger.debug("\u6309\u6761\u4ef6\u67e5\u8be2\u6240\u6709\u4fe1\u606f:");
        List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryAllByCondition(nlsCreditInfoVo);
        logger.debug("\u6309\u6761\u4ef6\u67e5\u8be2\u6240\u6709\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        List list = null;
        try {
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public NlsCreditInfoVO queryByTransactionId(String transactionId) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + transactionId);
        try {
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryByTransactionId(transactionId);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<NlsCreditInfoVO> countPeopelHasCredits(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u7edf\u8ba1\u67d0\u4e2a\u8eab\u4efd\u8bc1\u53f7\u662f\u5426\u6709\u591a\u4e2a\u6388\u4fe1");
        NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
        List<Object> nlsCreditInfoVOS = new ArrayList<NlsCreditInfoVO>();
        try {
            this.beanCopy(nlsCreditInfoVO, (Object)nlsCreditInfo);
            List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.countPeopelHasCredits(nlsCreditInfo);
            nlsCreditInfoVOS = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u67d0\u4e2a\u8eab\u4efd\u8bc1\u53f7\u662f\u5426\u6709\u591a\u4e2a\u6388\u4fe1\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return nlsCreditInfoVOS;
    }

    public NlsCreditInfoVO queryContractEle(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + nlsCreditInfoVO.toString());
        try {
            NlsCreditInfo queryNlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(nlsCreditInfoVO, (Object)queryNlsCreditInfo);
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryContractEle(queryNlsCreditInfo);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public NlsCreditInfoVO queryByLmtApplySeq(String lmtApplySeq) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + lmtApplySeq);
        try {
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryByLmtApplySeq(lmtApplySeq);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int updateAmtByApplySeq(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + nlsCreditInfoVO.toString());
        int num = 0;
        try {
            NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(nlsCreditInfoVO, (Object)nlsCreditInfo);
            num = this.nlsCreditInfoDao.updateAmtByApplySeq(nlsCreditInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + nlsCreditInfoVO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateApprvSts(String apprvSts, String applySeq) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u7684\u6d41\u6c34\u53f7\u4e3a:" + applySeq);
        int num = 0;
        try {
            num = this.nlsCreditInfoDao.updateApprvSts(apprvSts, applySeq);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + applySeq + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<NlsCreditInfoVO> getNeedUploadList(Integer recordsNum, String bizType, String prdId) {
        List<NlsCreditInfo> needUploadList = this.nlsCreditInfoDao.getNeedUploadList(recordsNum, bizType, prdId);
        try {
            return (List)this.beansCopy(needUploadList, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8f6c\u6362\u6570\u636e\u51fa\u9519");
            return null;
        }
    }

    public List<NlsCreditInfoVO> getFourElementsIfNullList(String prdId) {
        List<NlsCreditInfo> needUploadList = this.nlsCreditInfoDao.getFourElementsIfNullList(prdId);
        try {
            return (List)this.beansCopy(needUploadList, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8f6c\u6362\u6570\u636e\u51fa\u9519");
            return null;
        }
    }

    public List<NlsCreditInfoVO> getCreditsBycust(NlsCreditInfoVO nlsCreditInfoVO) {
        List result = null;
        logger.debug("\u67e5\u8be2\u6761\u4ef6\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)nlsCreditInfoVO));
        try {
            NlsCreditInfo nlsCreditInfo = (NlsCreditInfo)((Object)this.beanCopy(nlsCreditInfoVO, (Object)new NlsCreditInfo()));
            List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.getCreditsBycust(nlsCreditInfo);
            logger.debug("\u67e5\u8be2\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a\uff1a" + nlsCreditInfos.size());
            result = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public List<NlsCreditInfoVO> queryAllByCurrentDate(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryAllByCurrentDate(nlsCreditInfoVO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public boolean batchUpdateCusManage(List<SedSynCusManageVO> sedSynCusManageVOList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u5ba2\u6237\u7ecf\u7406\u5f00\u59cb");
        boolean result = false;
        try {
            ArrayList list = new ArrayList();
            int num = this.nlsCreditInfoDao.batchUpdateCusManage(sedSynCusManageVOList);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5ba2\u6237\u7ecf\u7406\u53d8\u66f4\u66f4\u65b0\u53f0\u8d26\u8868\u51fa\u9519!", (Throwable)e);
        }
        return result;
    }

    public NlsCreditInfoVO queryByCondition(NlsCreditInfoVO nlsCreditInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a" + nlsCreditInfoVo);
        try {
            NlsCreditInfo queryNlsCreditInfo = new NlsCreditInfo();
            this.beanCopy(nlsCreditInfoVo, (Object)queryNlsCreditInfo);
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryByCondition(queryNlsCreditInfo);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public int inValidLmtProContOverExpireDate(String openDay) {
        LocalDate date = LocalDate.now();
        String msg1 = "\u5f00\u59cb\u5931\u6548\u8d85\u8fc7\u6388\u4fe1\u534f\u8bae\u5230\u671f\u7684\u8bb0\u5f55..." + date;
        logger.debug(msg1, (Object)"message {}");
        int num = 0;
        try {
            num = this.nlsCreditInfoDao.inValidLmtProContOverExpireDate(openDay);
        }
        catch (Exception e) {
            String msg2 = "\u5931\u6548\u8d85\u8fc7\u6388\u4fe1\u534f\u8bae\u5230\u671f\u7684\u8bb0\u5f55\u53d1\u751f\u9519\u8bef" + e;
            num = -1;
            logger.error(msg2, (Object)"message {}");
        }
        return num;
    }

    public List<NlsCreditInfoVO> queryAllByConditionPage(NlsCreditInfoVO nlsCreditInfoVO) {
        List list = null;
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryAllByConditionByPage(nlsCreditInfoVO);
        logger.debug("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        try {
            this.pageSet(nlsCreditInfos, (BaseInfo)nlsCreditInfoVO);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<NlsCreditInfoVO> getCusManagerRecord(String prdId, String orgCode) throws BizException {
        List nlsCreditInfoVOs = null;
        try {
            List<NlsCreditInfo> cusManagerRecord = this.nlsCreditInfoDao.getCusManagerRecord(prdId, orgCode);
            nlsCreditInfoVOs = (List)this.beansCopy(cusManagerRecord, NlsCreditInfo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u67e5\u8be2\u5ba2\u6237\u7ecf\u7406\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38");
        }
        return nlsCreditInfoVOs;
    }

    public NlsCreditInfoVO queryByPrdSeq(String preLmtApplySeq) {
        return (NlsCreditInfoVO)this.beanCopy((Object)this.nlsCreditInfoDao.queryByPrdSeq(preLmtApplySeq), new NlsCreditInfoVO());
    }

    public List<NlsCreditInfoVO> queryPsdBtApprvDateByPage(NlsCreditInfoVO nlsCreditInfoVO) {
        String msg1 = "\u3010\u666e\u7a0e\u8d37\u3011\u67e5\u8be2\u5ba1\u6279\u65e5\u671f\u533a\u95f4\u6388\u4fe1\u4fe1\u606f";
        logger.debug(msg1, (Object)"message {}");
        List list = null;
        try {
            List<NlsCreditInfo> bdMoneyDrawTemps = this.nlsCreditInfoDao.queryPsdBtApprvDateByPage(nlsCreditInfoVO);
            list = (List)this.beansCopy(bdMoneyDrawTemps, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        if (list != null) {
            String msg2 = "\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u5927\u5c0f\u4e3a " + list.size();
            logger.debug(msg2, (Object)"message {}");
        }
        return list;
    }

    public int queryPsdBtApprvDateCount(NlsCreditInfoVO nlsCreditInfoVO) {
        String msg1 = "\u3010\u666e\u7a0e\u8d37\u3011\u67e5\u8be2\u5ba1\u6279\u65e5\u671f\u533a\u95f4\u6388\u4fe1\u4fe1\u606f\u6570\u636e\u91cf";
        logger.debug(msg1, (Object)"message {}");
        int num = 0;
        try {
            num = this.nlsCreditInfoDao.queryPsdBtApprvDateCount(nlsCreditInfoVO);
        }
        catch (Exception e) {
            String msg2 = "\u3010\u666e\u7a0e\u8d37\u3011\u67e5\u8be2\u5ba1\u6279\u65e5\u671f\u533a\u95f4\u6388\u4fe1\u4fe1\u606f\u6570\u636e\u91cf\u51fa\u9519" + e;
            logger.debug(msg2, (Object)"message {}");
            num = -1;
        }
        return num;
    }

    public List<NlsCreditInfoVO> selectByGlobalSerno(NlsCreditInfoVO nlsCreditInfoVO) {
        try {
            return (List)this.beansCopy(this.nlsCreditInfoDao.selectByGlobalSerno((NlsCreditInfo)((Object)this.beanCopy(nlsCreditInfoVO, (Object)new NlsCreditInfo()))), NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u3010\u6388\u4fe1\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public List<NlsCreditInfoVO> selectByGmAndCertCode(String gm, String certCode) throws Exception {
        return (List)this.beansCopy(this.nlsCreditInfoDao.selectByGmAndCertCode(gm, certCode), NlsCreditInfoVO.class);
    }

    public List<NlsCreditInfoVO> queryByCucCodeAndPrdId(NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        return (List)this.beansCopy(this.nlsCreditInfoDao.queryCertCode(nlsCreditInfoVO), NlsCreditInfoVO.class);
    }

    public List<NlsCreditInfoVO> queryByPreLmtApplySeq(String preLmtApplySeq) {
        String msg1 = "\u3010\u666e\u7a0e\u8d37\u3011\u67e5\u8be2\u5ba1\u6279\u65e5\u671f\u533a\u95f4\u6388\u4fe1\u4fe1\u606f";
        logger.debug(msg1, (Object)"message {}");
        List list = null;
        try {
            List<NlsCreditInfo> nlsCreditInfoList = this.nlsCreditInfoDao.queryByPreLmtApplySeq(preLmtApplySeq);
            list = (List)this.beansCopy(nlsCreditInfoList, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        if (list != null) {
            String msg2 = "\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u5927\u5c0f\u4e3a " + list.size();
            logger.debug(msg2, (Object)"message {}");
        }
        return list;
    }

    public BigDecimal queryArroveLimitTotal(String prdId) {
        return this.nlsCreditInfoDao.queryArroveLimitTotal(prdId);
    }

    public int queryByOrgCode(String orgCode) {
        NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
        nlsCreditInfo.setNlsOperOrgid(orgCode);
        int outputVo = this.nlsCreditInfoDao.queryByOrgCode(nlsCreditInfo);
        return outputVo;
    }

    public List<NlsCreditInfoVO> queryInPreLmtApplySeq(List<String> list) throws Exception {
        return (List)this.beansCopy(this.nlsCreditInfoDao.queryInPreLmtApplySeq(list), NlsCreditInfoVO.class);
    }

    public int batchUpdateRecvAcc(List<NlsCreditInfoVO> nlsCreditInfoVOList) {
        int num;
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u5f00\u59cb");
        try {
            ArrayList<NlsCreditInfo> list = new ArrayList();
            list = (List)this.beansCopy(nlsCreditInfoVOList, NlsCreditInfo.class);
            num = this.nlsCreditInfoDao.batchUpdateRecvAcc(list);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u7ed3\u675f");
        return num;
    }

    public int batchUpdateRecvAccHed(List<NlsCreditInfoVO> nlsCreditInfoVOList) {
        int num;
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u5f00\u59cb");
        try {
            ArrayList<NlsCreditInfo> list = new ArrayList();
            list = (List)this.beansCopy(nlsCreditInfoVOList, NlsCreditInfo.class);
            num = this.nlsCreditInfoDao.batchUpdateRecvAccHed(list);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u7ed3\u675f");
        return num;
    }

    public List<NlsCreditInfoVO> queryAllByOrgCode(String orgCode) {
        List list = null;
        try {
            NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
            nlsCreditInfo.setNlsOperOrgid(orgCode);
            List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryAllByOrgCode(nlsCreditInfo);
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public int queryCreditOnWay(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u67e5\u8be2\u6761\u4ef6\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)nlsCreditInfoVO));
        int count = 0;
        try {
            NlsCreditInfo nlsCreditInfo = (NlsCreditInfo)((Object)this.beanCopy(nlsCreditInfoVO, (Object)new NlsCreditInfo()));
            count = this.nlsCreditInfoDao.getCreditsByCondition(nlsCreditInfo);
            logger.debug("\u67e5\u8be2\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a\uff1a" + count);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return count;
    }

    public List<NlsCreditInfoVO> queryCreditDuring(String certType, String certCode, String prdId, String applySeq) {
        ArrayList<NlsCreditInfoVO> list = new ArrayList();
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryCreditDuring(certType, certCode, prdId, applySeq);
        logger.debug("\u5f53\u524d\u5728\u9014\u6388\u4fe1\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsCreditInfos.size());
        try {
            list = (List)this.beansCopy(nlsCreditInfos, NlsCreditInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int updateAcctNo(NlsCreditInfoVO nlsCreditInfoVO) {
        NlsCreditInfo nlsCreditInfo = new NlsCreditInfo();
        nlsCreditInfo.setCertCode(nlsCreditInfoVO.getCertCode());
        nlsCreditInfo.setPrdId(nlsCreditInfoVO.getPrdId());
        nlsCreditInfo.setRecvAccount(nlsCreditInfoVO.getRecvAccount());
        nlsCreditInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        logger.debug("\u5f53\u524d\u4fee\u6539\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)nlsCreditInfo));
        int num = this.nlsCreditInfoDao.updateAcctNo(nlsCreditInfo);
        return num;
    }

    public NlsCreditInfoVO queryAllOrderByCreateTime(Map<String, Object> paramsMap) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + paramsMap);
        try {
            NlsCreditInfo queryRslNlsCreditInfo = this.nlsCreditInfoDao.queryAllOrderByCreateTime(paramsMap);
            if (Objects.nonNull((Object)queryRslNlsCreditInfo)) {
                NlsCreditInfoVO outNlsCreditInfoVo = (NlsCreditInfoVO)this.beanCopy((Object)queryRslNlsCreditInfo, new NlsCreditInfoVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsCreditInfoVo.toString());
                return outNlsCreditInfoVo;
            }
            logger.error("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public int updateByHed() throws Exception {
        logger.info("\u5f00\u59cb\u66f4\u65b0\u60e0e\u8d37\u6388\u4fe1\u4fe1\u606f\u6570\u636e");
        int i = 0;
        try {
            i = this.nlsCreditInfoDao.updateByHed();
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u60e0e\u8d37\u6388\u4fe1\u4fe1\u606f\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new SQLException("\u66f4\u65b0\u60e0e\u8d37\u6388\u4fe1\u4fe1\u606f\u6570\u636e\u5931\u8d25,\u8bf7\u6392\u67e5nls.middle\u670d\u52a1\u5668\u65e5\u5fd7\uff0c\u6392\u67e5\u95ee\u9898\uff0c\u7136\u540e\u7eed\u8dd1\uff01" + e.getMessage());
        }
        return i;
    }

    public int queryCreditByCustAndPro(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.debug("\u67e5\u8be2\u6761\u4ef6\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)nlsCreditInfoVO));
        int count = 0;
        try {
            NlsCreditInfo nlsCreditInfo = (NlsCreditInfo)((Object)this.beanCopy(nlsCreditInfoVO, (Object)new NlsCreditInfo()));
            count = this.nlsCreditInfoDao.queryCreditByCustAndPro(nlsCreditInfo);
            logger.debug("\u67e5\u8be2\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a\uff1a" + count);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return count;
    }
}

