/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sx;

import com.alibaba.fastjson.JSONObject;
import com.gdrcu.efp.cus.common.CusBankRelEnum;
import com.gdrcu.efp.cus.common.CusStatusEnum;
import com.gdrcu.efp.cus.common.CusTypeEnum;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.basic.framework.core.util.sdic.SDicToLocal;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.cus.service.facade.CompanyWhiteListRecordService;
import com.irdstudio.efp.cus.service.facade.CompanyWhiteListService;
import com.irdstudio.efp.cus.service.facade.CusIndivExtService;
import com.irdstudio.efp.cus.service.facade.CusIndivRelService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CompanyWhiteListVO;
import com.irdstudio.efp.cus.service.vo.CusIndivExtVO;
import com.irdstudio.efp.cus.service.vo.CusIndivNoticeVO;
import com.irdstudio.efp.cus.service.vo.CusIndivRelNoticeVO;
import com.irdstudio.efp.cus.service.vo.CusIndivRelVO;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.ecif.CusDetialInfoQueryReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.MaintainEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.TrdPtyCustInfArryBean;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailIdInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailTelInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetialInfoQueryResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.MaintainEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PriMtEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PrivateCreateThirdCusResp;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.ecif.CusDetailInfoQueryService;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.esb.service.facade.hj.CustomerInfoCreateService;
import com.irdstudio.efp.limit.service.facade.ManualReviewAppService;
import com.irdstudio.efp.limit.service.vo.ManualReviewAppVO;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.common.util.NlsStringUtil;
import com.irdstudio.efp.nls.service.facade.CusCreateCommonService;
import com.irdstudio.efp.nls.service.facade.NlsApplyRelationService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoExdService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.ZydEcifThirdCusService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsCreditInfoNoticeVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoExdVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="yedCreditCusCreateService")
public class YedCreditCusCreateServiceImpl
extends CreditSoltServiceImpl {
    private static Logger log = LoggerFactory.getLogger(YedCreditCusCreateServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="cusIndivExtService")
    private CusIndivExtService cusIndivExtService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Autowired
    @Qualifier(value="cusReferrerInfoService")
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    @Qualifier(value="nlsCreditInfoExdService")
    private NlsCreditInfoExdService nlsCreditInfoExdService;
    @Autowired
    @Qualifier(value="companyWhiteListRecordService")
    private CompanyWhiteListRecordService companyWhiteListRecordService;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;
    private static final String LOGGER_ID = "\u6388\u4fe1\u2014\u2014\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fd";
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"CREL$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final String other = "Other";
    private static final String HEAD = "head";
    private static final String BODY = "body";
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsApplyRelationService")
    private NlsApplyRelationService nlsApplyRelationService;
    @Autowired
    @Qualifier(value="customerInfoCreateService")
    private CustomerInfoCreateService customerInfoCreateService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusIndivRelService")
    private CusIndivRelService cusIndivRelService;
    @Autowired
    private PatternedLimitableSeqService sequenceService;
    @Autowired
    @Qualifier(value="companyWhiteListService")
    private CompanyWhiteListService companyWhiteListService;
    @Autowired
    @Qualifier(value="cusDetailInfoQueryService")
    private CusDetailInfoQueryService cusDetailInfoQueryService;
    @Autowired
    private ZydEcifThirdCusService zydEcifThirdCusService;
    private static final PatternDescriptor CUS_PATTERN = DefaultPatternDescriptor.of((String)"$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="maintainEcifThirdCusService")
    private EsbService<MaintainEcifThirdCusReq, MaintainEcifThirdCusResp> maintainEcifThirdCusService;
    @Autowired
    @Qualifier(value="manualReviewAppService")
    private ManualReviewAppService manualReviewAppService;
    @Autowired
    @Qualifier(value="cusCreateCommonService")
    private CusCreateCommonService cusCreateCommonService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        block30: {
            String applySeq = nlsProcessBizVo.getApplySeq();
            try {
                ManualReviewAppVO manualReviewAppVO;
                log.info("\u6388\u4fe1\u2014\u2014\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u5f00\u59cb\u8fdb\u884c\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fd,\u6d41\u6c34\u53f7:" + applySeq);
                Objects.requireNonNull(nlsCreditInfoVO);
                String cusId = "";
                PriMtEcifThirdCusResp priMtEcifThirdCusResp = new PriMtEcifThirdCusResp();
                NlsCreditInfoExdVO pojo = new NlsCreditInfoExdVO();
                pojo.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
                NlsCreditInfoExdVO nlsCreditInfoExdVO = this.nlsCreditInfoExdService.queryByPk(pojo);
                nlsCreditInfoVO.setRetCode(nlsCreditInfoExdVO.getRetCode());
                CusReferrerInfoVO cusReferrerInfo = this.getCusReferrerInfo(nlsCreditInfoVO);
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("estblshDt", nlsCreditInfoVO.getCreateTime());
                paramsMap.put("sstblshBrch", nlsCreditInfoVO.getNlsOperOrgid());
                paramsMap.put("certCode", nlsCreditInfoVO.getCertCode());
                paramsMap.put("certType", nlsCreditInfoVO.getCertType());
                Map resultMap = this.cusCreateCommonService.getPrivateEstblshDtAndSstblshBrch(paramsMap);
                log.info(nlsCreditInfoVO.getLmtApplySeq() + "\u67e5\u8be2\u5230\u7684\u5f00\u6237\u4fe1\u606f:{}", (Object)resultMap);
                String estblshDt = (String)resultMap.get("estblshDt");
                String sstblshBrch = (String)resultMap.get("sstblshBrch");
                CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(nlsCreditInfoVO.getCusName(), nlsCreditInfoVO.getCertCode());
                String usrID = "";
                boolean cusIndivExsit = true;
                if (Objects.isNull(cusDetialInfoQueryResp) || StringUtil.isNullorBank((String)cusDetialInfoQueryResp.getCustNo())) {
                    log.info("\u6388\u4fe1\u2014\u2014\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fdecif\u4e0d\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237\uff0c\u524d\u5f80ecif\u5ba2\u6237\u5efa\u6863");
                    Map<String, Object> map = this.zydEcifThirdCusService.privateCreateFn(nlsCreditInfoVO, nlsCreditInfoExdVO, "");
                    usrID = this.checkCreateThirdCusResp(map, nlsCreditInfoVO);
                } else {
                    log.info("\u6388\u4fe1\u2014\u2014\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fdecif\u5df2\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237\uff0c\u524d\u5f80ecif\u5ba2\u6237\u4fe1\u606f\u7ef4\u62a4");
                    String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
                    String telCode = "";
                    List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
                    if (Objects.nonNull(telInfArry)) {
                        for (CusDetailTelInfArray item : telInfArry) {
                            if (!item.getAtchSys1().equals("2003000")) continue;
                            telCode = item.getTelId();
                        }
                    } else {
                        telCode = "";
                    }
                    priMtEcifThirdCusResp = this.zydEcifThirdCusService.PriMtEcifThirdCusFn(nlsCreditInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
                    usrID = priMtEcifThirdCusResp.getCustNo();
                }
                CusIndivVO queryCusIndiv = new CusIndivVO();
                queryCusIndiv.setCertType(nlsCreditInfoVO.getCertType());
                queryCusIndiv.setCertCode(nlsCreditInfoVO.getCertCode());
                queryCusIndiv = this.cusIndivService.getCusInvoByCertCode(queryCusIndiv);
                if (Objects.isNull(queryCusIndiv)) {
                    cusIndivExsit = false;
                }
                String prdId = Objects.requireNonNull(nlsCreditInfoVO.getPrdId());
                PrdInfoVO prdInfoVo = new PrdInfoVO();
                prdInfoVo.setPrdId(prdId);
                prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
                String dateString = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
                String dateTimeString = LocalDateTime.now().format(timeStrFormatter);
                String createUser = "admin";
                CusIndivVO cusIndivVO = new CusIndivVO();
                cusIndivVO.setCusName(nlsCreditInfoVO.getCusName());
                cusIndivVO.setIndivSex(nlsCreditInfoVO.getGender());
                cusIndivVO.setCertType(nlsCreditInfoVO.getCertType());
                cusIndivVO.setCertCode(nlsCreditInfoVO.getCertCode());
                cusIndivVO.setPhone(nlsCreditInfoVO.getIndivMobile());
                cusIndivVO.setCusType(CusTypeEnum.NATURAL_MAN.getCode());
                cusIndivVO.setCusBankRel(CusBankRelEnum.NORMAL.getCode());
                cusIndivVO.setIndivHouhRegAdd(nlsCreditInfoVO.getCertAddr());
                cusIndivVO.setCusStatus(CusStatusEnum.OFFICIAL.getCode());
                cusIndivVO.setIndivNtn(nlsCreditInfoVO.getEthnic());
                cusIndivVO.setIndivCountry(nlsCreditInfoVO.getNational());
                if (Objects.nonNull(nlsCreditInfoVO.getIndvMnthIncm())) {
                    cusIndivVO.setIndivAnnIncm(new BigDecimal(nlsCreditInfoVO.getIndvMnthIncm()).setScale(2, 4));
                    cusIndivVO.setFamilyMincm(new BigDecimal(nlsCreditInfoVO.getIndvMnthIncm()).setScale(2, 4));
                }
                BigDecimal annualIncome = new BigDecimal(0);
                annualIncome = StringUtil.isNullorBank((String)nlsCreditInfoVO.getCustTp()) ? ((manualReviewAppVO = this.manualReviewAppService.queryByLmtSeq(nlsCreditInfoVO.getLmtApplySeq())).getCustTp().equals("Y") ? manualReviewAppVO.getIndvMnthIncm().multiply(new BigDecimal(12)) : nlsCreditInfoVO.getApproveAmt().multiply(new BigDecimal(12)).divide(new BigDecimal(14), 2, 4)) : (nlsCreditInfoVO.getCustTp().equals("Y") ? new BigDecimal(nlsCreditInfoVO.getIndvMnthIncm() * 12.0) : nlsCreditInfoVO.getApproveAmt().multiply(new BigDecimal(12)).divide(new BigDecimal(14), 2, 4));
                cusIndivVO.setPerAnnualIncome(annualIncome);
                cusIndivVO.setFamAnnualIncome(annualIncome);
                cusIndivVO.setIndivEdt(nlsCreditInfoVO.getEdu());
                cusIndivVO.setIndivDgr(nlsCreditInfoExdVO.getIndivDgr());
                cusIndivVO.setIndivRsdSt(nlsCreditInfoExdVO.getIndivRsdSt());
                cusIndivVO.setIndivComName(nlsCreditInfoVO.getWrkCorpNm());
                if (!StringUtil.isNullorBank((String)nlsCreditInfoVO.getWrkCorpNm())) {
                    CompanyWhiteListVO companyWhiteListVO = new CompanyWhiteListVO();
                    companyWhiteListVO.setCompanyName(nlsCreditInfoVO.getWrkCorpNm());
                    List companyWhiteListVOS = this.companyWhiteListService.queryConditions(companyWhiteListVO);
                    if (Objects.nonNull(companyWhiteListVOS) && companyWhiteListVOS.size() > 0) {
                        cusIndivVO.setIndivComTyp(SDicToLocal.getLocalSysDicVal((String)"CompanyType", (String)((CompanyWhiteListVO)companyWhiteListVOS.get(0)).getCompanyType()));
                    }
                }
                cusIndivVO.setIndivComAddr(nlsCreditInfoVO.getWrkCorpAddr());
                cusIndivVO.setIndivSpsName(nlsCreditInfoVO.getSpsNm());
                cusIndivVO.setIndivCrtfctn(nlsCreditInfoVO.getTtl());
                cusIndivVO.setIndivOcc(nlsCreditInfoVO.getProfession());
                cusIndivVO.setIndivComJobTtl(nlsCreditInfoVO.getIndivComJobTtl());
                cusIndivVO.setIndivHouhRegAdd(nlsCreditInfoVO.getCertAddr());
                cusIndivVO.setIndivRsdAddr(nlsCreditInfoVO.getIndivRsdAddr());
                cusIndivVO.setFamilyAddr(nlsCreditInfoVO.getIndivRsdAddr());
                cusIndivVO.setPostAddr(nlsCreditInfoVO.getIndivRsdAddr());
                cusIndivVO.setIndivIdExpDt(nlsCreditInfoVO.getCertEndDt().replaceAll("-", ""));
                cusIndivVO.setIndivMarSt(nlsCreditInfoVO.getMrgSitu());
                cusIndivVO.setIndivDtOfBirth(ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()));
                cusIndivVO.setIndivZipCode(nlsCreditInfoVO.getPostCode());
                cusIndivVO.setPostCode(nlsCreditInfoVO.getPostCode());
                cusIndivVO.setIndivComFld(nlsCreditInfoVO.getIndivComFld());
                cusIndivVO.setInputId("admin");
                if (Objects.nonNull(cusReferrerInfo)) {
                    cusIndivVO.setCusManager(cusReferrerInfo.getReferrerId());
                    cusIndivVO.setMainBrId(cusReferrerInfo.getMainBrId());
                    cusIndivVO.setPerformanceOwner(cusReferrerInfo.getReferrerId());
                    cusIndivVO.setPerformanceOrg(cusReferrerInfo.getMainBrId());
                    nlsCreditInfoVO.setNlsOperUserid(cusReferrerInfo.getReferrerId());
                    nlsCreditInfoVO.setNlsOperOrgid(cusReferrerInfo.getMainBrId());
                    nlsProcessBizVo.setNlsOperOrgid(cusReferrerInfo.getMainBrId());
                }
                cusIndivVO.setLastUpdateTime(dateTimeString);
                cusIndivVO.setLastUpdateUser("admin");
                CusIndivRelVO cusIndivRelVO = new CusIndivRelVO();
                cusIndivRelVO.setRelName(nlsCreditInfoExdVO.getEmergencyContactName());
                cusIndivRelVO.setRelation(nlsCreditInfoExdVO.getEmergencyContactRelate());
                cusIndivRelVO.setMobile(nlsCreditInfoExdVO.getEmergencyContactPhone());
                cusIndivRelVO.setLastUpdateTime(dateTimeString);
                CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
                if (cusIndivExsit) {
                    if (StringUtils.isNotBlank((CharSequence)queryCusIndiv.getInnerCusId())) {
                        this.sendCusIndivToEcif(nlsCreditInfoVO, queryCusIndiv, estblshDt, sstblshBrch);
                    }
                    if (StringUtils.isNotBlank((CharSequence)usrID)) {
                        cusIndivVO.setSelfCusId(usrID);
                    }
                    cusId = queryCusIndiv.getCusId();
                    cusIndivVO.setCusId(cusId);
                    cusIndivRelVO.setCusId(cusId);
                    int num1 = this.cusIndivService.updateByPk(cusIndivVO);
                    nlsCreditInfoVO.setCusId(cusId);
                    this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                    List cusIndivRelVOs = Optional.ofNullable(this.cusIndivRelService.queryByPkCusId(cusIndivRelVO)).orElseGet(ArrayList::new);
                    String relSerno = "";
                    if (cusIndivRelVOs.size() > 0) {
                        boolean cusRelExits = Boolean.TRUE;
                        for (CusIndivRelVO cus : cusIndivRelVOs) {
                            if (!cus.getRelName().equals(nlsCreditInfoExdVO.getEmergencyContactName())) continue;
                            cusIndivRelVO.setRelSerno(cus.getRelSerno());
                            this.cusIndivRelService.updateByPk(cusIndivRelVO);
                            cusRelExits = Boolean.FALSE;
                            break;
                        }
                        if (cusRelExits) {
                            try {
                                relSerno = this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN);
                            }
                            catch (Exception e) {
                                throw new BizException("\u5173\u7cfb\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
                            }
                            cusIndivRelVO.setRelSerno(relSerno);
                            cusIndivRelVO.setCreateTime(dateTimeString);
                            this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
                            this.sendCusIndivRelToRisk(cusIndivRelVO, nlsCreditInfoVO);
                        }
                    } else {
                        try {
                            relSerno = this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN);
                        }
                        catch (Exception e) {
                            throw new BizException("\u5173\u7cfb\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
                        }
                        cusIndivRelVO.setRelSerno(relSerno);
                        cusIndivRelVO.setCreateTime(dateTimeString);
                        cusIndivRelVO.setLastUpdateTime(dateTimeString);
                        this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
                        this.sendCusIndivRelToRisk(cusIndivRelVO, nlsCreditInfoVO);
                    }
                    cusIndivExtVO.setCusId(cusId);
                    CusIndivExtVO cusIndivExtVO1 = this.cusIndivExtService.queryByPk(cusIndivExtVO);
                    cusIndivExtVO1.setIndivComJobTtlLvl(StringUtil.replaceNullByObj((Object)nlsCreditInfoExdVO.getPosLvl()));
                    cusIndivExtVO1.setSvcWrkMos(StringUtil.replaceNullByObj((Object)nlsCreditInfoExdVO.getSvcWrkMos()));
                    cusIndivExtVO1.setIndivOccSt(StringUtil.replaceNullByObj((Object)nlsCreditInfoExdVO.getWorkSt()));
                    if ("01".equals(cusIndivExtVO1.getCusType())) {
                        cusIndivExtVO1.setCusType("0102");
                    }
                    cusIndivExtVO1.setOnlineVerfStatus(nlsCreditInfoExdVO.getOnlineVerfStatus());
                    cusIndivExtVO1.setRetCode(nlsCreditInfoExdVO.getRetCode());
                    cusIndivExtVO1.setLastUpdateUser("admin");
                    cusIndivExtVO1.setLastUpdateTime(dateTimeString);
                    int num2 = this.cusIndivExtService.updateByPk(cusIndivExtVO1);
                    if (num2 == -1) {
                        throw new BizException("\u5ba2\u6237\u62d3\u5c55\u8868\u66f4\u65b0\u5f02\u5e38!!");
                    }
                    if (num1 == -1) {
                        throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u66f4\u65b0\u5f02\u5e38!");
                    }
                    this.sendCusIndivToRisk(cusIndivVO, nlsCreditInfoVO);
                    break block30;
                }
                cusId = this.sequenceService.getPatternedSequence("CUS_ID", CUS_PATTERN);
                nlsProcessBizVo.setCusId(cusId);
                cusIndivVO.setMainBrId(StringUtil.isNullorBank((String)cusReferrerInfo.getMainBrId()) ? prdInfoVo.getDefaultManageOrg() : cusReferrerInfo.getMainBrId());
                cusIndivVO.setCusId(cusId);
                cusIndivVO.setSelfCusId(usrID);
                cusIndivVO.setComInitLoanDate(dateString);
                cusIndivVO.setInputDate(dateString);
                cusIndivVO.setCreateTime(dateTimeString);
                cusIndivVO.setFstAppChannel(nlsCreditInfoVO.getChannelNo());
                int num2 = this.cusIndivService.insertCusIndiv(cusIndivVO);
                nlsCreditInfoVO.setCusId(cusId);
                cusIndivExtVO.setCusId(cusId);
                cusIndivExtVO.setCusType("02");
                cusIndivExtVO.setOnlineVerfStatus(nlsCreditInfoExdVO.getOnlineVerfStatus());
                cusIndivExtVO.setRetCode(nlsCreditInfoExdVO.getRetCode());
                cusIndivExtVO.setIndivComJobTtlLvl(nlsCreditInfoExdVO.getPosLvl());
                cusIndivExtVO.setSvcWrkMos(nlsCreditInfoExdVO.getSvcWrkMos());
                cusIndivExtVO.setIndivOccSt(nlsCreditInfoExdVO.getWorkSt());
                cusIndivExtVO.setCreateUser("admin");
                cusIndivExtVO.setCreateTime(dateTimeString);
                cusIndivExtVO.setLastUpdateUser("admin");
                cusIndivExtVO.setLastUpdateTime(dateTimeString);
                int num4 = this.cusIndivExtService.insert(cusIndivExtVO);
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                cusIndivRelVO.setCusId(cusId);
                cusIndivRelVO.setRelSerno(this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN));
                cusIndivRelVO.setCreateTime(dateTimeString);
                int num3 = this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
                if (num2 == -1 || num3 == -1 || num4 == -1) {
                    throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u589e\u52a0\u5f02\u5e38!");
                }
                this.sendCusIndivToRisk(cusIndivVO, nlsCreditInfoVO);
                this.sendCusIndivRelToRisk(cusIndivRelVO, nlsCreditInfoVO);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u6388\u4fe1\u2014\u2014\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u6267\u884c\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                nlsCreditInfoVO.setRefuseCause(e.getMessage());
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                this.sendToRisk(nlsCreditInfoVO);
                nlsProcessBizVo.setExceptionFlag(true);
                nlsProcessBizVo.setExceptionMsg(e);
            }
            finally {
                log.info("======>\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7<======" + applySeq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCusIndivRelToRisk(CusIndivRelVO cusIndivRelVO, NlsCreditInfoVO nlsCreditInfoVO) {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u5ba2\u6237\u8054\u7cfb\u4eba\u4fe1\u606f\u8868 kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("credit")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            CusIndivRelNoticeVO cusIndivRelNoticeVO = new CusIndivRelNoticeVO();
            cusIndivRelNoticeVO.setTableName("CUS_INDIV_REL");
            cusIndivRelNoticeVO.setCusId(cusIndivRelVO.getCusId());
            cusIndivRelNoticeVO.setRelName(cusIndivRelVO.getRelName());
            cusIndivRelNoticeVO.setRelation(cusIndivRelVO.getRelation());
            cusIndivRelNoticeVO.setMobile(cusIndivRelVO.getMobile());
            cusIndivRelNoticeVO.setCreateTime(cusIndivRelVO.getCreateTime());
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            cusIndivRelNoticeVO.setDataTime(timeStamp);
            cusIndivRelNoticeVO.setDeliverTime(timeStamp);
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedCreditCusCreateServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put(HEAD, (Object)header);
            jsonObject.put("biz", (Object)cusIndivRelNoticeVO);
            if (!flag) {
                log.info("\u5b9e\u65f6\u91c7\u96c6\u5f00\u5173\u672a\u6253\u5f00\uff01\uff01\uff01");
                return;
            }
            this.threadPool.add(() -> {
                KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                try {
                    kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u5ba2\u6237\u8054\u7cfb\u4eba\u4fe1\u606f\u8868 kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u5ba2\u6237\u8054\u7cfb\u4eba\u4fe1\u606f\u8868 kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u5ba2\u6237\u8054\u7cfb\u4eba\u4fe1\u606f\u8868 kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCusIndivToRisk(CusIndivVO cusIndivVO, NlsCreditInfoVO nlsCreditInfoVO) {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u4e2a\u4eba\u5ba2\u6237\u4fe1\u606f kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("credit")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            CusIndivNoticeVO cusIndivNoticeVO = new CusIndivNoticeVO();
            cusIndivNoticeVO.setTableName("CUS_INDIV");
            cusIndivNoticeVO.setCusId(cusIndivVO.getCusId());
            cusIndivNoticeVO.setCusName(cusIndivVO.getCusName());
            cusIndivNoticeVO.setCertType(cusIndivVO.getCertType());
            cusIndivNoticeVO.setCertCode(cusIndivVO.getCertCode());
            cusIndivNoticeVO.setCreateTime(StringUtils.isBlank((CharSequence)cusIndivVO.getCreateTime()) ? timeStamp : cusIndivVO.getCreateTime());
            cusIndivNoticeVO.setDataTime(timeStamp);
            cusIndivNoticeVO.setDeliverTime(timeStamp);
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedCreditCusCreateServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put(HEAD, (Object)header);
            jsonObject.put("biz", (Object)cusIndivNoticeVO);
            log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u4e2a\u4eba\u5ba2\u6237\u4fe1\u606f kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq + " \u53d1\u9001\u98ce\u63a7\u5bf9\u8c61\u4e3a\uff1a" + JSONObject.toJSONString((Object)cusIndivNoticeVO));
            if (!flag) {
                log.info("\u5b9e\u65f6\u91c7\u96c6\u5f00\u5173\u672a\u6253\u5f00\uff01\uff01\uff01");
                return;
            }
            this.threadPool.add(() -> {
                KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                try {
                    kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u4e2a\u4eba\u5ba2\u6237\u4fe1\u606f kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u4e2a\u4eba\u5ba2\u6237\u4fe1\u606f kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            log.info("\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\uff0c\u53d1\u9001 \u4e2a\u4eba\u5ba2\u6237\u4fe1\u606f kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(NlsCreditInfoVO nlsCreditInfoVO) {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        log.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("credit")) continue;
                flag = true;
            }
            NlsCreditInfoVO nlsCreditInfoVO1 = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
            JSONObject jsonObject = new JSONObject();
            NlsCreditInfoNoticeVO array = new NlsCreditInfoNoticeVO();
            array.setTableName("NLS_CREDIT_INFO");
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            array.setApprvSts(null != nlsCreditInfoVO1.getApprvSts() ? nlsCreditInfoVO1.getApprvSts() : "");
            array.setLmtApplySeq(nlsCreditInfoVO1.getLmtApplySeq());
            array.setRefuseCause(null != nlsCreditInfoVO1.getRefuseCause() ? nlsCreditInfoVO1.getRefuseCause() : "");
            array.setDataTime(timeStamp);
            array.setDeliverTime(timeStamp);
            array.setCusName(nlsCreditInfoVO1.getCusName());
            array.setGender(nlsCreditInfoVO1.getGender());
            array.setNational(nlsCreditInfoVO1.getNational());
            array.setMrgSitu(nlsCreditInfoVO1.getMrgSitu());
            array.setEdu(nlsCreditInfoVO1.getEdu());
            array.setProfession(nlsCreditInfoVO1.getProfession());
            array.setIndivComJobTtl(nlsCreditInfoVO1.getIndivComJobTtl());
            array.setCertType(nlsCreditInfoVO1.getCertType());
            array.setCertCode(nlsCreditInfoVO1.getCertCode());
            array.setCertEndDt(nlsCreditInfoVO1.getCertEndDt());
            array.setIndivMobile(nlsCreditInfoVO1.getIndivMobile());
            array.setIndivRsdAddr(nlsCreditInfoVO1.getIndivRsdAddr());
            if (StringUtils.isBlank((CharSequence)nlsCreditInfoVO1.getWrkCorpNm())) {
                String wrkCorpNm = nlsCreditInfoVO1.getWrkCorpNm();
                array.setWrkCorpNm(StringUtils.isBlank((CharSequence)wrkCorpNm) ? "" : wrkCorpNm);
            } else {
                array.setWrkCorpNm(nlsCreditInfoVO1.getWrkCorpNm());
            }
            array.setIndivComFld(nlsCreditInfoVO1.getIndivComFld());
            array.setWrkCorpAddr(nlsCreditInfoVO1.getWrkCorpAddr());
            array.setApplyDate(timeStamp);
            array.setApproveAmt(nlsCreditInfoVO1.getApproveAmt());
            array.setChannelNo(nlsCreditInfoVO1.getChannelNo());
            array.setApprvDate(StringUtils.isBlank((CharSequence)nlsCreditInfoVO1.getApprvDate()) ? TimeUtil.getCurDate() : nlsCreditInfoVO1.getApprvDate());
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedCreditCusCreateServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put(HEAD, (Object)header);
            jsonObject.put("biz", (Object)array);
            log.info("\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + "\u53d1\u9001\u98ce\u63a7\u7684\u4fe1\u606f\u4e3a\uff1a" + JSONObject.toJSONString((Object)array));
            if (!flag) {
                log.info("\u5b9e\u65f6\u91c7\u96c6\u5f00\u5173\u672a\u6253\u5f00\uff01\uff01\uff01");
                return;
            }
            this.threadPool.add(() -> {
                KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                try {
                    log.info("\u5ba2\u6237\u5efa\u6863\u5931\u8d25\u53d1\u9001kafka\uff0c\u6d41\u6c34\u53f7: " + applySeq + "\u53d1\u9001\u53c2\u6570\u4e3a: " + JSONObject.toJSONString((Object)jsonObject));
                    kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            log.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            log.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    private CusReferrerInfoVO getCusReferrerInfo(NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        CusReferrerInfoVO cusVo = new CusReferrerInfoVO();
        cusVo.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        CusReferrerInfoVO cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusVo);
        return cusReferrerInfoVO;
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }

    public CusDetialInfoQueryResp queryECIFInfo(String cusName, String idNo) throws Exception {
        CusDetialInfoQueryReq cusDetialInfoQueryReq = new CusDetialInfoQueryReq();
        cusDetialInfoQueryReq.setIdntfMd("1");
        cusDetialInfoQueryReq.setCustNm(cusName);
        cusDetialInfoQueryReq.setIdentNo(idNo);
        CusDetialInfoQueryResp resp = null;
        try {
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.cusDetailInfoQueryService, (Object)cusDetialInfoQueryReq, this.nlsQueueSoltComnService);
            resp = (CusDetialInfoQueryResp)esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            log.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        return resp;
    }

    public String checkCreateThirdCusResp(Map<String, Object> map, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        EsbRespSysHeadBean respSysHeadBean = (EsbRespSysHeadBean)map.get(HEAD);
        PrivateCreateThirdCusResp privateCreateThirdCusResp = (PrivateCreateThirdCusResp)map.get(BODY);
        String usrID = privateCreateThirdCusResp.getCustNo();
        if (StringUtils.equals((CharSequence)((EsbRespRetInfBean)respSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"3036000|210006")) {
            log.info("\u6388\u4fe1\u2014\u2014\u4f18e\u8d37\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u77ed\u65f6\u95f4\u5e76\u53d1\u5bfc\u81f4ecif\u5df2\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237,\u524d\u5f80ecif\u66f4\u65b0\uff01");
            CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(nlsCreditInfoVO.getCusName(), nlsCreditInfoVO.getCertCode());
            String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
            String telCode = "";
            List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
            if (Objects.nonNull(telInfArry)) {
                for (CusDetailTelInfArray item : telInfArry) {
                    if (!item.getAtchSys1().equals("2003000")) continue;
                    telCode = item.getTelId();
                }
            } else {
                telCode = "";
            }
            this.zydEcifThirdCusService.PriMtEcifThirdCusFn(nlsCreditInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
        }
        return usrID;
    }

    private void sendCusIndivToEcif(NlsCreditInfoVO nlsCreditInfoVO, CusIndivVO cusIndivVO, String estblshDt, String sstblshBrch) throws Exception {
        String identEfftvDt;
        MaintainEcifThirdCusReq maintainEcifThirdCusReq = MaintainEcifThirdCusReq.builder().build();
        String string = identEfftvDt = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
        if (identEfftvDt.length() > 8) {
            identEfftvDt = identEfftvDt.length() == 10 ? DateUtility.format10To8((String)identEfftvDt) : identEfftvDt.split("-")[1];
        }
        String crrCd = nlsCreditInfoVO.getProfession().length() == 1 ? SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsCreditInfoVO.getProfession()) : nlsCreditInfoVO.getProfession();
        String crrCd1 = null;
        String crrCd2 = null;
        String crrCd3 = null;
        if (!crrCd.endsWith("00")) {
            crrCd3 = crrCd;
        } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
            crrCd2 = crrCd;
        } else if (crrCd.endsWith("0000")) {
            crrCd1 = crrCd;
        }
        TrdPtyCustInfArryBean build = TrdPtyCustInfArryBean.builder().CustNm(nlsCreditInfoVO.getCusName()).IdentTp(nlsCreditInfoVO.getCertType()).IdentNo(nlsCreditInfoVO.getCertCode()).IdentMtrDt(identEfftvDt).Gnd(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname()).Nation(StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getNational()) ? "156" : nlsCreditInfoVO.getNational()).BrthDt(DateUtility.format10To8((String)ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()))).HghstEdu(nlsCreditInfoVO.getEdu()).CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).ProfTtl(nlsCreditInfoVO.getTtl()).CtcAddr(NlsStringUtil.toShorterString((String)nlsCreditInfoVO.getIndivRsdAddr(), (int)300)).CtcTel(nlsCreditInfoVO.getIndivMobile()).WrkCorp(nlsCreditInfoVO.getWrkCorpNm()).ChanNo("010").EstblshDt(estblshDt).EstblshBrch(sstblshBrch).build();
        maintainEcifThirdCusReq.setTrdPtyCustInfArry(Collections.singletonList(build));
        ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(cusIndivVO.getInnerCusId());
        this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
    }
}

