/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.wsd.credit;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.efp.console.common.ConsoleEnums;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.StopPaymentListService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.StopPaymentListVO;
import com.irdstudio.efp.esb.service.bo.req.wsd.finalnotice.FinalApproveNoticeReqBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.wsd.finalnotice.FinalApproveNoticeService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.WsApplyNotifyService;
import com.irdstudio.efp.nls.service.facade.WsApproveackConfirmService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.WsApplyNotifyVO;
import com.irdstudio.efp.nls.service.vo.WsApproveackConfirmVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="wsdCreditAccessService")
public class WsdCreditAccessServiceImpl
extends CreditSoltServiceImpl
implements FrameworkService {
    private final Logger logger = LoggerFactory.getLogger(WsdCreditAccessServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    @Qualifier(value="finalApproveNoticeService")
    private FinalApproveNoticeService finalApproveNoticeService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="wsApproveackConfirmService")
    private WsApproveackConfirmService wsApproveackConfirmService;
    @Autowired
    @Qualifier(value="stopPaymentListService")
    private StopPaymentListService stopPaymentListService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="wsApplyNotifyService")
    private WsApplyNotifyService wsApplyNotifyService;
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        this.logger.info("======>\u6388\u4fe1\u5ba1\u6279\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        try {
            WsApproveackConfirmVO wsApproveackConfirm = this.nlsPublicService.getWsApproveackConfirm(nlsCreditInfoVO.getLmtApplySeq());
            if ("Y".equals(wsApproveackConfirm.getIsAgree())) {
                return;
            }
            try {
                this.updateApproveackConfirm(nlsCreditInfoVO, wsApproveackConfirm);
                SCfgParamVO sCfgParamVO = new SCfgParamVO();
                sCfgParamVO.setParamKey(ConsoleEnums.ParamKey.WSD_STOP_PAYMENT_SWITCH.getValue());
                sCfgParamVO.setParamValue("Y");
                sCfgParamVO = this.sCfgParamService.queryByCondition(sCfgParamVO);
                if (Objects.nonNull(sCfgParamVO)) {
                    this.insertStopPayMentList(nlsCreditInfoVO);
                }
                throw new BizException("\u6267\u884c\u6388\u4fe1\u5ba1\u6279\u89c4\u5219\u5931\u8d25!!!");
            }
            catch (Exception e) {
                this.logger.error("======>\u3010\u6388\u4fe1\u5ba1\u6279\u670d\u52a1\u3011\u6267\u884c\u5931\u8d25\u539f\u56e0\u4e3a<======", (Object)e.getMessage());
                nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
                nlsProcessBizVo.setRefuseMsg(e.getMessage());
                nlsProcessBizVo.setExceptionMsg(e);
            }
        }
        finally {
            this.logger.info("======>\u6388\u4fe1\u5ba1\u6279\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7<======" + applySeq);
        }
    }

    private void updateApproveackConfirm(NlsCreditInfoVO nlsCreditInfoVO, WsApproveackConfirmVO wsApproveackConfirm) throws ESBException, InterruptedException {
        FinalApproveNoticeReqBean finalApproveNoticeReqBean = new FinalApproveNoticeReqBean();
        finalApproveNoticeReqBean.setRqsIdmptntID(wsApproveackConfirm.getRequestId());
        finalApproveNoticeReqBean.setAplNo(wsApproveackConfirm.getApplyNo());
        finalApproveNoticeReqBean.setAdptCertNm(nlsCreditInfoVO.getCusName());
        finalApproveNoticeReqBean.setAdptCertNo(nlsCreditInfoVO.getCertCode());
        finalApproveNoticeReqBean.setCnsntFlg(wsApproveackConfirm.getIsAgree());
        finalApproveNoticeReqBean.setRjctnCd(wsApproveackConfirm.getRefuseCode());
        finalApproveNoticeReqBean.setAprvlRsltRsn(wsApproveackConfirm.getAckMsg());
        finalApproveNoticeReqBean.setExnFld("{}");
        finalApproveNoticeReqBean.setGlobalSerno(nlsCreditInfoVO.getGlobalSerno());
        TraceUtil.setTraceId((String)nlsCreditInfoVO.getGlobalSerno());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.finalApproveNoticeService, (Object)finalApproveNoticeReqBean, this.nlsQueueSoltComnService);
        esbInvokeWrapper.invoke3Threes();
        wsApproveackConfirm.setResultInfo(JSON.toJSONString((Object)finalApproveNoticeReqBean));
        TraceUtil.clear();
        this.wsApproveackConfirmService.updateByPk(wsApproveackConfirm);
    }

    private void insertStopPayMentList(NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        LmtPrdContVO lmtPrdContVo = new LmtPrdContVO();
        lmtPrdContVo.setCertCode(nlsCreditInfoVO.getCertCode());
        lmtPrdContVo.setPrdCode(nlsCreditInfoVO.getPrdCode());
        List lmtPrdContVOS = this.lmtPrdContService.queryLmtPrdByCertCode(lmtPrdContVo);
        if (Objects.nonNull(lmtPrdContVOS) && lmtPrdContVOS.size() > 0) {
            String registerAddress = "";
            for (int i = 0; i < lmtPrdContVOS.size(); ++i) {
                WsApplyNotifyVO wsApplyNotifyVO = this.wsApplyNotifyService.queryByApplyNo(((LmtPrdContVO)lmtPrdContVOS.get(i)).getLmtApplySeq());
                if (i == 0) {
                    registerAddress = wsApplyNotifyVO.getRegisterAddress();
                }
                CusIndivVO cus = new CusIndivVO();
                cus.setCertType("10100");
                cus.setCertCode(nlsCreditInfoVO.getCertCode());
                CusIndivVO cusIndivVO = this.cusIndivService.getCusInvoByCertCode(cus);
                StopPaymentListVO stop = new StopPaymentListVO();
                stop.setCusId(cusIndivVO.getCusId());
                stop.setCertCode(nlsCreditInfoVO.getCertCode());
                stop.setRequestId(wsApplyNotifyVO.getRequestId());
                stop.setApplyNo(wsApplyNotifyVO.getApplyNo());
                stop.setAddress(cusIndivVO.getIndivRsdAddr());
                stop.setRegisterAddress(registerAddress);
                stop.setImportChannel("0");
                stop.setFlag("0");
                stop.setCreateTime(DateTool.getCurrentDateTime());
                stop.setLastUpdateTime(DateTool.getCurrentDateTime());
                this.stopPaymentListService.insert(stop);
            }
        }
    }
}

