/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.wsd.credit;

import com.alibaba.fastjson.JSON;
import com.gdrcu.efp.cus.common.CusBankRelEnum;
import com.gdrcu.efp.cus.common.CusStatusEnum;
import com.gdrcu.efp.cus.common.CusTypeEnum;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.basic.framework.core.util.sdic.SDicToLocal;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.cus.service.facade.CusIndivExtService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivExtVO;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.nls.NlsCrrEnum;
import com.irdstudio.efp.esb.service.bo.req.ecif.CusDetialInfoQueryReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.IdInfArry2Bean;
import com.irdstudio.efp.esb.service.bo.req.ecif.MaintainEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.PriMtEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.QryEcifThirdCusInfoReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.TelInfArry2Bean;
import com.irdstudio.efp.esb.service.bo.req.ecif.TrdPtyCustInfArryBean;
import com.irdstudio.efp.esb.service.bo.req.wsd.finalnotice.FinalApproveNoticeReqBean;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailIdInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailTelInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetialInfoQueryResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.MaintainEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PriMtEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.QryEcifThirdCusInfoResp;
import com.irdstudio.efp.esb.service.bo.resp.wsd.finalnotice.FinalApproveNoticeRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.ecif.CusDetailInfoQueryService;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.esb.service.facade.hj.CustomerInfoCreateService;
import com.irdstudio.efp.esb.service.facade.wsd.finalnotice.FinalApproveNoticeService;
import com.irdstudio.efp.nls.common.util.NlsStringUtil;
import com.irdstudio.efp.nls.service.facade.CusCreateCommonService;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.WsApproveackConfirmService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.WsApproveackConfirmVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="wsdCusDocumentService")
public class WsdCusDocumentServiceImpl
extends CreditSoltServiceImpl
implements FrameworkService {
    private final Logger logger = LoggerFactory.getLogger(WsdCusDocumentServiceImpl.class);
    private final String msgTemplate = "message{}";
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="customerInfoCreateService")
    private CustomerInfoCreateService customerInfoCreateService;
    @Autowired
    @Qualifier(value="finalApproveNoticeService")
    private FinalApproveNoticeService finalApproveNoticeService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="wsApproveackConfirmService")
    private WsApproveackConfirmService wsApproveackConfirmService;
    @Autowired
    @Qualifier(value="cusIndivExtService")
    private CusIndivExtService cusIndivExtService;
    @Autowired
    @Qualifier(value="qryEcifThirdCusInfoService")
    private EsbService<QryEcifThirdCusInfoReq, QryEcifThirdCusInfoResp> qryEcifThirdCusInfoService;
    @Autowired
    @Qualifier(value="maintainEcifThirdCusService")
    private EsbService<MaintainEcifThirdCusReq, MaintainEcifThirdCusResp> maintainEcifThirdCusService;
    @Autowired
    private PatternedLimitableSeqService sequenceService;
    @Autowired
    @Qualifier(value="cusDetailInfoQueryService")
    private CusDetailInfoQueryService cusDetailInfoQueryService;
    @Autowired
    @Qualifier(value="priMainEcifThirdCusService")
    private EsbService<PriMtEcifThirdCusReq, PriMtEcifThirdCusResp> priMainEcifThirdCusService;
    @Autowired
    @Qualifier(value="cusCreateCommonService")
    private CusCreateCommonService cusCreateCommonService;
    private static final String HEAD = "head";
    private static final String BODY = "body";
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final PatternDescriptor CUS_PATTERN = DefaultPatternDescriptor.of((String)"$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String identMtrDt;
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        this.logger.info("======>\u5ba2\u6237\u5efa\u6863\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        QryEcifThirdCusInfoReq query = QryEcifThirdCusInfoReq.builder().IdntfMd("1").IdentTp(nlsCreditInfoVO.getCertType()).IdentNo(nlsCreditInfoVO.getCertCode()).CustNm(nlsCreditInfoVO.getCusName()).StrtCnt("1").build();
        QryEcifThirdCusInfoResp queryResp = (QryEcifThirdCusInfoResp)this.qryEcifThirdCusInfoService.service((Object)query);
        boolean exist = queryResp.getTotCnt() != 0;
        PrdInfoVO prdInfoVo = this.nlsPublicService.getProInfo(nlsCreditInfoVO.getPrdId());
        CusIndivVO cusIndivVO = new CusIndivVO();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("estblshDt", nlsCreditInfoVO.getCreateTime());
        paramsMap.put("sstblshBrch", nlsCreditInfoVO.getNlsOperOrgid());
        paramsMap.put("certCode", nlsCreditInfoVO.getCertCode());
        paramsMap.put("certType", nlsCreditInfoVO.getCertType());
        Map resultMap = this.cusCreateCommonService.getEstblshDtAndSstblshBrch(paramsMap);
        this.logger.info(nlsCreditInfoVO.getLmtApplySeq() + "\u67e5\u8be2\u5230\u7684\u5f00\u6237\u4fe1\u606f:{}", (Object)resultMap);
        String estblshDt = (String)resultMap.get("estblshDt");
        String sstblshBrch = (String)resultMap.get("sstblshBrch");
        MaintainEcifThirdCusResp maintainEcifThirdCusResp = new MaintainEcifThirdCusResp();
        String crrCd = null;
        try {
            crrCd = StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getProfession()) ? NlsCrrEnum.UNKNOWN.getValue() : SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsCreditInfoVO.getProfession());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u672c\u5730\u7cfb\u7edf\u5b57\u5178\u9879\u8f6cECIF\u63a5\u53e3\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicExternal.properties)\uff01");
        }
        String crrCd1 = null;
        String crrCd2 = null;
        String crrCd3 = null;
        if (!crrCd.endsWith("00")) {
            crrCd3 = crrCd;
        } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
            crrCd2 = crrCd;
        } else if (crrCd.endsWith("0000")) {
            crrCd1 = crrCd;
        }
        MaintainEcifThirdCusReq maintainEcifThirdCusReq = MaintainEcifThirdCusReq.builder().build();
        String string = identMtrDt = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
        if (identMtrDt.length() > 8) {
            identMtrDt = identMtrDt.length() == 10 ? DateUtility.format10To8((String)identMtrDt) : identMtrDt.split("-")[1];
        }
        TrdPtyCustInfArryBean build = TrdPtyCustInfArryBean.builder().CustNm(nlsCreditInfoVO.getCusName()).IdentTp(nlsCreditInfoVO.getCertType()).IdentNo(nlsCreditInfoVO.getCertCode()).IdentMtrDt(identMtrDt).Gnd(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname()).Nation(StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getNational()) ? SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"Country", (String)"CHN") : SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"Country", (String)nlsCreditInfoVO.getNational())).BrthDt(DateUtility.format10To8((String)ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()))).HghstEdu(nlsCreditInfoVO.getEdu()).CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).ProfTtl(SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Ttl", (String)nlsCreditInfoVO.getTtl())).CtcAddr(NlsStringUtil.toShorterString((String)nlsCreditInfoVO.getIndivRsdAddr(), (int)300)).CtcTel(nlsCreditInfoVO.getIndivMobile()).WrkCorp(nlsCreditInfoVO.getWrkCorpNm()).ChanNo("010").EstblshDt(estblshDt).EstblshBrch(sstblshBrch).build();
        maintainEcifThirdCusReq.setTrdPtyCustInfArry(Collections.singletonList(build));
        try {
            if (!exist) {
                this.logger.info("\u7f51\u8d37\u4e0d\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u524d\u5f80ECIF\u65b0\u589e");
                Map respMap = this.maintainEcifThirdCusService.serviceMap((Object)maintainEcifThirdCusReq);
                EsbRespSysHeadBean respSysHeadBean = (EsbRespSysHeadBean)respMap.get(HEAD);
                if (StringUtils.equals((CharSequence)((EsbRespRetInfBean)respSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"3036000|210006")) {
                    this.logger.info("\u77ed\u65f6\u95f4\u5e76\u53d1\u5bfc\u81f4ecif\u5df2\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237,\u524d\u5f80ecif\u66f4\u65b0\uff01");
                    queryResp = (QryEcifThirdCusInfoResp)this.qryEcifThirdCusInfoService.service((Object)query);
                    ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(((QryEcifThirdCusInfoResp.TrdPtyCustInfArryBean)queryResp.getTrdPtyCustInfArry().get(0)).getTrdPtyCustNo());
                    maintainEcifThirdCusResp = (MaintainEcifThirdCusResp)this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
                } else {
                    maintainEcifThirdCusResp = (MaintainEcifThirdCusResp)respMap.get(BODY);
                }
            } else {
                this.logger.info("\u7f51\u8d37\u5df2\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u53bbECIF\u66f4\u65b0");
                ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(((QryEcifThirdCusInfoResp.TrdPtyCustInfArryBean)queryResp.getTrdPtyCustInfArry().get(0)).getTrdPtyCustNo());
                maintainEcifThirdCusResp = (MaintainEcifThirdCusResp)this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
            }
            cusIndivVO.setCertType(nlsCreditInfoVO.getCertType());
            cusIndivVO.setCertCode(nlsCreditInfoVO.getCertCode());
            cusIndivVO = this.cusIndivService.getCusInvoByCertCode(cusIndivVO);
            if (Objects.isNull(cusIndivVO)) {
                try {
                    nlsCreditInfoVO.setCusId(this.sequenceService.getPatternedSequence("CUS_ID", CUS_PATTERN));
                }
                catch (Exception e) {
                    throw new BizException("\u5ba2\u6237id\u751f\u6210\u5931\u8d25");
                }
                this.insertCustomerInfo(nlsCreditInfoVO, maintainEcifThirdCusResp, prdInfoVo);
            } else {
                if (StringUtils.isNotBlank((CharSequence)cusIndivVO.getSelfCusId())) {
                    CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(cusIndivVO.getCusName(), cusIndivVO.getCertCode());
                    String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
                    String telCode = "";
                    List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
                    if (Objects.nonNull(telInfArry)) {
                        for (CusDetailTelInfArray item : telInfArry) {
                            if (!item.getAtchSys1().equals("2003000")) continue;
                            telCode = item.getTelId();
                        }
                    } else {
                        telCode = "";
                    }
                    this.priMtEcifThirdCusFn(nlsCreditInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
                }
                nlsCreditInfoVO.setCusId(this.cusIndivService.getCusIdByCertCode(nlsCreditInfoVO.getCertType(), nlsCreditInfoVO.getCertCode()));
                this.updateCustomerInfo(nlsCreditInfoVO, maintainEcifThirdCusResp, prdInfoVo);
            }
            nlsProcessBizVo.setCusId(nlsCreditInfoVO.getCusId());
        }
        catch (Exception e) {
            this.logger.error("======>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011\u6267\u884c\u5931\u8d25\u539f\u56e0\u4e3a<======", (Object)e.getMessage());
            try {
                this.updateApproveackConfirm(nlsCreditInfoVO, e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
            nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
            nlsProcessBizVo.setExceptionMsg(e);
        }
        finally {
            this.logger.info("======>\u5ba2\u6237\u5efa\u6863\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7<======" + applySeq);
        }
    }

    private void updateApproveackConfirm(NlsCreditInfoVO nlsCreditInfoVO, Exception e) throws ESBException, InterruptedException {
        WsApproveackConfirmVO wsApproveackConfirm = this.nlsPublicService.getWsApproveackConfirm(nlsCreditInfoVO.getLmtApplySeq());
        FinalApproveNoticeReqBean finalApproveNoticeReqBean = new FinalApproveNoticeReqBean();
        finalApproveNoticeReqBean.setRqsIdmptntID(wsApproveackConfirm.getRequestId());
        finalApproveNoticeReqBean.setAplNo(wsApproveackConfirm.getApplyNo());
        finalApproveNoticeReqBean.setAdptCertNm(nlsCreditInfoVO.getCusName());
        finalApproveNoticeReqBean.setAdptCertNo(nlsCreditInfoVO.getCertCode());
        finalApproveNoticeReqBean.setCnsntFlg("N");
        finalApproveNoticeReqBean.setRjctnCd("reason_code_11");
        finalApproveNoticeReqBean.setAprvlRsltRsn("\u5ba2\u6237\u5efa\u6863\u5931\u8d25:" + e.getMessage());
        finalApproveNoticeReqBean.setExnFld("{}");
        finalApproveNoticeReqBean.setGlobalSerno(nlsCreditInfoVO.getGlobalSerno());
        TraceUtil.setTraceId((String)nlsCreditInfoVO.getGlobalSerno());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.finalApproveNoticeService, (Object)finalApproveNoticeReqBean, this.nlsQueueSoltComnService);
        FinalApproveNoticeRespBean finalApproveNoticeRespBean = (FinalApproveNoticeRespBean)esbInvokeWrapper.invoke3Threes();
        wsApproveackConfirm.setRefuseCode("reason_code_11");
        wsApproveackConfirm.setAckMsg("\u5ba2\u6237\u5efa\u6863\u5931\u8d25:" + e.getMessage());
        wsApproveackConfirm.setResultInfo(JSON.toJSONString((Object)finalApproveNoticeRespBean));
        TraceUtil.clear();
        this.wsApproveackConfirmService.updateByPk(wsApproveackConfirm);
    }

    private CusIndivVO getCusIndivVO(NlsCreditInfoVO nlsCreditInfoVO, MaintainEcifThirdCusResp maintainEcifThirdCusResp, PrdInfoVO prdInfoVo) {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(nlsCreditInfoVO.getCusId());
        cusIndivVO.setInnerCusId(maintainEcifThirdCusResp.getTrdPtyCustNo());
        cusIndivVO.setCusName(nlsCreditInfoVO.getCusName());
        cusIndivVO.setIndivSex(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname());
        cusIndivVO.setCertType(nlsCreditInfoVO.getCertType());
        cusIndivVO.setCertCode(nlsCreditInfoVO.getCertCode());
        cusIndivVO.setIndivIdExpDt(nlsCreditInfoVO.getCertEndDt());
        cusIndivVO.setIndivRsdAddr(nlsCreditInfoVO.getIndivRsdAddr());
        cusIndivVO.setIndivCountry("CHN");
        try {
            cusIndivVO.setIndivOcc(SDicToLocal.getLocalSysDicVal((String)"Crr", (String)NlsCrrEnum.UNKNOWN.getValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5916\u90e8\u7cfb\u7edf\u5b57\u5178\u9879\u8f6c\u7f51\u8d37\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicExternal.properties)\uff01");
        }
        cusIndivVO.setPhone(nlsCreditInfoVO.getIndivMobile());
        cusIndivVO.setCusType(CusTypeEnum.NATURAL_MAN.getCode());
        cusIndivVO.setCusBankRel(CusBankRelEnum.NORMAL.getCode());
        cusIndivVO.setCusStatus(CusStatusEnum.OFFICIAL.getCode());
        cusIndivVO.setFstAppChannel(prdInfoVo.getPrdType());
        return cusIndivVO;
    }

    private void insertCustomerInfo(NlsCreditInfoVO nlsCreditInfoVO, MaintainEcifThirdCusResp maintainEcifThirdCusResp, PrdInfoVO prdInfoVo) throws BizException {
        CusIndivVO cusIndivVO = this.getCusIndivVO(nlsCreditInfoVO, maintainEcifThirdCusResp, prdInfoVo);
        cusIndivVO.setMainBrId(prdInfoVo.getDefaultManageOrg());
        cusIndivVO.setComInitLoanDate(DateUtility.getCurrAppDateStr());
        cusIndivVO.setInputDate(DateUtility.getCurrAppDateStr());
        this.setServerInsertDefaultProperty((BaseInfo)cusIndivVO);
        int num1 = this.cusIndivService.insertCusIndiv(cusIndivVO);
        String dateTimeString = LocalDateTime.now().format(timeStrFormatter);
        CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
        cusIndivExtVO.setCusId(cusIndivVO.getCusId());
        cusIndivExtVO.setCusType("01");
        cusIndivExtVO.setOnlineVerfStatus("0");
        cusIndivExtVO.setCreateUser("admin");
        cusIndivExtVO.setCreateTime(dateTimeString);
        cusIndivExtVO.setLastUpdateUser("admin");
        cusIndivExtVO.setLastUpdateTime(dateTimeString);
        int num2 = this.cusIndivExtService.insert(cusIndivExtVO);
        if (num1 == -1 || num2 == -1) {
            this.logger.error("=========>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u63d2\u5165\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!<========", (Object)"message{}");
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u63d2\u5165\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!", "message{}");
        }
    }

    private CusIndivVO updateCustomerInfo(NlsCreditInfoVO nlsCreditInfoVO, MaintainEcifThirdCusResp maintainEcifThirdCusResp, PrdInfoVO prdInfoVo) throws BizException {
        CusIndivVO cusIndivVO = this.getCusIndivVO(nlsCreditInfoVO, maintainEcifThirdCusResp, prdInfoVo);
        this.setServerUpdateDefaultProperty((BaseInfo)cusIndivVO);
        int result = this.cusIndivService.updateByPk(cusIndivVO);
        if (result == -1) {
            this.logger.error("=========>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!<======", (Object)"message{}");
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!");
        }
        CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
        cusIndivExtVO.setCusId(cusIndivVO.getCusId());
        CusIndivExtVO cusIndivExtVO1 = this.cusIndivExtService.queryByPk(cusIndivExtVO);
        if ("02".equals(cusIndivExtVO1.getCusType())) {
            cusIndivExtVO1.setCusType("0201");
            int num2 = this.cusIndivExtService.updateByPk(cusIndivExtVO1);
            if (num2 == -1) {
                throw new BizException("\u5ba2\u6237\u62d3\u5c55\u8868\u66f4\u65b0\u5f02\u5e38!!!");
            }
        }
        return cusIndivVO;
    }

    public CusDetialInfoQueryResp queryECIFInfo(String cusName, String idNo) throws Exception {
        CusDetialInfoQueryReq cusDetialInfoQueryReq = new CusDetialInfoQueryReq();
        cusDetialInfoQueryReq.setIdntfMd("1");
        cusDetialInfoQueryReq.setCustNm(cusName);
        cusDetialInfoQueryReq.setIdentNo(idNo);
        CusDetialInfoQueryResp resp = null;
        try {
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.cusDetailInfoQueryService, (Object)cusDetialInfoQueryReq, this.nlsQueueSoltComnService);
            resp = (CusDetialInfoQueryResp)esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            this.logger.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        return resp;
    }

    public PriMtEcifThirdCusResp priMtEcifThirdCusFn(NlsCreditInfoVO nlsCreditInfoVO, String cusId, String idSeqCode, String telCode) throws ESBException {
        this.logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u5f00\u59cb>>>>>>>>>>>>>>>>>");
        PriMtEcifThirdCusResp resp = new PriMtEcifThirdCusResp();
        try {
            TelInfArry2Bean telInfArry2Bean;
            String endDtCert;
            String string = endDtCert = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
            if (endDtCert.length() > 8) {
                endDtCert = endDtCert.length() == 10 ? DateUtility.format10To8((String)endDtCert) : endDtCert.split("-")[1];
            }
            IdInfArry2Bean idInfArry2Bean = IdInfArry2Bean.builder().IdentInvalDt(endDtCert).IdentIssuCntry("156").IssuInst("\u4e2d\u56fd").IdentAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getCertAddr())).OprtFlg("2").IdentSeqNo(idSeqCode).NetwrkngExmnRslt(nlsCreditInfoVO.getRetCode()).build();
            ArrayList<IdInfArry2Bean> beans = new ArrayList<IdInfArry2Bean>();
            beans.add(idInfArry2Bean);
            ArrayList<TelInfArry2Bean> telBeans = new ArrayList<TelInfArry2Bean>();
            if (StringUtil.isNullorBank((String)telCode)) {
                telInfArry2Bean = TelInfArry2Bean.builder().OprtTp1("1").TelTp("05").CtcTelNo(nlsCreditInfoVO.getIndivMobile()).build();
                telBeans.add(telInfArry2Bean);
            } else {
                telInfArry2Bean = TelInfArry2Bean.builder().OprtTp1("2").TelId(telCode).TelTp("05").CtcTelNo(nlsCreditInfoVO.getIndivMobile()).AtchSys1("2003000").build();
                telBeans.add(telInfArry2Bean);
            }
            PriMtEcifThirdCusReq req = PriMtEcifThirdCusReq.builder().CustNo(cusId).CustNm(nlsCreditInfoVO.getCusName()).NationCd("156").MainMblNo(nlsCreditInfoVO.getIndivMobile()).TelInfArry(telBeans).IdInfArry(beans).build();
            resp = (PriMtEcifThirdCusResp)this.priMainEcifThirdCusService.service((Object)req);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u5f02\u5e38>>>>>>>>>>>>>>>>>");
            throw new ESBException((Throwable)e);
        }
        this.logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u7ed3\u675f>>>>>>>>>>>>>>>>>");
        return resp;
    }
}

