/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.wsd.credit;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.service.bo.req.wsd.finalnotice.FinalApproveNoticeReqBean;
import com.irdstudio.efp.esb.service.bo.resp.wsd.finalnotice.FinalApproveNoticeRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.wsd.finalnotice.FinalApproveNoticeService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.WsApproveackNotifyService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.WsApproveackConfirmVO;
import com.irdstudio.efp.nls.service.vo.WsApproveackNotifyVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="wsdLimitGenerateService")
public class WsdLimitGenerateServiceImpl
extends CreditSoltServiceImpl
implements FrameworkService {
    private final Logger logger = LoggerFactory.getLogger(WsdLimitGenerateServiceImpl.class);
    private final String msgTemplate = "message{}";
    private static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"lmt$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    @Qualifier(value="finalApproveNoticeService")
    private FinalApproveNoticeService finalApproveNoticeService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="wsApproveackNotifyService")
    private WsApproveackNotifyService wsApproveackNotifyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        this.logger.info("======>\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        try {
            boolean isLimitExits = this.getLimitByLmtApplySeq(nlsCreditInfoVO);
            if (isLimitExits) {
                this.insertProLmtCont(nlsCreditInfoVO);
            }
            this.updateCreditApplyInfo(nlsCreditInfoVO);
            WsApproveackNotifyVO wsApproveackNotifyVO = this.wsApproveackNotifyService.queryByApplyNo(nlsCreditInfoVO.getLmtApplySeq());
            this.invokeFinalNotice(nlsCreditInfoVO, null, null, wsApproveackNotifyVO);
        }
        catch (ESBException e) {
            this.logger.error("\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1 \u8c03\u7528\u590d\u5ba1\u901a\u77e5\u63a5\u53e3\u5931\u8d25!!!");
        }
        catch (InterruptedException e) {
            this.logger.error("\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1 \u8c03\u7528\u590d\u5ba1\u901a\u77e5\u63a5\u53e3\u5931\u8d25!!!");
        }
        catch (Exception e) {
            nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
            nlsProcessBizVo.setRefuseMsg(e.getMessage());
            nlsProcessBizVo.setExceptionMsg(e);
        }
        finally {
            TraceUtil.clear();
            this.logger.info("======>\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
        }
    }

    private void invokeFinalNotice(NlsCreditInfoVO nlsCreditInfoVO, String code, String reason, WsApproveackNotifyVO wsApproveackNotifyVO) throws ESBException, InterruptedException {
        WsApproveackConfirmVO wsApproveackConfirm = this.nlsPublicService.getWsApproveackConfirm(nlsCreditInfoVO.getLmtApplySeq());
        FinalApproveNoticeReqBean finalApproveNoticeReqBean = new FinalApproveNoticeReqBean();
        finalApproveNoticeReqBean.setRqsIdmptntID(wsApproveackConfirm.getRequestId());
        finalApproveNoticeReqBean.setAplNo(wsApproveackConfirm.getApplyNo());
        finalApproveNoticeReqBean.setAdptCertNm(nlsCreditInfoVO.getCusName());
        finalApproveNoticeReqBean.setAdptCertNo(nlsCreditInfoVO.getCertCode());
        finalApproveNoticeReqBean.setCnsntFlg(wsApproveackConfirm.getIsAgree());
        finalApproveNoticeReqBean.setRjctnCd(wsApproveackConfirm.getRefuseCode());
        finalApproveNoticeReqBean.setAprvlRsltRsn(wsApproveackConfirm.getAckMsg());
        HashMap exnFldMap = Maps.newHashMap();
        exnFldMap.put("creditAmt", wsApproveackNotifyVO.getPlatformAdmit());
        exnFldMap.put("creditRateLimit", wsApproveackNotifyVO.getPlatformRateLimit());
        exnFldMap.put("creditRateBottom", wsApproveackNotifyVO.getPlatformRateBottom());
        finalApproveNoticeReqBean.setExnFld(JSON.toJSONString((Object)exnFldMap));
        finalApproveNoticeReqBean.setGlobalSerno(nlsCreditInfoVO.getGlobalSerno());
        TraceUtil.setTraceId((String)nlsCreditInfoVO.getGlobalSerno());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.finalApproveNoticeService, (Object)finalApproveNoticeReqBean, this.nlsQueueSoltComnService);
        FinalApproveNoticeRespBean finalApproveNoticeRespBean = (FinalApproveNoticeRespBean)esbInvokeWrapper.invoke3Threes();
        wsApproveackConfirm.setResultInfo(JSON.toJSONString((Object)finalApproveNoticeRespBean));
        wsApproveackConfirm.setRefuseCode(code);
        wsApproveackConfirm.setAckMsg(reason);
        TraceUtil.clear();
    }

    private void updateCreditApplyInfo(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        nlsCreditInfoVO.setApprvSts("03");
        this.setServerUpdateDefaultProperty((BaseInfo)nlsCreditInfoVO);
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result == -1) {
            throw new BizException("\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void insertProLmtCont(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        Objects.requireNonNull(nlsCreditInfoVO, "\u3010\u989d\u5ea6\u751f\u6210\u63d2\u69fd\u3011\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a!!!");
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtContNo(this.generateLmtContNo());
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO.setCusId(nlsCreditInfoVO.getCusId());
        lmtPrdContVO.setCusName(nlsCreditInfoVO.getCusName());
        lmtPrdContVO.setCertType(nlsCreditInfoVO.getCertType());
        lmtPrdContVO.setCertCode(nlsCreditInfoVO.getCertCode());
        lmtPrdContVO.setChannelNo(nlsCreditInfoVO.getChannelNo());
        lmtPrdContVO.setPrdId(nlsCreditInfoVO.getPrdId());
        lmtPrdContVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        lmtPrdContVO.setPrdName(nlsCreditInfoVO.getPrdName());
        lmtPrdContVO.setLmtAmt(nlsCreditInfoVO.getApproveAmt());
        lmtPrdContVO.setAvailAmt(nlsCreditInfoVO.getApproveAmt());
        lmtPrdContVO.setCyclicFlg(nlsCreditInfoVO.getCyclicFlg());
        lmtPrdContVO.setCurrencyType(nlsCreditInfoVO.getCurrencyType());
        lmtPrdContVO.setTerm(new BigDecimal(nlsCreditInfoVO.getApplyTerm()));
        lmtPrdContVO.setTermType(nlsCreditInfoVO.getTermType());
        lmtPrdContVO.setAssureMeansMain(nlsCreditInfoVO.getAssureMeansMain());
        lmtPrdContVO.setLoanUse(nlsCreditInfoVO.getLoanUseType());
        lmtPrdContVO.setLmtStatus("02");
        String openDay = this.nlsPublicService.getSysInfoOpenDay("1001");
        lmtPrdContVO.setStartDate(openDay);
        try {
            lmtPrdContVO.setExpireDate(TimeUtil.addYear((String)openDay, (int)1));
        }
        catch (Exception e) {
            throw new BizException("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\u5230\u671f\u65e5\u671f\u8bbe\u7f6e\u5931\u8d25!!!");
        }
        lmtPrdContVO.setSignDate(openDay);
        this.setServerInsertDefaultProperty((BaseInfo)lmtPrdContVO);
        int result = this.lmtPrdContService.insertLmtPrdCont(lmtPrdContVO);
        if (result == -1) {
            throw new BizException("=======>\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u751f\u6210\u989d\u5ea6\u63d2\u69fd,\u63d2\u5165\u672a\u751f\u6548\u7684\u989d\u5ea6\u4fe1\u606f\u5931\u8d25<=======", "message{}");
        }
    }

    private boolean getLimitByLmtApplySeq(NlsCreditInfoVO nlsCreditInfoVO) {
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
        return lmtPrdContVO == null;
    }

    public String generateLmtContNo() {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("LMT", PATTERN);
    }
}

