/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.xhx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.esb.service.bo.req.xhx.XhxNewPrdQueryReq;
import com.irdstudio.efp.esb.service.bo.resp.xhx.PrdInfoArr;
import com.irdstudio.efp.esb.service.bo.resp.xhx.XhxNewPrdQueryResp;
import com.irdstudio.efp.esb.service.facade.xhx.XhxNewPrdEsbService;
import com.irdstudio.efp.nls.service.facade.xhx.XhxNewPrdService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="xhxNewPrdService")
public class XhxNewPrdServiceImpl
implements XhxNewPrdService {
    private static Logger logger = LoggerFactory.getLogger(XhxNewPrdServiceImpl.class);
    @Autowired
    @Qualifier(value="xhxNewPrdEsbService")
    private XhxNewPrdEsbService xhxNewPrdEsbService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;

    public PrdInfoVO queryByNewPrd(PrdInfoVO prdInfoVO) throws BizException, Exception {
        Objects.requireNonNull(prdInfoVO);
        if (StringUtil.isNullorBank((String)prdInfoVO.getPrdCode())) {
            throw new BizException("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String prdId = prdInfoVO.getPrdCode();
        XhxNewPrdQueryReq req = new XhxNewPrdQueryReq();
        req.setPdNo(prdId);
        req.setStrtCnt("0");
        req.setQryCnt("1");
        logger.info("\u5f00\u59cb\u8c03\u7528esb\u65b0\u6838\u5fc3\u4ea7\u54c1\u76ee\u5f55\u67e5\u8be2\u63a5\u53e3...");
        XhxNewPrdQueryResp resp = this.xhxNewPrdEsbService.queryByNewPrd(req);
        if (Objects.isNull(resp.getPdCtlgInfArry())) {
            logger.error("\u65b0\u6838\u5fc3\u672a\u67e5\u5230\u4fe1\u606f\uff01\u4ea7\u54c1\u7f16\u53f7\u4e3a\uff1a" + prdId);
            throw new BizException("\u65b0\u6838\u5fc3\u672a\u67e5\u5230\u4ea7\u54c1\u76ee\u5f55\u4fe1\u606f\uff01");
        }
        PrdInfoVO prdInfoOutVo = this.respToPrdInfoVO(resp, prdInfoVO, prdId);
        return prdInfoOutVo;
    }

    private PrdInfoVO respToPrdInfoVO(XhxNewPrdQueryResp resp, PrdInfoVO prdInfo, String prdId) {
        PrdInfoVO prdInfoVO = new PrdInfoVO();
        List list = new ArrayList();
        list = resp.getPdCtlgInfArry();
        if (Objects.nonNull(list) && list.size() > 0) {
            PrdInfoArr prdInfoArr = (PrdInfoArr)list.get(0);
            prdInfoVO.setPrdCode(prdId);
            prdInfoVO.setLoanSort(prdInfoArr.getFrthLvlClsf());
            prdInfoVO.setPrdDesc(prdInfoArr.getFfthLvlClsf());
            prdInfoVO.setPrdName(prdInfoArr.getPdNm());
            prdInfoVO.setPrdStatus(this.getPrdStatus(prdInfoArr.getPdSt()));
            prdInfoVO.setEffictiveDate(DateUtility.format8To10((String)prdInfoArr.getEfftvDt()));
            prdInfoVO.setExpiryDate(DateUtility.format8To10((String)prdInfoArr.getInvalDt()));
            PrdInfoVO prdInfoVOPre = this.prdInfoService.queryLastPrdInfo(prdInfoVO);
            if (Objects.nonNull(prdInfoVOPre)) {
                prdInfoVO.setCooprName(prdInfoVOPre.getCooprName());
                prdInfoVO.setPrdSort(prdInfoVOPre.getPrdSort());
                prdInfoVO.setCreateUser(prdInfoVOPre.getCreateUser());
                prdInfoVO.setCreateTime(prdInfoVOPre.getCreateTime());
            } else {
                prdInfoVO.setCreateUser(prdInfo.getLoginUserId());
                prdInfoVO.setCreateTime(TimeUtil.getCurrentDateTime());
            }
            prdInfoVO.setPrdVersion("1");
        }
        return prdInfoVO;
    }

    public String getPrdStatus(String pdSt) {
        String newPrdStatus = "";
        switch (pdSt) {
            case "1": {
                newPrdStatus = "1";
                break;
            }
            case "0": {
                newPrdStatus = "2";
                break;
            }
            case "2": {
                newPrdStatus = "3";
                break;
            }
            default: {
                newPrdStatus = "";
            }
        }
        return newPrdStatus;
    }
}

