/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.xhx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.efp.console.service.vo.SOrgVO;
import com.irdstudio.efp.esb.service.bo.req.xhx.XhxSOrgQueryReq;
import com.irdstudio.efp.esb.service.bo.resp.xhx.XhxSOrgQueryResp;
import com.irdstudio.efp.esb.service.facade.xhx.XhxSOrgEsbService;
import com.irdstudio.efp.nls.service.facade.xhx.XhxSOrgService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="xhxSOrgService")
public class XhxSOrgServiceImpl
implements XhxSOrgService {
    private static Logger logger = LoggerFactory.getLogger(XhxSOrgServiceImpl.class);
    @Autowired
    @Qualifier(value="xhxSOrgEsbService")
    private XhxSOrgEsbService xhxSOrgEsbService;

    public SOrgVO queryOrgByOrgCode(SOrgVO sOrgVO) throws BizException, Exception {
        Objects.requireNonNull(sOrgVO);
        if (StringUtil.isNullorBank((String)sOrgVO.getOrgCode())) {
            throw new BizException("\u673a\u6784\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        XhxSOrgQueryReq req = new XhxSOrgQueryReq();
        req.setBrchNo(sOrgVO.getOrgCode());
        logger.info("\u5f00\u59cb\u8c03\u7528esb\u65b0\u6838\u5fc3\u673a\u6784\u67e5\u8be2\u63a5\u53e3...");
        XhxSOrgQueryResp resp = this.xhxSOrgEsbService.queryOrgByOrgCode(req);
        if (Objects.isNull(resp)) {
            logger.error("\u65b0\u6838\u5fc3\u672a\u67e5\u5230\u8be5\u673a\u6784\u4fe1\u606f\uff01\u673a\u6784\u53f7\u4e3a\uff1a" + sOrgVO.getOrgCode());
            throw new BizException("\u65b0\u6838\u5fc3\u672a\u67e5\u5230\u8be5\u673a\u6784\u4fe1\u606f\uff01");
        }
        if (!"01".equals(resp.getBrchSt())) {
            logger.error("\u8be5\u673a\u6784\u72b6\u6001\u4e0d\u4e3a01\uff08\u6b63\u5e38\uff09\uff0c\u4e0d\u80fd\u65b0\u589e\uff01\u673a\u6784\u53f7\u4e3a\uff1a" + sOrgVO.getOrgCode());
            throw new BizException("\u8be5\u673a\u6784\u72b6\u6001\u4e0d\u4e3a01\uff08\u6b63\u5e38\uff09\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
        }
        SOrgVO result = this.tranToSOrgVO(resp, sOrgVO.getOrgCode());
        return result;
    }

    private SOrgVO tranToSOrgVO(XhxSOrgQueryResp resp, String orgCode) {
        SOrgVO result = new SOrgVO();
        result.setOrgCode(orgCode);
        result.setLegalOrgCode(resp.getLPCd());
        result.setOrgName(resp.getBrchCNNm());
        result.setOrgSimpleName(resp.getBrchAbbr());
        result.setOrgEname(resp.getBrchENGNm());
        result.setLaunchDate(resp.getBrchFoundTm());
        result.setFinaCode(resp.getFinBrchEncd());
        result.setOrgTel(resp.getTelNo());
        result.setOrgAddress(resp.getBrchAddr());
        result.setOrgZipcode(resp.getPstlCd());
        result.setDistno(resp.getDstcCd());
        result.setOrgFax(resp.getFax());
        return result;
    }
}

