/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed;

import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedGjjCompnayInfoRequestBean;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedGjjCompanyInfoResponseBean;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.esb.service.facade.yed.YedCompanyInfoService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayPlanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayPlanVO;
import com.irdstudio.efp.nls.common.util.SocketClientUtil;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.YedGjjInvoteService;
import com.irdstudio.efp.nls.service.facade.bean.YedSxGjjInvoteReqBean;
import com.irdstudio.efp.nls.service.facade.bean.YedSxGjjLoanReaseReqBean;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.yed.YedGjjLoanService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.YedGjjInvoteVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="yedGjjLoanService")
public class YedGjjLoanServiceImpl
implements YedGjjLoanService {
    private final Logger logger = LoggerFactory.getLogger(YedGjjLoanServiceImpl.class);
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    private YedGjjInvoteService yedGjjInvoteService;
    @Autowired
    private LoanRepayPlanService loanRepayPlanService;
    @Value(value="${send_to_gjj_ip}")
    private String ip;
    @Value(value="${send_to_gjj_port}")
    private String port;
    private static AtomicInteger msgCount = new AtomicInteger(1);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private YedCompanyInfoService yedCompanyInfoService;
    @Autowired
    private AlarmJudgementService alarmJudgementService;

    public void callSyncGjjInvoteApply(NlsApplyInfoVO nlsApplyInfoVO) {
        this.logger.info("\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u5f00\u59cb-\u7528\u4fe1\u9636\u6bb5\uff1a" + nlsApplyInfoVO.getApplySeq());
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
        lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
        accLoanVO = this.accLoanService.queryByApplySeq(accLoanVO);
        String stdbwtype = "Request";
        String stdprocode = "DS32";
        String stdyhdm = "21";
        String currentDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String stdseqnum = this.seqGenerator(stdprocode + stdyhdm + currentDate, 6);
        YedGjjInvoteVO vo = new YedGjjInvoteVO();
        vo.setStdSeqnum(stdseqnum);
        vo.setSendDate(new Date());
        vo.setCertType(nlsApplyInfoVO.getCertType());
        vo.setCertCode(nlsApplyInfoVO.getCertCode());
        vo.setApplSeq(nlsApplyInfoVO.getApplySeq());
        vo.setApplType("2");
        vo.setCusName(nlsApplyInfoVO.getCusName());
        vo.setStdProcode(stdprocode);
        vo.setStdYhdm(stdyhdm);
        try {
            this.yedGjjInvoteService.insert(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        YedSxGjjLoanReaseReqBean reqBean = new YedSxGjjLoanReaseReqBean();
        if (Objects.isNull(lmtPrdContVO)) {
            this.logger.error("\u4f18e\u8d37\u7528\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq() + "\u7684\u989d\u5ea6\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return;
        }
        if (Objects.isNull(accLoanVO)) {
            this.logger.error("\u4f18e\u8d37\u7528\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq() + "\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return;
        }
        LoanRepayPlanVO loanRepayPlanVO = new LoanRepayPlanVO();
        loanRepayPlanVO.setRefNbr(accLoanVO.getBillNo());
        loanRepayPlanVO.setTerm(Integer.valueOf(1));
        loanRepayPlanVO = this.loanRepayPlanService.getLoanRepayPlanByRefNbrAndTerm(loanRepayPlanVO);
        BigDecimal stdyhke = BigDecimal.ZERO;
        if (Objects.nonNull(loanRepayPlanVO)) {
            stdyhke = loanRepayPlanVO.getPrincipal().add(loanRepayPlanVO.getInterest());
        }
        if (StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getCertType()) || StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getCertCode()) || StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getCusName()) || StringUtils.isBlank((CharSequence)lmtPrdContVO.getLmtContNo()) || StringUtils.isBlank((CharSequence)accLoanVO.getContNo()) || StringUtils.isBlank((CharSequence)accLoanVO.getBillNo()) || Objects.isNull(accLoanVO.getLoanAmount()) || StringUtils.isBlank((CharSequence)accLoanVO.getReturnDate())) {
            this.logger.error("\u4f18e\u8d37\u7528\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq() + "\u7684\u5fc5\u8f93\u9879\u4e3a\u7a7a\u503c\uff01");
            return;
        }
        reqBean.setStdidtype("10100".equals(nlsApplyInfoVO.getCertType()) ? "01" : "");
        reqBean.setStdidno(nlsApplyInfoVO.getCertCode());
        reqBean.setStdxm(nlsApplyInfoVO.getCusName());
        reqBean.setStdsxbh(Objects.nonNull(lmtPrdContVO) ? lmtPrdContVO.getLmtContNo() : "");
        reqBean.setStdcontrnm(Objects.nonNull(accLoanVO) ? accLoanVO.getContNo() : "");
        reqBean.setStdbrno(Objects.nonNull(accLoanVO) ? accLoanVO.getBillNo() : "");
        reqBean.setStdfkje(Objects.nonNull(accLoanVO) ? accLoanVO.getLoanAmount() : BigDecimal.ZERO);
        reqBean.setStdfksj(Objects.nonNull(accLoanVO) ? accLoanVO.getFirstDisbDate().replace("-", "") : "");
        reqBean.setStddkqs(Objects.nonNull(accLoanVO) ? accLoanVO.getLoanTerm().toString() : "");
        reqBean.setStdydhkr(Objects.nonNull(accLoanVO) ? accLoanVO.getReturnDate() : "");
        reqBean.setStd400stcd("6".equals(nlsApplyInfoVO.getDnSts()) ? "000" : "001");
        String reqhead = "<?xml version=\"1.0\" encoding=\"GBK\"?>";
        String headStr = "<HEAD><stdbwtype>" + stdbwtype + "</stdbwtype><stdprocode>" + stdprocode + "</stdprocode><stdyhdm>" + stdyhdm + "</stdyhdm><stdseqnum>" + stdseqnum + "</stdseqnum></HEAD>";
        String bodyStr = "<ROOT><stdidtype>" + reqBean.getStdidtype() + "</stdidtype><stdidno>" + reqBean.getStdidno() + "</stdidno><stdxm>" + reqBean.getStdxm() + "</stdxm><stdsxbh>" + reqBean.getStdsxbh() + "</stdsxbh><stdcontrnm>" + reqBean.getStdcontrnm() + "</stdcontrnm><stdbrno>" + reqBean.getStdbrno() + "</stdbrno><stdfkje>" + reqBean.getStdfkje() + "</stdfkje><stdfksj>" + reqBean.getStdfksj() + "</stdfksj><stddkqs>" + reqBean.getStddkqs() + "</stddkqs><stdyhke>" + stdyhke + "</stdyhke><stdydhkr>" + reqBean.getStdydhkr() + "</stdydhkr><std400stcd>" + reqBean.getStd400stcd() + "</std400stcd></ROOT>";
        String reqStr1 = reqhead + headStr + bodyStr;
        this.logger.info("\u7528\u4fe1\u51c6\u5907\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u5165\u53c2reqStr1\uff1a" + reqStr1);
        try {
            YedGjjCompanyInfoResponseBean responseBean = this.getYedGjjAccNoInfoResponseBean(nlsApplyInfoVO.getCertType(), nlsApplyInfoVO.getCertCode(), nlsApplyInfoVO.getCusName(), nlsApplyInfoVO.getGlobalSerno());
            if (Objects.nonNull(responseBean)) {
                this.logger.info("nls-\u8c03\u7528\u5916\u6570\u5e73\u53f0\u67e5\u8be2\u516c\u79ef\u91d1\u8d26\u53f7\u6210\u529f");
                this.threadPool.add(() -> {
                    try {
                        this.sendGjj(reqStr1, nlsApplyInfoVO.getApplySeq());
                    }
                    catch (Exception e) {
                        this.logger.error("\u7528\u4fe1\u9636\u6bb5-\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq());
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void callSyncGjjInvoteCredit(NlsCreditInfoVO nlsCreditInfoVO) {
        this.logger.info("\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u5f00\u59cb-\u6388\u4fe1\u9636\u6bb5\uff1a" + nlsCreditInfoVO.getLmtApplySeq());
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
        String stdbwtype = "Request";
        String stdprocode = "DS31";
        String stdyhdm = "21";
        String currentDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String stdseqnum = this.seqGenerator(stdprocode + stdyhdm + currentDate, 6);
        YedGjjInvoteVO vo = new YedGjjInvoteVO();
        vo.setStdSeqnum(stdseqnum);
        vo.setSendDate(new Date());
        vo.setCertType(nlsCreditInfoVO.getCertType());
        vo.setCertCode(nlsCreditInfoVO.getCertCode());
        vo.setApplSeq(nlsCreditInfoVO.getLmtApplySeq());
        vo.setApplType("1");
        vo.setCusName(nlsCreditInfoVO.getCusName());
        vo.setStdProcode(stdprocode);
        vo.setStdYhdm(stdyhdm);
        try {
            this.yedGjjInvoteService.insert(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Objects.isNull(lmtPrdContVO)) {
            this.logger.error("\u4f18e\u8d37\u7528\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfoVO.getLmtApplySeq() + "\u7684\u989d\u5ea6\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return;
        }
        if (StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getCertType()) || StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getCertCode()) || StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getCusName()) || StringUtils.isBlank((CharSequence)lmtPrdContVO.getLmtContNo()) || Objects.isNull(nlsCreditInfoVO.getApproveAmt())) {
            this.logger.error("\u4f18e\u8d37\u7528\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfoVO.getLmtApplySeq() + "\u7684\u5fc5\u8f93\u9879\u4e3a\u7a7a\u503c\uff01");
            return;
        }
        YedSxGjjInvoteReqBean reqBean = new YedSxGjjInvoteReqBean();
        reqBean.setStdidtype("10100".equals(nlsCreditInfoVO.getCertType()) ? "01" : "");
        reqBean.setStdidno(nlsCreditInfoVO.getCertCode());
        reqBean.setStdxm(nlsCreditInfoVO.getCusName());
        reqBean.setStdsxbh(Objects.nonNull(lmtPrdContVO) ? lmtPrdContVO.getLmtContNo() : "");
        reqBean.setStdsxje(nlsCreditInfoVO.getApproveAmt());
        reqBean.setStd400stcd("02".equals(nlsCreditInfoVO.getApprvSts()) ? "000" : "001");
        String reqhead = "<?xml version=\"1.0\" encoding=\"GBK\"?>";
        String headStr = "<HEAD><stdbwtype>" + stdbwtype + "</stdbwtype><stdprocode>" + stdprocode + "</stdprocode><stdyhdm>" + stdyhdm + "</stdyhdm><stdseqnum>" + stdseqnum + "</stdseqnum></HEAD>";
        String bodyStr = "<ROOT><stdidtype>" + reqBean.getStdidtype() + "</stdidtype><stdidno>" + reqBean.getStdidno() + "</stdidno><stdxm>" + reqBean.getStdxm() + "</stdxm><stdsxbh>" + reqBean.getStdsxbh() + "</stdsxbh><stdsxje>" + reqBean.getStdsxje() + "</stdsxje><std400stcd>" + reqBean.getStd400stcd() + "</std400stcd></ROOT>";
        String reqStr1 = reqhead + headStr + bodyStr;
        this.logger.info("\u6388\u4fe1\u51c6\u5907\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u5165\u53c2reqStr1\uff1a" + reqStr1);
        try {
            this.threadPool.add(() -> {
                try {
                    this.sendGjj(reqStr1, nlsCreditInfoVO.getLmtApplySeq());
                }
                catch (Exception e) {
                    this.logger.error("\u6388\u4fe1\u9636\u6bb5-\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfoVO.getLmtApplySeq());
                }
            });
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void updateYedGjjInvote(String requestString) {
        if (requestString.contains("stdjsbz") && requestString.contains("stdseqnum") && requestString.contains("stdresdesc")) {
            String stdjsbz = requestString.split("<stdjsbz>")[1].split("</stdjsbz>")[0];
            String stdseqnum = requestString.split("<stdseqnum>")[1].split("</stdseqnum>")[0];
            String stdresdesc = requestString.split("<stdresdesc>")[1].split("</stdresdesc>")[0];
            YedGjjInvoteVO vo2 = new YedGjjInvoteVO();
            vo2.setStdSeqnum(stdseqnum);
            vo2.setStdState(stdjsbz);
            vo2.setStdResdesc(stdresdesc);
            try {
                this.yedGjjInvoteService.updateByPk(vo2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String seqGenerator(String prefix, int numLength) {
        int Suffix;
        String upperCode = "";
        Long size = this.redisTemplate.opsForList().size((Object)prefix);
        if (size > 0L) {
            List leve = this.redisTemplate.opsForList().range((Object)prefix, 0L, -1L);
            upperCode = leve.get(leve.size() - 1).toString();
        }
        String returnCode = "";
        if (!StringUtil.isEmpty((String)upperCode)) {
            String sequence = upperCode.substring(prefix.length());
            Suffix = Integer.parseInt(sequence);
            ++Suffix;
        } else {
            Suffix = 1;
        }
        returnCode = prefix + String.format("%0" + numLength + "d", Suffix);
        this.redisTemplate.opsForList().rightPush((Object)prefix, (Object)returnCode);
        return returnCode;
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"GBK\"?><HEAD>\n  <stdbwtype>Response</stdbwtype>\n  <stdyhdm>21</stdyhdm>\n  <stdprocode>DS31</stdprocode>\n  <stdseqnum>DS312120200930000007</stdseqnum>\n  <stdrescode>00</stdrescode>\n  <stdresdesc>\u4ea4\u6613\u6210\u529f</stdresdesc>\n</HEAD><ROOT>\n  <stdjsbz>1</stdjsbz>\n</ROOT>";
        try {
            String s = xml.split("<stdresdesc>")[1].split("</stdresdesc>")[0];
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private YedGjjCompanyInfoResponseBean getYedGjjAccNoInfoResponseBean(String certType, String certCode, String name, String globalSrlNo) throws Exception {
        YedGjjCompnayInfoRequestBean gjjRequestBean = new YedGjjCompnayInfoRequestBean();
        gjjRequestBean.setGlobalSerno(globalSrlNo);
        gjjRequestBean.setIdentNo(certCode);
        if ("10100".equalsIgnoreCase(certType)) {
            gjjRequestBean.setIdentTp("01");
        }
        gjjRequestBean.setBeQryPrsnNm(name);
        YedGjjCompanyInfoResponseBean responseBean = null;
        try {
            responseBean = this.yedCompanyInfoService.queryGJJCompanyInfoForEDS(gjjRequestBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseBean;
    }

    public void sendGjj(String reqStr1, String applySeq) throws Exception {
        try {
            String stdrescode;
            byte[] backinfo = new SocketClientUtil().sendMessageGjj(reqStr1, this.ip, this.port);
            String requestString = new String(backinfo, "GBK");
            this.logger.info("=========>\u89e3\u5bc6\u8fd4\u56de\u62a5\u6587\uff1a" + requestString);
            if (requestString.contains("stdrescode") && ("03".equals(stdrescode = requestString.split("<stdrescode>")[1].split("</stdrescode>")[0]) || "04".equals(stdrescode))) {
                throw new Exception("\u3010\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u3011\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u8fde\u63a5\u8d85\u65f6\u4e86\uff0c\u8fdb\u5165\u91cd\u8bd5\u65b9\u6cd5");
            }
            this.updateYedGjjInvote(requestString);
        }
        catch (Exception e) {
            this.logger.error("\u6388\u4fe1\u9636\u6bb5-\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq);
            if (msgCount.intValue() > 3) {
                this.logger.info("\u91cd\u8bd53\u6b21\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u4ecd\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5916\u6570\u7cfb\u7edf\uff01\uff01\uff01");
                msgCount.set(1);
                ReqAlarmJudgementBean reqAlarmJudgementBean = new ReqAlarmJudgementBean();
                reqAlarmJudgementBean.setAlrmInf("\u91cd\u8bd53\u6b21\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u4ecd\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5916\u6570\u7cfb\u7edf\uff01\uff01\uff01");
                throw new Exception("\u3010\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u3011\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            }
            while (msgCount.intValue() <= 3) {
                Thread.sleep(30000L);
                this.logger.error("\u6267\u884c\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                this.logger.info("\u5f00\u59cb\u91cd\u8bd5\u7b2c" + msgCount.intValue() + "\u6b21\u8c03\u7528\u516c\u79ef\u91d1\u56de\u5199\u63a5\u53e3\uff01\uff01\uff01");
                msgCount.incrementAndGet();
                this.sendGjj(reqStr1, applySeq);
            }
        }
    }

    public RespAlarmJudgementBean getrespAlarmJudgementBean(ReqAlarmJudgementBean reqAlarmJudgementBean) throws Exception {
        RespAlarmJudgementBean respAlarmJudgementBean = null;
        try {
            reqAlarmJudgementBean.setMonObjNm("\u4f18e\u8d37");
            reqAlarmJudgementBean.setMonObjSpfTpVal("\u5916\u90e8\u63a5\u53e3");
            reqAlarmJudgementBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmTmstmp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            reqAlarmJudgementBean.setMonAlrmLvl("3");
            respAlarmJudgementBean = this.alarmJudgementService.alarmJudgement(reqAlarmJudgementBean);
            this.logger.debug("\u8c03\u7528\u544a\u8b66\u5224\u65ad\u8fd4\u56de\u7801\uff1a\u3010" + respAlarmJudgementBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + respAlarmJudgementBean.getRetMsg() + "\u3011");
        }
        catch (Exception e) {
            this.logger.info("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
        return respAlarmJudgementBean;
    }
}

