/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.apply;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.console.service.facade.ActivityAndCouponRecordService;
import com.irdstudio.efp.cus.service.facade.CusIndivRelService;
import com.irdstudio.efp.cus.service.vo.CusIndivRelVO;
import com.irdstudio.efp.esb.common.constant.InstitutionEnums;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.yx.ApplyRiskInfArryBean;
import com.irdstudio.efp.esb.service.bo.req.yx.YedApplyRiskApproveReq;
import com.irdstudio.efp.esb.service.bo.resp.yx.YedApplyRiskApproveResp;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoExdService;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.ed.LimitControlsService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoExdVO;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedApplyRiskApproveSoltService")
public class YedApplyRiskApproveSoltServiceImpl
extends SoltServiceImpl {
    private static Logger log = LoggerFactory.getLogger(YedApplyRiskApproveSoltServiceImpl.class);
    @Autowired
    @Qualifier(value="limitControlsService")
    private LimitControlsService limitControlsService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="yedApplyRiskApproveService")
    private EsbService<YedApplyRiskApproveReq, YedApplyRiskApproveResp> yedapplyRiskApproveService;
    @Autowired
    @Qualifier(value="cusIndivRelService")
    private CusIndivRelService cusIndivRelService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="nlsApplyInfoExdService")
    private NlsApplyInfoExdService nlsApplyInfoExdService;
    @Autowired
    @Qualifier(value="activityAndCouponRecordService")
    private ActivityAndCouponRecordService activityAndCouponRecordService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        log.info("\u4f18e\u8d37\u7528\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u63a5\u53e3\u8c03\u7528\u63d2\u69fd\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq());
        try {
            String certType = nlsApplyInfoVO.getCertType();
            String certCode = nlsApplyInfoVO.getCertCode();
            YedApplyRiskApproveReq applyRiskReq = YedApplyRiskApproveReq.builder().build();
            AccLoanVO accLoanVO = this.accLoanService.queryOverdue(certType, certCode);
            BigDecimal preOccAmt = this.limitControlsService.getPreOccAmt2(certCode, certType, nlsApplyInfoVO.getApplyAmt());
            CusIndivRelVO cusIndivRelVO = new CusIndivRelVO();
            cusIndivRelVO.setCusId(nlsApplyInfoVO.getCusId());
            List cusIndivRelVOs = Optional.ofNullable(this.cusIndivRelService.queryByPkCusId(cusIndivRelVO)).orElseGet(ArrayList::new);
            if (cusIndivRelVOs == null || cusIndivRelVOs.isEmpty()) {
                throw new BizException("\u8054\u7cfb\u4eba\u4fe1\u606f\u4e3a\u7a7a");
            }
            CusIndivRelVO qryCusIndivRelVO = (CusIndivRelVO)cusIndivRelVOs.get(0);
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setLmtApplySeq(Objects.requireNonNull(nlsApplyInfoVO.getLmtApplySeq()));
            lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
            this.validateParam(nlsApplyInfoVO, lmtPrdContVO, qryCusIndivRelVO, preOccAmt);
            NlsApplyInfoExdVO nlsApplyInfoExdVO = new NlsApplyInfoExdVO();
            nlsApplyInfoExdVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
            NlsApplyInfoExdVO nlsApplyInfoExdVO1 = new NlsApplyInfoExdVO();
            nlsApplyInfoExdVO1 = Optional.ofNullable(this.nlsApplyInfoExdService.queryByPk(nlsApplyInfoExdVO)).orElseGet(NlsApplyInfoExdVO::new);
            String relation = "";
            try {
                relation = SDicToExternal.getExternalSysDicVal((String)"RDP", (String)"ConstactsRelation", (String)qryCusIndivRelVO.getRelation());
            }
            catch (Exception e) {
                relation = "00000";
            }
            ApplyRiskInfArryBean applyRiskInfArryBean = ApplyRiskInfArryBean.builder().DeptNo(InstitutionEnums.InstitutionEnum.GZYHZHYHZX.getCode()).CustNo(nlsApplyInfoVO.getCusId()).AppNo(nlsApplyInfoVO.getApplySeq()).MainCardAplcNm(nlsApplyInfoVO.getCusName()).Age(String.valueOf(ValidationUtils.getAgeFromIdNumber((String)nlsApplyInfoVO.getCertCode()))).AplcIdentNo(certCode).AplcIdentTp(certType).IdentVldty(nlsApplyInfoVO.getIndivIdExpDt()).CtcTel(nlsApplyInfoVO.getMobile()).CanLoanLmt(String.valueOf(lmtPrdContVO.getAvailAmt())).LmtVldty(Objects.isNull(lmtPrdContVO) ? "" : lmtPrdContVO.getExpireDate()).AppAmt(String.valueOf(nlsApplyInfoVO.getApplyAmt())).AppLoanTrm(nlsApplyInfoVO.getLoanTerm()).CrspTel(qryCusIndivRelVO.getMobile()).CrspNm(qryCusIndivRelVO.getRelName()).WthCrspRelaTp(relation).CrnLoanSt(Objects.isNull(accLoanVO) ? "0" : "1").NetwrkLoanOcptnLmt(String.valueOf(preOccAmt)).TxnChanNo(nlsApplyInfoVO.getChannelNo()).GlblSrlNo(nlsApplyInfoVO.getGlobalSerno()).WorkSt(nlsApplyInfoExdVO1.getIndivOccStatus()).build();
            applyRiskReq.setApplyInfArry(Collections.singletonList(applyRiskInfArryBean));
            YedApplyRiskApproveResp service = (YedApplyRiskApproveResp)this.yedapplyRiskApproveService.service((Object)applyRiskReq);
            if (!MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(((YedApplyRiskApproveResp.ApplyRiskInfArry)service.getApplyRiskInfArry().get(0)).getRcvSt())) {
                throw new BizException("\u7528\u4fe1\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + ((YedApplyRiskApproveResp.ApplyRiskInfArry)service.getApplyRiskInfArry().get(0)).getRcvRsltInf());
            }
        }
        catch (BizException ne) {
            log.error("\u4f18e\u8d37\u7528\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u5fc5\u586b\u9879\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38", (Throwable)ne);
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg((Exception)((Object)ne));
            this.activityAndCouponRecordService.deleteCouponRecord(nlsApplyInfoVO.getApplySeq());
        }
        catch (Exception e) {
            log.error("\u4f18e\u8d37\u7528\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8c03\u7528\u63d2\u69fd\u6267\u884c\u5f02\u5e38", (Throwable)e);
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
            this.activityAndCouponRecordService.deleteCouponRecord(nlsApplyInfoVO.getApplySeq());
        }
        finally {
            log.info("\u4f18e\u8d37\u7528\u4fe1\u98ce\u63a7\u5ba1\u6279\u63d2\u69fd\u7ed3\u675f,\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq());
        }
    }

    private boolean validateParam(NlsApplyInfoVO nlsApplyInfoVO, LmtPrdContVO lmtPrdContVO, CusIndivRelVO cusIndivRelVO, BigDecimal preOccAmt) throws BizException {
        if (Objects.isNull(cusIndivRelVO)) {
            throw new BizException("\u8054\u7cfb\u4eba\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getApplySeq())) {
            throw new BizException("\u7533\u8bf7\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getCusName())) {
            throw new BizException("\u4e3b\u5361\u7533\u8bf7\u4eba\u59d3\u540d\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getCertCode())) {
            throw new BizException("\u7533\u8bf7\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getCertType())) {
            throw new BizException("\u7533\u8bf7\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getIndivIdExpDt())) {
            throw new BizException("\u8bc1\u4ef6\u6709\u6548\u671f\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)lmtPrdContVO.getExpireDate())) {
            throw new BizException("\u989d\u5ea6\u6709\u6548\u671f\u4e3a\u7a7a");
        }
        if (Objects.isNull(lmtPrdContVO.getAvailAmt())) {
            throw new BizException("\u53ef\u7528\u989d\u5ea6\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getMobile())) {
            throw new BizException("\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (Objects.isNull(nlsApplyInfoVO.getApplyAmt())) {
            throw new BizException("\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getLoanTerm())) {
            throw new BizException("\u7533\u8bf7\u8d37\u6b3e\u671f\u9650\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)cusIndivRelVO.getMobile())) {
            throw new BizException("\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)cusIndivRelVO.getRelName())) {
            throw new BizException("\u8054\u7cfb\u4eba\u59d3\u540d\u4e3a\u7a7a");
        }
        if (StringUtil.isNullorBank((String)cusIndivRelVO.getRelation())) {
            throw new BizException("\u4e0e\u8054\u7cfb\u4eba\u7684\u5173\u7cfb\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (Objects.isNull(preOccAmt)) {
            throw new BizException("\u7f51\u7edc\u8d37\u6b3e\u5360\u7528\u989d\u5ea6\u4e3a\u7a7a");
        }
        return true;
    }
}

