/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.apply;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.console.service.facade.ActivityAndCouponRecordService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusAcctInfoService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusAcctInfoVo;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedLoanReleaseReqBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedLoanReleaseRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayResultQryService;
import com.irdstudio.efp.esb.service.facade.yed.YedHjLoanReleaseService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.exception.LoanReleaseException;
import com.irdstudio.efp.nls.common.exception.LoanRepaySyncException;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.UpdateLmtPrdContService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.yed.YedGjjLoanService;
import com.irdstudio.efp.nls.service.impl.yed.YedSoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.yed.apply.YedSyncLoanInfoServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.yed.NlsApplyInfoRespVO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="yedLoanReleaseService")
@Scope(value="prototype")
public class YedLoanReleaseServiceImpl
extends YedSoltServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(YedLoanReleaseServiceImpl.class);
    private static final String ONE_YEAR = "Y1";
    private static final String NO_DATA = "0";
    private NlsApplyInfoVO nlsApplyInfoVO;
    @Autowired
    @Qualifier(value="loanRepayResultQryService")
    private LoanRepayResultQryService loanRepayResultQryService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="yedHjLoanReleaseService")
    private YedHjLoanReleaseService yedHjLoanReleaseService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="updateLmtPrdContService")
    private UpdateLmtPrdContService updateLmtPrdContService;
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    @Qualifier(value="yedSyncLoanInfoService")
    private YedSyncLoanInfoServiceImpl yedSyncLoanInfoService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    private YedGjjLoanService yedGjjLoanService;
    @Autowired
    @Qualifier(value="cusAcctInfoService")
    private CusAcctInfoService cusAcctInfoService;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Autowired
    @Qualifier(value="activityAndCouponRecordService")
    private ActivityAndCouponRecordService activityAndCouponRecordService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;

    public NlsApplyInfoVO getNlsApplyInfoVO() {
        return this.nlsApplyInfoVO;
    }

    public void setNlsApplyInfoVO(NlsApplyInfoVO nlsApplyInfoVO) {
        this.nlsApplyInfoVO = nlsApplyInfoVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        block12: {
            String applySeq = nlsApplyInfoVO.getApplySeq();
            this.logger.info("======>\u3010\u4f18e\u8d37\u653e\u6b3e\u670d\u52a1\u3011\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
            boolean flag = false;
            try {
                CtrLoanContVO ctrLoanContVO = this.getCtrLoanContVO(nlsApplyInfoVO);
                Optional.ofNullable(ctrLoanContVO).orElseThrow(() -> new BizException("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u8d37\u6b3e\u5408\u540c\u4e3a\u7a7a!!!"));
                LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
                Optional.ofNullable(lmtPrdContVO).orElseThrow(() -> new BizException("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u989d\u5ea6\u4e3a\u7a7a!!!"));
                NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
                Optional.ofNullable(nlsCreditInfoVO).orElseThrow(() -> new BizException("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a!!!"));
                PrdInfoVO proInfo = this.nlsPublicService.getProInfo(nlsApplyInfoVO.getPrdId());
                Optional.ofNullable(proInfo).orElseThrow(() -> new BizException("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u4ea7\u54c1\u4e3a\u7a7a!!!"));
                CusIndivVO cusIndivVO = new CusIndivVO();
                cusIndivVO.setCusId(nlsApplyInfoVO.getCusId());
                cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
                Optional.ofNullable(cusIndivVO).orElseThrow(() -> new BizException("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a!!!"));
                YedLoanReleaseRespBean respLoanReleaseBean = null;
                RespLoanRepayResultQryBean respLoanRepayResultQryBean = this.getRespLoanRepayResultQryBean(nlsApplyInfoVO);
                String qrySt = respLoanRepayResultQryBean.getQrySt();
                if (!SedNlsEnum.QuerySts.WITHOUT.getValue().equals(qrySt)) break block12;
                respLoanReleaseBean = this.callLoanRelease(nlsApplyInfoVO, ctrLoanContVO, proInfo, lmtPrdContVO, cusIndivVO, nlsCreditInfoVO);
                this.updateLoanReleaseStatus(nlsApplyInfoVO, respLoanReleaseBean.getLoanNo(), respLoanReleaseBean.getDistrNo());
                this.updateLmtTerm(nlsApplyInfoVO);
                try {
                    this.yedSyncLoanInfoService.doExecute(nlsProcessBizVo, nlsApplyInfoVO);
                }
                catch (Exception e) {
                    this.logger.error("\u653e\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + nlsApplyInfoVO.getApplySeq() + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getGlobalSerno() + "\u3011\uff0c\u6210\u529f\u8fd8\u6b3e\u540e\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5931\u8d25\uff01");
                    throw new LoanRepaySyncException("\u653e\u6b3e\u540e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                }
                if (this.isReturnBackGjj(nlsApplyInfoVO)) {
                    this.yedGjjLoanService.callSyncGjjInvoteApply(nlsApplyInfoVO);
                    this.updateCusAcctInfo(nlsApplyInfoVO);
                }
            }
            catch (LoanReleaseException e) {
                this.logger.error(Arrays.toString(e.getStackTrace()));
                this.setException(nlsProcessBizVo, (Exception)((Object)e));
                this.logger.error("\u3010\u4f18e\u8d37\u653e\u6b3e\u6d41\u7a0b\u672a\u6267\u884c\u6210\u529f\u3011 \u8f6c\u4e3a\u66f4\u65b0\u8865\u507f\u4efb\u52a1\u5904\u7406!!!" + (Object)((Object)e));
                flag = true;
            }
            catch (LoanRepaySyncException e) {
                this.logger.error(Arrays.toString(e.getStackTrace()));
                this.setException(nlsProcessBizVo, (Exception)((Object)e));
                this.logger.error("\u3010\u4f18e\u8d37\u653e\u6b3e\u6d41\u7a0b\u672a\u6267\u884c\u6210\u529f\u3011 \u8f6c\u4e3a\u540c\u6b65\u4efb\u52a1\u5904\u7406!!!" + (Object)((Object)e));
                flag = true;
            }
            catch (Exception e) {
                this.logger.error(Arrays.toString(e.getStackTrace()));
                nlsApplyInfoVO.setDnSts(NO_DATA);
                this.setException(nlsProcessBizVo, e);
                this.logger.error("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u9047\u5230\u672a\u77e5\u5f02\u5e38!!!" + e);
                flag = true;
                this.activityAndCouponRecordService.deleteCouponRecord(nlsApplyInfoVO.getApplySeq());
            }
            finally {
                this.logger.info("======>\u3010\u4f18e\u8d37\u653e\u6b3e\u670d\u52a1\u3011\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
            }
        }
    }

    private void setException(NlsProcessBizVO nlsProcessBizVo, Exception e) {
        nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
        nlsProcessBizVo.setRefuseMsg(e.getMessage());
        nlsProcessBizVo.setExceptionMsg(e);
        this.setNlsProcessException(nlsProcessBizVo, e);
    }

    public RespLoanRepayResultQryBean getRespLoanRepayResultQryBean(NlsApplyInfoVO nlsApplyInfoVO) throws ESBException, InterruptedException {
        ReqLoanRepayResultQryBean reqLoanRepayResultQryBean = new ReqLoanRepayResultQryBean();
        reqLoanRepayResultQryBean.setTxnGlblSrlNo(nlsApplyInfoVO.getGlobalSerno());
        reqLoanRepayResultQryBean.setCnlTp(nlsApplyInfoVO.getCnlTp());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.loanRepayResultQryService, (Object)reqLoanRepayResultQryBean, this.nlsQueueSoltComnService);
        RespLoanRepayResultQryBean respLoanRepayResultQryBean = (RespLoanRepayResultQryBean)esbInvokeWrapper.invoke3Threes();
        Objects.requireNonNull(respLoanRepayResultQryBean, "\u4f18e\u8d37\u8c03\u7528\u4e92\u8054\u7f51\u91d1\u878d\u5e73\u53f0\u653e\u6b3e\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a!!!");
        return respLoanRepayResultQryBean;
    }

    private CtrLoanContVO getCtrLoanContVO(NlsApplyInfoVO nlsApplyInfoVO) {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(nlsApplyInfoVO.getApplySeq());
        ctrLoanContVO.setContType("02");
        ctrLoanContVO = this.ctrLoanContService.qryBySernoAndContTyp(ctrLoanContVO);
        return ctrLoanContVO;
    }

    private void setNlsProcessException(NlsProcessBizVO nlsProcessBizVo, Exception e) {
        nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
        nlsProcessBizVo.setRefuseMsg(e.getMessage());
    }

    public void recoverAmt(NlsApplyInfoVO nlsApplyInfoVO, LmtPrdContVO lmtPrdContVO) throws LoanReleaseException {
        this.updateLmtPrdContService.recoverLmtPro(nlsApplyInfoVO.getLmtApplySeq(), nlsApplyInfoVO.getApplySeq());
    }

    private void updateLmtAmt(NlsApplyInfoVO nlsApplyInfoVO, LmtPrdContVO lmtPrdContVO) throws OcmSystemException {
        List applySeqs = this.updateLmtPrdContService.getApplySeqList(nlsApplyInfoVO.getLmtApplySeq());
        BigDecimal occAmt = this.updateLmtPrdContService.getOccAmt(applySeqs);
        BigDecimal preOccAmt = this.updateLmtPrdContService.getPreOccAmt(nlsApplyInfoVO.getLmtApplySeq());
        lmtPrdContVO.setOccAmt(occAmt.add(preOccAmt));
        lmtPrdContVO.setPreOccAmt(BigDecimal.ZERO);
        lmtPrdContVO.setAvailAmt(lmtPrdContVO.getLmtAmt().subtract(occAmt.add(preOccAmt)));
        int result = 0;
        try {
            result = this.lmtPrdContService.updateByPk(lmtPrdContVO);
        }
        catch (Exception e) {
            throw new OcmSystemException("\u3010\u4f18e\u8d37\u3011\u653e\u6b3e\u63d2\u69fd \u989d\u5ea6\u5360\u7528\u5931\u8d25!!!");
        }
        if (result != 1) {
            throw new OcmSystemException("\u3010\u4f18e\u8d37\u3011\u653e\u6b3e\u63d2\u69fd \u989d\u5ea6\u5360\u7528\u5931\u8d25!!!");
        }
    }

    private void updateLoanReleaseStatus(NlsApplyInfoVO nlsApplyInfoVO, String loanNo, String distrNo) throws LoanReleaseException {
        String msg = "\u66f4\u65b0\u7528\u4fe1\u7533\u8bf7\u8868 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u66f4\u65b0 \u653e\u6b3e\u72b6\u6001 \u8d37\u6b3e\u53f7 \u53d1\u653e\u53f7,\u653e\u6b3e\u72b6\u6001,\u653e\u6b3e\u91d1\u989d\u5931\u8d25!!!";
        nlsApplyInfoVO.setDnSts("6");
        String amoutOfLoan = nlsApplyInfoVO.getApplyAmt().setScale(2, 4).toString();
        nlsApplyInfoVO.setAmountOfLoan(amoutOfLoan);
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u6210\u529f");
        nlsApplyInfoVO.setLoanNo(loanNo);
        nlsApplyInfoVO.setDistrNo(distrNo);
        nlsApplyInfoVO.setExecuteTime(0);
        nlsApplyInfoVO.setRefuseCause("");
        nlsApplyInfoVO.setNlsApplyState("02");
        int result = 0;
        try {
            result = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(msg);
            }
            this.logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1", (Throwable)e);
            throw new LoanReleaseException("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1");
        }
        if (result != 1) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(msg);
            }
            this.logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1");
            throw new LoanReleaseException("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1");
        }
    }

    private void updateNlsApplyInfo(NlsApplyInfoVO nlsApplyInfoVO) throws LoanReleaseException {
        nlsApplyInfoVO.setDnSts(NO_DATA);
        nlsApplyInfoVO.setNlsApplyState(NlsApplyInfoEnums.NlsApplyState.REJECT.getValue());
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u5931\u8d25");
        int result = 0;
        try {
            result = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
        }
        catch (Exception e) {
            throw new LoanReleaseException();
        }
        if (result != 1) {
            throw new LoanReleaseException();
        }
    }

    private YedLoanReleaseRespBean callLoanRelease(NlsApplyInfoVO nlsApplyInfoVO, CtrLoanContVO ctrLoanContVO, PrdInfoVO proInfo, LmtPrdContVO lmtPrdContVO, CusIndivVO cusIndivVO, NlsCreditInfoVO nlsCreditInfoVO) throws OcmSystemException, LoanReleaseException {
        YedLoanReleaseReqBean reqLoanReleaseBean = new YedLoanReleaseReqBean();
        try {
            String cusId = cusIndivVO.getSelfCusId();
            String loanCcy = SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"CurType", (String)nlsApplyInfoVO.getLoanCcy());
            String repayMethod = SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"RepayMode", (String)nlsApplyInfoVO.getRepayMethod());
            BigDecimal rateY = nlsApplyInfoVO.getLoanRate().setScale(4, 4);
            BigDecimal applyAmt = nlsApplyInfoVO.getApplyAmt().setScale(2, 4);
            String loanTerm = nlsApplyInfoVO.getLoanTerm();
            Objects.requireNonNull(loanTerm, "\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u8868 \u671f\u9650 \u4e3a\u7a7a!!!");
            String loanTermType = nlsApplyInfoVO.getLoanTermType();
            Objects.requireNonNull(loanTermType, "\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u8868 \u671f\u9650\u7c7b\u578b \u4e3a\u7a7a!!!");
            String contNo = ctrLoanContVO.getContNo();
            Objects.requireNonNull(contNo, "\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u8d37\u6b3e\u5408\u540c\u8868 \u53d6\u6388\u4fe1\u5408\u540c \u4e3a\u7a7a!!!");
            String repaymentPeriod = nlsApplyInfoVO.getRepaymentPeriod();
            Objects.requireNonNull(repaymentPeriod, "\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u989d\u5ea6\u4fe1\u606f\u8868 \u8fd8\u6b3e\u5468\u671f \u4e3a\u7a7a!!!");
            String repaymentDayType = nlsApplyInfoVO.getRepaymentPeriodType();
            Objects.requireNonNull(repaymentDayType, "\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u989d\u5ea6\u4fe1\u606f\u8868 \u8fd8\u6b3e\u5468\u671f\u5355\u4f4d\u7c7b\u578b \u4e3a\u7a7a!!!");
            BigDecimal rateRadio = BigDecimal.ZERO;
            reqLoanReleaseBean.setClntNo(cusId);
            String ifpProduct = "XD050300703";
            reqLoanReleaseBean.setProdType(ifpProduct);
            reqLoanReleaseBean.setPrjNo(lmtPrdContVO.getLmtApplySeq());
            reqLoanReleaseBean.setCurrCd(loanCcy);
            reqLoanReleaseBean.setContrAmt(Double.valueOf(applyAmt.doubleValue()));
            reqLoanReleaseBean.setRpyMd(repayMethod);
            reqLoanReleaseBean.setIntSetlFrqcy(repaymentDayType.concat(repaymentPeriod));
            reqLoanReleaseBean.setLoanTrm(loanTerm);
            reqLoanReleaseBean.setTrmType(loanTermType);
            reqLoanReleaseBean.setIntSetlDt(Objects.isNull(proInfo.getInteDay()) ? "21" : proInfo.getInteDay());
            reqLoanReleaseBean.setComIntRate(Double.valueOf(Optional.ofNullable(rateY).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).doubleValue()));
            reqLoanReleaseBean.setComIntRateFltIntPrt(Double.valueOf(Optional.ofNullable(rateRadio).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100").setScale(2, 4)).doubleValue()));
            reqLoanReleaseBean.setCrdtContrNo(contNo);
            reqLoanReleaseBean.setMblNo(nlsApplyInfoVO.getMobile());
            reqLoanReleaseBean.setNxtIntSetlDt("");
            reqLoanReleaseBean.setTxnBrId(this.getRefferOrgId(nlsCreditInfoVO));
            YedLoanReleaseReqBean.IntSetInfArry intSetInf1 = new YedLoanReleaseReqBean.IntSetInfArry();
            intSetInf1.setAcctCtgry("01");
            intSetInf1.setAmtType("PF");
            intSetInf1.setBlgAcctCl("PAY");
            intSetInf1.setBlgAcctCurrCd(loanCcy);
            intSetInf1.setBlgAcctNo(nlsApplyInfoVO.getDnAccount());
            intSetInf1.setBlgAcctProdType(ifpProduct);
            intSetInf1.setBlgMth("R");
            intSetInf1.setBlgAcctBnkNo(nlsApplyInfoVO.getBankId());
            intSetInf1.setOwnOthrBankflg(Optional.ofNullable(nlsApplyInfoVO.getBankName()).orElse("").contains("\u5e7f\u5dde\u94f6\u884c") ? "1" : "2");
            YedLoanReleaseReqBean.IntSetInfArry intSetInf2 = new YedLoanReleaseReqBean.IntSetInfArry();
            intSetInf2.setAcctCtgry("01");
            intSetInf2.setAmtType("PF");
            intSetInf2.setBlgAcctCl("AUT");
            intSetInf2.setBlgAcctCurrCd(loanCcy);
            intSetInf2.setBlgAcctNo(nlsApplyInfoVO.getRecvAcctNo());
            intSetInf2.setBlgAcctProdType(ifpProduct);
            intSetInf2.setBlgMth("R");
            reqLoanReleaseBean.getIntSetInfArry().add(intSetInf1);
            reqLoanReleaseBean.getIntSetInfArry().add(intSetInf2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OcmSystemException("\u3010\u4f18e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011\u8c03\u7528\u5f00\u7acb\u53d1\u653e\u7cfb\u7edf\u8f6c\u5316\u503c\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        NlsApplyInfoVO nlsApplyInfoVOHj = new NlsApplyInfoVO();
        nlsApplyInfoVOHj.setApplySeq(nlsApplyInfoVO.getApplySeq());
        nlsApplyInfoVOHj = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
        nlsApplyInfoVOHj.setCnlTp(nlsApplyInfoVO.getCnlTp());
        return this.yedHjLoanReleaseService.applyPsdLoanRelease(reqLoanReleaseBean, nlsApplyInfoVOHj);
    }

    @Deprecated
    private void insertOrUpdateAccLoan(NlsApplyInfoVO nlsApplyInfoVO, String distrNo, String loanNo) throws OcmSystemException {
        int result = 0;
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setBillNo(nlsApplyInfoVO.getApplySeq());
        accLoanVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
        accLoanVO.setDistrNo(distrNo);
        accLoanVO.setLoanSeq(loanNo);
        try {
            result = this.accLoanService.insertOrUpdateByPk(accLoanVO);
            if (result != 1) {
                throw new OcmSystemException("\u3010\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u751f\u6210\u501f\u636e\u5931\u8d25!!!");
            }
        }
        catch (Exception e) {
            throw new OcmSystemException("\u3010\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u751f\u6210\u501f\u636e\u5931\u8d25!!!");
        }
    }

    public void updateLmtTerm(NlsApplyInfoVO nlsApplyInfoVO) {
    }

    public String getRefferOrgId(NlsCreditInfoVO nlsCreditInfoVO) throws OcmSystemException {
        CusReferrerInfoVO cusReferrerInfoVO = new CusReferrerInfoVO();
        cusReferrerInfoVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusReferrerInfoVO);
        if (Objects.isNull(cusReferrerInfoVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\uff0c\u83b7\u53d6\u5230\u63a8\u8350\u4eba\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return cusReferrerInfoVO.getChargeOffBrId();
    }

    private void updateCusAcctInfo(NlsApplyInfoVO nlsApplyInfoVO) {
        CusAcctInfoVo acctInfoVo = new CusAcctInfoVo();
        try {
            acctInfoVo.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            List cusAcctInfoVos = this.cusAcctInfoService.queryByLmtApplySeq(acctInfoVo);
            if (null != cusAcctInfoVos && !cusAcctInfoVos.isEmpty()) {
                acctInfoVo.setApplySeq(nlsApplyInfoVO.getApplySeq());
                acctInfoVo.setApplyTime(DateUtility.getCurrDateTime());
                acctInfoVo.setApproveStatus(nlsApplyInfoVO.getApproveStatus() == null ? "02" : nlsApplyInfoVO.getApproveStatus());
                acctInfoVo.setReturnBack("Y");
                this.cusAcctInfoService.update(acctInfoVo);
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5ba2\u6237\u516c\u79ef\u91d1\u4fe1\u606f\u8868\u9519\u8bef\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + nlsApplyInfoVO.getLmtApplySeq() + "\u9519\u8bef\u4fe1\u606f\u4e3a" + e.getMessage());
        }
    }

    private boolean isReturnBackGjj(NlsApplyInfoVO nlsApplyInfoVO) {
        CusAcctInfoVo acctInfoVo = new CusAcctInfoVo();
        try {
            acctInfoVo.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            List cusAcctInfoVos = this.cusAcctInfoService.queryByLmtApplySeq(acctInfoVo);
            return null != cusAcctInfoVos && !cusAcctInfoVos.isEmpty();
        }
        catch (Exception e) {
            this.logger.error("\u5224\u65ad\u662f\u5426\u9700\u8981\u56de\u5199\u516c\u79ef\u91d1\u62a5\u9519\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + nlsApplyInfoVO.getLmtApplySeq() + "\u9519\u8bef\u4fe1\u606f\u4e3a" + e.getMessage());
            return false;
        }
    }

    private void setNlsApplyInfoToRisk(NlsApplyInfoVO info) {
        NlsApplyInfoRespVO respVO = new NlsApplyInfoRespVO();
        NlsApplyInfoVO nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(info);
        respVO.setAmountOfLoan(StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getAmountOfLoan()) ? "" : nlsApplyInfoVO.getAmountOfLoan());
        respVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
        respVO.setCreateTime(nlsApplyInfoVO.getCreateTime());
        respVO.setDnSts(StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getDnSts()) ? "" : nlsApplyInfoVO.getDnSts());
        respVO.setLastModifyTime(nlsApplyInfoVO.getLastModifyTime());
        respVO.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
        respVO.setLoanPurpose(nlsApplyInfoVO.getLoanPurpose());
        respVO.setLoanRate(nlsApplyInfoVO.getLoanRate().toString());
        respVO.setLoanTerm(nlsApplyInfoVO.getLoanTerm());
        respVO.setNlsApplyState(nlsApplyInfoVO.getNlsApplyState());
        respVO.setRefuseCause("\u7528\u4fe1\u5931\u8d25");
        respVO.setTableName("NLS_APPLY_INFO");
        respVO.setChannelNo(nlsApplyInfoVO.getChannelNo());
        respVO.setDeliverTime(TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss"));
        this.sendToRisk(respVO, nlsApplyInfoVO.getApplySeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(Object obj, String applySeq) {
        this.logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("apply")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedLoanReleaseServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", obj);
            this.logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7: " + applySeq + " \u53d1\u9001\u4fe1\u606f\u4e3a\uff1a" + JSONObject.toJSONString((Object)obj));
            if (flag) {
                this.threadPool.add(() -> {
                    KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                    try {
                        kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.error("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            this.logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }
}

