/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.apply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.constant.TimeType;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.MessageRuleCheckUtil;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.console.common.YedConstantSet;
import com.irdstudio.efp.console.service.facade.ActivityAndCouponRecordService;
import com.irdstudio.efp.console.service.facade.SOrgService;
import com.irdstudio.efp.console.service.vo.SOrgVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizDetailVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.ImageBizDetailService;
import com.irdstudio.efp.edoc.service.facade.signature.YedContResult;
import com.irdstudio.efp.edoc.service.facade.signature.YedContService;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.impl.yed.apply.bean.SignContractBean;
import com.irdstudio.efp.nls.service.impl.yed.apply.ctrcont.YedApplyCtrLoanCtr;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.yed.NlsApplyInfoRespVO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="yedSignContractService")
@Scope(value="prototype")
public class YedSignContractServiceImpl
extends SoltServiceImpl
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(YedSignContractServiceImpl.class);
    private boolean Flag = false;
    private NlsApplyInfoVO nlsApplyInfoVO;
    @Autowired
    @Qualifier(value="activityAndCouponRecordService")
    private ActivityAndCouponRecordService activityAndCouponRecordService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="yedUploadService")
    private YedUploadService yedUploadService;
    @Autowired
    @Qualifier(value="sOrgService")
    private SOrgService sOrgService;
    @Autowired
    private YedApplyCtrLoanCtr yedApplyCtrLoanCtr;
    @Autowired
    private YedContService yedContService;
    @Autowired
    private ImageBizDetailService imageBizDetailService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;
    @Autowired
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;

    public NlsApplyInfoVO getNlsApplyInfoVO() {
        return this.nlsApplyInfoVO;
    }

    public void setNlsApplyInfoVO(NlsApplyInfoVO nlsApplyInfoVO) {
        this.nlsApplyInfoVO = nlsApplyInfoVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsApplyInfoVO.getApplySeq();
        boolean flag = false;
        String msg = "";
        try {
            logger.info("======>\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
            NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
            nlsCreditInfoVO.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            nlsCreditInfoVO = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
            if (nlsCreditInfoVO == null && logger.isErrorEnabled()) {
                logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + applySeq + "\u4e0d\u5b58\u5728\u6388\u4fe1");
                flag = true;
                msg = "\u4e0d\u5b58\u5728\u6388\u4fe1";
                throw new OcmSystemException("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + applySeq + "\u4e0d\u5b58\u5728\u6388\u4fe1");
            }
            JSONObject signContractJson = (JSONObject)nlsApplyInfoVO.getSignContractBean();
            SignContractBean signContractBean = new SignContractBean();
            CusIndivVO cusIndivVO = null;
            CfcaSignInfoVO cfcaSignInfoVO = null;
            if (Objects.isNull(signContractJson)) {
                CusIndivVO cusIndivVO1 = new CusIndivVO();
                cusIndivVO1.setCusId(nlsCreditInfoVO.getCusId());
                cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO1);
                CfcaSignInfoVO cfcaSignInfoVO1 = new CfcaSignInfoVO();
                cfcaSignInfoVO1.setApplySeq(applySeq);
                cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(cfcaSignInfoVO1);
            } else {
                cusIndivVO = (CusIndivVO)signContractJson.getObject("cusIndivVO", CusIndivVO.class);
                cfcaSignInfoVO = (CfcaSignInfoVO)signContractJson.getObject("cfcaSignInfoVO", CfcaSignInfoVO.class);
                signContractBean.setCusIndivVO(cusIndivVO);
                signContractBean.setCfcaSignInfoVO(cfcaSignInfoVO);
                nlsApplyInfoVO.setSignContractBean((Object)signContractBean);
            }
            if (cusIndivVO == null && logger.isErrorEnabled()) {
                logger.error("\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u901a\u8fc7\u3010" + nlsApplyInfoVO.getCusId() + "\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a \u6216 \u5b89\u5fc3\u7b7e\u7528\u6237\u53f7\u4e3a\u7a7a \u8bf7\u6838\u67e5!!!");
                flag = true;
                msg = "\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a \u6216 \u5b89\u5fc3\u7b7e\u7528\u6237\u53f7\u4e3a\u7a7a!";
                throw new OcmSystemException("\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u901a\u8fc7\u3010" + nlsApplyInfoVO.getCusId() + "\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a \u6216 \u5b89\u5fc3\u7b7e\u7528\u6237\u53f7\u4e3a\u7a7a  \u8bf7\u6838\u67e5!!!");
            }
            String axquserid = cusIndivVO.getAxqUsrId();
            YedContResult yedContResult1 = null;
            if (StringUtils.isEmpty((CharSequence)axquserid)) {
                try {
                    yedContResult1 = this.yedContService.openAccount(cusIndivVO.getCusName(), cusIndivVO.getCertType(), cusIndivVO.getCertCode(), cusIndivVO.getEmail(), cusIndivVO.getPhone(), cusIndivVO.getIndivRsdAddr(), nlsApplyInfoVO.getLmtApplySeq());
                    axquserid = Objects.requireNonNull(yedContResult1).getAxqUserId();
                }
                catch (Exception e) {
                    logger.error("\u5b89\u5fc3\u7b7e\u5f00\u6237\u5f02\u5e38\uff0c\u7528\u4fe1\u6d41\u6c34\u53f7" + nlsApplyInfoVO.getApplySeq() + "-\u9519\u8bef\u4fe1\u606f\u4e3a" + yedContResult1.getMsg());
                    flag = true;
                    msg = "\u5b89\u5fc3\u7b7e\u5f00\u6237\u5f02\u5e38";
                    throw new OcmSystemException(yedContResult1.getMsg());
                }
                if (!yedContResult1.isRetFlag()) {
                    if (logger.isErrorEnabled()) {
                        logger.error("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u5b89\u5fc3\u7b7e\u5f00\u6237\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + yedContResult1.getMsg());
                        flag = true;
                        msg = "\u5b89\u5fc3\u7b7e\u5f00\u6237\u51fa\u73b0\u5f02\u5e38";
                    }
                    throw new OcmSystemException(yedContResult1.getMsg());
                }
            }
            if (Objects.isNull(cfcaSignInfoVO)) {
                SOrgVO sOrgVO = null;
                try {
                    sOrgVO = this.getSOrg(nlsCreditInfoVO.getNlsOperOrgid());
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01\u7528\u4fe1\u6d41\u6c34\u53f7\u4e3a" + nlsApplyInfoVO.getApplySeq());
                    flag = true;
                    msg = "\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a";
                    throw new OcmSystemException("\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                Map<Object, Object> ctrLoanContMetaData = new HashMap();
                try {
                    ctrLoanContMetaData = this.yedApplyCtrLoanCtr.getCtrLoanContMetaData(nlsCreditInfoVO, sOrgVO, nlsApplyInfoVO);
                }
                catch (Exception e) {
                    logger.error("Map\u7528\u4fe1\u6d41\u6c34\u53f7\u4e3a" + nlsApplyInfoVO.getApplySeq());
                    flag = true;
                    msg = "\u83b7\u53d6\u5230\u5206\u652f\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a";
                    throw new OcmSystemException("\u83b7\u53d6\u5230\u5206\u652f\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                YedContResult yedContResult = null;
                try {
                    yedContResult = this.yedContService.signature(nlsApplyInfoVO.getGlobalSerno(), nlsApplyInfoVO.getApplySeq(), axquserid, "yed_dkcont.pdf", "\u4e2a\u4eba\u501f\u6b3e\u5408\u540c", ctrLoanContMetaData);
                }
                catch (Exception e) {
                    logger.error("\u5408\u540c\u7b7e\u8ba2\u5f02\u5e38\uff0c\u7528\u4fe1\u6d41\u6c34\u53f7" + nlsApplyInfoVO.getApplySeq() + "-\u9519\u8bef\u4fe1\u606f\u4e3a" + e.getMessage(), (Throwable)e);
                    flag = true;
                    msg = "\u5408\u540c\u7b7e\u8ba2\u5f02\u5e38";
                    if (null != yedContResult) {
                        logger.error("\u5408\u540c\u7b7e\u8ba2\u5f02\u5e38\uff0c\u7528\u4fe1\u6d41\u6c34\u53f7" + nlsApplyInfoVO.getApplySeq() + "-\u9519\u8bef\u4fe1\u606f\u4e3a" + yedContResult.getMsg());
                        throw new OcmSystemException(yedContResult.getMsg());
                    }
                    throw new OcmSystemException(e.getMessage());
                }
                if (!yedContResult.isRetFlag()) {
                    if (logger.isErrorEnabled()) {
                        logger.error("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u5408\u540c\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + yedContResult.getMsg());
                        flag = true;
                        msg = "\u5408\u540c\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38";
                    }
                    throw new OcmSystemException(yedContResult.getMsg());
                }
                this.insertCfcaSignInfo(nlsCreditInfoVO, yedContResult, "02", applySeq, cfcaSignInfoVO, signContractBean, nlsApplyInfoVO);
                this.updateCtrContInfo(applySeq, "02", nlsApplyInfoVO.getLmtApplySeq());
            } else {
                int result;
                CfcaSignInfoVO selectCfcaSignInfo = this.cfcaSignInfoService.queryByPk(cfcaSignInfoVO);
                if (selectCfcaSignInfo == null && (result = this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO)) < 0) {
                    if (logger.isErrorEnabled()) {
                        logger.error("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165CFCA\u4fe1\u606f\u8868\u51fa\u9519\uff01 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + nlsApplyInfoVO.getApplySeq());
                        flag = true;
                        msg = "\u63d2\u5165CFCA\u4fe1\u606f\u8868\u51fa\u9519";
                    }
                    throw new OcmSystemException("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165CFCA\u4fe1\u606f\u8868\u51fa\u9519\uff01");
                }
            }
            cfcaSignInfoVO = signContractBean.getCfcaSignInfoVO();
            if (StringUtil.isEmpty((String)signContractBean.getFilePath()) && StringUtils.isNotEmpty((CharSequence)cfcaSignInfoVO.getCfcaContNo()) && ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname().equals(cfcaSignInfoVO.getCfcaSignState())) {
                YedContResult yedContResult = null;
                try {
                    yedContResult = this.yedContService.downSignFile2(nlsApplyInfoVO.getGlobalSerno(), nlsApplyInfoVO.getApplySeq(), cfcaSignInfoVO.getCfcaContNo(), nlsApplyInfoVO.getApplySeq() + "_yed_dkcont.pdf");
                }
                catch (Exception e) {
                    logger.error("\u5408\u540c\u4e0b\u8f7d\u5931\u8d25" + applySeq + "-\u5f02\u5e38\u4fe1\u606f\u4e3a" + e.getMessage(), (Throwable)e);
                    flag = true;
                    msg = "\u5408\u540c\u4e0b\u8f7d\u5931\u8d25";
                    if (null != yedContResult) {
                        logger.error("\u5408\u540c\u4e0b\u8f7d\u5931\u8d25" + applySeq + "-\u5f02\u5e38\u4fe1\u606f\u4e3a" + yedContResult.getMsg());
                        throw new OcmSystemException(yedContResult.getMsg());
                    }
                    throw new OcmSystemException(e.getMessage());
                }
                if (!yedContResult.isRetFlag() && logger.isErrorEnabled()) {
                    logger.error("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + yedContResult.getMsg());
                    flag = true;
                    msg = "\u5408\u540c\u4e0b\u8f7d\u5f02\u5e38";
                    throw new OcmSystemException("\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + yedContResult.getMsg());
                }
                signContractBean.setFilePath(yedContResult.getFileFullPath());
                this.insertCert(nlsApplyInfoVO, signContractBean);
                this.insertImageBizDetail(nlsApplyInfoVO, YedConstantSet.YED_YX_CONT_TYPE, FilenameUtils.getBaseName((String)yedContResult.getFileFullPath()), yedContResult.getFileFullPath());
            } else if (StringUtils.isNotEmpty((CharSequence)signContractBean.getFilePath())) {
                this.insertCert(nlsApplyInfoVO, signContractBean);
            }
            nlsApplyInfoVO.setFlowStatus("\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u524d");
            nlsApplyInfoVO.setSoltStage(PrdAdaptedSoltEnums.PsdSoltStageEnum.REPAY.getVALUE());
            NlsProcessBizVO nlsProcessBizVO = new NlsProcessBizVO();
            nlsProcessBizVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
            NlsProcessBizVO nlsProcessBizVO1 = this.nlsProcessBizService.queryByPk(nlsProcessBizVO);
            nlsProcessBizVO1.setSoltName2(nlsApplyInfoVO.getSoltName());
            nlsProcessBizVO1.setSoltState2(PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
            nlsProcessBizVO1.setSoltTime2(DateUtility.getCurrAppDateTimeString());
            this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
            this.nlsProcessBizService.updateByPk(nlsProcessBizVO1);
            String messageKey = TopicEnums.YEDLOANRELEASE_QUEUE_TASK_TOPIC.getTopicId() + "_" + TagEnums.YEDLOANRELEASE_QUEUE_TASK.getTagId() + "_" + nlsApplyInfoVO.getApplySeq();
            this.producerService.sendMsg(new Message(TopicEnums.YEDLOANRELEASE_QUEUE_TASK_TOPIC.getTopicId(), TagEnums.YEDLOANRELEASE_QUEUE_TASK.getTagId(), nlsApplyInfoVO.getApplySeq(), JSON.toJSONString((Object)nlsApplyInfoVO).getBytes("UTF-8")), messageKey);
        }
        catch (Exception e) {
            logger.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg((Exception)new OcmSystemException((Throwable)e));
            this.activityAndCouponRecordService.deleteCouponRecord(nlsApplyInfoVO.getApplySeq());
        }
        finally {
            if (flag) {
                logger.info("\u7528\u4fe1\u6d41\u6c34\u53f7\u4e3a" + applySeq + "\u5408\u540c\u6821\u9a8c\u5fc5\u8981\u53c2\u6570\u5931\u8d25\uff0c\u6216\u8005\u7b7e\u8ba23\u6b21\u5931\u8d25\u6216\u8005\u4e0b\u8f7d3\u6b21\u5931\u8d25");
                nlsApplyInfoVO.setNlsApplyState("03");
                nlsApplyInfoVO.setRefuseCause(msg);
                this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
                NlsProcessBizVO nlsProcessBizVO = new NlsProcessBizVO();
                nlsProcessBizVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
                NlsProcessBizVO nlsProcessBizVO1 = this.nlsProcessBizService.queryByPk(nlsProcessBizVO);
                nlsProcessBizVO1.setSoltName2(nlsApplyInfoVO.getSoltName());
                nlsProcessBizVO1.setSoltState2(PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                nlsProcessBizVO1.setSoltTime2(DateUtility.getCurrAppDateTimeString());
                this.nlsProcessBizService.updateByPk(nlsProcessBizVO1);
                this.setNlsApplyInfoVO(nlsApplyInfoVO, msg);
            }
            logger.info("======>\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
        }
    }

    private void insertCert(NlsApplyInfoVO nlsApplyInfoVO, SignContractBean signContractBean) throws OcmSystemException {
        int result = this.insertUploadRecord(nlsApplyInfoVO, signContractBean.getFilePath());
        if (result != 1) {
            if (logger.isErrorEnabled()) {
                logger.error("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165\u4e0a\u4f20\u4fe1\u606f\u8868\u51fa\u9519\uff01 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + nlsApplyInfoVO.getApplySeq());
            }
            throw new OcmSystemException("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165\u4e0a\u4f20\u4fe1\u606f\u8868\u51fa\u9519\uff01");
        }
    }

    public Integer insertUploadRecord(NlsApplyInfoVO nlsApplyInfoVO, String fpath) {
        YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
        yedUploadRecordVO.setApplSeq(nlsApplyInfoVO.getApplySeq());
        yedUploadRecordVO.setCreateTime(new Date());
        yedUploadRecordVO.setDealType("2");
        yedUploadRecordVO.setFileType("Y02");
        yedUploadRecordVO.setFileUrl(fpath);
        yedUploadRecordVO.setPrdId(nlsApplyInfoVO.getPrdId());
        yedUploadRecordVO.setUpErrMsg("");
        yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
        yedUploadRecordVO.setUpNum(Integer.valueOf(0));
        yedUploadRecordVO.setUpSta(Integer.valueOf(0));
        yedUploadRecordVO.setUpTime(new Date());
        return this.yedUploadService.insert(yedUploadRecordVO);
    }

    private CusIndivVO getCustInfo(String cusId) throws OcmSystemException {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(cusId);
        cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
        if (Objects.isNull(cusIndivVO)) {
            throw new OcmSystemException("\u6839\u636e\u5ba2\u6237\u53f7\uff1a" + cusId + "\uff0c\u67e5\u8be2\u5230\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return cusIndivVO;
    }

    private String getContNo(String applySeq, String contType) throws OcmSystemException {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(applySeq);
        ctrLoanContVO.setContType(contType);
        ctrLoanContVO = this.ctrLoanContService.qryBySernoAndContTyp(ctrLoanContVO);
        if (Objects.isNull(ctrLoanContVO)) {
            logger.error("\u4f18e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            throw new OcmSystemException("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String ctrContNo = ctrLoanContVO.getContNo();
        if (StringUtil.isNullorBank((String)ctrContNo)) {
            logger.error("\u4f18e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5408\u540c\u4fe1\u606f\uff0c\u5f97\u5230\u7684\u5408\u540c\u53f7\u4e3a\u7a7a\uff01");
            throw new OcmSystemException("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5408\u540c\u4fe1\u606f\uff0c\u5f97\u5230\u7684\u5408\u540c\u53f7\u4e3a\u7a7a\uff01");
        }
        return ctrContNo;
    }

    private void insertCfcaSignInfo(NlsCreditInfoVO nlsCreditInfoVO, YedContResult yedContResult, String contType, String applySeq, CfcaSignInfoVO cfcaSignInfoVO, SignContractBean signContractBean, NlsApplyInfoVO nlsApplyInfoVO) throws OcmSystemException {
        String contNo = this.getContNo(applySeq, contType);
        if (logger.isInfoEnabled()) {
            logger.info("======>\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u4fdd\u5b58\u5408\u540c\u7b7e\u7ae0\u8bb0\u5f55\u4fe1\u606f\u5f00\u59cb<===== \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + applySeq + " \u5408\u540c\u53f7\u4e3a\uff1a" + contNo);
        }
        cfcaSignInfoVO = Optional.ofNullable(cfcaSignInfoVO).orElse(new CfcaSignInfoVO());
        cfcaSignInfoVO.setApplySeq(applySeq);
        cfcaSignInfoVO.setPrdId(nlsCreditInfoVO.getPrdId());
        cfcaSignInfoVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        cfcaSignInfoVO.setPrdName(nlsCreditInfoVO.getPrdName());
        cfcaSignInfoVO.setContNo(contNo);
        cfcaSignInfoVO.setCfcaContNo(yedContResult.getAxqContNo());
        cfcaSignInfoVO.setCusId(nlsCreditInfoVO.getCusId());
        cfcaSignInfoVO.setCusName(nlsCreditInfoVO.getCusName());
        cfcaSignInfoVO.setPrdType(nlsCreditInfoVO.getChannelNo());
        cfcaSignInfoVO.setNlsOperOrgid(nlsCreditInfoVO.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperUserid(nlsCreditInfoVO.getNlsOperUserid());
        cfcaSignInfoVO.setFinaBrId(nlsCreditInfoVO.getNlsOperOrgid());
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        signContractBean.setCfcaSignInfoVO(cfcaSignInfoVO);
        nlsApplyInfoVO.setSignContractBean((Object)signContractBean);
        cfcaSignInfoVO.setCfcaSignTime(yedContResult.getAxqSignTime());
        int num = this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
        if (num < 0) {
            if (logger.isErrorEnabled()) {
                logger.error("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a: " + applySeq + "\u5408\u540c\u53f7\u4e3a\uff1a" + contNo + " \u5f80cfca\u52a0\u7b7e\u4fe1\u606f\u8868\u65b0\u589e\u6570\u636e\u51fa\u9519!");
            }
            throw new OcmSystemException("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a: " + applySeq + "\u5408\u540c\u53f7\u4e3a\uff1a" + contNo + " \u5f80cfca\u52a0\u7b7e\u4fe1\u606f\u8868\u65b0\u589e\u6570\u636e\u51fa\u9519!");
        }
        if (logger.isInfoEnabled()) {
            logger.info("======>\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u4fdd\u5b58\u5408\u540c\u7b7e\u7ae0\u8bb0\u5f55\u4fe1\u606f\u7ed3\u675f<===== \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + applySeq + " \u5408\u540c\u53f7\u4e3a\uff1a" + contNo);
        }
    }

    private void updateCtrContInfo(String applySeq, String contType, String lmtApplySeq) throws OcmSystemException {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(applySeq);
        ctrLoanContVO.setContType(contType);
        ctrLoanContVO = this.ctrLoanContService.qryBySernoAndContTyp(ctrLoanContVO);
        if (Objects.isNull(ctrLoanContVO)) {
            logger.error("\u4f18e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            throw new OcmSystemException("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        CusReferrerInfoVO referrerInfoVO = new CusReferrerInfoVO();
        referrerInfoVO.setLmtApplySeq(lmtApplySeq);
        referrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(referrerInfoVO);
        if (!Objects.isNull(referrerInfoVO)) {
            ctrLoanContVO.setPerformanceOwner(referrerInfoVO.getReferrerId());
            ctrLoanContVO.setPerformanceOrg(referrerInfoVO.getMainBrId());
            ctrLoanContVO.setFinaBrId(referrerInfoVO.getChargeOffBrId());
        }
        ctrLoanContVO.setContState("200");
        int result = this.ctrLoanContService.updateByPk(ctrLoanContVO);
        if (result != 1) {
            logger.error("\u4f18e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u66f4\u65b0\u5408\u540c\u4fe1\u606f\u4e3a\u5df2\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38\uff01");
            throw new OcmSystemException("\u4f18e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u66f4\u65b0\u5408\u540c\u4fe1\u606f\u4e3a\u5df2\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38");
        }
    }

    private void updCfcaSignInfo(String contNo) throws OcmSystemException {
        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
        cfcaSignInfoVO.setContNo(contNo);
        cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(cfcaSignInfoVO);
        if (Objects.isNull(cfcaSignInfoVO)) {
            if (logger.isErrorEnabled()) {
                logger.error("\u8c03\u7528cfca\u5173\u952e\u5b57\u7b7e\u7f72\u63a5\u53e3\u30103207\u3011\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u67e5\u8be2\u5230\u7684cfca\u52a0\u7b7e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            throw new OcmSystemException("\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u67e5\u8be2\u5230\u7684cfca\u52a0\u7b7e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        int result = this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
        if (result != 1) {
            if (logger.isErrorEnabled()) {
                logger.error("\u8c03\u7528cfca\u5173\u952e\u5b57\u7b7e\u7f72\u63a5\u53e3\u30103207\u3011\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u66f4\u65b0cfca\u52a0\u7b7e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            throw new OcmSystemException("\u8c03\u7528cfca\u5173\u952e\u5b57\u7b7e\u7f72\u63a5\u53e3\u30103207\u3011\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u66f4\u65b0cfca\u52a0\u7b7e\u4fe1\u606f\u5931\u8d25");
        }
    }

    private SOrgVO getSOrg(String orgCode) throws OcmSystemException {
        SOrgVO sOrgVO = new SOrgVO();
        sOrgVO.setOrgCode(orgCode);
        sOrgVO = this.sOrgService.queryByPk(sOrgVO);
        if (Objects.isNull(sOrgVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u673a\u6784\u53f7\u3010" + orgCode + "\u3011\uff0c\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return sOrgVO;
    }

    private LmtPrdContVO getLmtPrdCont(String lmtApplySeq) throws OcmSystemException {
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
        if (Objects.isNull(lmtPrdContVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (null == lmtPrdContVO.getLmtAmt()) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a\uff01");
        }
        return lmtPrdContVO;
    }

    private String getDateString(String date, String dateType) throws OcmSystemException {
        if (!this.Flag) {
            try {
                MessageRuleCheckUtil.checkDate((String)"\u6388\u4fe1\u6709\u6548\u65e5\u671f", (String)date, (String)"yyyy-MM-dd");
                this.Flag = true;
            }
            catch (BizException e) {
                throw new OcmSystemException("\u7ec4\u88c5\u5408\u540c\u53c2\u6570\u65f6\uff0c\u6821\u9a8c\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u8868\u7684\u6709\u6548\u65e5\u671f\u4e0d\u7b26\u5408\u683c\u5f0f\u201cyyyy-MM-dd\u201d");
            }
        }
        String result = "";
        String[] dates = date.split("-");
        if (TimeType.YEAR.getKey().equals(dateType)) {
            result = dates[0];
        } else if (TimeType.MONTH.getKey().equals(dateType)) {
            result = dates[1];
        } else if (TimeType.DAY.getKey().equals(dateType)) {
            result = dates[2];
        }
        return result;
    }

    private void insertImageBizDetail(NlsApplyInfoVO nlsApplyInfoVO, String imgType, String fileName, String filePath) {
        ImageBizDetailVO imageBizDetail = new ImageBizDetailVO();
        imageBizDetail.setApplySeq(nlsApplyInfoVO.getApplySeq());
        imageBizDetail.setBizStage("\u7528\u4fe1\u5408\u540c");
        imageBizDetail.setFileDesc("\u4f18e\u8d37\u7528\u4fe1\u5408\u540c");
        imageBizDetail.setFileName(fileName);
        imageBizDetail.setFilePath(filePath);
        imageBizDetail.setImageId(imgType);
        imageBizDetail.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizDetail.setImageType(imgType);
        this.imageBizDetailService.insertImageBizDetail(imageBizDetail);
    }

    public String getRefferOrgId(NlsCreditInfoVO nlsCreditInfoVO) throws OcmSystemException {
        CusReferrerInfoVO cusReferrerInfoVO = new CusReferrerInfoVO();
        cusReferrerInfoVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusReferrerInfoVO);
        if (Objects.isNull(cusReferrerInfoVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\uff0c\u83b7\u53d6\u5230\u63a8\u8350\u4eba\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return cusReferrerInfoVO.getChargeOffBrId();
    }

    @Override
    public void run() {
        try {
            this.doExecute(new NlsProcessBizVO(), this.nlsApplyInfoVO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setNlsApplyInfoVO(NlsApplyInfoVO vo, String refuseMessage) {
        try {
            NlsApplyInfoRespVO respVO = new NlsApplyInfoRespVO();
            NlsApplyInfoVO applyInfoVO = this.nlsApplyInfoService.queryByPk(vo);
            if (applyInfoVO.getNlsApplyState().equals(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE())) {
                respVO.setAmountOfLoan(StringUtils.isBlank((CharSequence)applyInfoVO.getAmountOfLoan()) ? "" : applyInfoVO.getAmountOfLoan());
                vo.setAmountOfLoan(StringUtils.isBlank((CharSequence)applyInfoVO.getAmountOfLoan()) ? "" : applyInfoVO.getAmountOfLoan());
                respVO.setApplySeq(applyInfoVO.getApplySeq());
                respVO.setCreateTime(applyInfoVO.getCreateTime());
                respVO.setDnSts(applyInfoVO.getDnSts());
                respVO.setLastModifyTime(applyInfoVO.getLastModifyTime());
                respVO.setLmtApplySeq(applyInfoVO.getLmtApplySeq());
                respVO.setLoanPurpose(applyInfoVO.getLoanPurpose());
                respVO.setLoanRate(applyInfoVO.getLoanRate().toString());
                respVO.setLoanTerm(applyInfoVO.getLoanTerm());
                respVO.setNlsApplyState(applyInfoVO.getNlsApplyState());
                respVO.setRefuseCause(applyInfoVO.getRefuseCause());
                respVO.setTableName("NLS_APPLY_INFO");
                respVO.setChannelNo(applyInfoVO.getChannelNo());
                respVO.setDeliverTime(TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss"));
                this.sendToRisk(respVO, applyInfoVO.getApplySeq());
            }
        }
        catch (Exception e) {
            logger.error("\u98ce\u63a7\u56de\u8c03\u5931\u8d25\uff0c\u53d1\u9001nls_apply_info\u8868\u6570\u636e\u7ed9\u98ce\u63a7\uff0c\u7ed3\u679c\u4e3a\u5931\u8d25" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(Object obj, String applySeq) {
        logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("apply")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedSignContractServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", obj);
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f,\u6d41\u6c34\u53f7\u4e3a\uff1a" + applySeq + "\u53d1\u9001\u98ce\u63a7\u4fe1\u606f\u4e3a\uff1a" + JSONObject.toJSONString((Object)obj));
            if (flag) {
                this.threadPool.add(() -> {
                    KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                    try {
                        kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }
}

