/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.apply;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.redis.lock.RedisLock;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.yed.UpdateLmtPrdContService;
import com.irdstudio.efp.nls.service.impl.common.UpdateLmtPrdContServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedUpdateLmtPrdContService")
public class YedUpdateLmtPrdContServiceImpl
implements UpdateLmtPrdContService {
    private static Logger logger = LoggerFactory.getLogger(UpdateLmtPrdContServiceImpl.class);
    private static final String LMT_PRO_LOCK = "/wd/psd/lmt_prod/";
    private static final long DEFAULT_EXPIRE_TIME = 180L;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;

    public BigDecimal getPreOccAmt(String lmtApplySeq) {
        logger.info("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011,\u83b7\u53d6\u6240\u6709\u5728\u9014\u7684\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u5f00\u59cb------------------- \u76ee\u524d\u8868\u793a\u5728\u9014\u7684\u72b6\u6001\u6709\u3010\u5904\u7406\u4e2d\u3001\u6302\u8d77\u3011");
        NlsApplyInfoVO nlsApplyInfoVo = new NlsApplyInfoVO();
        nlsApplyInfoVo.setLmtApplySeq(lmtApplySeq);
        nlsApplyInfoVo.setNlsApplyState("01");
        List nlsApplyInfoVs = Optional.ofNullable(this.nlsApplyInfoService.queryListByLmtApplySqe(nlsApplyInfoVo)).orElseGet(ArrayList::new);
        return nlsApplyInfoVs.stream().map(NlsApplyInfoVO::getApplyAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public List<String> getApplySeqList(String lmtApplySeq) {
        logger.info("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011,\u83b7\u53d6\u6240\u6709\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u5f00\u59cb-------------------");
        List nlsApplyInfoVOS = this.nlsApplyInfoService.queryAllByLmtApplySeq(lmtApplySeq);
        List<String> applySeqs = nlsApplyInfoVOS.stream().map(NlsApplyInfoVO::getApplySeq).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        logger.info("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011,\u83b7\u53d6\u6240\u6709\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u7ed3\u675f--------\u7ed3\u679c\u96c6\u6570\u4e3a\uff1a" + applySeqs.size());
        return applySeqs;
    }

    public BigDecimal getOccAmt(List<String> applySeqs) {
        if (null == applySeqs || applySeqs.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List accLoanVOS = Optional.ofNullable(this.accLoanService.queryByApplySqes(applySeqs)).orElseGet(ArrayList::new);
        return accLoanVOS.stream().map(AccLoanVO::getLoanBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @RedisLock(keyParamNames={"lmtApplySeq"})
    public void updateLmtProdAfterLoanRelease(String lmtApplySeq, String applySeq) {
        try {
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setLmtApplySeq(lmtApplySeq);
            lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
            if (Objects.nonNull(lmtPrdContVO)) {
                BigDecimal preOCcAmt = lmtPrdContVO.getPreOccAmt();
                List<String> successApplySeq = this.getSuccessApplySeq(lmtApplySeq);
                BigDecimal occAmt = this.getOccAmt(successApplySeq);
                this.takeUpLmt(lmtPrdContVO, occAmt, preOCcAmt);
                this.apprSuccess(applySeq);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RedisLock(keyParamNames={"lmtApplySeq"})
    public void updateLmtProdAfterRepay(String lmtApplySeq, String applySeq, String setlSeq) {
        block5: {
            try {
                LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
                lmtPrdContVO.setLmtApplySeq(lmtApplySeq);
                lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
                if (!Objects.nonNull(lmtPrdContVO)) break block5;
                BigDecimal occAmt = this.getOccAmt(this.getSuccessApplySeq(lmtApplySeq));
                BigDecimal preOccAmt = this.getPreOccAmt(lmtApplySeq);
                this.normalTakeUpLmt(occAmt, preOccAmt, lmtPrdContVO);
                LoanRepayDetailVO loanRepayDetailVO = new LoanRepayDetailVO();
                loanRepayDetailVO.setSetlSeq(setlSeq);
                loanRepayDetailVO = this.loanRepayDetailService.queryByPk(loanRepayDetailVO);
                if (!Objects.nonNull(loanRepayDetailVO)) break block5;
                loanRepayDetailVO.setWfApprSts("02");
                loanRepayDetailVO.setRpSts("1");
                try {
                    int result = this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
                    if (result != 1) {
                        logger.error("\u8fd8\u6b3e\u660e\u7ec6\u8868\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011 \u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u8fd8\u6b3e\u660e\u7ec6\u72b6\u6001\u4e3a\u5931\u8d25");
                        throw new BizException("\u8fd8\u6b3e\u660e\u7ec6\u8868\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u8fd8\u6b3e\u660e\u7ec6\u72b6\u6001\u4e3a\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u8fd8\u6b3e\u660e\u7ec6\u8868\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u8fd8\u6b3e\u660e\u7ec6\u72b6\u6001\u4e3a\u5931\u8d25");
                    throw new BizException("\u8fd8\u6b3e\u660e\u7ec6\u8868\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u8fd8\u6b3e\u660e\u7ec6\u72b6\u6001\u4e3a\u5931\u8d25");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void apprSuccess(String applySeq) throws BizException {
        NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
        nlsApplyInfoVO.setApplySeq(applySeq);
        nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
        if (Objects.nonNull(nlsApplyInfoVO)) {
            nlsApplyInfoVO.setNlsApplyState("02");
            nlsApplyInfoVO.setExecuteTime(6);
            try {
                int result = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
                if (result != 1) {
                    logger.error("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getLmtApplySeq() + "\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u7528\u4fe1\u72b6\u6001\u4e3a\u5931\u8d25");
                    throw new BizException("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getLmtApplySeq() + "\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u7528\u4fe1\u72b6\u6001\u4e3a\u5931\u8d25");
                }
            }
            catch (Exception e) {
                logger.error("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getLmtApplySeq() + "\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u7528\u4fe1\u72b6\u6001\u4e3a\u5931\u8d25");
                e.printStackTrace();
                throw new BizException("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getLmtApplySeq() + "\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\u540c\u6b65\u6210\u529f\u540e\u66f4\u65b0\u7528\u4fe1\u72b6\u6001\u4e3a\u5931\u8d25");
            }
        }
    }

    private void takeUpLmt(LmtPrdContVO lmtPrdContVO, BigDecimal occAmt, BigDecimal preOccAmt) throws BizException {
        BigDecimal newOccAmt = occAmt.add(preOccAmt);
        lmtPrdContVO.setOccAmt(newOccAmt);
        lmtPrdContVO.setPreOccAmt(BigDecimal.ZERO);
        lmtPrdContVO.setAvailAmt(lmtPrdContVO.getLmtAmt().subtract(newOccAmt));
        int result = this.lmtPrdContService.updateByPk(lmtPrdContVO);
        if (result != 1) {
            logger.error("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtPrdContVO.getLmtApplySeq() + "\u3011\u989d\u5ea6\u5360\u7528\u662f\u5931\u8d25");
            throw new BizException("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtPrdContVO.getLmtApplySeq() + "\u3011\u989d\u5ea6\u5360\u7528\u662f\u5931\u8d25");
        }
    }

    @RedisLock(keyParamNames={"lmtApplySeq"})
    public void updateLmtPro(String lmtApplySeq, String applySeq) {
        try {
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setLmtApplySeq(lmtApplySeq);
            lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
            if (Objects.nonNull(lmtPrdContVO)) {
                List<String> lmtApplySeqs = this.getSuccessApplySeq(lmtApplySeq);
                BigDecimal occAmt = this.getOccAmt(lmtApplySeqs);
                this.normalTakeUpLmt(occAmt, null, lmtPrdContVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getSuccessApplySeq(String lmtApplySeq) {
        NlsApplyInfoVO nlsApplyInfoVo = new NlsApplyInfoVO();
        nlsApplyInfoVo.setLmtApplySeq(lmtApplySeq);
        nlsApplyInfoVo.setNlsApplyState("02");
        List nlsApplyInfoVs = Optional.ofNullable(this.nlsApplyInfoService.queryListByLmtApplySqe(nlsApplyInfoVo)).orElseGet(ArrayList::new);
        return nlsApplyInfoVs.stream().filter(Objects::nonNull).map(NlsApplyInfoVO::getApplySeq).collect(Collectors.toList());
    }

    private void normalTakeUpLmt(BigDecimal occAmt, BigDecimal preOccAmt, LmtPrdContVO lmtPrdContVO) throws BizException {
        lmtPrdContVO.setOccAmt(occAmt);
        lmtPrdContVO.setPreOccAmt(BigDecimal.ZERO);
        lmtPrdContVO.setAvailAmt(lmtPrdContVO.getLmtAmt().subtract(occAmt));
        int result = this.lmtPrdContService.updateByPk(lmtPrdContVO);
        if (result != 1) {
            logger.error("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtPrdContVO.getLmtApplySeq() + "\u3011\u989d\u5ea6\u5360\u7528\u662f\u5931\u8d25");
            throw new BizException("\u6388\u4fe1\u534f\u8bae\u8868 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtPrdContVO.getLmtApplySeq() + "\u3011\u989d\u5ea6\u5360\u7528\u662f\u5931\u8d25");
        }
    }

    @RedisLock(keyParamNames={"lmtApplySeq"})
    public void recoverLmtPro(String lmtApplySeq, String applySeq) {
        try {
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setLmtApplySeq(lmtApplySeq);
            lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
            if (Objects.nonNull(lmtPrdContVO)) {
                List<String> lmtApplySeqs = this.getSuccessApplySeq(lmtApplySeq);
                BigDecimal occAmt = this.getOccAmt(lmtApplySeqs);
                this.normalTakeUpLmt(occAmt, BigDecimal.ZERO, lmtPrdContVO);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u989d\u5ea6\u5360\u7528\u4fe1\u606f \u91ca\u653e\u5206\u5e03\u5f0f\u9501\u5931\u8d25 ");
            e.printStackTrace();
        }
    }
}

