/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.apply.ctrcont;

import com.irdstudio.basic.framework.core.constant.SDicCertTypeEnum;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.Amount2RMB;
import com.irdstudio.efp.console.service.facade.PrdInfoLprService;
import com.irdstudio.efp.console.service.facade.SOrgInfoService;
import com.irdstudio.efp.console.service.facade.SOrgService;
import com.irdstudio.efp.console.service.vo.PrdInfoLprVO;
import com.irdstudio.efp.console.service.vo.SOrgInfoVO;
import com.irdstudio.efp.console.service.vo.SOrgVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.impl.yed.apply.ctrcont.AbstractCtrLoanCtrBean;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="yedApplyCtrLoanCont")
public class YedApplyCtrLoanCtr
extends AbstractCtrLoanCtrBean<NlsApplyInfoVO> {
    protected String repayMethod;
    protected String LPRRate;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="prdInfoLprService")
    private PrdInfoLprService prdInfoLprService;
    @Autowired
    @Qualifier(value="sOrgService")
    private SOrgService sOrgService;
    @Autowired
    private CusIndivService cusIndivService;
    @Autowired
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    private AccLoanService accLoanService;
    @Autowired
    private SOrgInfoService sOrgInfoService;

    public YedApplyCtrLoanCtr() {
        this.inputPath = "";
        this.outputPath = "";
    }

    @Override
    protected void setSpecifiedLoanContMedaData(NlsApplyInfoVO nlsApplyInfoVO) throws BizException {
        String applyDate;
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setContNo(nlsApplyInfoVO.getApplySeq());
        ctrLoanContVO = this.ctrLoanContService.queryByPk(ctrLoanContVO);
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(nlsApplyInfoVO.getCusId());
        cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
        CusReferrerInfoVO cusReferrerInfoVO = new CusReferrerInfoVO();
        cusReferrerInfoVO.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
        cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusReferrerInfoVO);
        if (Objects.nonNull(cusReferrerInfoVO)) {
            SOrgVO sOrgVO = new SOrgVO();
            sOrgVO.setOrgCode(cusReferrerInfoVO.getChargeOffBrId());
            sOrgVO = this.sOrgService.queryByPk(sOrgVO);
            this.addContMetaData("chargeoffBrName", Objects.nonNull(sOrgVO) ? sOrgVO.getOrgName() : "");
        }
        if (Objects.nonNull(cusIndivVO)) {
            this.addContMetaData("cusAddr", cusIndivVO.getIndivRsdAddr());
            this.addContMetaData("cusPhone", cusIndivVO.getPhone());
        }
        if (Objects.nonNull(ctrLoanContVO)) {
            this.addContMetaData("cusName", ctrLoanContVO.getCusName());
            this.addContMetaData("certType", SDicCertTypeEnum.getDesc((String)ctrLoanContVO.getCertType()));
            this.addContMetaData("certCode", ctrLoanContVO.getCertCode());
            this.addContMetaData("lmtContNo", ctrLoanContVO.getContNo());
        }
        String returnDate = "";
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setCertCode(cusIndivVO.getCertCode());
        accLoanVO.setCusId(cusIndivVO.getSelfCusId());
        accLoanVO.setPrdId(nlsApplyInfoVO.getPrdId());
        accLoanVO = this.accLoanService.queryfirstDisbDateByCond(accLoanVO);
        returnDate = Objects.nonNull(accLoanVO) ? accLoanVO.getReturnDate() : (Integer.valueOf(returnDate = (applyDate = nlsApplyInfoVO.getApplyDate()).substring(applyDate.length() - 2, applyDate.length())) > 28 ? "28" : returnDate);
        this.addContMetaData("repaymentDay", returnDate);
        String amount = nlsApplyInfoVO.getApplyAmt().setScale(2, 4).toString();
        this.addContMetaData("lmtAmtLower", amount);
        this.addContMetaData("lmtAmtUpper", Amount2RMB.convert((String)amount));
        this.addContMetaData("contNo", nlsApplyInfoVO.getApplySeq());
        this.addContMetaData("loanTerm", nlsApplyInfoVO.getLoanTerm());
        String termStr = "";
        String term = "";
        if ("3".equals(nlsApplyInfoVO.getLoanTerm())) {
            termStr = "\u4e09\u4e2a\u6708\u81f3\u516d\u4e2a\u6708";
            term = "2";
        } else if ("6".equals(nlsApplyInfoVO.getLoanTerm()) || "12".equals(nlsApplyInfoVO.getLoanTerm())) {
            termStr = "\u516d\u4e2a\u6708\u81f3\u4e00\u5e74\uff08\u542b\uff09";
            term = "2";
        } else if ("24".equals(nlsApplyInfoVO.getLoanTerm()) || "36".equals(nlsApplyInfoVO.getLoanTerm())) {
            termStr = "\u4e00\u5e74\u81f3\u4e09\u5e74\uff08\u542b\uff09";
            term = "3";
        }
        PrdInfoLprVO prdInfoLprVO = new PrdInfoLprVO();
        prdInfoLprVO.setTerm(term);
        prdInfoLprVO = this.prdInfoLprService.queryByIntratecdAndTerm2(prdInfoLprVO);
        if (prdInfoLprVO != null) {
            BigDecimal loanRate = nlsApplyInfoVO.getLoanRate().multiply(new BigDecimal("100")).setScale(2, 4);
            String lprRate = loanRate.subtract(prdInfoLprVO.getIntrate()).multiply(new BigDecimal("100")).abs().setScale(2, 4).toString();
            this.addContMetaData("quoteRates", loanRate.subtract(prdInfoLprVO.getIntrate()).multiply(new BigDecimal("100")).toString());
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            this.addContMetaData("expireDate", df.format(prdInfoLprVO.getEffectDate()));
        }
        this.addContMetaData("term", termStr);
        this.addContMetaData("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
        this.addContMetaData("recvAcctNo", nlsApplyInfoVO.getRecvAcctNo());
        this.addContMetaData("recvNo", nlsApplyInfoVO.getDnAccount());
        this.addContMetaData("recvBankName", nlsApplyInfoVO.getBankName());
        this.addContMetaData("orgName", nlsApplyInfoVO.getBankName());
        this.addContMetaData("yRate", Objects.nonNull(nlsApplyInfoVO.getLoanRate()) ? nlsApplyInfoVO.getLoanRate().multiply(new BigDecimal("100")).setScale(2, 4).toString() : "0.00");
        SOrgInfoVO pkParam = new SOrgInfoVO();
        pkParam.setInnerOrg(cusReferrerInfoVO.getChargeOffBrId());
        SOrgInfoVO sOrgInfoVO = this.sOrgInfoService.queryByPk(pkParam);
        if (Objects.isNull(sOrgInfoVO)) {
            throw new BizException("\u83b7\u53d6\u5206\u652f\u884c\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)sOrgInfoVO.getInnerOrg())) {
            throw new BizException("\u83b7\u53d6\u5206\u652f\u884c\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.addContMetaData("sOrgAddr", sOrgInfoVO.getRegistAddr());
    }
}

