/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.compensate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.console.service.facade.ActivityAndCouponRecordService;
import com.irdstudio.efp.cus.service.facade.CusAcctInfoService;
import com.irdstudio.efp.cus.service.vo.CusAcctInfoVo;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.constant.sed.DealState;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.yed.YedGjjLoanService;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.impl.yed.apply.YedLoanReleaseServiceImpl;
import com.irdstudio.efp.nls.service.impl.yed.apply.YedSyncLoanInfoServiceImpl;
import com.irdstudio.efp.nls.service.impl.yed.compensate.CompensationYedTask;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.yed.NlsApplyInfoRespVO;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="loanReleaseCompensationYedTask")
public class LoanReleaseCompensationYedTask
extends CompensationYedTask<NlsApplyInfoVO> {
    private static Logger logger = LoggerFactory.getLogger(LoanReleaseCompensationYedTask.class);
    @Autowired
    @Qualifier(value="yedLoanReleaseService")
    private YedLoanReleaseServiceImpl yedLoanReleaseService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="yedSyncLoanInfoService")
    private YedSyncLoanInfoServiceImpl syncLoanInfoHsdService;
    @Autowired
    private YedGjjLoanService yedGjjLoanService;
    @Autowired
    @Qualifier(value="cusAcctInfoService")
    private CusAcctInfoService cusAcctInfoService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Autowired
    @Qualifier(value="activityAndCouponRecordService")
    private ActivityAndCouponRecordService activityAndCouponRecordService;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;

    @Override
    protected void updateStatus(NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        RespLoanRepayResultQryBean respLoanRepayResultQryBean = this.yedLoanReleaseService.getRespLoanRepayResultQryBean(nlsApplyInfoVO);
        RespLoanRepayResultQryBean.TxnRsltInfBean txnRsltInfBean = Optional.ofNullable(respLoanRepayResultQryBean.parseTxnRsltInf()).orElseGet(RespLoanRepayResultQryBean.TxnRsltInfBean::new);
        String txnStCd = respLoanRepayResultQryBean.getTxnStCd();
        if (nlsApplyInfoVO.getExecuteTime() + 1 == 218) {
            NlsApplyInfoVO updateNlsApplyInfo = this.updateNlsApplyInfoFailureStatus(nlsApplyInfoVO, txnRsltInfBean.getBaseAcctNo(), txnRsltInfBean.getAcctSeqNo());
            this.nlsApplyInfoService.updateByPk(updateNlsApplyInfo);
            this.activityAndCouponRecordService.deleteCouponRecord(nlsApplyInfoVO.getApplySeq());
            return;
        }
        String qrySt = respLoanRepayResultQryBean.getQrySt();
        NlsApplyInfoVO updateNlsApplyInfo = null;
        if (DealState.SUCCESS.getValue().equals(txnStCd)) {
            this.yedLoanReleaseService.updateLmtTerm(nlsApplyInfoVO);
            updateNlsApplyInfo = this.updateNlsApplyInfoSuccessStatus(nlsApplyInfoVO, txnRsltInfBean.getBaseAcctNo(), txnRsltInfBean.getAcctSeqNo());
            try {
                this.syncLoanInfoHsdService.doExecute(null, nlsApplyInfoVO);
                this.threadPool.add(() -> {
                    try {
                        if (this.isReturnBackGjj(nlsApplyInfoVO)) {
                            this.yedGjjLoanService.callSyncGjjInvoteApply(nlsApplyInfoVO);
                            this.updateCusAcctInfo(nlsApplyInfoVO);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7" + nlsApplyInfoVO.getLmtApplySeq() + "\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u6210\u529f,\u6267\u884c\u540c\u6b65\u5931\u8d25 \u7b49\u5f85\u8865\u507f\u4efb\u52a1\u8865\u507f");
                nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u540c\u6b65\u4efb\u52a1");
                nlsApplyInfoVO.setNlsApplyState("01");
            }
        } else if (DealState.FAIL.getValue().equals(txnStCd) || SedNlsEnum.QuerySts.WITHOUT.getValue().equals(qrySt) && StringUtils.isEmpty((CharSequence)txnStCd)) {
            updateNlsApplyInfo = this.updateNlsApplyInfoFailureStatus(nlsApplyInfoVO, txnRsltInfBean.getBaseAcctNo(), txnRsltInfBean.getAcctSeqNo());
            LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            this.activityAndCouponRecordService.deleteCouponRecord(nlsApplyInfoVO.getApplySeq());
        } else if (DealState.DEALING.getValue().equals(txnStCd) || DealState.SUSPEND.getValue().equals(txnStCd) || DealState.UNKNOW.getValue().equals(txnStCd)) {
            logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011 \u653e\u6b3e\u8865\u507f\u4efb\u52a1\u6b63\u5728\u6267\u884c \u5f53\u524d\u6267\u884c\u7684\u6b21\u6570\u4e3a\u3010" + nlsApplyInfoVO.getExecuteTime() + "\u3011");
            logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011 \u7528\u4fe1\u7533\u8bf7\u4e3a" + JSONObject.toJSONString((Object)nlsApplyInfoVO));
            throw new ESBException("\u653e\u6b3e\u8865\u507f\u4efb\u52a1\u6267\u884c");
        }
        this.nlsApplyInfoService.updateByPk(updateNlsApplyInfo);
        try {
            NlsApplyInfoRespVO respVO = new NlsApplyInfoRespVO();
            NlsApplyInfoVO nlsApplyRespVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
            if (nlsApplyRespVO.getNlsApplyState().equals(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE()) && nlsApplyInfoVO.getDnSts().equals("6") || nlsApplyRespVO.getNlsApplyState().equals(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE()) && nlsApplyInfoVO.getDnSts().equals("0")) {
                respVO.setAmountOfLoan(nlsApplyRespVO.getAmountOfLoan());
                respVO.setApplySeq(nlsApplyRespVO.getApplySeq());
                respVO.setCreateTime(nlsApplyRespVO.getCreateTime());
                respVO.setDnSts(nlsApplyRespVO.getDnSts());
                respVO.setLastModifyTime(nlsApplyRespVO.getLastModifyTime());
                respVO.setLmtApplySeq(nlsApplyRespVO.getLmtApplySeq());
                respVO.setLoanPurpose(nlsApplyRespVO.getLoanPurpose());
                respVO.setLoanRate(nlsApplyRespVO.getLoanRate().toString());
                respVO.setLoanTerm(nlsApplyRespVO.getLoanTerm());
                respVO.setNlsApplyState(nlsApplyRespVO.getNlsApplyState());
                respVO.setRefuseCause(nlsApplyRespVO.getRefuseCause());
                respVO.setTableName("NLS_APPLY_INFO");
                respVO.setChannelNo(nlsApplyRespVO.getChannelNo());
                respVO.setDeliverTime(TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss"));
                this.sendToRisk(respVO, nlsApplyInfoVO.getApplySeq());
            }
        }
        catch (Exception e) {
            logger.error("\u9519\u8bef\u4fe1\u606f" + e.getMessage() + "\u6d41\u6c34\u53f7\uff1a" + nlsApplyInfoVO.getApplySeq());
        }
    }

    @Override
    protected void sendMessage(NlsApplyInfoVO nlsApplyInfoVO) {
        try {
            int executeTime = nlsApplyInfoVO.getExecuteTime();
            nlsApplyInfoVO.setExecuteTime(++executeTime);
            this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
            logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011 \u653e\u6b3e\u8865\u507f\u4efb\u52a1\u6b63\u5728\u6267\u884c \u5f53\u524d\u6267\u884c\u7684\u6b21\u6570\u4e3a\u3010" + nlsApplyInfoVO.getExecuteTime() + "\u3011 \u5ef6\u8fdf\u6267\u884c\u7ea7\u522b\u3010" + this.delayLevel(nlsApplyInfoVO.getExecuteTime()) + "\u3011");
            Message message = new Message(TopicEnums.YED_RELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId(), TagEnums.YED_RELEASEORREPAY_QUEUE_TASK.getTagId(), nlsApplyInfoVO.getApplySeq().concat(".").concat("NlsApplyInfoVO-" + nlsApplyInfoVO.getExecuteTime()), JSON.toJSONString((Object)nlsApplyInfoVO).getBytes("UTF-8"));
            message.setDelayTimeLevel(this.delayTimes(nlsApplyInfoVO.getExecuteTime()));
            String messageKey = TopicEnums.YED_RELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId() + "_" + TagEnums.YED_RELEASEORREPAY_QUEUE_TASK.getTagId() + "_" + nlsApplyInfoVO.getApplySeq().concat(".").concat("NlsApplyInfoVO-" + nlsApplyInfoVO.getExecuteTime());
            this.producerService.sendMsg(message, messageKey);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1\u65f6\uff0c\u53d1\u9001mq\u51fa\u73b0\u5f02\u5e38!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1\u65f6\uff0c\u66f4\u65b0\u8865\u507f\u4efb\u52a1\u6267\u884c\u6b21\u6570\u5931\u8d25!!!");
        }
    }

    @Override
    protected NlsApplyInfoVO convertToJavaBean(String body) {
        return (NlsApplyInfoVO)JSONObject.parseObject((String)body, NlsApplyInfoVO.class);
    }

    private NlsApplyInfoVO updateNlsApplyInfoFailureStatus(NlsApplyInfoVO nlsApplyInfoVO, String loanNo, String distrNo) {
        nlsApplyInfoVO.setNlsApplyState("03");
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u5931\u8d25");
        nlsApplyInfoVO.setDnSts("0");
        nlsApplyInfoVO.setLoanNo(loanNo);
        nlsApplyInfoVO.setDistrNo(distrNo);
        return nlsApplyInfoVO;
    }

    private NlsApplyInfoVO updateNlsApplyInfoSuccessStatus(NlsApplyInfoVO nlsApplyInfoVO, String loanNo, String distrNo) {
        nlsApplyInfoVO.setRefuseCause("");
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u6210\u529f");
        nlsApplyInfoVO.setDnSts("6");
        nlsApplyInfoVO.setLoanNo(loanNo);
        nlsApplyInfoVO.setDistrNo(distrNo);
        nlsApplyInfoVO.setRefuseCause("");
        nlsApplyInfoVO.setExecuteTime(0);
        return nlsApplyInfoVO;
    }

    private void updateCusAcctInfo(NlsApplyInfoVO nlsApplyInfoVO) {
        CusAcctInfoVo acctInfoVo = new CusAcctInfoVo();
        try {
            acctInfoVo.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            List cusAcctInfoVos = this.cusAcctInfoService.queryByLmtApplySeq(acctInfoVo);
            if (null != cusAcctInfoVos && !cusAcctInfoVos.isEmpty()) {
                acctInfoVo.setApplySeq(nlsApplyInfoVO.getApplySeq());
                acctInfoVo.setApplyTime(DateUtility.getCurrDateTime());
                acctInfoVo.setApproveStatus(nlsApplyInfoVO.getApproveStatus() == null ? "02" : nlsApplyInfoVO.getApproveStatus());
                acctInfoVo.setReturnBack("Y");
                this.cusAcctInfoService.update(acctInfoVo);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5ba2\u6237\u516c\u79ef\u91d1\u4fe1\u606f\u8868\u9519\u8bef\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + nlsApplyInfoVO.getLmtApplySeq() + "\u9519\u8bef\u4fe1\u606f\u4e3a" + e.getMessage());
        }
    }

    private boolean isReturnBackGjj(NlsApplyInfoVO nlsApplyInfoVO) {
        CusAcctInfoVo acctInfoVo = new CusAcctInfoVo();
        try {
            acctInfoVo.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            List cusAcctInfoVos = this.cusAcctInfoService.queryByLmtApplySeq(acctInfoVo);
            return null != cusAcctInfoVos && !cusAcctInfoVos.isEmpty();
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u662f\u5426\u9700\u8981\u56de\u5199\u516c\u79ef\u91d1\u62a5\u9519\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + nlsApplyInfoVO.getLmtApplySeq() + "\u9519\u8bef\u4fe1\u606f\u4e3a" + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(Object obj, String applySeq) {
        logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("apply")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(LoanReleaseCompensationYedTask.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", obj);
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7: " + applySeq + " \u53d1\u9001\u4fe1\u606f\u4e3a\uff1a" + JSONObject.toJSONString((Object)obj));
            if (flag) {
                this.threadPool.add(() -> {
                    KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                    try {
                        kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }
}

