/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.compensate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.TxnRsltInf2Bean;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayResultQryService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.sed.DealState;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.impl.yed.compensate.CompensationYedTask;
import com.irdstudio.efp.nls.service.impl.yed.repay.YedRepaymentInfoSyncServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.yed.LoanRepayDetailRespVO;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="repayCompensationYedTask")
public class RepayCompensationYedTask
extends CompensationYedTask<LoanRepayDetailVO> {
    private static Logger logger = LoggerFactory.getLogger(RepayCompensationYedTask.class);
    @Autowired
    @Qualifier(value="loanRepayResultQryService")
    private LoanRepayResultQryService loanRepayResultQryService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;
    @Autowired
    @Qualifier(value="yedRepaymentInfoSyncService")
    private YedRepaymentInfoSyncServiceImpl yedRepaymentInfoSyncService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;

    @Override
    protected void updateStatus(LoanRepayDetailVO loanRepayDetailVO) throws ESBException {
        if (loanRepayDetailVO.getExecuteTime() + 1 == 218) {
            LoanRepayDetailVO updateNlsApplyInfo = this.updateRepayDetailFailureStatus(loanRepayDetailVO);
            this.loanRepayDetailService.updateByPk(updateNlsApplyInfo);
            return;
        }
        String globalSerno = loanRepayDetailVO.getGlobalSerno();
        ReqLoanRepayResultQryBean reqLoanRepResQryBean = new ReqLoanRepayResultQryBean();
        reqLoanRepResQryBean.setTxnGlblSrlNo(globalSerno);
        reqLoanRepResQryBean.setCnlTp(loanRepayDetailVO.getCnlTp());
        RespLoanRepayResultQryBean respLoanRepResQryBean = new RespLoanRepayResultQryBean();
        respLoanRepResQryBean = this.loanRepayResultQryService.loanRepayResultQry(reqLoanRepResQryBean);
        String isRepay = respLoanRepResQryBean.getQrySt();
        String dealState = respLoanRepResQryBean.getTxnStCd();
        LoanRepayDetailVO updateLoanRepayDetail = null;
        if (DealState.SUCCESS.getValue().equals(dealState)) {
            String dealDetail = respLoanRepResQryBean.getTxnRsltInf();
            TxnRsltInf2Bean sd = (TxnRsltInf2Bean)JSONObject.parseObject((String)dealDetail, TxnRsltInf2Bean.class);
            loanRepayDetailVO.setRpyNo(sd.getReceiptNo());
            try {
                this.yedRepaymentInfoSyncService.doExecute(null, updateLoanRepayDetail);
            }
            catch (Exception e) {
                updateLoanRepayDetail = this.updateRepayDetailHandling(loanRepayDetailVO);
                logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u8fd8\u6b3e\u6210\u529f,\u6267\u884c\u540c\u6b65\u5931\u8d25 \u7b49\u5f85\u540c\u6b65\u4efb\u52a1\u5904\u7406");
            }
        } else if (DealState.FAIL.getValue().equals(dealState) || SedNlsEnum.QuerySts.WITHOUT.getValue().equals(isRepay) && StringUtils.isEmpty((CharSequence)dealState)) {
            updateLoanRepayDetail = this.updateRepayDetailFailureStatus(loanRepayDetailVO);
        } else if (DealState.DEALING.getValue().equals(dealState) || DealState.UNKNOW.getValue().equals(dealState) || DealState.SUSPEND.getValue().equals(dealState)) {
            logger.info("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011 \u8fd8\u6b3e\u8865\u507f\u4efb\u52a1\u6b63\u5728\u6267\u884c \u5f53\u524d\u6267\u884c\u7684\u6b21\u6570\u4e3a\u3010" + loanRepayDetailVO.getExecuteTime() + "\u3011");
            logger.info("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011 \u8fd8\u6b3e\u7533\u8bf7\u4e3a" + JSONObject.toJSONString((Object)loanRepayDetailVO));
            throw new ESBException("\u8fd8\u6b3e\u6b3e\u8865\u507f\u4efb\u52a1\u6267\u884c");
        }
        this.loanRepayDetailService.updateByPk(updateLoanRepayDetail);
        try {
            LoanRepayDetailVO detailVO = this.loanRepayDetailService.queryByPk(loanRepayDetailVO);
            if (detailVO.getWfApprSts().equals(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE())) {
                LoanRepayDetailRespVO vo = new LoanRepayDetailRespVO();
                vo.setTableName("LOAN_REPAY_DETAIL");
                vo.setLoanNo(detailVO.getLoanNo());
                vo.setSetlSeq(detailVO.getSetlSeq());
                vo.setSetlApplyDt(detailVO.getSetlApplyDt());
                vo.setSetlTotalFee(detailVO.getSetlTotalFee() == null ? "" : detailVO.getSetlTotalFee().doubleValue() + "");
                vo.setSetlOdPrcpAmt(detailVO.getSetlOdPrcpAmt() == null ? "" : detailVO.getSetlOdPrcpAmt().doubleValue() + "");
                vo.setSetlTyp(detailVO.getSetlTyp());
                vo.setSetlCreateDt(detailVO.getSetlCreateDt());
                vo.setDeliverTime(TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss"));
                logger.info("\u8fd8\u6b3e\u53d1\u9001kafka\u4fe1\u606f\u5f00\u59cb->\u53d1\u9001\u5bf9\u8c61\u4e3a" + JSONObject.toJSONString((Object)vo));
                this.sendToRisk(vo);
            }
        }
        catch (Exception e) {
            logger.error("\u98ce\u63a7\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private LoanRepayDetailVO updateRepayDetailFailureStatus(LoanRepayDetailVO loanRepayDetailVO) {
        loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.REJECT.getKey());
        loanRepayDetailVO.setRpSts("0");
        loanRepayDetailVO.setFlowStatus("\u8fd8\u6b3e\u5931\u8d25");
        return loanRepayDetailVO;
    }

    private LoanRepayDetailVO updateRepayDetailHandling(LoanRepayDetailVO loanRepayDetailVO) {
        loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.DEALING.getKey());
        loanRepayDetailVO.setRpSts("1");
        loanRepayDetailVO.setFlowStatus("\u8fd8\u6b3e\u540c\u6b65\u4efb\u52a1\u4e2d");
        return loanRepayDetailVO;
    }

    @Override
    protected void sendMessage(LoanRepayDetailVO loanRepayDetailVO) {
        try {
            int executeTime = loanRepayDetailVO.getExecuteTime();
            loanRepayDetailVO.setFlowStatus("\u8fd8\u6b3e\u8865\u507f\u4efb\u52a1\u4e2d");
            loanRepayDetailVO.setExecuteTime(++executeTime);
            this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
            logger.info("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011 \u8fd8\u6b3e\u8865\u507f\u4efb\u52a1\u6b63\u5728\u6267\u884c \u5f53\u524d\u6267\u884c\u7684\u6b21\u6570\u4e3a\u3010" + loanRepayDetailVO.getExecuteTime() + "\u3011 \u5ef6\u8fdf\u6267\u884c\u7ea7\u522b\u3010" + this.delayLevel(loanRepayDetailVO.getExecuteTime()) + "\u3011");
            Message message = new Message(TopicEnums.YED_RELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId(), TagEnums.YED_RELEASEORREPAY_QUEUE_TASK.getTagId(), loanRepayDetailVO.getSetlSeq().concat(".").concat("LoanRepayDetailVO-" + loanRepayDetailVO.getExecuteTime()), JSON.toJSONString((Object)loanRepayDetailVO).getBytes("UTF-8"));
            message.setDelayTimeLevel(this.delayTimes(loanRepayDetailVO.getExecuteTime()));
            String messageKey = TopicEnums.YED_RELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId() + "_" + TagEnums.YED_RELEASEORREPAY_QUEUE_TASK.getTagId() + "_" + loanRepayDetailVO.getSetlSeq().concat(".").concat("LoanRepayDetailVO-" + loanRepayDetailVO.getExecuteTime());
            this.producerService.sendMsg(message, messageKey);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u6267\u884c\u8fd8\u6b3e\u8865\u507f\u4efb\u52a1\u65f6\uff0c\u53d1\u9001mq\u51fa\u73b0\u5f02\u5e38!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u6267\u884c\u8fd8\u6b3e\u8865\u507f\u4efb\u52a1\u65f6\uff0c\u66f4\u65b0\u8865\u507f\u4efb\u52a1\u6267\u884c\u6b21\u6570\u5931\u8d25!!!");
        }
    }

    @Override
    protected LoanRepayDetailVO convertToJavaBean(String body) {
        return (LoanRepayDetailVO)JSONObject.parseObject((String)body, LoanRepayDetailVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(Object obj) {
        logger.info("\u4f18e\u8d37\u8fd8\u6b3e\u660e\u7ec6\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c");
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("apply")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(RepayCompensationYedTask.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", obj);
            if (flag) {
                this.threadPool.add(() -> {
                    KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                    try {
                        kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f");
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }
}

