/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.queue;

import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.basic.framework.mq.handle.MQMessageProcessor;
import com.irdstudio.efp.console.common.YedEnums;
import com.irdstudio.efp.esb.common.constant.nls.SmsTypeEnum;
import com.irdstudio.efp.esb.common.util.JsonUtil;
import com.irdstudio.efp.esb.service.bo.req.sed.letter.ReqSedLetterBean;
import com.irdstudio.efp.esb.service.facade.sed.letter.SedLetterInformService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.yed.SmsHistoryService;
import com.irdstudio.efp.nls.service.vo.SmsHistoryVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DelayMsgSendMessageProcessorImpl
implements MQMessageProcessor {
    private static Logger logger = LoggerFactory.getLogger(DelayMsgSendMessageProcessorImpl.class);
    private static final String prefix = "rc:" + TopicEnums.DELAY_MSG_SEND_QUEUE_TASK_TOPIC.getTopicId() + ":";
    @Autowired
    @Qualifier(value="sedLetterInformService")
    private SedLetterInformService sedLetterInformService;
    @Autowired
    @Qualifier(value="smsHistoryService")
    private SmsHistoryService smsHistoryService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    private StringRedisTemplate template;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(MessageExt messageExt) {
        block9: {
            try {
                if (this.isRepeat(messageExt)) {
                    logger.warn("\u6d88\u606f\u91cd\u590d\u53d1\u9001\uff01messageid: " + messageExt.getMsgId() + " key: " + messageExt.getKeys());
                    break block9;
                }
                String topic = messageExt.getTopic();
                String tag = messageExt.getTags();
                String key = messageExt.getKeys();
                String body = new String(messageExt.getBody(), StandardCharsets.UTF_8);
                logger.info("\u83b7\u53d6\u6d88\u606f\u6210\u529f\uff0c\u6d88\u606f\u4e3b\u9898Topic\uff1a\u3010" + topic + "\u3011,\u6d88\u606f\u6807\u7b7etag\uff1a\u3010" + tag + "\u3011,\u6d88\u606fKey:\u3010" + key + "\u3011,\u6d88\u606f\u4f53\uff1a\u3010" + body + "\u3011");
                SmsHistoryVO smsHistoryVO = (SmsHistoryVO)JsonUtil.fromJson((String)body, SmsHistoryVO.class).orElseThrow(() -> new RuntimeException("MQ\u6d88\u606fJson\u53cd\u5e8f\u5217\u5316\u4e3a\u7a7a\uff01\uff0ckey:" + key));
                logger.info("\u5ef6\u8fdf\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5f00\u59cb\u5904\u7406\uff0c\u77ed\u4fe1\u8bb0\u5f55ID\uff1a" + smsHistoryVO.getId() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + key);
                NlsCreditInfoVO nlsCreditInfo = new NlsCreditInfoVO();
                nlsCreditInfo.setCertCode(smsHistoryVO.getCertNo());
                nlsCreditInfo.setCertType(smsHistoryVO.getCertType());
                List nlsCreditInfoVOS = this.nlsCreditInfoService.queryCertCode(nlsCreditInfo);
                if (this.isSend(nlsCreditInfoVOS)) {
                    logger.info("\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u63a5\u53e3\u5f00\u59cb\uff0c\u77ed\u4fe1\u8bb0\u5f55ID\uff1a" + smsHistoryVO.getId() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + key);
                    ReqSedLetterBean reqSedLetterBean = new ReqSedLetterBean();
                    reqSedLetterBean.setShrtMsgPrtyLvl("08#");
                    reqSedLetterBean.setMblNo(smsHistoryVO.getPhone());
                    reqSedLetterBean.setCntntInf(smsHistoryVO.getContext());
                    try {
                        this.sedLetterInformService.sendLetter(reqSedLetterBean);
                        SmsHistoryVO smsVO = SmsHistoryVO.builder().id(smsHistoryVO.getId()).retryTimes(Integer.valueOf(0)).status(SmsTypeEnum.SUCCESS.getValue()).lastUpdateTime(new Date()).lastUpdateUser("mqconsumer").build();
                        this.smsHistoryService.updateByPk(smsVO);
                        logger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff0c\u77ed\u4fe1\u8bb0\u5f55ID\uff1a" + smsHistoryVO.getId() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + key);
                        break block9;
                    }
                    catch (Exception ex) {
                        SmsHistoryVO smsVO = SmsHistoryVO.builder().id(smsHistoryVO.getId()).retryTimes(Integer.valueOf(0)).status(SmsTypeEnum.FAIL.getValue()).lastUpdateTime(new Date()).lastUpdateUser("mqconsumer").build();
                        this.smsHistoryService.updateByPk(smsVO);
                        logger.warn("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u8bb0\u5f55ID\uff1a" + smsHistoryVO.getId() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + key);
                        break block9;
                    }
                    finally {
                        logger.info("\u5ef6\u8fdf\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5904\u7406\u5b8c\u6210\uff0c\u77ed\u4fe1\u8bb0\u5f55ID\uff1a" + smsHistoryVO.getId() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + key);
                    }
                }
                SmsHistoryVO smsVO = SmsHistoryVO.builder().id(smsHistoryVO.getId()).retryTimes(Integer.valueOf(0)).status(SmsTypeEnum.NO_NEED_TO_SEND.getValue()).build();
                this.smsHistoryService.updateByPk(smsVO);
                logger.info("\u5ef6\u8fdf\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5904\u7406\u5b8c\u6210\uff0c\u77ed\u4fe1\u8bb0\u5f55ID\uff1a" + smsHistoryVO.getId() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + key);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return true;
    }

    private boolean isSend(List<NlsCreditInfoVO> nlsCreditInfoVOS) {
        if (nlsCreditInfoVOS == null || nlsCreditInfoVOS.isEmpty()) {
            return true;
        }
        for (NlsCreditInfoVO creditInfoVO : nlsCreditInfoVOS) {
            if (!creditInfoVO.getPrdId().equals(YedEnums.PrdIdEnum.YED.getValue()) || !creditInfoVO.getApprvSts().equals("01") && !creditInfoVO.getApprvSts().equals("02")) continue;
            return false;
        }
        return true;
    }

    private boolean isRepeat(MessageExt messageExt) {
        String key = messageExt.getKeys();
        String checkKey = prefix + key;
        if (this.template.opsForValue().setIfAbsent((Object)checkKey, (Object)"").booleanValue()) {
            this.template.expire((Object)checkKey, 12L, TimeUnit.HOURS);
            return false;
        }
        return true;
    }

    public void setTemplate(StringRedisTemplate template) {
        this.template = template;
    }
}

