/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.queue;

import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.threadpool.AbstractThreadTask;
import com.irdstudio.basic.framework.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.edoc.service.bo.YedSignResultVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.yed.YedSettleCertService;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="yedSettleCertQueueHandleService")
@Scope(scopeName="prototype")
public class YedSettleCertQueueHandle
extends AbstractThreadTask {
    private static Logger logger = LoggerFactory.getLogger(YedSettleCertQueueHandle.class);
    private static final String SUFFIX_FILE_NAME = "_settle_cert.pdf";
    private static final String prefix = "rc:" + TopicEnums.YED_SETTLE_CERT_QUEUE_TASK_TOPIC.getTopicId() + ":";
    private AccLoanVO accLoanVO;
    @Autowired
    @Qualifier(value="redisTemplate")
    private StringRedisTemplate template;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="yedSettleCertService")
    private YedSettleCertService yedSettleCertService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="yedUploadService")
    private YedUploadService yedUploadService;

    public void setAccLoanVO(AccLoanVO accLoanVO) {
        this.accLoanVO = accLoanVO;
    }

    public ExecuteRtnInfo call() throws Exception {
        this.doTask();
        return new ExecuteRtnInfo(null, null, null, null, true);
    }

    public void doTask() throws Exception {
        try {
            String openday = this.pubSysInfoService.getOpenday("1001");
            logger.info("\u5f00\u59cb\u6821\u9a8c\u8425\u4e1a\u65e5...");
            if (StringUtils.isEmpty((CharSequence)openday)) {
                logger.error("\u7ed3\u6e05\u8bc1\u660e\u7b7e\u7ae0\u6d41\u7a0b\u83b7\u53d6\u5230\u7684openday\u4e3a\u7a7a\uff0c\u7528\u4fe1\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)this.accLoanVO.getApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u5c0a\u656c\u7684\u5ba2\u6237\u60a8\u597d\uff0c\u7531\u4e8e\u7cfb\u7edf\u5f02\u5e38\u672c\u6b21\u7ed3\u6e05\u8bc1\u660e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5");
            }
            logger.info("\u8425\u4e1a\u65e5\u6821\u9a8c\u901a\u8fc7");
            logger.info("\u5f00\u59cb\u6821\u9a8c\u5ba2\u6237\u4fe1\u606f...");
            CusIndivVO cusIndivVO = new CusIndivVO();
            cusIndivVO.setCusId(Objects.requireNonNull(this.accLoanVO.getCusId()));
            cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
            if (Objects.isNull(cusIndivVO)) {
                logger.error("\u83b7\u53d6\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7528\u4fe1\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)this.accLoanVO.getApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u83b7\u53d6\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            logger.info("\u5ba2\u6237\u4fe1\u606f\u6821\u9a8c\u901a\u8fc7");
            logger.info("\u5f00\u59cb\u68c0\u9a8c\u7528\u4fe1\u4fe1\u606f...");
            NlsApplyInfoVO inNlsApplyInfoVO = new NlsApplyInfoVO();
            inNlsApplyInfoVO.setApplySeq(this.accLoanVO.getApplySeq());
            NlsApplyInfoVO queryNlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(inNlsApplyInfoVO);
            if (Objects.isNull(queryNlsApplyInfoVO)) {
                logger.error("\u83b7\u53d6\u7684\u5ba2\u6237\u7528\u4fe1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7528\u4fe1\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)this.accLoanVO.getApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u83b7\u53d6\u7684\u5ba2\u6237\u7528\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
            }
            logger.info("\u7528\u4fe1\u4fe1\u606f\u6821\u9a8c\u901a\u8fc7");
            Map<String, String> paramMap = this.initParamMap(cusIndivVO, openday, queryNlsApplyInfoVO.getApplyDate());
            YedSignResultVO yedSignResultVO = this.yedSettleCertService.signature(this.accLoanVO.getApplySeq(), cusIndivVO.getAxqUsrId(), paramMap);
            logger.info("\u7b7e\u7ae0\u8fd4\u56de\u7ed3\u679c\uff1a" + yedSignResultVO.isRetFlag());
            if (!yedSignResultVO.isRetFlag()) {
                logger.error(yedSignResultVO.getMsg());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), yedSignResultVO.getMsg() + ",\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a" + this.accLoanVO.getApplySeq());
            }
            yedSignResultVO = this.yedSettleCertService.downSignFile(this.accLoanVO.getApplySeq(), yedSignResultVO.getAxqContNo(), this.accLoanVO.getApplySeq() + SUFFIX_FILE_NAME);
            logger.info("\u7b7e\u7ae0\u540e\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c\uff1a" + yedSignResultVO.isRetFlag());
            if (!yedSignResultVO.isRetFlag()) {
                logger.error(yedSignResultVO.getMsg());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), yedSignResultVO.getMsg() + ",\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a" + this.accLoanVO.getApplySeq());
            }
            YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
            yedUploadRecordVO.setApplSeq(this.accLoanVO.getApplySeq());
            yedUploadRecordVO.setCreateTime(new Date());
            yedUploadRecordVO.setDealType("2");
            yedUploadRecordVO.setFileType("Y04");
            yedUploadRecordVO.setFileUrl(yedSignResultVO.getFileFullPath());
            yedUploadRecordVO.setPrdId(queryNlsApplyInfoVO.getPrdId());
            yedUploadRecordVO.setUpErrMsg("");
            yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
            yedUploadRecordVO.setUpNum(Integer.valueOf(0));
            yedUploadRecordVO.setUpSta(Integer.valueOf(0));
            yedUploadRecordVO.setUpTime(new Date());
            int n = this.yedUploadService.insert(yedUploadRecordVO);
            logger.info("\u5df2\u63d2\u5165\u4f18e\u8d37\u6587\u4ef6\u4e0a\u4f20\u8bb0\u5f55\u8868\uff1a" + n + "\u6761\u8bb0\u5f55\uff01");
            logger.info("\u7ed3\u6e05\u8bc1\u660e\u7533\u8bf7\u7b7e\u7ae0\u4e0b\u8f7d\u5df2\u5b8c\u6210\uff0c\u5f85\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u5f71\u50cf\u5e73\u53f0,\u672c\u5730\u6587\u4ef6\u8def\u5f84\uff1a" + yedSignResultVO.getFileFullPath());
        }
        catch (BizException bz) {
            logger.error(bz.getMessage(), (Throwable)bz);
            this.template.delete((Object)(prefix + this.accLoanVO.getApplySeq()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.template.delete((Object)(prefix + this.accLoanVO.getApplySeq()));
        }
    }

    private Map<String, String> initParamMap(CusIndivVO cusIndivVO, String openday, String applyDate) throws BizException {
        logger.info("\u3010\u4f18e\u8d37\u7ed3\u6e05\u8bc1\u660e\u7b7e\u8ba2\u670d\u52a1\u3011\u7ec4\u88c5\u5408\u540c\u6a21\u677f\u586b\u5199\u53c2\u6570\u5f00\u59cb \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a" + this.accLoanVO.getApplySeq());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("name", cusIndivVO.getCusName());
            map.put("certCode", cusIndivVO.getCertCode());
            map.put("applyYear", String.valueOf(DateTool.getYear((Date)DateTool.parseDate((String)applyDate, (String)"yyyy-MM-dd"))));
            map.put("applyMonth", String.valueOf(DateTool.getMonth((Date)DateTool.parseDate((String)applyDate, (String)"yyyy-MM-dd"))));
            map.put("applyDay", String.valueOf(DateTool.getDay((Date)DateTool.parseDate((String)applyDate, (String)"yyyy-MM-dd"))));
            map.put("settlYear", String.valueOf(DateTool.getYear((Date)DateTool.parseDate((String)this.accLoanVO.getSettlDate(), (String)"yyyy-MM-dd"))));
            map.put("settlMonth", String.valueOf(DateTool.getMonth((Date)DateTool.parseDate((String)this.accLoanVO.getSettlDate(), (String)"yyyy-MM-dd"))));
            map.put("settlDay", String.valueOf(DateTool.getDay((Date)DateTool.parseDate((String)this.accLoanVO.getSettlDate(), (String)"yyyy-MM-dd"))));
            map.put("prdName", this.accLoanVO.getPrdName());
            map.put("loanTerm", String.valueOf(this.accLoanVO.getLoanTerm()));
            map.put("settlDate", this.accLoanVO.getSettlDate());
            map.put("actualIntCumu", String.valueOf(this.accLoanVO.getActualIntCumu()));
            map.put("repaymentAccount", this.accLoanVO.getRepaymentAccount());
            map.put("loanAmount1", String.valueOf(this.accLoanVO.getLoanAmount()));
            map.put("loanAmount2", String.valueOf(this.accLoanVO.getLoanAmount()));
            map.put("loanStartDate", this.accLoanVO.getLoanStartDate());
            map.put("tranYear", String.valueOf(DateTool.getYear((Date)DateTool.parseDate((String)openday, (String)"yyyy-MM-dd"))));
            map.put("tranMonth", String.valueOf(DateTool.getMonth((Date)DateTool.parseDate((String)openday, (String)"yyyy-MM-dd"))));
            map.put("tranDay", String.valueOf(DateTool.getDay((Date)DateTool.parseDate((String)openday, (String)"yyyy-MM-dd"))));
        }
        catch (Exception e) {
            logger.error("\u5408\u540c\u6a21\u677f\u586b\u5199\u53c2\u6570\u7ec4\u88c5\u5931\u8d25\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a" + this.accLoanVO.getApplySeq(), (Throwable)e);
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u5408\u540c\u6a21\u677f\u586b\u5199\u53c2\u6570\u7ec4\u88c5\u5931\u8d25\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a" + this.accLoanVO.getApplySeq());
        }
        logger.info("\u3010\u4f18e\u8d37\u7ed3\u6e05\u8bc1\u660e\u7b7e\u8ba2\u670d\u52a1\u3011\u7ec4\u88c5\u5408\u540c\u6a21\u677f\u53c2\u6570\u521d\u59cb\u5b8c\u6210\uff01");
        return map;
    }
}

