/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.queue;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.basic.framework.mq.handle.MQMessageProcessor;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.impl.yed.queue.YedSettleCertQueueHandle;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;

public class YedSettleCertQueueTaskMessageProcessorImpl
implements MQMessageProcessor {
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadpool;
    private StringRedisTemplate template;
    private static Logger logger = LoggerFactory.getLogger(YedSettleCertQueueTaskMessageProcessorImpl.class);
    private static final String prefix = "rc:" + TopicEnums.YED_SETTLE_CERT_QUEUE_TASK_TOPIC.getTopicId() + ":";

    public void setTemplate(StringRedisTemplate template) {
        this.template = template;
    }

    public boolean handleMessage(MessageExt messageExt) {
        try {
            if (this.isRepeat(messageExt)) {
                logger.warn("\u6d88\u606f\u91cd\u590d\u53d1\u9001\uff01messageid: " + messageExt.getMsgId() + " key: " + messageExt.getKeys());
            } else {
                String topic = messageExt.getTopic();
                String tag = messageExt.getTags();
                String key = messageExt.getKeys();
                String body = new String(messageExt.getBody(), "UTF-8");
                logger.info("\u83b7\u53d6\u6d88\u606f\u6210\u529f\uff0c\u6d88\u606f\u4e3b\u9898Topic\uff1a\u3010" + topic + "\u3011,\u6d88\u606f\u6807\u7b7etag\uff1a\u3010" + tag + "\u3011,\u6d88\u606fKey:\u3010" + key + "\u3011,\u6d88\u606f\u4f53\uff1a\u3010" + body + "\u3011");
                AccLoanVO accLoanVO = (AccLoanVO)JSONObject.parseObject((String)body, AccLoanVO.class);
                YedSettleCertQueueHandle executoryQueueThread = (YedSettleCertQueueHandle)((Object)SpringContextUtils.getBean((String)"yedSettleCertQueueHandleService"));
                executoryQueueThread.setAccLoanVO(accLoanVO);
                try {
                    this.threadpool.add((Callable)((Object)executoryQueueThread));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return true;
    }

    private boolean isRepeat(MessageExt messageExt) {
        String key = messageExt.getKeys();
        String checkKey = prefix + key;
        if (this.template.opsForValue().setIfAbsent((Object)checkKey, (Object)"").booleanValue()) {
            this.template.expire((Object)checkKey, 12L, TimeUnit.HOURS);
            return false;
        }
        return true;
    }
}

