/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.repay;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.constant.EsbEnums;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanAccountBean;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayBean;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayResultQryService;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.exception.LoanRepaySyncException;
import com.irdstudio.efp.nls.common.exception.RepayException;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.impl.yed.queue.YedRepaySoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.yed.repay.YedRepaymentInfoSyncServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedRepaymentApplyService")
public class YedRepaymentApplyServiceImpl
extends YedRepaySoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(YedRepaymentApplyServiceImpl.class);
    @Autowired
    @Qualifier(value="loanRepayResultQryService")
    private LoanRepayResultQryService loanRepayResultQryService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="loanRepayService")
    private LoanRepayService loanRepayService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    private YedRepaymentInfoSyncServiceImpl repaymentInfoSyncService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, LoanRepayDetailVO loanRepayDetailVO) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        String billNo = loanRepayDetailVO.getLoanNo();
        logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        try {
            if (SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue().equals(loanRepayDetailVO.getExceptionLocation())) {
                AccLoanVO accLoanVO = new AccLoanVO();
                accLoanVO.setBillNo(billNo);
                accLoanVO = this.accLoanService.queryByPk(accLoanVO);
                if (Objects.isNull(accLoanVO)) {
                    throw new OcmSystemException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
            } else {
                this.excuteRepayMain(loanRepayDetailVO, nlsProcessBizVo);
            }
        }
        catch (LoanRepaySyncException e) {
            logger.error("\u8fd8\u6b3e\u6d41\u6c34\u53f7\u4e3a:\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u6267\u884c\u8fd8\u6b3e\u540e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25 \u7531\u5b9a\u65f6\u4efb\u52a1\u5904\u7406");
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg((Exception)((Object)e));
        }
        catch (RepayException e) {
            logger.error("\u8fd8\u6b3e\u6d41\u6c34\u53f7\u4e3a:\u3010" + loanRepayDetailVO.getSetlSeq() + "\u3011\u6267\u884c\u8fd8\u6b3e\u5931\u8d25 \u7531\u8865\u507f\u4efb\u52a1\u5904\u7406");
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
        finally {
            logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        }
    }

    private void excuteRepayMain(LoanRepayDetailVO loanRepayDetailVO, NlsProcessBizVO nlsProcessBizVo) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        String globalSerno = loanRepayDetailVO.getGlobalSerno();
        String billNo = loanRepayDetailVO.getLoanNo();
        logger.info("\u6839\u636e\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u5f00\u59cb-----------------------------------");
        ReqLoanRepayResultQryBean reqLoanRepResQryBean = new ReqLoanRepayResultQryBean();
        reqLoanRepResQryBean.setTxnGlblSrlNo(globalSerno);
        RespLoanRepayResultQryBean respLoanRepResQryBean = new RespLoanRepayResultQryBean();
        reqLoanRepResQryBean.setCnlTp(loanRepayDetailVO.getCnlTp());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.loanRepayResultQryService, (Object)reqLoanRepResQryBean, this.nlsQueueSoltComnService);
        respLoanRepResQryBean = (RespLoanRepayResultQryBean)esbInvokeWrapper.invoke3Threes();
        logger.info("\u6839\u636e\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u7ed3\u675f-------\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)respLoanRepResQryBean));
        AccLoanVO accLoanVO = this.getAccLoan(billNo);
        String isRepay = respLoanRepResQryBean.getQrySt();
        if (SedNlsEnum.QuerySts.WITHOUT.getValue().equals(isRepay)) {
            this.excuteRepay(loanRepayDetailVO, accLoanVO);
            try {
                this.repaymentInfoSyncService.doExecute(nlsProcessBizVo, loanRepayDetailVO);
            }
            catch (Exception e) {
                logger.error("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + setlSeq + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u6210\u529f\u8fd8\u6b3e\u540e\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5931\u8d25\uff01");
                throw new LoanRepaySyncException("\u8fd8\u6b3e\u540e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25");
            }
        }
    }

    public AccLoanVO getAccLoan(String billNo) throws BizException {
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setBillNo(billNo);
        accLoanVO = this.accLoanService.queryByPk(accLoanVO);
        if (Objects.isNull(accLoanVO)) {
            throw new BizException("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u524d\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return accLoanVO;
    }

    private ReqLoanRepayBean buildReqLoanRepayBean(LoanRepayDetailVO loanRepayDetailVO, AccLoanVO accLoanVO) throws Exception {
        ReqLoanRepayBean reqLoanRepayBean = new ReqLoanRepayBean();
        reqLoanRepayBean.setLoanNo(accLoanVO.getLoanSeq());
        reqLoanRepayBean.setDistrNo(accLoanVO.getDistrNo());
        reqLoanRepayBean.setRpyDt(StringUtil.isNotEmpty((String)loanRepayDetailVO.getSetlApplyDt()) ? DateUtility.format10To8((String)loanRepayDetailVO.getSetlApplyDt()) : null);
        try {
            reqLoanRepayBean.setRpyType(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"SetlType", (String)loanRepayDetailVO.getSetlTyp()));
        }
        catch (Exception e) {
            logger.error("\u8fd8\u6b3e\u7c7b\u578b\u5b57\u5178\u9879\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
            throw new Exception("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u65f6\uff0c\u51fa\u73b0\u8fd8\u6b3e\u7c7b\u578b\u5b57\u5178\u9879\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        reqLoanRepayBean.setRpyAmt(loanRepayDetailVO.getTotalAmt() == null ? BigDecimal.ZERO.toString() : loanRepayDetailVO.getTotalAmt().toString());
        reqLoanRepayBean.setRpyPrin(this.caculRpyPrin(loanRepayDetailVO));
        reqLoanRepayBean.setRpyTime(loanRepayDetailVO.getRepayTerm());
        reqLoanRepayBean.setRpyRsn(loanRepayDetailVO.getRepayReason());
        reqLoanRepayBean.setMblNo(this.getMobile(loanRepayDetailVO.getIdType(), loanRepayDetailVO.getIdNo(), accLoanVO.getBillNo()));
        BigDecimal loanTe = accLoanVO.getLoanTerm();
        String loanTermTy = accLoanVO.getLoadTermType();
        String blgAcctProdType = "XD050300703";
        ArrayList<ReqLoanAccountBean> reqLoanAccountList = new ArrayList<ReqLoanAccountBean>();
        if (StringUtil.isStrNotEmpty((String)loanRepayDetailVO.getAmtType())) {
            String[] amtType = loanRepayDetailVO.getAmtType().split(",");
            for (int i = 0; i < amtType.length; ++i) {
                ReqLoanAccountBean reqLAccBean = new ReqLoanAccountBean();
                reqLAccBean.setAmtType(amtType[i]);
                BigDecimal setlAmt = BigDecimal.ZERO;
                if (EsbEnums.AmtType.ALL.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getTotalAmt();
                } else if (EsbEnums.AmtType.PRINCIPAL.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getSetlOdPrcpAmt();
                } else if (EsbEnums.AmtType.INTEREST.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getAllOdNormIntAmt();
                } else if (EsbEnums.AmtType.COMP_INTEREST.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getAllOdCommIntAmt();
                } else if (EsbEnums.AmtType.DEF_INTEREST.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getAllOdIntAmt();
                } else if (EsbEnums.AmtType.FEE.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getTotalFee();
                }
                reqLAccBean.setBlgAmt(setlAmt == null ? BigDecimal.ZERO.toString() : setlAmt.toString());
                reqLAccBean.setBlgAcctCl(loanRepayDetailVO.getSetlAcctClassify());
                reqLAccBean.setBlgMth(loanRepayDetailVO.getSetlMode());
                reqLAccBean.setAcctCtgry(loanRepayDetailVO.getAcctTyp());
                reqLAccBean.setBlgCstNo(loanRepayDetailVO.getCusNo());
                reqLAccBean.setBlgAcctNo(loanRepayDetailVO.getDisbAcNo());
                reqLAccBean.setBlgAcctProdType(blgAcctProdType);
                try {
                    reqLAccBean.setBlgAcctCurrCd(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"CurType", (String)loanRepayDetailVO.getSetlCurr()));
                }
                catch (Exception e) {
                    logger.error("\u5e01\u79cd\u5b57\u5178\u9879\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
                    throw new Exception("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u65f6\uff0c\u51fa\u73b0\u5e01\u79cd\u5b57\u5178\u9879\u8f6c\u6362\u5f02\u5e38\uff01");
                }
                reqLAccBean.setBlgAcctSrlNo(loanRepayDetailVO.getSetlAcctSeq());
                reqLAccBean.setAtmLockMark(loanRepayDetailVO.getAtmLockMark());
                reqLAccBean.setLoanPrtyLvl(loanRepayDetailVO.getLoanPrtyLvl());
                reqLAccBean.setBlgRto(loanRepayDetailVO.getSetlWeight());
                reqLAccBean.setBankInsdOutSdFlg(loanRepayDetailVO.getBankInOut());
                reqLAccBean.setMdfMd(loanRepayDetailVO.getModifyMode());
                reqLoanAccountList.add(reqLAccBean);
            }
        }
        reqLoanRepayBean.setIntSetInfArry(reqLoanAccountList.toArray(new ReqLoanAccountBean[reqLoanAccountList.size()]));
        String str = "";
        return reqLoanRepayBean;
    }

    private String getMobile(String idType, String idNo, String billNo) throws BizException {
        String cusId = this.cusIndivService.getCusIdByCertCode(idType, idNo);
        if (StringUtils.isEmpty((String)cusId)) {
            logger.error("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u524d\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u5ba2\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff01");
            throw new BizException("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u524d\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u5ba2\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff01");
        }
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(cusId);
        cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
        if (Objects.nonNull(cusIndivVO)) {
            return cusIndivVO.getPhone();
        }
        logger.error("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u524d\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u5ba2\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff01");
        throw new BizException("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u524d\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u5ba2\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff01");
    }

    private void excuteRepay(LoanRepayDetailVO loanRepayDetailVO, AccLoanVO accLoanVO) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        logger.info("\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u63a5\u53e3\u5f00\u59cb----------------------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
        ReqLoanRepayBean reqLoanRepayBean = this.buildReqLoanRepayBean(loanRepayDetailVO, accLoanVO);
        EsbRespSysHeadBean esbRespSysHeadBean = new EsbRespSysHeadBean();
        RespLoanRepayBean respLoanRepayBean = new RespLoanRepayBean();
        try {
            respLoanRepayBean = this.loanRepayService.loanRepay(reqLoanRepayBean, loanRepayDetailVO);
            if ("06".equals(loanRepayDetailVO.getSetlTyp())) {
                loanRepayDetailVO.setRepayTerm("0");
            }
        }
        catch (Exception e) {
            if ("06".equals(loanRepayDetailVO.getSetlTyp())) {
                loanRepayDetailVO.setRepayTerm("0");
            }
            throw new RepayException(e.getMessage());
        }
        logger.info("\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u63a5\u53e3\u7ed3\u675f----------------------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
        String sysHeadRetCode = respLoanRepayBean.getSysHeadRetCode();
        if (!EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE().equals(sysHeadRetCode)) {
            throw new RepayException("\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + setlSeq);
        }
        loanRepayDetailVO.setRpyNo(respLoanRepayBean.getRpyNo());
        loanRepayDetailVO.setTxnRefrNo(respLoanRepayBean.getTxnRefrNo());
        loanRepayDetailVO.setFlowStatus("\u8fd8\u6b3e\u6210\u529f");
        loanRepayDetailVO.setRpSts("1");
        this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
    }

    public void updStateAndLmt(LoanRepayDetailVO loanRepayDetailVO, AccLoanVO accLoanVO) throws RepayException {
        block8: {
            String setlSeq = loanRepayDetailVO.getSetlSeq();
            logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u6267\u884c\u5230\u8fd8\u6b3e\u6210\u529f\u540e,\u540e\u5904\u7406\u5f00\u59cb,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
            try {
                loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.DEALING.getKey());
                int num = this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
                if (num < 0) {
                    logger.error("\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u72b6\u6001\u4e3a\u201c\u901a\u8fc7\u201d\uff0c\u6267\u884c\u5931\u8d25\uff01");
                    throw new OcmSystemException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u72b6\u6001\u4e3a\u201c\u5904\u7406\u4e2d\u201d\uff0c\u6267\u884c\u5931\u8d25\uff01--------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
                }
                String lmtApplySeq = this.getLmtApplySeq(accLoanVO.getApplySeq());
                LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
                if (Objects.nonNull(lmtPrdContVO)) {
                    BigDecimal lmtAmt = lmtPrdContVO.getLmtAmt();
                    BigDecimal occAmt = Optional.ofNullable(lmtPrdContVO.getOccAmt()).orElse(BigDecimal.ZERO);
                    BigDecimal preOccAmt = Optional.ofNullable(lmtPrdContVO.getPreOccAmt()).orElse(BigDecimal.ZERO);
                    BigDecimal rpyPrin = loanRepayDetailVO.getSetlOdPrcpAmt();
                    lmtPrdContVO.setOccAmt(occAmt.subtract(rpyPrin));
                    lmtPrdContVO.setAvailAmt(lmtAmt.subtract(occAmt).subtract(preOccAmt).add(rpyPrin));
                    lmtPrdContVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
                    int numLmt = this.lmtPrdContService.updateByPk(lmtPrdContVO);
                    if (numLmt < 0) {
                        throw new RepayException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u5931\u8d25\uff01\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + setlSeq + "\u3011\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + lmtApplySeq);
                    }
                    break block8;
                }
                logger.error("\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u8fdb\u884c\u989d\u5ea6\u6062\u590d\uff0c\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
                throw new RepayException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + lmtApplySeq + "\u3011\uff0c\u67e5\u8be2\u5230\u7684\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
            }
            catch (Exception e) {
                throw new RepayException((Throwable)e);
            }
            finally {
                logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u6267\u884c\u5230\u8fd8\u6b3e\u6210\u529f\u540e,\u540e\u5904\u7406\u7ed3\u675f,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
            }
        }
    }

    private String getLmtApplySeq(String applySeq) throws OcmSystemException {
        NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
        nlsApplyInfoVO.setApplySeq(applySeq);
        nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
        if (Objects.isNull(nlsApplyInfoVO)) {
            throw new OcmSystemException("\u8fd8\u6b3e\u6210\u529f\u540e\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u65f6\uff0c\u901a\u8fc7\u652f\u7528\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u652f\u7528\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getLmtApplySeq())) {
            throw new OcmSystemException("\u8fd8\u6b3e\u6210\u529f\u540e\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u65f6\uff0c\u901a\u8fc7\u652f\u7528\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff01");
        }
        return nlsApplyInfoVO.getLmtApplySeq();
    }

    private String caculRpyPrin(LoanRepayDetailVO loanRepayDetailVO) {
        String rpyPrin = "";
        rpyPrin = "02".equals(loanRepayDetailVO.getSetlTyp()) ? (loanRepayDetailVO.getSetlOdPrcpAmt() == null ? BigDecimal.ZERO.toString() : loanRepayDetailVO.getSetlOdPrcpAmt().toString()) : (loanRepayDetailVO.getTotalAmt() == null ? BigDecimal.ZERO.toString() : loanRepayDetailVO.getTotalAmt().toString());
        return rpyPrin;
    }
}

