/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.repay;

import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToLocal;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqLoanBalanceBean;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqLoanInfoQueryBean;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqRepaymentDetailsInfoQueryBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.AcctDtlInfBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespLoanBalanceQueryBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespLoanInfoQueryBean;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespRepaymentPlanListQueryBean;
import com.irdstudio.efp.esb.service.facade.hj.LoanInfoQueryService;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.facade.LoanRepayPlanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayPlanVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.constant.yed.YedAccLoanUtils;
import com.irdstudio.efp.nls.common.exception.LoanRepaySyncException;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.UpdateLmtPrdContService;
import com.irdstudio.efp.nls.service.impl.yed.queue.YedRepaySoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedRepaymentInfoSyncService")
public class YedRepaymentInfoSyncServiceImpl
extends YedRepaySoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(YedRepaymentInfoSyncServiceImpl.class);
    @Autowired
    @Qualifier(value="loanInfoQueryService")
    LoanInfoQueryService loanInfoQueryService;
    @Autowired
    @Qualifier(value="accLoanService")
    AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="accLoanRepayPlanService")
    LoanRepayPlanService loanRepayPlanService;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;
    @Autowired
    @Qualifier(value="updateLmtPrdContService")
    private UpdateLmtPrdContService updateLmtPrdContService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, LoanRepayDetailVO loanRepayDetailVO) throws Exception {
        HashMap<String, String> openDayMap = new HashMap<String, String>();
        HashMap<String, String> termIsOverDueMap = new HashMap<String, String>();
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        String loanNo = loanRepayDetailVO.getLoanNo();
        RespLoanInfoQueryBean respLoanInfo = null;
        RespRepaymentPlanListQueryBean respRepayPlan = null;
        RespLoanBalanceQueryBean respLoanBalanceQueryBean = null;
        String exceptionLocation = loanRepayDetailVO.getExceptionLocation();
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setBillNo(loanNo);
        accLoanVO = this.accLoanService.queryByPk(accLoanVO);
        if (Objects.isNull(accLoanVO)) {
            throw new OcmSystemException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u901a\u8fc7\u501f\u636e\u53f7\u3010" + loanNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String loanSeq = accLoanVO.getLoanSeq();
        String distrNo = accLoanVO.getDistrNo();
        ReqLoanInfoQueryBean reqLoanInfoQueryBean = new ReqLoanInfoQueryBean();
        ReqRepaymentDetailsInfoQueryBean reqRepaymentDetailsInfoQueryBean = new ReqRepaymentDetailsInfoQueryBean();
        ReqLoanBalanceBean reqLoanBalanceBean = new ReqLoanBalanceBean();
        String seq = Integer.toString((int)((Math.random() * 9.0 + 1.0) * 100000.0));
        String globalSerno = "109080" + DateTool.getCurrentDateTimeSSS() + seq;
        logger.info("\u501f\u636e\u4fe1\u606f\u67e5\u8be2\u3001\u8fd8\u6b3e\u8ba1\u5212\u660e\u7ec6\u67e5\u8be2\u67e5\u8be2\u3001\u8d37\u6b3e\u4f59\u989d\u67e5\u8be2\u6d41\u6c34\uff1a\u3010" + globalSerno + "\u3011");
        try {
            logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u501f\u636e\u4fe1\u606f\u5f00\u59cb---------------------");
            reqLoanInfoQueryBean.setLoanNo(loanSeq);
            reqLoanInfoQueryBean.setDistrNo(distrNo);
            respLoanInfo = this.loanInfoQueryService.loanInfoQuery(reqLoanInfoQueryBean, globalSerno);
            logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u501f\u636e\u4fe1\u606f\u7ed3\u675f---------------------");
            logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8fd8\u6b3e\u8ba1\u5212\u660e\u7ec6\u5f00\u59cb---------------------");
            reqRepaymentDetailsInfoQueryBean.setAcctNo(loanSeq);
            reqRepaymentDetailsInfoQueryBean.setDistrNo(distrNo);
            respRepayPlan = this.loanInfoQueryService.repaymentPlanListQuery(reqRepaymentDetailsInfoQueryBean, globalSerno);
            logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8fd8\u6b3e\u8ba1\u5212\u660e\u7ec6\u7ed3\u675f---------------------");
            logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8d37\u6b3e\u4f59\u989d\u5f00\u59cb---------------------");
            reqLoanBalanceBean.setLoanNo(loanSeq);
            reqLoanBalanceBean.setDistrNo(distrNo);
            respLoanBalanceQueryBean = this.loanInfoQueryService.loanBalanceQuery(reqLoanBalanceBean, globalSerno);
            logger.info("\u524d\u5f80\u4e92\u91d1\u67e5\u8be2\u8d37\u6b3e\u4f59\u989d\u7ed3\u675f---------------------");
        }
        catch (Exception e) {
            throw new LoanRepaySyncException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u540c\u6b65\u501f\u636e\u3001\u8fd8\u6b3e\u8ba1\u5212\uff0c\u8c03\u7528\u4e92\u91d1\u63a5\u53e3\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        if (StringUtil.isNullorBank((String)exceptionLocation) || SedNlsEnum.ExceptionLocation.INSERT_LOAN_PLAN_AFTER_REPAY.getValue().equals(exceptionLocation)) {
            this.synLoanRepayPlan(respRepayPlan, accLoanVO, openDayMap, termIsOverDueMap);
        }
        this.synAccLoan(accLoanVO, respLoanInfo, respLoanBalanceQueryBean, openDayMap);
        String applySeq = accLoanVO.getApplySeq();
        NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
        nlsApplyInfoVO.setApplySeq(applySeq);
        nlsApplyInfoVO = Optional.ofNullable(this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO)).orElseGet(NlsApplyInfoVO::new);
        this.updateLmtPrdContService.updateLmtProdAfterRepayYed(nlsApplyInfoVO.getLmtApplySeq(), accLoanVO.getApplySeq(), loanRepayDetailVO.getSetlSeq());
        loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.PASS.getKey());
        loanRepayDetailVO.setFlowStatus("\u6d41\u7a0b\u7ed3\u675f");
        loanRepayDetailVO.setPsRemPrcp(respLoanBalanceQueryBean.getLoanBal());
        this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
    }

    private void synLoanRepayPlan(RespRepaymentPlanListQueryBean respRepayPlan, AccLoanVO accLoanVO, Map<String, String> openDayMap, Map<String, String> termIsOverDueMap) throws LoanRepaySyncException {
        String loanNo = accLoanVO.getBillNo();
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u5f00\u59cb,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        try {
            List localLRPVoLists = this.loanRepayPlanService.qryAllByLoanNo(loanNo);
            HashMap<String, String> termClearDateMap = new HashMap<String, String>();
            for (LoanRepayPlanVO lRepPlanVO : localLRPVoLists) {
                termIsOverDueMap.put(lRepPlanVO.getTerm().toString(), lRepPlanVO.getIsOverDue());
                termClearDateMap.put(lRepPlanVO.getTerm().toString(), lRepPlanVO.getClearDate());
            }
            int deleteNum = this.loanRepayPlanService.deleteByLoanNo(loanNo);
            if (deleteNum < 0) {
                throw new LoanRepaySyncException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u6839\u636e\u501f\u636e\u53f7\u3010" + loanNo + "\u3011\uff0c\u5220\u9664\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff01");
            }
            String bizDate = this.pubSysInfoService.getOpenday("1001");
            ArrayList<LoanRepayPlanVO> insertLists = new ArrayList<LoanRepayPlanVO>(respRepayPlan.getAcctDtlInfArry().size());
            if (respRepayPlan.getAcctDtlInfArry().size() == 0) {
                return;
            }
            for (int i = 0; i < respRepayPlan.getAcctDtlInfArry().size(); ++i) {
                AcctDtlInfBean acctDtlInfBean = (AcctDtlInfBean)respRepayPlan.getAcctDtlInfArry().get(i);
                LoanRepayPlanVO loanRepayPlan = new LoanRepayPlanVO();
                loanRepayPlan.setBizDate(bizDate);
                loanRepayPlan.setRefNbr(acctDtlInfBean.getAcctKwd());
                loanRepayPlan.setTerm(Integer.valueOf(Integer.parseInt(acctDtlInfBean.getRpyTime())));
                loanRepayPlan.setBeginDate(DateUtility.format8To10((String)acctDtlInfBean.getStartDt()));
                loanRepayPlan.setStmtDate(DateUtility.format8To10((String)acctDtlInfBean.getEndDt()));
                loanRepayPlan.setGraceDate(StringUtil.isNullorBank((String)acctDtlInfBean.getGrcPrd()) ? "" : DateUtility.format8To10((String)acctDtlInfBean.getGrcPrd()));
                loanRepayPlan.setStatus(this.getTermStatus(acctDtlInfBean, openDayMap));
                Double principal = acctDtlInfBean.getPlanPrin();
                Double interest = acctDtlInfBean.getPlanInt();
                Double penaltyDue = Double.valueOf(BigDecimal.valueOf(acctDtlInfBean.getIssuePnyInt()).add(acctDtlInfBean.getAlrdyPrvnPnyInt()).toString());
                Double comIntDue = Double.valueOf(BigDecimal.valueOf(acctDtlInfBean.getIssueCmpdInt()).add(acctDtlInfBean.getAlrdyPrvnCmpdInt()).toString());
                loanRepayPlan.setPrincipal(new BigDecimal(principal));
                loanRepayPlan.setPrincipalPaid(new BigDecimal(acctDtlInfBean.getActRpyPrin()));
                loanRepayPlan.setInterest(new BigDecimal(interest));
                loanRepayPlan.setInterestPaid(new BigDecimal(acctDtlInfBean.getActRpyInt()));
                loanRepayPlan.setPenaltyDue(new BigDecimal(penaltyDue));
                loanRepayPlan.setPenaltyPaid(new BigDecimal(acctDtlInfBean.getActRpyPnyInt()));
                loanRepayPlan.setComIntDue(new BigDecimal(comIntDue));
                loanRepayPlan.setComIntPaid(new BigDecimal(acctDtlInfBean.getActRpyCmpdInt()));
                loanRepayPlan.setFeeDue(BigDecimal.ZERO);
                loanRepayPlan.setFeePaid(BigDecimal.ZERO);
                loanRepayPlan.setPerAmt(new BigDecimal(principal + interest + penaltyDue + comIntDue));
                loanRepayPlan.setProductCd(accLoanVO.getPrdId());
                loanRepayPlan.setIsOverDue(this.getIsOverDueMethod(acctDtlInfBean.getRpyTime(), loanRepayPlan.getStatus(), termIsOverDueMap));
                loanRepayPlan.setInitTerm(Integer.valueOf(respRepayPlan.getAcctDtlInfArry().size()));
                loanRepayPlan.setClearDate(this.getClearDate(acctDtlInfBean, termClearDateMap, openDayMap));
                insertLists.add(loanRepayPlan);
            }
            int num = this.loanRepayPlanService.batchInsert(insertLists);
            if (num < 0) {
                throw new LoanRepaySyncException(SedNlsEnum.ExceptionLocation.INSERT_LOAN_PLAN_AFTER_REPAY.getValue(), "\u66f4\u65b0\u8fd8\u6b3e\u8ba1\u5212\u5931\u8d25\uff0c\u501f\u636e\u53f7\u3010" + loanNo + "\u3011");
            }
        }
        catch (Exception e) {
            throw new LoanRepaySyncException((Throwable)e);
        }
        finally {
            logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u7ed3\u675f,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        }
    }

    private String getTermStatus(AcctDtlInfBean acctDtlInfBean, Map<String, String> openDayMap) {
        String termStatus = null;
        String endDate = StringUtil.isNullorBank((String)acctDtlInfBean.getGrcPrd()) ? acctDtlInfBean.getEndDt() : acctDtlInfBean.getGrcPrd();
        String sysDate = this.getSysOpenDay(openDayMap);
        Double principal = acctDtlInfBean.getPlanPrin();
        Double principalPaid = acctDtlInfBean.getActRpyPrin();
        try {
            if (TimeUtil.compareDates((String)DateUtility.format8To10((String)endDate), (String)sysDate) == -1) {
                termStatus = this.checkIsP(acctDtlInfBean) ? "P" : "O";
            } else if (TimeUtil.compareDates((String)DateUtility.format8To10((String)endDate), (String)sysDate) == 0) {
                termStatus = this.checkIsP(acctDtlInfBean) ? "P" : "N";
            } else if (TimeUtil.compareDates((String)DateUtility.format8To10((String)endDate), (String)sysDate) == 1) {
                termStatus = this.checkIsP(acctDtlInfBean) ? "P" : "N";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u540c\u6b65\u8fd8\u6b3e\u8ba1\u5212\u65f6\uff0c\u83b7\u53d6\u671f\u6570\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
        return termStatus;
    }

    private String getClearDate(AcctDtlInfBean acctDtlInfBean, Map<String, String> termClearDateMap, Map<String, String> openDayMap) {
        String clearDate = null;
        if (StringUtil.isStrNotEmpty((String)termClearDateMap.get(acctDtlInfBean.getRpyTime()))) {
            clearDate = termClearDateMap.get(acctDtlInfBean.getRpyTime());
        } else if (acctDtlInfBean.getPlanPrin() == acctDtlInfBean.getActRpyPrin() && acctDtlInfBean.getPlanInt() == acctDtlInfBean.getActRpyInt() && acctDtlInfBean.getIssuePnyInt() == acctDtlInfBean.getActRpyPnyInt() && acctDtlInfBean.getIssueCmpdInt() == acctDtlInfBean.getActRpyCmpdInt()) {
            clearDate = this.getSysOpenDay(openDayMap);
        }
        return clearDate;
    }

    private String getIsOverDueMethod(String term, String termStatus, Map<String, String> termIsOverDueMap) {
        String isOverDue = SedNlsEnum.YesOrNo.NO.getValue();
        if (SedNlsEnum.YesOrNo.YES.getValue().equals(termIsOverDueMap.get(term))) {
            isOverDue = termIsOverDueMap.get(term);
        }
        if (SedNlsEnum.YesOrNo.NO.getValue().equals(termIsOverDueMap.get(term)) && "O".equals(termStatus)) {
            isOverDue = SedNlsEnum.YesOrNo.YES.getValue();
            termIsOverDueMap.put(term, isOverDue);
        }
        return isOverDue;
    }

    private void synAccLoan(AccLoanVO accLoanVO, RespLoanInfoQueryBean respLoanInfoQueryBean, RespLoanBalanceQueryBean respLoanBalanceQueryBean, Map<String, String> openDayMap) throws LoanRepaySyncException {
        String loanNo = accLoanVO.getBillNo();
        logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u501f\u636e\u4fe1\u606f\u5f00\u59cb,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        try {
            accLoanVO.setLoanBalance(respLoanBalanceQueryBean.getLoanBal());
            accLoanVO.setReceIntCumu(respLoanBalanceQueryBean.getDstrInfArry()[0].getIssueInt());
            accLoanVO.setActualIntCumu(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpydInt());
            accLoanVO.setDelayIntCumu(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpyblInt_1());
            accLoanVO.setUnpdArrPrnBal(respLoanBalanceQueryBean.getDstrInfArry()[0].getIssueCmpdInt());
            accLoanVO.setActArrsIntBal(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpydPnyInt());
            accLoanVO.setActArrPrnBal(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpydCmpdInt());
            accLoanVO.setUnpdArrsIntBal1(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpyblPnyInt_1());
            accLoanVO.setUnpdArrPrnBal1(respLoanBalanceQueryBean.getDstrInfArry()[0].getRpyblCmpdInt_1());
            accLoanVO.setDelayIntCumu1(respLoanBalanceQueryBean.getDstrInfArry()[0].getIssuePnyInt());
            String rulingIr = respLoanInfoQueryBean.getBnchmrkRate();
            accLoanVO.setRulingIr(StringUtil.isNotEmpty((String)rulingIr) ? new BigDecimal(rulingIr).divide(new BigDecimal("100")) : BigDecimal.ZERO);
            accLoanVO.setRealityIrY(null == respLoanInfoQueryBean.getComIntRate() ? BigDecimal.ZERO : respLoanInfoQueryBean.getComIntRate().divide(new BigDecimal("100")));
            accLoanVO.setSettlDate(StringUtils.isEmpty((CharSequence)respLoanInfoQueryBean.getCldDt()) ? null : DateUtility.format8To10((String)respLoanInfoQueryBean.getCldDt()));
            String accSts = YedAccLoanUtils.transferAccStatusByHj((String)respLoanInfoQueryBean.getAcctStDsc(), (String)respLoanInfoQueryBean.getAcctLdgrSt());
            accLoanVO.setAccountStatus(accSts);
            if ("1".equals(accSts)) {
                accLoanVO.setNormalBalance(respLoanBalanceQueryBean.getLoanBal());
                accLoanVO.setUnpdPrinBal(BigDecimal.ZERO);
            } else if ("10".equals(accSts) || "14".equals(accSts)) {
                accLoanVO.setUnpdPrinBal(respLoanInfoQueryBean.getOduePrin());
                accLoanVO.setNormalBalance(BigDecimal.ZERO);
            }
            accLoanVO.setGraceDay(StringUtil.isStrNotEmpty((String)respLoanInfoQueryBean.getGrcDay()) ? new BigDecimal(respLoanInfoQueryBean.getGrcDay()) : BigDecimal.ZERO);
            List loanRepayPlanVOs = this.loanRepayPlanService.qryAllByLoanNo(loanNo);
            if (null != loanRepayPlanVOs || loanRepayPlanVOs.size() > 0) {
                try {
                    accLoanVO.setCapOverdueDate(this.getMinOverdueDate(loanRepayPlanVOs));
                }
                catch (Exception e) {
                    logger.error("\u671f\u6570\u6700\u5c0f\u7684\u903e\u671f\u5230\u671f\u65e5\u53d6\u503c\u5f02\u5e38");
                    accLoanVO.setCapOverdueDate(null);
                }
                accLoanVO.setOverTimesCurrent(this.getOverTimesCurrent(loanRepayPlanVOs));
                accLoanVO.setOverTimesTotal(this.getOverTimesTotal(loanRepayPlanVOs));
                accLoanVO.setMaxTimesTotal(this.getMaxTimesTotal(loanRepayPlanVOs));
                accLoanVO.setCurrTerm(this.getCurTerm(loanRepayPlanVOs, openDayMap));
            }
            accLoanVO.setBizDate(this.getSysOpenDay(openDayMap));
            accLoanVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            accLoanVO.setLastUpdateUser("admin");
            int num = this.accLoanService.updateByPk(accLoanVO);
            if (num < 0) {
                throw new LoanRepaySyncException(SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue(), "\u66f4\u65b0\u501f\u636e\u8868\u4fe1\u606f\u51fa\u9519------------\u501f\u636e\u53f7\u3010" + accLoanVO.getBillNo() + "\u3011");
            }
        }
        catch (Exception e) {
            throw new LoanRepaySyncException((Throwable)e);
        }
        finally {
            logger.info("======>\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u670d\u52a1\u7ed3\u675f,\u540c\u6b65\u501f\u636e\u4fe1\u606f\u7ed3\u675f,\u501f\u636e\u53f7\u4e3a:" + loanNo + "<======");
        }
    }

    private String getAccLoanSts(String acctSts, String setledDate, BigDecimal loanBalance, Map<String, String> openDayMap) {
        String accLoanSts = "1";
        try {
            String openDay;
            if (StringUtil.isStrNotEmpty((String)setledDate) && TimeUtil.compareDates((String)(openDay = this.getSysOpenDay(openDayMap)), (String)setledDate) > -1) {
                accLoanSts = "4";
            }
            if (loanBalance.compareTo(BigDecimal.ZERO) < 1) {
                accLoanSts = "4";
            }
            if (!"4".equals(accLoanSts)) {
                accLoanSts = SDicToLocal.getLocalSysDicVal((String)"AccStatus", (String)acctSts);
            }
        }
        catch (Exception e) {
            logger.error("\u8fd8\u6b3e\u6210\u529f\u66f4\u65b0\u501f\u636e\u4fe1\u606f\u65f6\uff0c\u83b7\u53d6\u53f0\u8d26\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
        return accLoanSts;
    }

    private String getMinOverdueDate(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        List resultList = loanRepayPlanVOs.stream().filter(lrpvo -> "O".equals(lrpvo.getStatus())).sorted(Comparator.comparing(LoanRepayPlanVO::getTerm)).collect(Collectors.toList());
        if (null == resultList || resultList.isEmpty()) {
            return null;
        }
        String date = null;
        try {
            date = ((LoanRepayPlanVO)resultList.get(0)).getStmtDate();
        }
        catch (Exception e) {
            e.printStackTrace();
            date = null;
        }
        return date;
    }

    private BigDecimal getOverTimesCurrent(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        long result = loanRepayPlanVOs.stream().filter(lrpvo -> "O".equals(lrpvo.getStatus())).count();
        return new BigDecimal(result);
    }

    private BigDecimal getOverTimesTotal(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        long overTimeTotal = loanRepayPlanVOs.stream().map(LoanRepayPlanVO::getIsOverDue).filter(val -> SedNlsEnum.YesOrNo.YES.getValue().equals(val)).count();
        return new BigDecimal(overTimeTotal);
    }

    private BigDecimal getMaxTimesTotal(List<LoanRepayPlanVO> loanRepayPlanVOs) {
        List collect = loanRepayPlanVOs.stream().filter(i -> "1".equals(i.getIsOverDue())).sorted(Comparator.comparing(LoanRepayPlanVO::getTerm)).collect(Collectors.toList());
        if (loanRepayPlanVOs == null || loanRepayPlanVOs.isEmpty()) {
            return BigDecimal.ZERO;
        }
        int max = 1;
        int count = 1;
        for (int i2 = 0; i2 < collect.size() - 1; ++i2) {
            if (loanRepayPlanVOs.get(i2).getTerm() + 1 == loanRepayPlanVOs.get(i2 + 1).getTerm()) {
                max = max > ++count ? max : count;
                continue;
            }
            count = 0;
        }
        return new BigDecimal(max);
    }

    private BigDecimal getCurTerm(List<LoanRepayPlanVO> loanRepayPlanVOs, Map<String, String> openDayMap) {
        String openDay = this.getSysOpenDay(openDayMap);
        List termList = loanRepayPlanVOs.stream().filter(lrp -> TimeUtil.compareDate((String)lrp.getBeginDate(), (String)openDay) == -1 && TimeUtil.compareDate((String)lrp.getStmtDate(), (String)openDay) != -1).map(LoanRepayPlanVO::getTerm).sorted().collect(Collectors.toList());
        if (null == termList || termList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal((Integer)termList.get(0));
    }

    private String getSysOpenDay(Map<String, String> openDayMap) {
        if (openDayMap.containsKey("1001")) {
            return openDayMap.get("1001");
        }
        String openDayStr = this.pubSysInfoService.getOpenday("1001");
        openDayMap.put("1001", openDayStr);
        return openDayStr;
    }

    private boolean checkIsP(AcctDtlInfBean acctDtlInfBean) {
        Double principal = acctDtlInfBean.getPlanPrin();
        Double interest = acctDtlInfBean.getPlanInt();
        Double penalty = Double.valueOf(BigDecimal.valueOf(acctDtlInfBean.getIssuePnyInt()).add(acctDtlInfBean.getAlrdyPrvnPnyInt()).toString());
        Double comInt = Double.valueOf(BigDecimal.valueOf(acctDtlInfBean.getIssueCmpdInt()).add(acctDtlInfBean.getAlrdyPrvnCmpdInt()).toString());
        Double principalPaid = acctDtlInfBean.getActRpyPrin();
        Double interestPaid = acctDtlInfBean.getActRpyInt();
        Double penaltyPaid = acctDtlInfBean.getActRpyPnyInt();
        Double cmpdIntPaid = acctDtlInfBean.getActRpyCmpdInt();
        return Double.doubleToLongBits(principal) == Double.doubleToLongBits(principalPaid) && Double.doubleToLongBits(interest) == Double.doubleToLongBits(interestPaid) && Double.doubleToLongBits(penalty) == Double.doubleToLongBits(penaltyPaid) && Double.doubleToLongBits(comInt) == Double.doubleToLongBits(cmpdIntPaid);
    }
}

