/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.sx;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.console.service.facade.SmsTemplateService;
import com.irdstudio.efp.console.service.vo.SmsTemplateVO;
import com.irdstudio.efp.cus.service.facade.CusAcctInfoService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusAcctInfoVo;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.edoc.service.facade.yed.YedImageFileAnalysisService;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.sed.letter.ReqSedLetterBean;
import com.irdstudio.efp.esb.service.facade.sed.letter.SedLetterInformService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContNoticeVO;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.yed.YedGjjLoanService;
import com.irdstudio.efp.nls.service.facade.yed.YedSqsSignatureService;
import com.irdstudio.efp.nls.service.facade.yed.YedSxCtrSignatureService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsCreditInfoNoticeVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="yedCreditLmtService")
public class YedCreditLmtServiceImpl
extends CreditSoltServiceImpl
implements FrameworkService {
    private final Logger logger = LoggerFactory.getLogger(YedCreditLmtServiceImpl.class);
    private final String msgTemplate = "message{}";
    private final String CITY = "\u5e7f\u5dde";
    private static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"lmt$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    @Autowired
    @Qualifier(value="yedImageFileAnalysisService")
    private YedImageFileAnalysisService yedImageFileAnalysisService;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;
    @Value(value="${yed.download.url}")
    private String url;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;
    @Autowired
    @Qualifier(value="sedLetterInformService")
    private SedLetterInformService sedLetterInformService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Autowired
    @Qualifier(value="cusReferrerInfoService")
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Autowired
    private YedGjjLoanService yedGjjLoanService;
    @Autowired
    private YedSxCtrSignatureService yedSxCtrSignatureService;
    @Autowired
    private YedSqsSignatureService yedSqsSignatureService;
    @Autowired
    @Qualifier(value="cusAcctInfoService")
    private CusAcctInfoService cusAcctInfoService;
    @Autowired
    @Qualifier(value="smsTemplateService")
    private SmsTemplateService smsTemplateService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        block11: {
            String applySeq = nlsProcessBizVo.getApplySeq();
            this.logger.info("======>\u4f18e\u8d37\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
            try {
                boolean isLimitExits = this.getLimitByLmtApplySeq(nlsCreditInfoVO);
                if (!isLimitExits) break block11;
                String openday = this.pubSysInfoService.getOpenday("1001");
                String[] yedStr = this.yedSqsSignatureService.signature(nlsCreditInfoVO);
                if (!"000000".equals(yedStr[0])) {
                    throw new Exception("\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfoVO.getLmtApplySeq() + "\u7b7e\u8ba2\u7efc\u5408\u59d4\u6258\u6388\u6743\u4e66\u5f02\u5e38!");
                }
                String[] strings = this.yedSxCtrSignatureService.sxSignature(nlsCreditInfoVO);
                if (!"000000".equals(strings[0])) {
                    throw new Exception("\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfoVO.getLmtApplySeq() + "\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c\u5f02\u5e38!");
                }
                this.insertProLmtCont(nlsCreditInfoVO, openday);
                this.updateCusReferrerInfo(nlsCreditInfoVO, openday);
                this.updateCreditApplyInfo(nlsCreditInfoVO);
                SmsTemplateVO smsTemplateVO = new SmsTemplateVO();
                smsTemplateVO.setSceneNo(nlsCreditInfoVO.getChannelNo());
                smsTemplateVO = this.smsTemplateService.queryBySceneNo(smsTemplateVO);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)smsTemplateVO.getContext())) {
                    this.sendCtrMsg(nlsCreditInfoVO, smsTemplateVO);
                }
                if ("\u5e7f\u5dde".equals(nlsCreditInfoVO.getCity())) {
                    try {
                        this.insertCusAcctInfo(nlsCreditInfoVO);
                        this.yedGjjLoanService.callSyncGjjInvoteCredit(nlsCreditInfoVO);
                    }
                    catch (Exception e) {
                        this.logger.error("\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getGlobalSerno() + "\u3011\uff0c\u540c\u6b65\u516c\u79ef\u91d1\u63a5\u53e3\u5931\u8d25\uff01");
                        throw new Exception("\u6388\u4fe1\u751f\u6210\u989d\u5ea6\u540e\u540c\u6b65\u516c\u79ef\u91d1\u63a5\u53e3\u5931\u8d25");
                    }
                }
                this.sendToRisk(nlsCreditInfoVO, true);
            }
            catch (Exception e) {
                nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                nlsCreditInfoVO.setRefuseCause(e.getMessage());
                this.sendToRisk(nlsCreditInfoVO, false);
                nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
                nlsProcessBizVo.setSoltName30("1");
                nlsProcessBizVo.setRefuseMsg(e.getMessage());
                nlsProcessBizVo.setExceptionMsg(e);
            }
            finally {
                this.logger.info("======>\u4f18e\u8d37\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
            }
        }
    }

    private void updateCreditApplyInfo(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        nlsCreditInfoVO.setApprvSts("02");
        this.setServerUpdateDefaultProperty((BaseInfo)nlsCreditInfoVO);
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result == -1) {
            throw new BizException("\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void updateCreditApplyInfoErr(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        nlsCreditInfoVO.setApprvSts("03");
        this.setServerUpdateDefaultProperty((BaseInfo)nlsCreditInfoVO);
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result == -1) {
            throw new BizException("\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void insertProLmtCont(NlsCreditInfoVO nlsCreditInfoVO, String openday) throws BizException {
        Objects.requireNonNull(nlsCreditInfoVO, "\u3010\u989d\u5ea6\u751f\u6210\u63d2\u69fd\u3011\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a!!!");
        this.logger.info("======>\u3010\u989d\u5ea6\u751f\u6210\u63d2\u69fd\u3011\u63d2\u5165\u6388\u4fe1\u534f\u8bae\u8868\u5f00\u59cb" + nlsCreditInfoVO.getLmtApplySeq() + "<======");
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtContNo(this.generateLmtContNo());
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO.setCusId(nlsCreditInfoVO.getCusId());
        lmtPrdContVO.setCusName(nlsCreditInfoVO.getCusName());
        lmtPrdContVO.setCertType(nlsCreditInfoVO.getCertType());
        lmtPrdContVO.setCertCode(nlsCreditInfoVO.getCertCode());
        lmtPrdContVO.setChannelNo(nlsCreditInfoVO.getChannelNo());
        lmtPrdContVO.setPrdId(nlsCreditInfoVO.getPrdId());
        lmtPrdContVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        lmtPrdContVO.setPrdName(nlsCreditInfoVO.getPrdName());
        lmtPrdContVO.setLmtAmt(nlsCreditInfoVO.getApproveAmt());
        lmtPrdContVO.setAvailAmt(nlsCreditInfoVO.getApproveAmt());
        lmtPrdContVO.setCyclicFlg(nlsCreditInfoVO.getCyclicFlg());
        lmtPrdContVO.setCurrencyType(nlsCreditInfoVO.getCurrencyType());
        if (!StringUtil.isNullorBank((String)nlsCreditInfoVO.getApplyTerm())) {
            lmtPrdContVO.setTerm(new BigDecimal(nlsCreditInfoVO.getApplyTerm()));
        }
        lmtPrdContVO.setTermType(nlsCreditInfoVO.getTermType());
        lmtPrdContVO.setAssureMeansMain(nlsCreditInfoVO.getAssureMeansMain());
        lmtPrdContVO.setLmtStatus("02");
        lmtPrdContVO.setRateY(nlsCreditInfoVO.getApproveRateY());
        lmtPrdContVO.setStartDate(openday);
        try {
            lmtPrdContVO.setExpireDate(TimeUtil.addMonth((String)openday, (int)12));
        }
        catch (Exception e) {
            throw new BizException("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\u5230\u671f\u65e5\u671f\u8bbe\u7f6e\u5931\u8d25!!!");
        }
        CusReferrerInfoVO cusReferrerInfoVO = new CusReferrerInfoVO();
        CusReferrerInfoVO cusReferrerInfoVO2 = CusReferrerInfoVO.builder().lmtApplySeq(nlsCreditInfoVO.getLmtApplySeq()).build();
        try {
            cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusReferrerInfoVO2);
        }
        catch (Exception e) {
            this.logger.info("======>\u67e5\u8be2\u63a8\u8350\u4eba\u4fe1\u606f\u5f02\u5e38----------");
        }
        this.logger.info("======>\u3010\u63a8\u8350\u4eba\u4fe1\u606f\u3011cusReferrerInfoVO----" + cusReferrerInfoVO);
        if (!StringUtils.isEmpty((Object)cusReferrerInfoVO)) {
            this.logger.info("======\u8bbe\u7f6e\u51fa\u8d26\u7ba1\u6237\u673a\u6784\u503c----");
            lmtPrdContVO.setChargeoffBrId(cusReferrerInfoVO.getChargeOffBrId());
            lmtPrdContVO.setMainBrId(cusReferrerInfoVO.getMainBrId());
        }
        this.setServerInsertDefaultProperty((BaseInfo)lmtPrdContVO);
        lmtPrdContVO.setLegalOrgCode("00010");
        lmtPrdContVO.setLegalOrgName("\u5e7f\u5dde\u94f6\u884c\u667a\u6167\u4e2d\u5fc3");
        lmtPrdContVO.setAccountDate(openday);
        int result = this.lmtPrdContService.insertLmtPrdCont(lmtPrdContVO);
        if (result == -1) {
            throw new BizException("=======>\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u751f\u6210\u989d\u5ea6\u63d2\u69fd,\u63d2\u5165\u672a\u751f\u6548\u7684\u989d\u5ea6\u4fe1\u606f\u5931\u8d25<=======", "message{}");
        }
        this.sendToRisk(lmtPrdContVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(LmtPrdContVO lmtPrdContVO) {
        String applySeq = lmtPrdContVO.getLmtApplySeq();
        this.logger.info("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("credit")) continue;
                flag = true;
            }
            LmtPrdContNoticeVO array = new LmtPrdContNoticeVO();
            JSONObject jsonObject = new JSONObject();
            array.setTableName("LMT_PRD_CONT");
            array.setLmtApplySeq(lmtPrdContVO.getLmtApplySeq());
            array.setLmtContNo(lmtPrdContVO.getLmtContNo());
            array.setCreateTime(lmtPrdContVO.getCreateTime());
            array.setLmtAmt(lmtPrdContVO.getLmtAmt());
            array.setTerm(lmtPrdContVO.getTerm());
            array.setRateY(lmtPrdContVO.getRateY());
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            array.setDataTime(timeStamp);
            array.setDeliverTime(timeStamp);
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedCreditLmtServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", (Object)array);
            if (!flag) {
                this.logger.info("\u5b9e\u65f6\u91c7\u96c6\u5f00\u5173\u672a\u6253\u5f00\uff01\uff01\uff01");
                return;
            }
            this.threadPool.add(() -> {
                KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                try {
                    kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            this.logger.info("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            this.logger.error("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(NlsCreditInfoVO nlsCreditInfoVO, boolean sucessOrFail) {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        this.logger.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("credit")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            NlsCreditInfoVO creditInfoVO = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
            NlsCreditInfoNoticeVO array = new NlsCreditInfoNoticeVO();
            array.setTableName("NLS_CREDIT_INFO");
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            array.setLmtApplySeq(creditInfoVO.getLmtApplySeq());
            if (sucessOrFail) {
                array.setRefuseCause("");
                array.setApprvSts(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE());
                nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE());
                nlsCreditInfoVO.setRefuseCause("");
            } else {
                array.setRefuseCause("\u7f51\u8d37\u6388\u6743\u4e66\u6216\u8005\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u5931\u8d25\u6216\u8005\u989d\u5ea6\u751f\u6210\u5931\u8d25\uff0c\u6388\u4fe1\u62d2\u7edd");
                array.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                nlsCreditInfoVO.setRefuseCause("\u7f51\u8d37\u6388\u6743\u4e66\u6216\u8005\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u5931\u8d25\u6216\u8005\u989d\u5ea6\u751f\u6210\u5931\u8d25\uff0c\u6388\u4fe1\u62d2\u7edd");
            }
            array.setWrkCorpNm(creditInfoVO.getWrkCorpNm());
            array.setDataTime(timeStamp);
            array.setDeliverTime(timeStamp);
            array.setCusName(creditInfoVO.getCusName());
            array.setGender(creditInfoVO.getGender());
            array.setNational(creditInfoVO.getNational());
            array.setMrgSitu(creditInfoVO.getMrgSitu());
            array.setEdu(creditInfoVO.getEdu());
            array.setProfession(creditInfoVO.getProfession());
            array.setIndivComJobTtl(creditInfoVO.getIndivComJobTtl());
            array.setCertType(creditInfoVO.getCertType());
            array.setCertCode(creditInfoVO.getCertCode());
            array.setCertEndDt(creditInfoVO.getCertEndDt());
            array.setIndivMobile(creditInfoVO.getIndivMobile());
            array.setIndivRsdAddr(creditInfoVO.getIndivRsdAddr());
            array.setIndivComFld(creditInfoVO.getIndivComFld());
            array.setWrkCorpAddr(creditInfoVO.getWrkCorpAddr());
            array.setApplyDate(timeStamp);
            array.setChannelNo(creditInfoVO.getChannelNo());
            array.setApproveAmt(creditInfoVO.getApproveAmt() == null ? BigDecimal.valueOf(0L) : creditInfoVO.getApproveAmt());
            array.setApprvDate(creditInfoVO.getApprvDate());
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedCreditLmtServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", (Object)array);
            this.logger.info("\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + applySeq + "\u53d1\u9001\u98ce\u63a7\u7684\u4fe1\u606f\u4e3a\uff1a" + JSONObject.toJSONString((Object)array));
            if (!flag) {
                this.logger.info("\u5b9e\u65f6\u91c7\u96c6\u5f00\u5173\u672a\u6253\u5f00\uff01\uff01\uff01");
                return;
            }
            this.threadPool.add(() -> {
                KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                try {
                    kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            this.logger.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            this.logger.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }

    private boolean getLimitByLmtApplySeq(NlsCreditInfoVO nlsCreditInfoVO) {
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
        return lmtPrdContVO == null;
    }

    private String generateLmtContNo() {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("LMT", PATTERN);
    }

    private void sendCtrMsg(NlsCreditInfoVO nlsCreditInfoVO, SmsTemplateVO smsTemplateVO) {
        String context = smsTemplateVO.getContext();
        Object[] array = new String[]{nlsCreditInfoVO.getCusName(), nlsCreditInfoVO.getPrdName(), String.valueOf(nlsCreditInfoVO.getApproveAmt()), this.url};
        String msg = MessageFormat.format(context, array);
        ReqSedLetterBean reqSedLetterBean = new ReqSedLetterBean();
        reqSedLetterBean.setShrtMsgPrtyLvl("08#");
        reqSedLetterBean.setMblNo(nlsCreditInfoVO.getIndivMobile());
        reqSedLetterBean.setCntntInf(msg);
        try {
            this.sedLetterInformService.sendLetter(reqSedLetterBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4f18e\u8d37\u6388\u4fe1\u901a\u8fc7\u4e0b\u53d1\u77ed\u4fe1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void updateCusReferrerInfo(NlsCreditInfoVO nlsCreditInfoVO, String openday) throws BizException {
        String expireDate = "";
        try {
            expireDate = TimeUtil.addMonth((String)openday, (int)12);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CusReferrerInfoVO cus = CusReferrerInfoVO.builder().lmtApplySeq(nlsCreditInfoVO.getLmtApplySeq()).wrkCorpNm(nlsCreditInfoVO.getWrkCorpNm()).startDate(openday).expireDate(expireDate).lastModifyTime(TimeUtil.getCurrentDateTime()).build();
        int result = this.cusReferrerInfoService.updateByPk(cus);
        if (result == -1) {
            throw new BizException("=======>\u3010\u4f18e\u8d37\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u66f4\u65b0\u5ba2\u6237\u63a8\u8350\u4eba\u4fe1\u606f\u8868\u5931\u8d25<=======");
        }
    }

    private void insertCusAcctInfo(NlsCreditInfoVO nlsCreditInfoVO) {
        CusAcctInfoVo acctInfoVo = new CusAcctInfoVo();
        try {
            acctInfoVo.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            List cusAcctInfoVos = this.cusAcctInfoService.queryByLmtApplySeq(acctInfoVo);
            if (cusAcctInfoVos.isEmpty()) {
                acctInfoVo.setGlobalSerno(nlsCreditInfoVO.getGlobalSerno());
                acctInfoVo.setCusId(nlsCreditInfoVO.getCusId());
                acctInfoVo.setCusName(nlsCreditInfoVO.getCusName());
                acctInfoVo.setCertType(nlsCreditInfoVO.getCertType());
                acctInfoVo.setCertCode(nlsCreditInfoVO.getCertCode());
                acctInfoVo.setPrdCode(nlsCreditInfoVO.getPrdCode());
                acctInfoVo.setPrdName(nlsCreditInfoVO.getPrdName());
                acctInfoVo.setCity(nlsCreditInfoVO.getCity());
                acctInfoVo.setCreditApplyTime(DateUtility.getCurrDateTime());
                acctInfoVo.setApprvSts(nlsCreditInfoVO.getApprvSts());
                this.cusAcctInfoService.insert(acctInfoVo);
            }
        }
        catch (Exception e) {
            this.logger.error("\u63d2\u5165\u5ba2\u6237\u516c\u79ef\u91d1\u4fe1\u606f\u8868\u9519\u8bef\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a" + nlsCreditInfoVO.getLmtApplySeq() + "\u9519\u8bef\u4fe1\u606f\u4e3a" + e.getMessage());
        }
    }
}

