/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.sx;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.efp.console.common.YedConstantSet;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizDetailVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizInfoVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.ImageBizDetailService;
import com.irdstudio.efp.edoc.service.facade.ImageBizInfoService;
import com.irdstudio.efp.edoc.service.facade.signature.YedContResult;
import com.irdstudio.efp.edoc.service.facade.signature.YedContService;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.nls.service.dao.SignatureRecordDao;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.SignatureRecord;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditInfo;
import com.irdstudio.efp.nls.service.facade.yed.YedSqsSignatureService;
import com.irdstudio.efp.nls.service.vo.SignatureRecordVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedSqsSignatureService")
public class YedSqsSignatureServiceImpl
implements YedSqsSignatureService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(YedSqsSignatureServiceImpl.class);
    @Autowired
    private SignatureRecordDao signatureRecordDAO;
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    private SCfgParamService sCfgParamService;
    @Autowired
    private YedContService yedContService;
    @Autowired
    private YedUploadService yedUploadService;
    @Autowired
    private CusIndivService cusIndivService;
    @Autowired
    private ImageBizDetailService imageBizDetailService;
    @Autowired
    private ImageBizInfoService imageBizInfoService;

    public Boolean signature() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5728\u7ebf\u7b7e\u7ae0");
        int[] handleNumArr = this.getHandleNumArr();
        List<SignatureRecord> SignatureRecords = this.signatureRecordDAO.getSignatureNlsList("XD050300703", handleNumArr[1], YedConstantSet.YED_FILE_TYPE_03, handleNumArr[0]);
        if (SignatureRecords == null || SignatureRecords.isEmpty()) {
            logger.info("\u5728\u7ebf\u7b7e\u7ae0\uff1a\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a");
            return Boolean.TRUE;
        }
        for (SignatureRecord signatureRecord : SignatureRecords) {
            try {
                signatureRecord.setRetryNum(signatureRecord.getRetryNum() + 1);
                if (signatureRecord.getSiuSta() == 1) continue;
                String applySeq = signatureRecord.getApplySeq();
                NlsCreditInfo pkParam = new NlsCreditInfo();
                pkParam.setLmtApplySeq(applySeq);
                NlsCreditInfo nlsCreditInfo = this.nlsCreditInfoDao.queryByPk(pkParam);
                if (Objects.isNull((Object)nlsCreditInfo)) {
                    if (signatureRecord.getSiuSta() == 0) {
                        signatureRecord.setSiuSta(2);
                    }
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setErrMsg("\u67e5\u8be2\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                    this.signatureRecordDAO.updateByPk(signatureRecord);
                    continue;
                }
                if (signatureRecord.getSiuSta() == 3) {
                    YedContResult yedContResult = this.yedContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), signatureRecord.getSiuContNo(), nlsCreditInfo.getLmtApplySeq() + "_yed_sqs.pdf");
                    if (yedContResult.isRetFlag()) {
                        signatureRecord.setSiuSta(1);
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                        this.signatureRecordDAO.updateByPk(signatureRecord);
                        this.insertUploadRecord(nlsCreditInfo, yedContResult.getFileFullPath());
                        this.insertCfcaSignInfo(yedContResult, nlsCreditInfo, signatureRecord.getSiuContNo());
                        this.insertImageBizDetail(nlsCreditInfo, YedConstantSet.YED_FILE_TYPE_03, FilenameUtils.getBaseName((String)yedContResult.getFileFullPath()), yedContResult.getFileFullPath());
                        this.insertImageBizInfo(nlsCreditInfo);
                        continue;
                    }
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(yedContResult.getMsg());
                    this.signatureRecordDAO.updateByPk(signatureRecord);
                    continue;
                }
                if (signatureRecord.getSiuSta() != 0 && signatureRecord.getSiuSta() != 2) continue;
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("cusName", nlsCreditInfo.getCusName());
                paramMap.put("cusCertCode", nlsCreditInfo.getCertCode());
                paramMap.put("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
                YedContResult signatureResult = this.yedContService.signature(nlsCreditInfo.getGlobalSerno(), nlsCreditInfo.getLmtApplySeq(), this.getAxqUserId(nlsCreditInfo), "yed_sqs.pdf", "\u4e2a\u4eba\u6388\u6743\u4e66", paramMap);
                if (signatureResult.isRetFlag()) {
                    signatureRecord.setSiuContNo(signatureResult.getAxqContNo());
                    signatureRecord.setSiuRetMsg("\u7b7e\u7f72\u6388\u6743\u4e66\u6210\u529f");
                    YedContResult yedContResult = this.yedContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), signatureRecord.getSiuContNo(), nlsCreditInfo.getLmtApplySeq() + "_yed_sqs.pdf");
                    if (yedContResult.isRetFlag()) {
                        signatureRecord.setSiuSta(1);
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                        this.signatureRecordDAO.updateByPk(signatureRecord);
                        this.insertCfcaSignInfo(yedContResult, nlsCreditInfo, signatureRecord.getSiuContNo());
                        this.insertUploadRecord(nlsCreditInfo, yedContResult.getFileFullPath());
                        this.insertImageBizDetail(nlsCreditInfo, YedConstantSet.YED_FILE_TYPE_03, FilenameUtils.getBaseName((String)yedContResult.getFileFullPath()), yedContResult.getFileFullPath());
                        this.insertImageBizInfo(nlsCreditInfo);
                        continue;
                    }
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(yedContResult.getMsg());
                    this.signatureRecordDAO.updateByPk(signatureRecord);
                    continue;
                }
                signatureRecord.setSiuSta(2);
                signatureRecord.setSiuRetMsg(signatureResult.getMsg());
                signatureRecord.setLastUpdateTime(new Date());
                this.signatureRecordDAO.updateByPk(signatureRecord);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7b7e\u7ae0\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                signatureRecord.setErrMsg(e.getMessage());
                this.signatureRecordDAO.updateByPk(signatureRecord);
            }
        }
        return Boolean.TRUE;
    }

    private String getAxqUserId(NlsCreditInfo nlsCreditInfo) throws Exception {
        YedContResult openAccountResult = this.yedContService.openAccount(nlsCreditInfo.getCusName(), nlsCreditInfo.getCertType(), nlsCreditInfo.getCertCode(), nlsCreditInfo.getEmail(), nlsCreditInfo.getIndivMobile(), nlsCreditInfo.getIndivRsdAddr(), nlsCreditInfo.getLmtApplySeq());
        if (openAccountResult.isRetFlag()) {
            return openAccountResult.getAxqUserId();
        }
        throw new Exception(openAccountResult.getMsg());
    }

    public Integer insertRecord(SignatureRecordVO signatureRecordVO) {
        SignatureRecord signatureRecord = this.signatureRecordDAO.selectByPst(signatureRecordVO.getPrdId(), signatureRecordVO.getApplySeq(), signatureRecordVO.getLinkType());
        if (!Objects.isNull((Object)signatureRecord)) {
            return 0;
        }
        return this.signatureRecordDAO.insert((SignatureRecord)((Object)this.beanCopy(signatureRecordVO, (Object)new SignatureRecord())));
    }

    public Integer updateOperInfo(String lmtAppSeq, String userId, String orgId) {
        CfcaSignInfoVO pkParam = new CfcaSignInfoVO();
        pkParam.setApplySeq(lmtAppSeq + "_sqs");
        CfcaSignInfoVO cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(pkParam);
        if (Objects.isNull(cfcaSignInfoVO)) {
            return 0;
        }
        cfcaSignInfoVO.setNlsOperOrgid(orgId);
        cfcaSignInfoVO.setNlsOperUserid(userId);
        cfcaSignInfoVO.setFinaBrId(orgId);
        return this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
    }

    private void insertCfcaSignInfo(YedContResult yedContResult, NlsCreditInfo nlsCreditInfo, String cfcaContNo) {
        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
        cfcaSignInfoVO.setApplySeq(nlsCreditInfo.getLmtApplySeq() + "_sqs");
        cfcaSignInfoVO.setPrdId(nlsCreditInfo.getPrdId());
        cfcaSignInfoVO.setPrdCode(nlsCreditInfo.getPrdCode());
        cfcaSignInfoVO.setPrdName(nlsCreditInfo.getPrdName());
        cfcaSignInfoVO.setContNo(nlsCreditInfo.getLmtApplySeq());
        cfcaSignInfoVO.setCfcaContNo(cfcaContNo);
        cfcaSignInfoVO.setCusId(nlsCreditInfo.getCusId());
        cfcaSignInfoVO.setCusName(nlsCreditInfo.getCusName());
        cfcaSignInfoVO.setFinaBrId(nlsCreditInfo.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperOrgid(nlsCreditInfo.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperUserid(nlsCreditInfo.getNlsOperUserid());
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        cfcaSignInfoVO.setCfcaSignTime(yedContResult.getAxqSignTime());
        this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
    }

    private int[] getHandleNumArr() {
        int[] result = new int[2];
        try {
            SCfgParamVO param = new SCfgParamVO();
            param.setParamKey("YED_FILE_HANDLE_NUM");
            SCfgParamVO maxNumCfg = this.sCfgParamService.queryByPk(param);
            result[0] = Objects.isNull(maxNumCfg) ? 50 : Integer.parseInt(maxNumCfg.getParamValue());
            param.setParamKey("YED_UP_RETRY_NUM");
            SCfgParamVO retryNumCfg = this.sCfgParamService.queryByPk(param);
            result[1] = Objects.isNull(retryNumCfg) ? 3 : Integer.parseInt(retryNumCfg.getParamValue());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void insertImageBizDetail(NlsCreditInfo nlsCreditInfoVO, String imgType, String fileName, String filePath) {
        ImageBizDetailVO imageBizDetail = new ImageBizDetailVO();
        imageBizDetail.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizDetail.setBizStage("\u6388\u4fe1\u9636\u6bb5");
        imageBizDetail.setFileDesc("\u4f18e\u8d37\u4e2a\u4eba\u6388\u6743\u4e66");
        imageBizDetail.setFileName(fileName);
        imageBizDetail.setFilePath(filePath);
        imageBizDetail.setImageId(imgType);
        imageBizDetail.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizDetail.setImageType(imgType);
        this.imageBizDetailService.insertImageBizDetail(imageBizDetail);
    }

    private void insertImageBizInfo(NlsCreditInfo nlsCreditInfoVO) {
        ImageBizInfoVO param = new ImageBizInfoVO();
        param.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        if (!Objects.isNull(this.imageBizInfoService.queryByPk(param))) {
            return;
        }
        ImageBizInfoVO imageBizInfo = new ImageBizInfoVO();
        imageBizInfo.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizInfo.setCreateDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        imageBizInfo.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizInfo.setCusId(nlsCreditInfoVO.getCusId());
        imageBizInfo.setCusName(nlsCreditInfoVO.getCusName());
        imageBizInfo.setPrdId(nlsCreditInfoVO.getPrdId());
        imageBizInfo.setPrdCode(nlsCreditInfoVO.getPrdCode());
        imageBizInfo.setPrdName(nlsCreditInfoVO.getPrdName());
        imageBizInfo.setSoltImageAccept("");
        imageBizInfo.setSoltImageCfca("");
        imageBizInfo.setSoltImageThird1("");
        imageBizInfo.setSoltImageThird2("");
        this.imageBizInfoService.insertOrUpdateImageBizInfoVO(imageBizInfo);
    }

    public void insertUploadRecord(NlsCreditInfo nlsCreditInfo, String fpath) {
        YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
        yedUploadRecordVO.setApplSeq(nlsCreditInfo.getLmtApplySeq());
        yedUploadRecordVO.setCreateTime(new Date());
        yedUploadRecordVO.setDealType("1");
        yedUploadRecordVO.setFileType("Y01");
        yedUploadRecordVO.setFileUrl(fpath);
        yedUploadRecordVO.setPrdId(nlsCreditInfo.getPrdId());
        yedUploadRecordVO.setUpErrMsg("");
        yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
        yedUploadRecordVO.setUpNum(Integer.valueOf(0));
        yedUploadRecordVO.setUpSta(Integer.valueOf(0));
        yedUploadRecordVO.setUpTime(new Date());
        this.yedUploadService.insert(yedUploadRecordVO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] signature(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5728\u7ebf\u7b7e\u7ae0");
        SignatureRecord signatureRecord = this.signatureRecordDAO.selectByPst("XD050300703", nlsCreditInfoVO.getLmtApplySeq(), 1);
        if (signatureRecord == null) {
            logger.info("\u5728\u7ebf\u7b7e\u7ae0\uff1a\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a");
            return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), "\u6388\u6743\u4e66\u7b7e\u7ae0\u5185\u5bb9\u4e3a\u7a7a"};
        }
        try {
            signatureRecord.setRetryNum(signatureRecord.getRetryNum() + 1);
            String applySeq = signatureRecord.getApplySeq();
            NlsCreditInfo pkParam = new NlsCreditInfo();
            pkParam.setLmtApplySeq(applySeq);
            NlsCreditInfo nlsCreditInfo = this.nlsCreditInfoDao.queryByPk(pkParam);
            if (Objects.isNull((Object)nlsCreditInfo)) {
                if (signatureRecord.getSiuSta() == 0) {
                    signatureRecord.setSiuSta(2);
                }
                signatureRecord.setLastUpdateTime(new Date());
                signatureRecord.setErrMsg("\u67e5\u8be2\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                this.signatureRecordDAO.updateByPk(signatureRecord);
                return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), "\u7b7e\u8ba2\u6388\u6743\u4e66-\u6388\u4fe1\u8868\u4fe1\u606f\u4e3a\u7a7a"};
            }
            if (signatureRecord.getSiuSta() == 3) {
                YedContResult yedContResult = null;
                try {
                    yedContResult = this.yedContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), signatureRecord.getSiuContNo(), nlsCreditInfo.getLmtApplySeq() + "_yed_sqs.pdf");
                }
                catch (Exception e) {
                    logger.error(yedContResult.getMsg());
                    throw new OcmSystemException(yedContResult.getMsg());
                }
                logger.error("\u7b7e\u8ba2\u6388\u6743\u4e66-\u5408\u540c\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}],\u4e0b\u8f7d\u7ed3\u679c\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq(), (Object)yedContResult.toString());
                if (!yedContResult.isRetFlag()) {
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(yedContResult.getMsg());
                    this.signatureRecordDAO.updateByPk(signatureRecord);
                    return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), yedContResult.getMsg()};
                }
                signatureRecord.setSiuSta(1);
                signatureRecord.setLastUpdateTime(new Date());
                signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                this.signatureRecordDAO.updateByPk(signatureRecord);
                this.insertUploadRecord(nlsCreditInfo, yedContResult.getFileFullPath());
                this.insertCfcaSignInfo(yedContResult, nlsCreditInfo, signatureRecord.getSiuContNo());
                this.insertImageBizDetail(nlsCreditInfo, YedConstantSet.YED_FILE_TYPE_03, FilenameUtils.getBaseName((String)yedContResult.getFileFullPath()), yedContResult.getFileFullPath());
                this.insertImageBizInfo(nlsCreditInfo);
            }
            if (signatureRecord.getSiuSta() == 0 || signatureRecord.getSiuSta() == 2) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("cusName", nlsCreditInfo.getCusName());
                paramMap.put("cusCertCode", nlsCreditInfo.getCertCode());
                paramMap.put("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
                YedContResult signatureResult = null;
                try {
                    signatureResult = this.yedContService.signature(nlsCreditInfo.getGlobalSerno(), nlsCreditInfo.getLmtApplySeq(), this.getAxqUserId(nlsCreditInfo), "yed_sqs.pdf", "\u4e2a\u4eba\u6388\u6743\u4e66", paramMap);
                }
                catch (Exception e) {
                    logger.error(signatureResult.getMsg());
                    throw new OcmSystemException(signatureResult.getMsg());
                }
                if (!signatureResult.isRetFlag()) {
                    signatureRecord.setSiuSta(2);
                    signatureRecord.setSiuRetMsg(signatureResult.getMsg());
                    signatureRecord.setLastUpdateTime(new Date());
                    this.signatureRecordDAO.updateByPk(signatureRecord);
                    return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), "\u5c0a\u656c\u7684\u5ba2\u6237\u60a8\u597d\uff0c\u7531\u4e8e\u7cfb\u7edf\u5728\u5904\u7406\u6388\u6743\u4e66\u7b7e\u7ae0\u51fa\u73b0\u4e86\u5f02\u5e38\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5"};
                }
                signatureRecord.setSiuContNo(signatureResult.getAxqContNo());
                signatureRecord.setSiuRetMsg("\u7b7e\u7f72\u6388\u6743\u4e66\u6210\u529f");
                YedContResult yedContResult = null;
                try {
                    yedContResult = this.yedContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), signatureRecord.getSiuContNo(), nlsCreditInfo.getLmtApplySeq() + "_yed_sqs.pdf");
                }
                catch (Exception e) {
                    logger.error(yedContResult.getMsg());
                    throw new OcmSystemException(yedContResult.getMsg());
                }
                if (!yedContResult.isRetFlag()) {
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(yedContResult.getMsg());
                    this.signatureRecordDAO.updateByPk(signatureRecord);
                    return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), "\u5c0a\u656c\u7684\u5ba2\u6237\u60a8\u597d\uff0c\u7531\u4e8e\u7cfb\u7edf\u5728\u5904\u7406\u6388\u6743\u4e66\u4e0b\u8f7d\u51fa\u73b0\u4e86\u5f02\u5e38\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5"};
                }
                signatureRecord.setSiuSta(1);
                signatureRecord.setLastUpdateTime(new Date());
                signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                this.signatureRecordDAO.updateByPk(signatureRecord);
                this.insertCfcaSignInfo(yedContResult, nlsCreditInfo, signatureRecord.getSiuContNo());
                this.insertUploadRecord(nlsCreditInfo, yedContResult.getFileFullPath());
                this.insertImageBizDetail(nlsCreditInfo, YedConstantSet.YED_FILE_TYPE_03, FilenameUtils.getBaseName((String)yedContResult.getFileFullPath()), yedContResult.getFileFullPath());
                this.insertImageBizInfo(nlsCreditInfo);
            }
            return new String[]{"000000", "\u4f18e\u8d37\u6388\u6743\u4e66\u7b7e\u8ba2\u6210\u529f"};
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u7b7e\u7ae0\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            signatureRecord.setErrMsg(e.getMessage());
            this.signatureRecordDAO.updateByPk(signatureRecord);
            return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), e.getMessage()};
        }
    }
}

