/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.sx;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.Amount2RMB;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.console.common.YedConstantSet;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.console.service.facade.SOrgService;
import com.irdstudio.efp.console.service.vo.SOrgVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizDetailVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizInfoVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.ImageBizDetailService;
import com.irdstudio.efp.edoc.service.facade.ImageBizInfoService;
import com.irdstudio.efp.edoc.service.facade.signature.YedContResult;
import com.irdstudio.efp.edoc.service.facade.signature.YedContService;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditInfo;
import com.irdstudio.efp.nls.service.facade.psd.NlsCreditApprovalInfoService;
import com.irdstudio.efp.nls.service.facade.yed.YedSxCtrSignatureService;
import com.irdstudio.efp.nls.service.vo.psd.NlsCreditApprovalInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedSxCtrSignatureService")
public class YedSxCtrSignatureServiceImpl
implements YedSxCtrSignatureService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(YedSxCtrSignatureServiceImpl.class);
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;
    @Autowired
    @Qualifier(value="sOrgService")
    private SOrgService sOrgService;
    @Autowired
    private YedContService yedContService;
    @Autowired
    private YedUploadService yedUploadService;
    @Autowired
    private NlsCreditApprovalInfoService nlsCreditApprovalInfoService;
    @Autowired
    private PubSysInfoService pubSysInfoService;
    private boolean updateCtrStatusFlag = false;
    @Autowired
    private ImageBizDetailService imageBizDetailService;
    @Autowired
    private ImageBizInfoService imageBizInfoService;
    @Autowired
    private CusReferrerInfoService cusReferrerInfoService;

    public String[] sxSignature(NlsCreditInfoVO nlsCreditInfoVO) {
        logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u83b7\u53d6\u5230\u5f97\u4fe1\u606f\u4e3a\uff1a[{}]", (Object)JSONObject.toJSONString((Object)nlsCreditInfoVO));
        NlsCreditInfo nlsCreditInfo = null;
        LmtPrdContVO lmtPrdContVO = null;
        CusIndivVO custInfoVo = null;
        CfcaSignInfoVO cfcaSignInfoVO = null;
        CtrLoanContVO ctrLoanContVO = null;
        try {
            String openday = this.pubSysInfoService.getOpenday("1001");
            if (StringUtils.isEmpty((CharSequence)openday)) {
                logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c\u6d41\u7a0b\u83b7\u53d6\u5230\u7684openday\u4e3a\u7a7a\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u5c0a\u656c\u7684\u5ba2\u6237\u60a8\u597d\uff0c\u7531\u4e8e\u7cfb\u7edf\u5f02\u5e38\u672c\u6b21\u7b7e\u8ba2\u5408\u540c\u5931\u8d25\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5");
            }
            nlsCreditInfo = this.nlsCreditInfoDao.queryByLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            if (Objects.isNull((Object)nlsCreditInfo)) {
                logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c\u6d41\u7a0b\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u6839\u636e\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
            }
            NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(nlsCreditInfo.getLmtApplySeq());
            if (!"Y".equals(nlsCreditApprovalInfoVO.getApprResult())) {
                logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c\u6d41\u7a0b\u5224\u65ad\u5ba1\u6279\u901a\u8fc7\u5df2\u7ecf\u8d85\u8fc7\u4e8690\u5929\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u4e0d\u5408\u6cd5\u7684\u5408\u540c\u7b7e\u7f72\u8bf7\u6c42\uff0c\u98ce\u63a7\u5ba1\u6279\u72b6\u6001\u4e0d\u4e3a\u6210\u529f");
            }
            if (TimeUtil.compareDates((String)TimeUtil.addDay((String)new SimpleDateFormat("yyyy-MM-dd").format(nlsCreditApprovalInfoVO.getApproveTime()), (int)90), (String)DateTool.getCurrentDateTime()) < 0) {
                logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c\u6d41\u7a0b\u5224\u65ad\u98ce\u63a7\u5ba1\u6279\u901a\u8fc7\u65f6\u95f4\u5df2\u7ecf\u67e5\u8fc7\u4e8690\u5929\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq());
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u98ce\u63a7\u5ba1\u6279\u901a\u8fc7\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc7\u4e8690\u5929\uff0c\u65e0\u6cd5\u8fdb\u884c\u5408\u540c\u7b7e\u8ba2");
            }
            custInfoVo = this.getCustInfo(nlsCreditInfo.getCusId());
            if (Objects.isNull(custInfoVo)) {
                throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u83b7\u53d6\u5ba2\u6237\u5230\u7684\u4fe1\u606f\u4e3a\u7a7a");
            }
            ctrLoanContVO = this.ctrLoanContService.queryContNoByLmtContNoAndContype(nlsCreditInfo.getLmtApplySeq(), "01");
            if (!Objects.isNull(ctrLoanContVO)) {
                if ("200".equals(ctrLoanContVO.getContState())) {
                    throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u5f53\u524d\u6388\u4fe1\u8bb0\u5f55\u5df2\u7ecf\u6210\u529f\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c\uff0c\u65e0\u9700\u518d\u6b21\u7533\u8bf7");
                }
                if (!"101".equals(ctrLoanContVO.getContState())) {
                    throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u4e0d\u4e3a\u5f85\u7b7e\u8ba2\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u5408\u540c\u7b7e\u8ba2");
                }
            } else {
                ctrLoanContVO = this.insertLoanCtrContract(openday, nlsCreditInfo, custInfoVo);
            }
            CfcaSignInfoVO cfcaPkParam = new CfcaSignInfoVO();
            cfcaPkParam.setApplySeq(nlsCreditInfo.getLmtApplySeq());
            cfcaPkParam.setContNo(nlsCreditInfo.getLmtApplySeq());
            List cfcaSignInfoVOS = this.cfcaSignInfoService.queryByApplyAndContNo(cfcaPkParam);
            if (cfcaSignInfoVOS != null && !cfcaSignInfoVOS.isEmpty()) {
                YedContResult downResult = this.yedContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), ((CfcaSignInfoVO)cfcaSignInfoVOS.get(0)).getCfcaContNo(), nlsCreditInfo.getLmtApplySeq() + "_yed_sxcont.pdf");
                logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c-\u5408\u540c\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}],\u4e0b\u8f7d\u7ed3\u679c\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq(), (Object)downResult.toString());
                if (downResult.isRetFlag()) {
                    this.updateCtrStatus(ctrLoanContVO, "200");
                    this.updateArrpvDateAndLmtDate(nlsCreditInfo, lmtPrdContVO, openday);
                    this.insertUploadRecord(nlsCreditInfo, downResult.getFileFullPath());
                    this.insertImageBizDetail(nlsCreditInfo, YedConstantSet.YED_SX_CONT_TYPE, FilenameUtils.getName((String)downResult.getFileFullPath()), downResult.getFileFullPath());
                    this.insertImageBizInfo(nlsCreditInfo);
                    return new String[]{"000000", "\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u6210\u529f"};
                }
                return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), downResult.getMsg()};
            }
            if (StringUtils.isEmpty((CharSequence)custInfoVo.getAxqUsrId())) {
                this.execute3001(nlsCreditInfo, custInfoVo);
            }
            cfcaSignInfoVO = new CfcaSignInfoVO();
            this.execute3203(nlsCreditInfo, custInfoVo, lmtPrdContVO, "01", cfcaSignInfoVO, openday);
            YedContResult downResult = this.yedContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), cfcaSignInfoVO.getCfcaContNo(), nlsCreditInfo.getLmtApplySeq() + "_yed_sxcont.pdf");
            logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c-\u5408\u540c\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}],\u4e0b\u8f7d\u7ed3\u679c\u4e3a\uff1a[{}]", (Object)nlsCreditInfoVO.getLmtApplySeq(), (Object)downResult.toString());
            if (!downResult.isRetFlag()) {
                return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), "\u5c0a\u656c\u7684\u5ba2\u6237\u60a8\u597d\uff0c\u7531\u4e8e\u7cfb\u7edf\u5728\u5904\u7406\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u4e86\u5f02\u5e38\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5"};
            }
            this.updateCtrStatus(ctrLoanContVO, "200");
            this.updateArrpvDateAndLmtDate(nlsCreditInfo, lmtPrdContVO, openday);
            this.insertUploadRecord(nlsCreditInfo, downResult.getFileFullPath());
            this.insertImageBizDetail(nlsCreditInfo, YedConstantSet.YED_SX_CONT_TYPE, FilenameUtils.getName((String)downResult.getFileFullPath()), downResult.getFileFullPath());
            this.insertImageBizInfo(nlsCreditInfo);
            return new String[]{"000000", "\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u6210\u529f"};
        }
        catch (BizException e) {
            logger.info("\u4f18e\u8d37\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
            return new String[]{e.getErrorCode(), e.getMessage()};
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u6388\u4fe1\u5408\u540c\u7b7e\u8ba2\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
            return new String[]{EsbRetCodeStandard.OTHERS_EXCEPTION.getValue(), e.getMessage()};
        }
    }

    private void updateArrpvDateAndLmtDate(NlsCreditInfo nlsCreditInfo, LmtPrdContVO lmtPrdContVO, String openday) throws Exception {
        nlsCreditInfo.setApprvDate(openday);
        int i = this.nlsCreditInfoDao.updateByPk(nlsCreditInfo);
        if (i != 1) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u66f4\u65b0\u6388\u4fe1\u7533\u8bf7\u65e5\u671f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    public void insertUploadRecord(NlsCreditInfo nlsCreditInfo, String fpath) {
        YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
        yedUploadRecordVO.setApplSeq(nlsCreditInfo.getLmtApplySeq());
        yedUploadRecordVO.setCreateTime(new Date());
        yedUploadRecordVO.setDealType("1");
        yedUploadRecordVO.setFileType("Y05");
        yedUploadRecordVO.setFileUrl(fpath);
        yedUploadRecordVO.setPrdId(nlsCreditInfo.getPrdId());
        yedUploadRecordVO.setUpErrMsg("");
        yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
        yedUploadRecordVO.setUpNum(Integer.valueOf(0));
        yedUploadRecordVO.setUpSta(Integer.valueOf(0));
        yedUploadRecordVO.setUpTime(new Date());
        this.yedUploadService.insert(yedUploadRecordVO);
    }

    private CusIndivVO getCustInfo(String cusId) throws OcmSystemException {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(cusId);
        cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
        if (Objects.isNull(cusIndivVO)) {
            throw new OcmSystemException("\u6839\u636e\u5ba2\u6237\u53f7\uff1a" + cusId + "\uff0c\u67e5\u8be2\u5230\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return cusIndivVO;
    }

    private void execute3001(NlsCreditInfo nlsCreditInfo, CusIndivVO cusIndivVO) throws OcmSystemException {
        YedContResult psdContResult = null;
        try {
            psdContResult = this.yedContService.openAccount(nlsCreditInfo.getCusName(), nlsCreditInfo.getCertType(), nlsCreditInfo.getCertCode(), nlsCreditInfo.getEmail(), nlsCreditInfo.getIndivMobile(), nlsCreditInfo.getIndivRsdAddr(), nlsCreditInfo.getLmtApplySeq());
        }
        catch (Exception e) {
            logger.error(psdContResult.getMsg());
            throw new OcmSystemException(psdContResult.getMsg());
        }
        if (!psdContResult.isRetFlag()) {
            throw new OcmSystemException(psdContResult.getMsg());
        }
        cusIndivVO.setAxqUsrId(psdContResult.getAxqUserId());
        int cusUpdNum = this.cusIndivService.updateByPk(cusIndivVO);
        if (cusUpdNum < 0) {
            if (logger.isErrorEnabled()) {
                logger.error("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfo.getLmtApplySeq() + "\u66f4\u65b0\u5b89\u5fc3\u7b7e\u5f00\u6237\u53f7\u5230\u5ba2\u6237\u4fe1\u606f\u8868(cus_indiv)\u51fa\u9519!");
            }
            throw new OcmSystemException("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfo.getLmtApplySeq() + "\u66f4\u65b0\u5b89\u5fc3\u7b7e\u5f00\u6237\u53f7\u5230\u5ba2\u6237\u4fe1\u606f\u8868\u51fa\u9519!");
        }
        logger.info("======>\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u8c03\u7528cfca\u7b7e\u7ae0\u5f00\u6237\u63a5\u53e3\u30103201\u3011\u7ed3\u675f<====== \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfo.getLmtApplySeq());
    }

    private void execute3203(NlsCreditInfo nlsCreditInfo, CusIndivVO cusIndivVO, LmtPrdContVO lmtPrdContVO, String contType, CfcaSignInfoVO cfcaSignInfoVO, String openday) throws Exception {
        YedContResult psdContResult = this.yedContService.signature4Sx(nlsCreditInfo.getGlobalSerno(), nlsCreditInfo.getLmtApplySeq(), cusIndivVO.getAxqUsrId(), "yed_sxcont.pdf", "\u4e2a\u4eba\u7efc\u5408\u6388\u4fe1\u5408\u540c", this.getLocalCtrParamMap(nlsCreditInfo, cusIndivVO, lmtPrdContVO, openday));
        logger.error("\u7b7e\u8ba2\u6388\u4fe1\u5408\u540c-\u5408\u540c\u7b7e\u7f72\uff083203\uff09\u5b8c\u6210\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a[{}],\u7b7e\u7f72\u7ed3\u679c\u4e3a\uff1a[{}]", (Object)nlsCreditInfo.getLmtApplySeq(), (Object)psdContResult.toString());
        if (!psdContResult.isRetFlag()) {
            throw new OcmSystemException("\u5408\u540c\u7b7e\u7f72\u5931\u8d25" + psdContResult.getMsg());
        }
        this.insertCfcaSignInfo(nlsCreditInfo, lmtPrdContVO, cfcaSignInfoVO, psdContResult.getAxqContNo(), psdContResult.getAxqSignTime());
    }

    private Map<String, String> getLocalCtrParamMap(NlsCreditInfo nlsCreditInfoVO, CusIndivVO cusIndivVO, LmtPrdContVO lmtPrdContVO, String openday) throws BizException {
        logger.info("\u3010\u4f18e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7ec4\u88c5\u5408\u540c\u6a21\u677f\u586b\u5199\u53c2\u6570\u5f00\u59cb \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a" + nlsCreditInfoVO.getLmtApplySeq());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ctrNo", nlsCreditInfoVO.getLmtApplySeq());
        map.put("addrA", PsdConstantSet.ZH_ADDR);
        map.put("postA", PsdConstantSet.ZH_POST);
        map.put("telA", PsdConstantSet.ZH_TEL);
        map.put("certTypeB", YedSxCtrSignatureServiceImpl.getCertTyName(nlsCreditInfoVO.getCertType()));
        map.put("certNoB", nlsCreditInfoVO.getCertCode());
        map.put("postB", cusIndivVO.getPostCode());
        map.put("telB", cusIndivVO.getPhone());
        map.put("emailB", cusIndivVO.getEmail());
        map.put("addrB", nlsCreditInfoVO.getIndivRsdAddr());
        String amount = nlsCreditInfoVO.getApproveAmt().setScale(2, 4).toString();
        map.put("amountBig", Amount2RMB.convert((String)amount));
        map.put("amountSmal", amount);
        map.put("cusNameB", nlsCreditInfoVO.getCusName());
        map.put("identNoB", nlsCreditInfoVO.getCertCode());
        map.put("faxCode", cusIndivVO.getFaxCode());
        map.put("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        map.put("startDate", df.format(this.getDate1(openday)));
        try {
            map.put("expireDate", df.format(this.getDate1(TimeUtil.addMonth((String)openday, (int)12))));
        }
        catch (Exception e) {
            throw new BizException("\u83b7\u53d6\u6388\u4fe1\u989d\u5ea6\u622a\u6b62\u65e5\u671f\u5931\u8d25!!!");
        }
        return map;
    }

    public Date getDate1(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private void insertCfcaSignInfo(NlsCreditInfo nlsCreditInfoVO, LmtPrdContVO lmtPrdContVO, CfcaSignInfoVO cfcaSignInfoVO, String axqContNo, String time) throws OcmSystemException {
        cfcaSignInfoVO.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        cfcaSignInfoVO.setPrdId(nlsCreditInfoVO.getPrdId());
        cfcaSignInfoVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        cfcaSignInfoVO.setPrdName(nlsCreditInfoVO.getPrdName());
        cfcaSignInfoVO.setContNo(nlsCreditInfoVO.getLmtApplySeq());
        cfcaSignInfoVO.setCfcaContNo(axqContNo);
        cfcaSignInfoVO.setCusId(nlsCreditInfoVO.getCusId());
        cfcaSignInfoVO.setCusName(nlsCreditInfoVO.getCusName());
        cfcaSignInfoVO.setPrdType(nlsCreditInfoVO.getChannelNo());
        cfcaSignInfoVO.setLastUpdateUser(nlsCreditInfoVO.getLastUpdateUser());
        cfcaSignInfoVO.setNlsOperOrgid(nlsCreditInfoVO.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperUserid(nlsCreditInfoVO.getNlsOperUserid());
        cfcaSignInfoVO.setFinaBrId(nlsCreditInfoVO.getNlsOperOrgid());
        cfcaSignInfoVO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        cfcaSignInfoVO.setCreateUser(nlsCreditInfoVO.getCreateUser());
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        cfcaSignInfoVO.setCfcaSignTime(time);
        int num = this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
        if (num < 0) {
            if (logger.isErrorEnabled()) {
                logger.error("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a: " + nlsCreditInfoVO.getLmtApplySeq() + " \u5f80cfca\u52a0\u7b7e\u4fe1\u606f\u8868\u65b0\u589e\u6570\u636e\u51fa\u9519!");
            }
            throw new OcmSystemException("\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a: " + nlsCreditInfoVO.getLmtApplySeq() + " \u5f80cfca\u52a0\u7b7e\u4fe1\u606f\u8868\u65b0\u589e\u6570\u636e\u51fa\u9519!");
        }
        if (logger.isInfoEnabled()) {
            logger.info("======>\u4f18e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u4fdd\u5b58\u5408\u540c\u7b7e\u7ae0\u8bb0\u5f55\u4fe1\u606f\u7ed3\u675f<===== \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + nlsCreditInfoVO.getLmtApplySeq());
        }
    }

    private SOrgVO getSOrg(String orgCode) throws OcmSystemException {
        SOrgVO sOrgVO = new SOrgVO();
        sOrgVO.setOrgCode(orgCode);
        sOrgVO = this.sOrgService.queryByPk(sOrgVO);
        if (Objects.isNull(sOrgVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u673a\u6784\u53f7\u3010" + orgCode + "\u3011\uff0c\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return sOrgVO;
    }

    private LmtPrdContVO getLmtPrdCont(String lmtApplySeq) throws OcmSystemException {
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
        if (Objects.isNull(lmtPrdContVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (null == lmtPrdContVO.getLmtAmt()) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a\uff01");
        }
        return lmtPrdContVO;
    }

    public static String getCertTyName(String certTy) {
        if ("00000".equals(certTy)) {
            return "\u672a\u77e5\u8bc1\u4ef6\u7c7b\u578b";
        }
        if ("10000".equals(certTy)) {
            return "\u5bf9\u79c1\u8eab\u4efd\u8bc1\u4ef6";
        }
        if ("10100".equals(certTy)) {
            return "\u5c45\u6c11\u8eab\u4efd\u8bc1";
        }
        if ("10200".equals(certTy)) {
            return "\u4e34\u65f6\u8eab\u4efd\u8bc1";
        }
        if ("10300".equals(certTy)) {
            return "\u6237\u53e3\u7c3f";
        }
        if ("10400".equals(certTy)) {
            return "\u62a4\u7167";
        }
        if ("10401".equals(certTy)) {
            return "\u666e\u901a\u62a4\u7167";
        }
        if ("10402".equals(certTy)) {
            return "\u5916\u4ea4\u62a4\u7167";
        }
        if ("10403".equals(certTy)) {
            return "\u516c\u52a1\u62a4\u7167";
        }
        if ("10404".equals(certTy)) {
            return "\u56e0\u516c\u666e\u901a\u62a4\u7167";
        }
        if ("10405".equals(certTy)) {
            return "\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a\u62a4\u7167";
        }
        if ("10406".equals(certTy)) {
            return "\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a\u62a4\u7167";
        }
        if ("10407".equals(certTy)) {
            return "\u53f0\u6e7e\u62a4\u7167";
        }
        if ("10408".equals(certTy)) {
            return "\u5916\u56fd\u62a4\u7167";
        }
        if ("10500".equals(certTy)) {
            return "\u519b\u4eba\u8eab\u4efd\u8bc1\u4ef6";
        }
        if ("10501".equals(certTy)) {
            return "\u58eb\u5175\u8bc1";
        }
        if ("10502".equals(certTy)) {
            return "\u519b\u5b98\u8bc1";
        }
        if ("10503".equals(certTy)) {
            return "\u6587\u804c\u5e72\u90e8\u8bc1";
        }
        if ("10504".equals(certTy)) {
            return "\u519b\u5b98\u9000\u4f11\u8bc1";
        }
        if ("10505".equals(certTy)) {
            return "\u6587\u804c\u5e72\u90e8\u9000\u4f11\u8bc1";
        }
        if ("10506".equals(certTy)) {
            return "\u519b\u4e8b\u5b66\u5458\u8bc1";
        }
        if ("10507".equals(certTy)) {
            return "\u519b\u961f\u79bb\u4f11\u5e72\u90e8\u8363\u8a89\u8bc1";
        }
        if ("10600".equals(certTy)) {
            return "\u6b66\u8b66\u8eab\u4efd\u8bc1\u4ef6";
        }
        if ("10601".equals(certTy)) {
            return "\u6b66\u8b66\u58eb\u5175\u8bc1";
        }
        if ("10602".equals(certTy)) {
            return "\u8b66\u5b98\u8bc1";
        }
        if ("10603".equals(certTy)) {
            return "\u6b66\u8b66\u6587\u804c\u5e72\u90e8\u8bc1";
        }
        if ("10604".equals(certTy)) {
            return "\u6b66\u8b66\u519b\u5b98\u9000\u4f11\u8bc1";
        }
        if ("10605".equals(certTy)) {
            return "\u6b66\u8b66\u6587\u804c\u5e72\u90e8\u9000\u4f11\u8bc1";
        }
        if ("10700".equals(certTy)) {
            return "\u6e2f\u6fb3\u53f0\u5c45\u6c11\u6709\u6548\u8eab\u4efd\u8bc1\u4ef6";
        }
        if ("10701".equals(certTy)) {
            return "\u6e2f\u6fb3\u5c45\u6c11\u6765\u5f80\u5185\u5730\u901a\u884c\u8bc1";
        }
        if ("10702".equals(certTy)) {
            return "\u6e2f\u6fb3\u5c45\u6c11\u8eab\u4efd\u8bc1";
        }
        if ("10703".equals(certTy)) {
            return "\u53f0\u6e7e\u5c45\u6c11\u6765\u5f80\u5927\u9646\u901a\u884c\u8bc1";
        }
        if ("10704".equals(certTy)) {
            return "\u53f0\u6e7e\u5c45\u6c11\u6765\u5f80\u5927\u9646\u901a\u884c\u8bc1\uff08\u4e00\u6b21\u6709\u6548\uff09";
        }
        if ("10705".equals(certTy)) {
            return "\u53f0\u6e7e\u5c45\u6c11\u8eab\u4efd\u8bc1";
        }
        if ("10706".equals(certTy)) {
            return "\u53f0\u6e7e\u5c45\u6c11\u5b9a\u5c45\u8bc1";
        }
        if ("10707".equals(certTy)) {
            return "\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a\u65c5\u884c\u8bc1";
        }
        if ("10708".equals(certTy)) {
            return "\u9999\u6e2f\u5c45\u6c11\u8eab\u4efd\u8bc1";
        }
        if ("10709".equals(certTy)) {
            return "\u6fb3\u95e8\u5c45\u6c11\u8eab\u4efd\u8bc1";
        }
        if ("10800".equals(certTy)) {
            return "\u5185\u5730\u5c45\u6c11\u5f80\u6765\u6e2f\u6fb3\u53f0\u6709\u6548\u8eab\u4efd\u8bc1\u4ef6";
        }
        if ("10801".equals(certTy)) {
            return "\u5f80\u6765\u6e2f\u6fb3\u901a\u884c\u8bc1";
        }
        if ("10802".equals(certTy)) {
            return "\u524d\u5f80\u6e2f\u6fb3\u901a\u884c\u8bc1";
        }
        if ("10803".equals(certTy)) {
            return "\u5927\u9646\u5c45\u6c11\u5f80\u6765\u53f0\u6e7e\u901a\u884c\u8bc1";
        }
        if ("10804".equals(certTy)) {
            return "\u56e0\u516c\u5f80\u6765\u9999\u6e2f\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a\u901a\u884c\u8bc1";
        }
        if ("10900".equals(certTy)) {
            return "\u5916\u56fd\u4eba\u6c38\u4e45\u5c45\u7559\u8bc1";
        }
        if ("11000".equals(certTy)) {
            return "\u5916\u56fd\u4eba\u5c45\u7559\u8bc1";
        }
        if ("11100".equals(certTy)) {
            return "\u9a7e\u9a76\u8bc1";
        }
        if ("11101".equals(certTy)) {
            return "\u673a\u52a8\u8f66\u9a7e\u9a76\u8bc1";
        }
        if ("11102".equals(certTy)) {
            return "\u98de\u673a\u9a7e\u9a76\u8bc1";
        }
        if ("11103".equals(certTy)) {
            return "\u8239\u8236\u9a7e\u9a76\u8bc1";
        }
        if ("11200".equals(certTy)) {
            return "\u8fb9\u6c11\u51fa\u5165\u5883\u901a\u884c\u8bc1";
        }
        if ("12300".equals(certTy)) {
            return "\u5b66\u751f\u8bc1";
        }
        if ("12400".equals(certTy)) {
            return "\u9000\u4f11\u8bc1";
        }
        if ("12500".equals(certTy)) {
            return "\u5de5\u4f5c\u8bc1";
        }
        if ("12600".equals(certTy)) {
            return "\u6267\u884c\u516c\u52a1\u8bc1";
        }
        if ("12700".equals(certTy)) {
            return "\u56de\u4e61\u8bc1";
        }
        if ("12800".equals(certTy)) {
            return "\u6587\u804c\u8bc1";
        }
        if ("19999".equals(certTy)) {
            return "\u5176\u5b83\u4e2a\u4eba\u8bc1\u4ef6";
        }
        if ("20000".equals(certTy)) {
            return "\u5bf9\u516c\u8bc1\u4ef6";
        }
        if ("20100".equals(certTy)) {
            return "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801";
        }
        if ("20200".equals(certTy)) {
            return "\u4f01\u4e1a\u767b\u8bb0\u4ee3\u7801";
        }
        if ("20300".equals(certTy)) {
            return "\u5de5\u5546\u767b\u8bb0\u8bc1";
        }
        if ("20400".equals(certTy)) {
            return "\u80a1\u4e1c\u4ee3\u7801\u8bc1";
        }
        if ("20500".equals(certTy)) {
            return "\u4f01\u4e1a\u8425\u4e1a\u6267\u7167";
        }
        if ("20600".equals(certTy)) {
            return "\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\u8bc1";
        }
        if ("20700".equals(certTy)) {
            return "\u7a0e\u52a1\u767b\u8bb0\u8bc1";
        }
        if ("20701".equals(certTy)) {
            return "\u7a0e\u52a1\u767b\u8bb0\u8bc1\uff08\u56fd\u7a0e\uff09";
        }
        if ("20702".equals(certTy)) {
            return "\u7a0e\u52a1\u767b\u8bb0\u8bc1\uff08\u5730\u7a0e\uff09";
        }
        if ("20800".equals(certTy)) {
            return "\u57df\u540d\u6ce8\u518c\u8bc1";
        }
        if ("20900".equals(certTy)) {
            return "\u5f00\u6237\u8bb8\u53ef\u8bc1";
        }
        if ("20901".equals(certTy)) {
            return "\u519b\u961f\u5f00\u6237\u8bb8\u53ef\u8bc1";
        }
        if ("21000".equals(certTy)) {
            return "\u5916\u6c47\u8bb8\u53ef\u8bc1";
        }
        if ("21100".equals(certTy)) {
            return "\u4f01\u4e1a\u5916\u7ba1\u4ee3\u7801";
        }
        if ("21200".equals(certTy)) {
            return "\u4e2d\u5f81\u7801";
        }
        if ("21300".equals(certTy)) {
            return "\u91d1\u878d\u8bb8\u53ef\u8bc1\u53f7";
        }
        if ("21400".equals(certTy)) {
            return "\u4fdd\u9669\u4e1a\u52a1\u8bb8\u53ef\u8bc1";
        }
        if ("21500".equals(certTy)) {
            return "\u8bc1\u5238\u4e1a\u52a1\u8bb8\u53ef\u8bc1";
        }
        if ("21600".equals(certTy)) {
            return "\u8bc1\u76d1\u4f1a\u4ee3\u7801\u8bc1\u53f7";
        }
        if ("21700".equals(certTy)) {
            return "\u8fdb\u51fa\u53e3\u7ecf\u8425\u6743\u8bb8\u53ef\u8bc1\u4e66";
        }
        if ("21800".equals(certTy)) {
            return "\u5916\u5546\u4f01\u4e1a\u6295\u8d44\u767b\u8bb0\u8bc1\u4e66";
        }
        if ("21900".equals(certTy)) {
            return "\u5ba1\u6279\u6587\u53f7";
        }
        if ("22000".equals(certTy)) {
            return "\u6280\u672f\u76d1\u7763\u5c40\u7f16\u53f7";
        }
        if ("22100".equals(certTy)) {
            return "\u4eba\u884c\u91d1\u878d\u673a\u6784\u4ee3\u7801";
        }
        if ("22200".equals(certTy)) {
            return "\u94f6\u884cswift bic";
        }
        if ("22300".equals(certTy)) {
            return "\u8054\u884c\u884c\u53f7";
        }
        if ("22400".equals(certTy)) {
            return "\u5916\u6c47\u7ba1\u7406\u5c40\u5370\u5355\u5c40\u4ee3\u7801";
        }
        if ("22500".equals(certTy)) {
            return "FCI\u7f16\u53f7";
        }
        if ("22600".equals(certTy)) {
            return "\u4e8b\u4e1a\u6cd5\u4eba\u8bc1\u4e66";
        }
        if ("22700".equals(certTy)) {
            return "\u6536\u8d39\u8bb8\u53ef\u8bc1";
        }
        if ("22800".equals(certTy)) {
            return "\u8d44\u8d28\u8bc1\u4e66";
        }
        if ("22900".equals(certTy)) {
            return "\u4e0b\u5c5e\u673a\u6784\u8bc1\u4e66";
        }
        if ("23100".equals(certTy)) {
            return "\u652f\u4ed8\u4e1a\u52a1\u8bb8\u53ef\u8bc1";
        }
        if ("23200".equals(certTy)) {
            return "\u793e\u56e2\u6cd5\u4eba\u8bc1\u4e66";
        }
        if ("23300".equals(certTy)) {
            return "\u6c11\u529e\u975e\u4f01\u4e1a\u767b\u8bb0\u8bc1";
        }
        if ("23400".equals(certTy)) {
            return "\u5916\u56fd\u9a7b\u534e\u673a\u6784\u767b\u8bb0\u8bc1";
        }
        if ("23500".equals(certTy)) {
            return "\u5916\u5730\u5e38\u8bbe\u673a\u6784\u767b\u8bb0\u8bc1";
        }
        if ("23600".equals(certTy)) {
            return "\u7279\u6b8a\u673a\u6784\u4ee3\u7801";
        }
        if ("23700".equals(certTy)) {
            return "\u884c\u653f\u673a\u5173";
        }
        if ("23800".equals(certTy)) {
            return "\u793e\u4f1a\u56e2\u4f53";
        }
        if ("23900".equals(certTy)) {
            return "\u767b\u8bb0\u6587\u4ef6";
        }
        if ("24100".equals(certTy)) {
            return "\u6279\u6587\u6216\u6279\u590d";
        }
        if ("24200".equals(certTy)) {
            return "\u5f00\u6237\u8bc1\u660e";
        }
        if ("24300".equals(certTy)) {
            return "\u4f01\u4e1a\u540d\u79f0\u9884\u5148\u6838\u51c6\u901a\u77e5\u4e66";
        }
        if ("24400".equals(certTy)) {
            return "\u4e8b\u4e1a\u793e\u56e2\u6cd5\u4eba\u8bc1\u4e66";
        }
        if ("24500".equals(certTy)) {
            return "\u9ad8\u65b0\u6280\u672f\u4f01\u4e1a\u8ba4\u5b9a\u8bc1\u4e66";
        }
        if ("24600".equals(certTy)) {
            return "\u5efa\u7b51\u4e1a\u4f01\u4e1a\u8d44\u8d28\u8bc1\u4e66";
        }
        if ("24700".equals(certTy)) {
            return "\u793e\u4f1a\u798f\u5229\u4f01\u4e1a\u8bc1\u4e66";
        }
        if ("24800".equals(certTy)) {
            return "\u673a\u6784\u4fe1\u7528\u4ee3\u7801";
        }
        if ("29999".equals(certTy)) {
            return "\u5176\u5b83\u5bf9\u516c\u8bc1\u4ef6";
        }
        if ("99999".equals(certTy)) {
            return "\u5176\u5b83\u8bc1\u4ef6";
        }
        if ("10409".equals(certTy)) {
            return "\u5916\u4ea4\u5b98\u8bc1";
        }
        if ("10410".equals(certTy)) {
            return "\u4f7f\uff08\u9886\u4e8b\uff09\u9986\u8bc1";
        }
        if ("11104".equals(certTy)) {
            return "\u6d77\u5458\u8bc1";
        }
        if ("10411".equals(certTy)) {
            return "\u5916\u56fd\u4eba\u8eab\u4efd\u8bc1\u4ef6";
        }
        if ("12301".equals(certTy)) {
            return "\u9ad8\u6821\u6bd5\u4e1a\u751f\u81ea\u4e3b\u521b\u4e1a\u8bc1";
        }
        if ("12302".equals(certTy)) {
            return "\u5c31\u4e1a\u5931\u4e1a\u767b\u8bb0\u8bc1";
        }
        if ("12304".equals(certTy)) {
            return "\u79bb\u4f11\u8bc1";
        }
        if ("10507".equals(certTy)) {
            return "\u57ce\u9547\u9000\u5f79\u58eb\u5175\u81ea\u8c0b\u804c\u4e1a\u8bc1";
        }
        if ("10508".equals(certTy)) {
            return "\u968f\u519b\u5bb6\u5c5e\u8eab\u4efd\u8bc1\u660e";
        }
        if ("10509".equals(certTy)) {
            return "\u4e2d\u56fd\u4eba\u6c11\u89e3\u653e\u519b\u519b\u5b98\u8f6c\u4e1a\u8bc1\u4e66";
        }
        if ("10510".equals(certTy)) {
            return "\u4e2d\u56fd\u4eba\u6c11\u89e3\u653e\u519b\u4e49\u52a1\u5175\u9000\u51fa\u73b0\u5f79\u8bc1";
        }
        if ("10511".equals(certTy)) {
            return "\u4e2d\u56fd\u4eba\u6c11\u89e3\u653e\u519b\u58eb\u5b98\u9000\u51fa\u73b0\u5f79\u8bc1";
        }
        if ("12303".equals(certTy)) {
            return "\u5c31\u4e1a\u521b\u4e1a\u8bc1";
        }
        if ("10301".equals(certTy)) {
            return "\u533b\u5b66\u51fa\u751f\u8bc1\u660e";
        }
        return "\u8eab\u4efd\u8bc1";
    }

    private void insertImageBizDetail(NlsCreditInfo nlsCreditInfoVO, String imgType, String fileName, String filePath) {
        logger.info(nlsCreditInfoVO.getLmtApplySeq(), (Object)"\u5f00\u59cb\u6dfb\u52a0\u8bb0\u5f55\u5230insertImageBizDetail");
        ImageBizDetailVO imageBizDetail = new ImageBizDetailVO();
        imageBizDetail.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizDetail.setBizStage("\u6388\u4fe1\u5408\u540c");
        imageBizDetail.setFileDesc("\u4f18e\u8d37\u6388\u4fe1\u5408\u540c");
        imageBizDetail.setFileName(fileName);
        imageBizDetail.setFilePath(filePath);
        imageBizDetail.setImageId(imgType);
        imageBizDetail.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizDetail.setImageType(imgType);
        this.imageBizDetailService.insertImageBizDetail(imageBizDetail);
    }

    private void insertImageBizInfo(NlsCreditInfo nlsCreditInfoVO) {
        logger.info(nlsCreditInfoVO.getLmtApplySeq(), (Object)"\u5f00\u59cb\u6dfb\u52a0\u8bb0\u5f55\u5230insertImageBizInfo");
        ImageBizInfoVO param = new ImageBizInfoVO();
        param.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        if (!Objects.isNull(this.imageBizInfoService.queryByPk(param))) {
            return;
        }
        ImageBizInfoVO imageBizInfo = new ImageBizInfoVO();
        imageBizInfo.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizInfo.setCreateDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        imageBizInfo.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizInfo.setCusId(nlsCreditInfoVO.getCusId());
        imageBizInfo.setCusName(nlsCreditInfoVO.getCusName());
        imageBizInfo.setPrdId(nlsCreditInfoVO.getPrdId());
        imageBizInfo.setPrdCode(nlsCreditInfoVO.getPrdCode());
        imageBizInfo.setPrdName(nlsCreditInfoVO.getPrdName());
        imageBizInfo.setSoltImageAccept("");
        imageBizInfo.setSoltImageCfca("");
        imageBizInfo.setSoltImageThird1("");
        imageBizInfo.setSoltImageThird2("");
        this.imageBizInfoService.insertOrUpdateImageBizInfoVO(imageBizInfo);
    }

    private CtrLoanContVO insertLoanCtrContract(String openDay, NlsCreditInfo nlsCreditInfo, CusIndivVO custInfoVo) throws Exception {
        Optional.ofNullable(nlsCreditInfo).orElseThrow(() -> new BizException("\u6388\u4fe1\u6d41\u6c34\u53f7\u4e3a\u3010" + nlsCreditInfo.getLmtApplySeq() + "\u3011\u7684\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728"));
        logger.info("************\u5f00\u59cb\u5411\u5408\u540c\u8868\u63d2\u5165\u6570\u636e\uff01************");
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setContNo(nlsCreditInfo.getLmtApplySeq());
        ctrLoanContVO.setSerno(nlsCreditInfo.getLmtApplySeq());
        ctrLoanContVO.setLmtContNo(nlsCreditInfo.getLmtApplySeq());
        ctrLoanContVO.setPrdCode(nlsCreditInfo.getPrdCode());
        ctrLoanContVO.setCusId(nlsCreditInfo.getCusId());
        ctrLoanContVO.setChannelCode(nlsCreditInfo.getChannelNo());
        ctrLoanContVO.setPrdId(nlsCreditInfo.getPrdId());
        ctrLoanContVO.setPrdName(nlsCreditInfo.getPrdName());
        ctrLoanContVO.setContAmt(nlsCreditInfo.getApplyAmt());
        ctrLoanContVO.setCusName(nlsCreditInfo.getCusName());
        ctrLoanContVO.setCertType(nlsCreditInfo.getCertType());
        ctrLoanContVO.setCertCode(nlsCreditInfo.getCertCode());
        ctrLoanContVO.setContAmt(nlsCreditInfo.getApproveAmt());
        ctrLoanContVO.setTermTimeType(nlsCreditInfo.getTermType());
        ctrLoanContVO.setLoanTerm(BigDecimal.valueOf(12L));
        ctrLoanContVO.setCalFloatingRate(BigDecimal.ZERO);
        ctrLoanContVO.setRepaymentMode(nlsCreditInfo.getRepaymentMode());
        ctrLoanContVO.setSignDate(openDay);
        ctrLoanContVO.setContState("101");
        ctrLoanContVO.setContType("01");
        ctrLoanContVO.setCnContNo("\u6388\u4fe1\u5408\u540c");
        ctrLoanContVO.setResdntAddr(custInfoVo.getIndivRsdAddr());
        ctrLoanContVO.setPstcd(custInfoVo.getPostCode());
        ctrLoanContVO.setClnttFax(custInfoVo.getFaxCode());
        ctrLoanContVO.setCtcTelNo(custInfoVo.getPhone());
        ctrLoanContVO.setEmail(custInfoVo.getEmail());
        ctrLoanContVO.setLrgLoanAmt("");
        ctrLoanContVO.setCreateTime(TimeUtil.getCurrentDateTime());
        ctrLoanContVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        CusReferrerInfoVO cusReferrerInfoVO = new CusReferrerInfoVO();
        cusReferrerInfoVO.setLmtApplySeq(nlsCreditInfo.getLmtApplySeq());
        cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusReferrerInfoVO);
        if (Objects.nonNull(cusReferrerInfoVO)) {
            ctrLoanContVO.setCusManager(cusReferrerInfoVO.getReferrerId());
            ctrLoanContVO.setInputBrId(cusReferrerInfoVO.getMainBrId());
            ctrLoanContVO.setChargeoffBrId(cusReferrerInfoVO.getChargeOffBrId());
        }
        logger.info("************\u5411\u5408\u540c\u8868\u63d2\u5165\u7684\u6388\u4fe1\u5408\u540c\u4e3a\uff1a\u3010" + ctrLoanContVO.toString() + "\u3011");
        int count2 = this.ctrLoanContService.insertCtrLoanCont(ctrLoanContVO);
        if (count2 == -1) {
            logger.error("\u4f18e\u8d37\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + nlsCreditInfo.getLmtApplySeq() + "\u3011 \u63d2\u5165\u6388\u4fe1\u5408\u540c\u5f02\u5e38!");
            throw new BizException(EsbRetCodeStandard.SJCLYC.getValue(), "\u63d2\u5165\u6388\u4fe1\u5408\u540c\u5f02\u5e38!");
        }
        logger.info("************\u5411\u5408\u540c\u8868\u63d2\u5165\u6388\u4fe1\u5408\u540c\u6210\u529f\uff01************");
        return ctrLoanContVO;
    }

    private void updateCtrStatus(CtrLoanContVO ctrLoanContVO, String ctrStatus) throws BizException {
        if (ctrStatus.equals(ctrLoanContVO.getContState())) {
            return;
        }
        ctrLoanContVO.setContState(ctrStatus);
        ctrLoanContVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        int i = this.ctrLoanContService.updateByPk(ctrLoanContVO);
        if (i != 1) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u66f4\u65b0\u5408\u540c\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }
}

