/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.timeTask;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.yed.YedRepayPlanService;
import com.irdstudio.efp.nls.service.impl.yed.repay.YedRepaymentInfoSyncServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.yed.LoanRepayDetailRespVO;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="yedRepayPlanService")
public class YedRepayPlanServiceImpl
implements YedRepayPlanService {
    private static Logger logger = LoggerFactory.getLogger(YedRepayPlanServiceImpl.class);
    @Autowired
    @Qualifier(value="yedRepaymentInfoSyncService")
    private YedRepaymentInfoSyncServiceImpl yedRepaymentInfoSyncService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRepaySoltService() {
        logger.info(">>>>>>>>>\u4f18e\u8d37\u8fd8\u6b3e\u660e\u7ec6\u8865\u507f\u4efb\u52a1\u5f00\u59cb<<<<<<<<<<<");
        List loanRepayDetailVOS = this.loanRepayDetailService.queryByWfStsAndRsSts();
        if (Objects.isNull(loanRepayDetailVOS) || loanRepayDetailVOS.isEmpty()) {
            logger.warn(">>>>>>>>>>>>>\u4f18e\u8d37\u8fd8\u6b3e\u660e\u7ec6\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a<<<<<<<<<<<<<<<<");
            return;
        }
        try {
            String prdId = "";
            NlsProcessBizVO nlsProcessBizVO = new NlsProcessBizVO();
            for (LoanRepayDetailVO item : loanRepayDetailVOS) {
                prdId = this.accLoanService.queryPrdId(item.getLoanNo());
                if ("XD050300703".equals(prdId)) {
                    nlsProcessBizVO.setApplySeq(item.getSetlSeq());
                    NlsProcessBizVO queryNlsProcessBizVO = this.nlsProcessBizService.queryByPk(nlsProcessBizVO);
                    this.yedRepaymentInfoSyncService.doExecute(queryNlsProcessBizVO, item);
                }
                try {
                    LoanRepayDetailVO detailVO = this.loanRepayDetailService.queryByPk(item);
                    if (!detailVO.getWfApprSts().equals(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE())) continue;
                    LoanRepayDetailRespVO vo = new LoanRepayDetailRespVO();
                    vo.setTableName("LOAN_REPAY_DETAIL");
                    vo.setLoanNo(detailVO.getLoanNo());
                    vo.setSetlSeq(detailVO.getSetlSeq());
                    vo.setSetlApplyDt(detailVO.getSetlApplyDt());
                    vo.setSetlTotalFee(detailVO.getSetlTotalFee() == null ? "" : detailVO.getSetlTotalFee().doubleValue() + "");
                    vo.setSetlOdPrcpAmt(detailVO.getSetlOdPrcpAmt() == null ? "" : detailVO.getSetlOdPrcpAmt().doubleValue() + "");
                    vo.setSetlTyp(detailVO.getSetlTyp());
                    vo.setSetlCreateDt(detailVO.getSetlCreateDt());
                    vo.setDeliverTime(TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss"));
                    logger.info("\u8fd8\u6b3e\u53d1\u9001kafka\u4fe1\u606f\u5f00\u59cb->\u53d1\u9001\u5bf9\u8c61\u4e3a" + JSONObject.toJSONString((Object)vo));
                    this.sendToRisk(vo);
                }
                catch (Exception e) {
                    logger.error("\u98ce\u63a7\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(">>>>>>>>>>>>>\u4f18e\u8d37\u8fd8\u6b3e\u8ba1\u5212\u4efb\u52a1\u6267\u884c\u5931\u8d25<<<<<<<<<<<<<<<<");
        }
        finally {
            logger.info(">>>>>>>>>>>>>\u4f18e\u8d37\u8fd8\u6b3e\u8ba1\u5212\u4efb\u52a1\u6267\u884c\u7ed3\u675f<<<<<<<<<<<<<<<<");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(Object obj) {
        logger.info("\u4f18e\u8d37\u8fd8\u6b3e\u660e\u7ec6\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c");
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("apply")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedRepayPlanServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", obj);
            if (flag) {
                this.threadPool.add(() -> {
                    KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                    try {
                        kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f");
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }
}

