/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yed.timeTask;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.yed.YedTaskNlsApplyInfoService;
import com.irdstudio.efp.nls.service.impl.yed.apply.YedSyncLoanInfoServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.yed.NlsApplyInfoRespVO;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="yedTaskNlsApplyInfoService")
public class YedTaskNlsApplyInfoServiceImpl
implements YedTaskNlsApplyInfoService {
    private static Logger logger = LoggerFactory.getLogger(YedTaskNlsApplyInfoServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="yedSyncLoanInfoService")
    private YedSyncLoanInfoServiceImpl yedSyncLoanInfoService;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void yedSnys() {
        List nlsApplyInfoVOS = this.nlsApplyInfoService.queryNlsApplyInfoByDnstsAndState4Yed();
        if (nlsApplyInfoVOS == null || nlsApplyInfoVOS.size() == 0) {
            logger.warn(">>>>>>>>\u67e5\u8be2\u4f18e\u8d37\u653e\u6b3e\u540c\u6b65\u6570\u636e\u4e3a\u7a7a<<<<<<<<<<");
            return;
        }
        try {
            NlsProcessBizVO nlsProcessBizVO = new NlsProcessBizVO();
            for (NlsApplyInfoVO item : nlsApplyInfoVOS) {
                nlsProcessBizVO.setApplySeq(item.getApplySeq());
                NlsProcessBizVO queryNlsProcessBizVO = this.nlsProcessBizService.queryByPk(nlsProcessBizVO);
                this.yedSyncLoanInfoService.doExecute(queryNlsProcessBizVO, item);
                NlsApplyInfoVO nlsApplyRespVO = this.nlsApplyInfoService.queryByPk(item);
                if (!nlsApplyRespVO.getNlsApplyState().equals("02") || !nlsApplyRespVO.getDnSts().equals("6")) continue;
                NlsApplyInfoRespVO respVO = new NlsApplyInfoRespVO();
                respVO.setAmountOfLoan(nlsApplyRespVO.getAmountOfLoan());
                respVO.setApplySeq(nlsApplyRespVO.getApplySeq());
                respVO.setCreateTime(nlsApplyRespVO.getCreateTime());
                respVO.setDnSts(nlsApplyRespVO.getDnSts());
                respVO.setLastModifyTime(nlsApplyRespVO.getLastModifyTime());
                respVO.setLmtApplySeq(nlsApplyRespVO.getLmtApplySeq());
                respVO.setLoanPurpose(nlsApplyRespVO.getLoanPurpose());
                respVO.setLoanRate(nlsApplyRespVO.getLoanRate().toString());
                respVO.setLoanTerm(nlsApplyRespVO.getLoanTerm());
                respVO.setNlsApplyState(nlsApplyRespVO.getNlsApplyState());
                respVO.setRefuseCause(nlsApplyRespVO.getRefuseCause());
                respVO.setTableName("NLS_APPLY_INFO");
                respVO.setChannelNo(nlsApplyRespVO.getChannelNo());
                respVO.setDeliverTime(TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss"));
                this.sendToRisk(respVO, nlsApplyRespVO.getApplySeq());
            }
        }
        catch (Exception e) {
            logger.error(">>>>>>>>>\u4f18e\u8d37\u653e\u6b3e\u540c\u6b65\u4efb\u52a1\u5931\u8d25<<<<<<<<<<<" + e);
        }
        finally {
            logger.info(">>>>>>>>>\u4f18e\u8d37\u653e\u6b3e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f<<<<<<<<<<<");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(Object obj, String applySeq) {
        logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("XD050300703") || !vo.getStatus().equals("on") || !vo.getStage().equals("apply")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(YedTaskNlsApplyInfoServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", obj);
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7: " + applySeq + " \u53d1\u9001\u4fe1\u606f\u4e3a\uff1a" + JSONObject.toJSONString((Object)obj));
            if (flag) {
                this.threadPool.add(() -> {
                    KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                    try {
                        kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            logger.info("\u4f18e\u8d37\u7528\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }
}

