/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yx;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterBasicInfo;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterExpanding;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterMessage;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterReq;
import com.irdstudio.efp.esb.service.bo.resp.yx.LetterResp;
import com.irdstudio.efp.esb.service.facade.yx.LetterService;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="letterBackService")
public class LetterBackServiceImpl
extends SoltServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(LetterBackServiceImpl.class);
    @Autowired
    @Qualifier(value="letterService")
    private LetterService letterService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;

    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        try {
            logger.info("\u7528\u4fe1\u5ba1\u6838\u901a\u77e5\u63a5\u53e3\uff0c\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsApplyInfoVO);
            LetterReq letterReq = new LetterReq();
            LetterMessage letterMessage = new LetterMessage();
            LetterBasicInfo letterBasicInfo = new LetterBasicInfo();
            LetterExpanding letterExpanding = new LetterExpanding();
            letterReq.setRqsFlg(nlsApplyInfoVO.getBdReqSn());
            letterReq.setRetCd(MsLoanConstant.RetCodeEnum.SUCCESS.VALUE);
            letterReq.setTxnMd("async");
            letterMessage.setSessionId(applySeq);
            letterMessage.setEvTp("apply");
            letterMessage.setEvID(nlsApplyInfoVO.getBdTransactionId());
            letterMessage.setRqsTmstmp(TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmss"));
            letterBasicInfo.setIDCertNo(nlsApplyInfoVO.getCertCode());
            letterBasicInfo.setBankCardNo(nlsApplyInfoVO.getRecvAcctNo());
            letterBasicInfo.setCustNm(nlsApplyInfoVO.getCusName());
            letterBasicInfo.setMblNo(nlsApplyInfoVO.getMobile());
            letterExpanding.setInstRsnCd(nlsApplyInfoVO.getBdReasonCode());
            letterExpanding.setInstRsnCdRmk(nlsApplyInfoVO.getBdReasonMsg());
            letterExpanding.setInstPolcyCd(MsLoanConstant.RisCodeEnum.SUCCESS.VALUE);
            letterMessage.setBasicInfo((Object)letterBasicInfo);
            letterMessage.setExpanding((Object)letterExpanding);
            letterReq.setMessage((Object)letterMessage);
            boolean isSend = false;
            nlsApplyInfoVO.setDnSts("3");
            logger.info("\u7528\u4fe1\u5ba1\u6838\u901a\u77e5\u66f4\u65b0\u653e\u6b3e\u72b6\u6001\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)nlsApplyInfoVO));
            int num = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
            logger.info("\u7528\u4fe1\u5ba1\u6838\u901a\u77e5\u66f4\u65b0\u653e\u6b3e\u72b6\u6001\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)num));
            if (num > 0) {
                isSend = true;
            }
            if (isSend) {
                LetterResp letterResp = this.letterService.letterNotify(letterReq);
                Objects.requireNonNull(letterResp);
                if (!MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(letterResp.getRetCd()) || !"E1001".equals(letterResp.getRetCd())) {
                    logger.error("\u8c03\u7528\u7528\u4fe1\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u7528\u4fe1\u8d37\u6b3e\u5ba1\u6838\u901a\u77e5\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

