/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.efp.console.common.IrAdjModeEnum;
import com.irdstudio.efp.console.common.RateTypeEnum;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="letterCtrService")
public class LetterCtrServiceImpl
extends SoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(LetterCtrServiceImpl.class);
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        try {
            log.info("\u5f00\u59cb\u751f\u6210\u5408\u540c\u4fe1\u606f,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsApplyInfoVO);
            String prdId = Objects.requireNonNull(nlsApplyInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
            ctrLoanContVO.setContNo(applySeq);
            ctrLoanContVO.setSerno(applySeq);
            ctrLoanContVO.setContType("02");
            ctrLoanContVO.setPrdCode(prdInfoVo.getPrdCode());
            ctrLoanContVO.setPrdId(prdInfoVo.getPrdId());
            ctrLoanContVO.setPrdName(prdInfoVo.getPrdName());
            ctrLoanContVO.setCusId(nlsApplyInfoVO.getCusId());
            ctrLoanContVO.setCusName(nlsApplyInfoVO.getCusName());
            ctrLoanContVO.setCertCode(nlsApplyInfoVO.getCertCode());
            ctrLoanContVO.setCertType(nlsApplyInfoVO.getCertType());
            ctrLoanContVO.setTermTimeType(nlsApplyInfoVO.getLoanTermType());
            ctrLoanContVO.setLoanTerm(new BigDecimal(nlsApplyInfoVO.getLoanTerm()));
            ctrLoanContVO.setApprovalAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setContAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setAvailAmt(BigDecimal.ZERO);
            ctrLoanContVO.setTotalIssueAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setContState("101");
            ctrLoanContVO.setContStartDt(LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE));
            ctrLoanContVO.setContEndDt(LocalDate.now().plusMonths(Long.valueOf(nlsApplyInfoVO.getLoanTerm())).format(DateTimeFormatter.ISO_LOCAL_DATE));
            ctrLoanContVO.setIntRateType(RateTypeEnum.NORMAL.getCode());
            ctrLoanContVO.setIrAdjustMode(IrAdjModeEnum.FIXED.getCode());
            ctrLoanContVO.setUseDec(nlsApplyInfoVO.getLoanPurpose());
            ctrLoanContVO.setInputBrId("01328");
            ctrLoanContVO.setMainBrId("01328");
            ctrLoanContVO.setFinaBrId("01328");
            ctrLoanContVO.setLegalOrgCode("GCB");
            ctrLoanContVO.setLegalOrgName("\u5e7f\u5dde\u94f6\u884c\u667a\u6167\u94f6\u884c");
            ctrLoanContVO.setChannelCode(nlsApplyInfoVO.getChannelNo());
            ctrLoanContVO.setLastUpdateUser("admin");
            ctrLoanContVO.setCreateUser("admin");
            ctrLoanContVO.setCreateTime(LocalDateTime.now().format(timeStrFormatter));
            ctrLoanContVO.setLastUpdateTime(LocalDateTime.now().format(timeStrFormatter));
            ctrLoanContVO.setLastUpdateUser("admin");
            int num2 = this.ctrLoanContService.insertCtrLoanCont(ctrLoanContVO);
            if (num2 == -1) {
                throw new BizException("\u751f\u6210\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }
}

