/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.console.common.IrAdjModeEnum;
import com.irdstudio.efp.console.common.PrdStatEnums;
import com.irdstudio.efp.console.common.RateTypeEnum;
import com.irdstudio.efp.console.service.facade.CustomerLimitInfoService;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.PrdSoltRuleService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.PrdSoltRuleVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.esb.common.constant.InstitutionEnums;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.common.constant.nls.NlsProdCdEnum;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterBasicInfo;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterExpanding;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterMessage;
import com.irdstudio.efp.esb.service.bo.req.yx.LetterReq;
import com.irdstudio.efp.esb.service.bo.resp.yx.LetterResp;
import com.irdstudio.efp.esb.service.facade.yx.LetterService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.ed.LimitControlsService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import com.irdstudio.efp.rule.common.enumeration.Rule;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import com.irdstudio.efp.rule.service.vo.ReqAccessRuleVo;
import com.irdstudio.efp.rule.service.vo.ReqRuleVo;
import com.irdstudio.efp.rule.service.vo.RespRuleVO;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="letterRuleService")
public class LetterRuleServiceImpl
extends SoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(LetterRuleServiceImpl.class);
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final int MIN_TRM = 3;
    private static final int MAX_MYD_TRM = 12;
    private static final int MAX_ZXD_TRM = 36;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="ruleCallService")
    private RuleCallService ruleService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="prdSoltRuleService")
    private PrdSoltRuleService prdSoltRuleService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="letterService")
    private LetterService letterService;
    @Autowired
    @Qualifier(value="limitControlsService")
    private LimitControlsService limitControlsService;
    @Autowired
    @Qualifier(value="customerLimitInfoService")
    private CustomerLimitInfoService customerLimitInfoService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String slotCode = nlsProcessBizVo.getSoltCode();
        boolean isAvailApply = false;
        boolean isCreditInvalid = false;
        boolean isDuring = false;
        BigDecimal applyAmt = nlsApplyInfoVO.getApplyAmt();
        int num2 = 0;
        int num = 0;
        try {
            log.info("\u5f00\u59cb\u8fdb\u884c\u51c6\u5165\u89c4\u5219\u4ea7\u54c1\u6821\u9a8c,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsApplyInfoVO);
            String prdId = nlsApplyInfoVO.getPrdId();
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            PrdStatEnums prdStat = PrdStatEnums.parse((String)prdInfoVo.getPrdStatus());
            if (!Objects.equals(prdStat, PrdStatEnums.IN_USE)) {
                nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                throw new BizException("\u4ea7\u54c1\uff1a " + prdInfoVo.getPrdName() + " \u4e0d\u662f\u6709\u6548\u72b6\u6001");
            }
            BigDecimal availAmt = this.limitControlsService.getAvailAmt(nlsApplyInfoVO);
            LmtPrdContVO lmtPrdContVo = new LmtPrdContVO();
            NlsCreditInfoVO nlsCreditInfoVo = new NlsCreditInfoVO();
            nlsCreditInfoVo.setBdTransactionId(nlsApplyInfoVO.getBdTransactionId());
            nlsCreditInfoVo = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVo);
            if (nlsCreditInfoVo != null && nlsCreditInfoVo.getLmtApplySeq() != null) {
                lmtPrdContVo.setLmtStatus("02");
                lmtPrdContVo.setLmtApplySeq(nlsCreditInfoVo.getLmtApplySeq());
                lmtPrdContVo = this.lmtPrdContService.queryByPk(lmtPrdContVo);
                if (lmtPrdContVo != null && lmtPrdContVo.getLmtApplySeq() != null) {
                    isAvailApply = true;
                    String invalidDate = lmtPrdContVo.getExpireDate();
                    int invalidflag = TimeUtil.compareDates((String)TimeUtil.getCurrentDate(), (String)invalidDate);
                    if (invalidflag != -1) {
                        log.info(nlsApplyInfoVO.getApplySeq() + "\u6388\u4fe1\u534f\u8bae\u5df2\u5931\u6548");
                        isCreditInvalid = true;
                    }
                }
            }
            isDuring = this.limitControlsService.isDuring(nlsApplyInfoVO);
            if (NlsProdCdEnum.MYD.getValue().equals(prdInfoVo.getPrdCode())) {
                if (Integer.valueOf(nlsApplyInfoVO.getBdTerm()) < 3 || Integer.valueOf(nlsApplyInfoVO.getBdTerm()) > 12) {
                    nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                    throw new BizException("\u671f\u9650\uff1a " + nlsApplyInfoVO.getBdTerm() + " \u4e0d\u662f\u6709\u6548\u671f\u9650");
                }
            } else if (NlsProdCdEnum.ZXD.getValue().equals(prdInfoVo.getPrdCode()) && (Integer.valueOf(nlsApplyInfoVO.getBdTerm()) < 3 || Integer.valueOf(nlsApplyInfoVO.getBdTerm()) > 36)) {
                nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                throw new BizException("\u671f\u9650\uff1a " + nlsApplyInfoVO.getBdTerm() + " \u4e0d\u662f\u6709\u6548\u671f\u9650");
            }
            BigDecimal maxAmt = prdInfoVo.getLoanAppMaxAmt();
            BigDecimal minAmt = prdInfoVo.getLoanAppMinAmt();
            AccLoanVO accLoanVO = new AccLoanVO();
            accLoanVO.setCertType(nlsApplyInfoVO.getCertType());
            accLoanVO.setCertCode(nlsApplyInfoVO.getCertCode());
            accLoanVO.setPrdId(prdId);
            BigDecimal totalAmt = BigDecimal.ZERO;
            if (NlsProdCdEnum.ZXD.getValue().equals(nlsApplyInfoVO.getPrdCode())) {
                List accLoanVOs = Optional.ofNullable(this.accLoanService.queryAccLoanListByCondition(accLoanVO)).orElseGet(Collections::emptyList);
                totalAmt = accLoanVOs.stream().filter(vo -> {
                    String accStatus = vo.getAccountStatus();
                    return accStatus != null;
                }).map(AccLoanVO::getLoanBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
            nlsProcessRuleVO.setApplySeq(applySeq);
            nlsProcessRuleVO.setCreateTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setLastModifyTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setPrdCode(prdId);
            nlsProcessRuleVO.setPrdName(nlsApplyInfoVO.getPrdName());
            nlsProcessRuleVO.setCusName(nlsApplyInfoVO.getCusName());
            nlsProcessRuleVO.setCusId(nlsApplyInfoVO.getCusId());
            List prdSoltRules = this.prdSoltRuleService.queryByPrdIdAndSoltCode(prdId, slotCode);
            log.info("\u51c6\u5165\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f00\u59cb\u6267\u884c\u51c6\u5165\u89c4\u5219");
            ReqRuleVo reqRuleVo = new ReqRuleVo();
            reqRuleVo.setAppNo(applySeq);
            reqRuleVo.setPrdName(nlsApplyInfoVO.getPrdName());
            ReqAccessRuleVo param = new ReqAccessRuleVo();
            param.setMaxLoanAmt(maxAmt);
            param.setMinLoanAmt(minAmt);
            param.setLoanAmt(applyAmt);
            param.setCusLoanBal(totalAmt);
            param.setAvailAmt(availAmt);
            param.setAvailApply(isAvailApply);
            param.setDuring(isDuring);
            param.setCreditInvalid(isCreditInvalid);
            reqRuleVo.setReqAccessRuleVo(param);
            List list = this.ruleService.executeBatchRule(Rule.RuleType.BDACCESS, reqRuleVo);
            Map<String, List<RespRuleVO>> map = list.stream().collect(Collectors.groupingBy(RespRuleVO::getRuleId));
            String refuseMsg = "";
            String reasonCode = "";
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < prdSoltRules.size(); ++j) {
                String order = ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleOrder();
                Method methodRuleName = NlsProcessRuleVO.class.getMethod("setRuleName" + order, String.class);
                Method methodRuleState = NlsProcessRuleVO.class.getMethod("setRuleState" + order, String.class);
                Method methodRuleTime = NlsProcessRuleVO.class.getMethod("setRuleTime" + order, String.class);
                methodRuleName.invoke((Object)nlsProcessRuleVO, ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                methodRuleTime.invoke((Object)nlsProcessRuleVO, DateUtility.getCurrAppDateTimeString());
                if (map.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()) != null) {
                    methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    sb.append(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleName()).append("\u89c4\u5219\u4e0d\u901a\u8fc7;");
                    reasonCode = (String)MsLoanConstant.ReasonCodeMap.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                    refuseMsg = (String)MsLoanConstant.ReasonMsgMap.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                    break;
                }
                methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
            }
            nlsApplyInfoVO.setBdReasonCode(reasonCode);
            nlsApplyInfoVO.setBdReasonMsg(refuseMsg);
            this.nlsProcessRuleService.insertNlsProcessRule(nlsProcessRuleVO);
            if (!list.isEmpty()) {
                throw new BizException(sb.toString());
            }
            CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
            ctrLoanContVO.setContNo(applySeq);
            ctrLoanContVO.setSerno(applySeq);
            ctrLoanContVO.setContType("02");
            ctrLoanContVO.setPrdCode(prdInfoVo.getPrdCode());
            ctrLoanContVO.setPrdId(prdInfoVo.getPrdId());
            ctrLoanContVO.setPrdName(prdInfoVo.getPrdName());
            ctrLoanContVO.setCusId(nlsApplyInfoVO.getCusId());
            ctrLoanContVO.setCusName(nlsApplyInfoVO.getCusName());
            ctrLoanContVO.setCertCode(nlsApplyInfoVO.getCertCode());
            ctrLoanContVO.setCertType(nlsApplyInfoVO.getCertType());
            ctrLoanContVO.setTermTimeType(nlsApplyInfoVO.getLoanTermType());
            ctrLoanContVO.setLoanTerm(new BigDecimal(nlsApplyInfoVO.getBdTerm()));
            ctrLoanContVO.setApprovalAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setContAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setAvailAmt(BigDecimal.ZERO);
            ctrLoanContVO.setTotalIssueAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setContState("101");
            ctrLoanContVO.setContStartDt(nlsApplyInfoVO.getApplyDate());
            ctrLoanContVO.setContEndDt(LocalDate.now().plusMonths(Long.valueOf(nlsApplyInfoVO.getBdTerm())).format(DateTimeFormatter.ISO_LOCAL_DATE));
            ctrLoanContVO.setIntRateType(RateTypeEnum.NORMAL.getCode());
            ctrLoanContVO.setIrAdjustMode(IrAdjModeEnum.FIXED.getCode());
            ctrLoanContVO.setUseDec(nlsApplyInfoVO.getLoanPurpose());
            ctrLoanContVO.setChannelCode(nlsApplyInfoVO.getChannelNo());
            ctrLoanContVO.setLastUpdateUser("admin");
            ctrLoanContVO.setCreateUser("admin");
            ctrLoanContVO.setCreateTime(LocalDateTime.now().format(timeStrFormatter));
            ctrLoanContVO.setLastUpdateTime(LocalDateTime.now().format(timeStrFormatter));
            ctrLoanContVO.setLastUpdateUser("admin");
            ctrLoanContVO.setInputBrId(InstitutionEnums.InstitutionEnum.GZYHZHYHZXSCTD1.getCode());
            num2 = this.ctrLoanContService.insertCtrLoanCont(ctrLoanContVO);
            if (num2 == -1) {
                throw new BizException("\u751f\u6210\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            nlsApplyInfoVO.setDnSts("3");
            num = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
            if (num == -1) {
                throw new BizException("\u7528\u4fe1\u66f4\u65b0\u653e\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
            }
            this.invalidLimit(lmtPrdContVo, nlsCreditInfoVo);
            this.letterBack(nlsApplyInfoVO);
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }

    private void letterBack(NlsApplyInfoVO nlsApplyInfoVO) {
        try {
            log.info("\u7528\u4fe1\u5ba1\u6838\u901a\u77e5\u63a5\u53e3\uff0c\u6d41\u6c34\u53f7:" + nlsApplyInfoVO.getApplySeq());
            Objects.requireNonNull(nlsApplyInfoVO);
            LetterReq letterReq = new LetterReq();
            LetterMessage letterMessage = new LetterMessage();
            LetterBasicInfo letterBasicInfo = new LetterBasicInfo();
            LetterExpanding letterExpanding = new LetterExpanding();
            letterReq.setProdCd(nlsApplyInfoVO.getPrdCode());
            letterReq.setRqsFlg(nlsApplyInfoVO.getBdReqSn());
            letterReq.setRetCd(MsLoanConstant.RetCodeEnum.SUCCESS.VALUE);
            letterReq.setTxnMd("async");
            letterReq.setRepeatRqsBss(nlsApplyInfoVO.getBdReqSn());
            letterMessage.setSessionId(nlsApplyInfoVO.getApplySeq());
            letterMessage.setEvTp("transaction");
            letterMessage.setEvID(nlsApplyInfoVO.getBdTransactionId());
            letterMessage.setRqsTmstmp(new Date().getTime() + "");
            letterBasicInfo.setIDCertNo(nlsApplyInfoVO.getCertCode());
            letterBasicInfo.setBankCardNo(nlsApplyInfoVO.getRecvAcctNo());
            letterBasicInfo.setCustNm(nlsApplyInfoVO.getCusName());
            letterBasicInfo.setMblNo(nlsApplyInfoVO.getMobile());
            letterExpanding.setInstRsnCd(nlsApplyInfoVO.getBdReasonCode());
            letterExpanding.setInstRsnCdRmk(nlsApplyInfoVO.getBdReasonMsg());
            letterExpanding.setInstPolcyCd(MsLoanConstant.RisCodeEnum.SUCCESS.VALUE);
            letterMessage.setBasicInfo((Object)letterBasicInfo);
            letterMessage.setExpanding((Object)letterExpanding);
            letterReq.setMessage((Object)letterMessage);
            LetterResp letterResp = this.letterService.letterNotify(letterReq);
            if (!MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(letterResp.getRetCd()) || !"E1001".equals(letterResp.getRetCd())) {
                log.error("\u8c03\u7528\u7528\u4fe1\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u51fa\u9519");
            }
            log.error("\u8c03\u7528\u7528\u4fe1\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7528\u4fe1\u5ba1\u6279\u7ed3\u679c\u56de\u8c03\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void invalidLimit(LmtPrdContVO lmtPrdContVo, NlsCreditInfoVO nlsCreditInfo) {
        if (lmtPrdContVo != null && lmtPrdContVo.getLmtApplySeq() != null) {
            lmtPrdContVo.setExpireDate("2099-12-31");
            lmtPrdContVo.setTerm(new BigDecimal("9999"));
            lmtPrdContVo.setValidDays("9999");
            this.lmtPrdContService.updateByPk(lmtPrdContVo);
        }
        if (nlsCreditInfo != null && nlsCreditInfo.getLmtApplySeq() != null) {
            nlsCreditInfo.setApplyTerm("9999");
            this.nlsCreditInfoService.updateByPk(nlsCreditInfo);
        }
    }
}

