/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.yx;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.console.service.facade.CustomerLimitInfoService;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.CustomerLimitInfoVO;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.loan.PerLoanSysLoanBalanceReqBean;
import com.irdstudio.efp.esb.service.bo.resp.loan.PerLoanSysLoanBalanceRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.loan.PerLoanSysLoanBalanceService;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.ed.LimitControlsService;
import com.irdstudio.efp.nls.service.facade.ed.LmtRecoverRecordService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="limitControlsService")
public class LimitControlsServiceImpl
implements LimitControlsService {
    public final String prdStatus = "2";
    public final String loanCate = "001";
    public final String customerLimitInfoSts = "01";
    public final String cusType = "02";
    public final String cuarMd = "1";
    public final String guarWay = "00";
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtRecoverRecordService")
    private LmtRecoverRecordService lmtRecoverRecordService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="customerLimitInfoService")
    private CustomerLimitInfoService customerLimitInfoService;
    @Autowired
    @Qualifier(value="perLoanSysLoanBalanceService")
    private PerLoanSysLoanBalanceService perLoanSysLoanBalanceService;
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    private static final Logger log = LoggerFactory.getLogger(LimitControlsServiceImpl.class);

    public BigDecimal getAvailAmt(NlsApplyInfoVO nlsApplyInfoVO) throws BizException {
        CustomerLimitInfoVO customerLimitInfoVO = new CustomerLimitInfoVO();
        customerLimitInfoVO.setSts("01");
        customerLimitInfoVO.setCusType("02");
        BigDecimal availAmt = new BigDecimal("1");
        PerLoanSysLoanBalanceReqBean perLoanSysLoanBalanceReqBean = new PerLoanSysLoanBalanceReqBean();
        perLoanSysLoanBalanceReqBean.setCertTp(nlsApplyInfoVO.getCertType());
        perLoanSysLoanBalanceReqBean.setCertNo(nlsApplyInfoVO.getCertCode());
        perLoanSysLoanBalanceReqBean.setGuarMd("1");
        try {
            customerLimitInfoVO = this.customerLimitInfoService.queryByStsAndCusTyp(customerLimitInfoVO);
            if (customerLimitInfoVO.getQuotaLimiAmt() != null && TimeUtil.compareDates((String)TimeUtil.getCurDate(), (String)customerLimitInfoVO.getStrDt()) > -1 && TimeUtil.compareDates((String)TimeUtil.getCurDate(), (String)customerLimitInfoVO.getEndDt()) < 1) {
                BigDecimal amtLimit = customerLimitInfoVO.getQuotaLimiAmt();
                BigDecimal preOccAmt = this.getPreOccAmt(nlsApplyInfoVO.getCertCode(), nlsApplyInfoVO.getCertType());
                BigDecimal otherSysAmt = BigDecimal.ZERO;
                SCfgParamVO sCfgParamVO = new SCfgParamVO();
                sCfgParamVO.setParamKey("LOAN_SYS_LOAN_BALANCE_QUERY_SWITCH");
                sCfgParamVO.setParamValue("Y");
                sCfgParamVO = this.sCfgParamService.queryByCondition(sCfgParamVO);
                if (Objects.nonNull(sCfgParamVO)) {
                    PerLoanSysLoanBalanceRespBean perLoanSysLoanBalanceRespBean = null;
                    try {
                        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.perLoanSysLoanBalanceService, (Object)perLoanSysLoanBalanceReqBean, this.nlsQueueSoltComnService);
                        perLoanSysLoanBalanceRespBean = (PerLoanSysLoanBalanceRespBean)esbInvokeWrapper.invoke3Threes();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(nlsApplyInfoVO.getApplySeq() + "------\u8c03\u7528\u4e2a\u8d37\u67e5\u8be2\u8d37\u6b3e\u501f\u636e\u4f59\u989d\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38!!!");
                        throw new BizException("\u8c03\u7528\u4e2a\u8d37\u67e5\u8be2\u8d37\u6b3e\u501f\u636e\u4f59\u989d\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38!");
                    }
                    if (Objects.nonNull(perLoanSysLoanBalanceRespBean) && Objects.nonNull(perLoanSysLoanBalanceRespBean.getLoanBalSumr())) {
                        otherSysAmt = new BigDecimal(perLoanSysLoanBalanceRespBean.getLoanBalSumr());
                    }
                }
                availAmt = amtLimit.subtract(preOccAmt).subtract(otherSysAmt);
                log.info(nlsApplyInfoVO.getApplySeq() + "\u5df2\u5360\u7528\u989d\u5ea6\u4e3a" + preOccAmt + "\u5f53\u524d\u7533\u8bf7\u989d\u5ea6\u4e3a" + nlsApplyInfoVO.getApplyAmt() + "\u76ee\u524d\u53ef\u7528\u989d\u5ea6\u4e3a" + availAmt);
            }
            return availAmt;
        }
        catch (BizException e) {
            nlsApplyInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get("Other"));
            nlsApplyInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get("Other"));
            e.printStackTrace();
            throw new BizException("\u8c03\u7528\u4e2a\u8d37\u67e5\u8be2\u8d37\u6b3e\u501f\u636e\u4f59\u989d\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38!");
        }
        catch (Exception e) {
            nlsApplyInfoVO.setBdReasonCode((String)MsLoanConstant.ReasonCodeMap.get("Other"));
            nlsApplyInfoVO.setBdReasonMsg((String)MsLoanConstant.ReasonMsgMap.get("Other"));
            e.printStackTrace();
            throw new BizException("\u5728\u8d37\u91d1\u989d\u7edf\u8ba1\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public BigDecimal getPreOccAmt(String certCode, String cerType) throws BizException {
        BigDecimal sumAmt = BigDecimal.ZERO;
        try {
            log.info("\u5f00\u59cb\u8fdb\u884c\u989d\u5ea6\u7edf\u8ba1,\u6d41\u6c34\u53f7:\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType);
            String prdId = this.queryPrdIdByLoanCate("2", "001", "00");
            BigDecimal loanBalance = this.queryPreOccAmt2(certCode, cerType, prdId);
            BigDecimal duringAmt = this.queryDuringAmt(certCode, cerType, prdId);
            BigDecimal recoverAmt = this.queryRecoverAmt(certCode, cerType, prdId);
            sumAmt = loanBalance.add(duringAmt).subtract(recoverAmt);
            log.info("\u7edf\u8ba1\u5168\u90e8\u91d1\u989d" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u5df2\u5360\u7528\u989d\u5ea6\u67e5\u8be2\u5f02\u5e38");
        }
        finally {
            return sumAmt;
        }
    }

    public BigDecimal getPreOccAmt2(String certCode, String cerType, BigDecimal applyAmt) throws BizException {
        BigDecimal sumAmt = BigDecimal.ZERO;
        try {
            log.info("\u5f00\u59cb\u8fdb\u884c\u989d\u5ea6\u7edf\u8ba1,\u6d41\u6c34\u53f7:\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType);
            String prdId = this.queryPrdIdByLoanCate("2", "001", "00");
            BigDecimal loanBalance = this.queryPreOccAmt2(certCode, cerType, prdId);
            BigDecimal duringAmt = this.queryDuringAmt(certCode, cerType, prdId);
            BigDecimal recoverAmt = this.queryRecoverAmt(certCode, cerType, prdId);
            sumAmt = loanBalance.add(duringAmt).subtract(recoverAmt).subtract(applyAmt);
            log.info("\u7edf\u8ba1\u5168\u90e8\u91d1\u989d" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u5df2\u5360\u7528\u989d\u5ea6\u67e5\u8be2\u5f02\u5e38");
        }
        finally {
            return sumAmt;
        }
    }

    public String queryPrdIdByLoanCate(String prdStatus, String loanCate, String guarWay) throws BizException {
        String prdId = "";
        try {
            PrdInfoVO prdInfoVO = new PrdInfoVO();
            prdInfoVO.setPrdStatus(prdStatus);
            prdInfoVO.setLoanCate(loanCate);
            prdInfoVO.setGuarWay(guarWay);
            List prdInfoVOS = this.prdInfoService.queryPrdType(prdInfoVO);
            StringBuffer prdIdStrs = new StringBuffer();
            for (PrdInfoVO infoVO : prdInfoVOS) {
                prdIdStrs.append("'" + infoVO.getPrdId() + "',");
            }
            prdId = prdIdStrs.substring(1, prdIdStrs.length() - 2) + "";
            return prdId;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u6839\u636e\u4ea7\u54c1\u72b6\u6001\uff0c\u8d37\u6b3e\u5206\u7c7b\uff0c\u62c5\u4fdd\u65b9\u5f0f\u67e5\u8be2\u4ea7\u54c1\u4ee3\u7801\u5931\u8d25\uff01");
        }
        finally {
            return prdId;
        }
    }

    public BigDecimal queryDuringAmt(String certCode, String cerType, String prdId) throws BizException {
        BigDecimal duringAmt = BigDecimal.ZERO;
        try {
            NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
            nlsApplyInfoVO.setCertCode(certCode);
            nlsApplyInfoVO.setCertType(cerType);
            nlsApplyInfoVO.setPrdId(prdId);
            duringAmt = this.nlsApplyInfoService.queryDuringAmt(nlsApplyInfoVO);
            log.info("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u67e5\u8be2\u5728\u9014\u91d1\u989d\uff1a\u6302\u8d77\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u901a\u8fc7\u5f85\u653e\u6b3e\u91d1\u989d\u4e3a" + duringAmt);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u67e5\u8be2\u5728\u9014\u91d1\u989d\uff1a\u6302\u8d77\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u901a\u8fc7\u5f85\u653e\u6b3e\u5931\u8d25\uff01");
        }
        finally {
            return duringAmt;
        }
    }

    public BigDecimal queryPreOccAmt(String certCode, String cerType, String prdId) throws BizException {
        BigDecimal loanBalance = BigDecimal.ZERO;
        try {
            AccLoanVO accloanParam = new AccLoanVO();
            accloanParam.setCertCode(certCode);
            accloanParam.setCertType(cerType);
            accloanParam.setPrdId(prdId);
            loanBalance = this.accLoanService.queryPreOccAmt(accloanParam);
            log.info("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u501f\u636e\u4f59\u989d\u4e3a" + loanBalance);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u67e5\u8be2\u501f\u636e\u4f59\u989d\u5931\u8d25\uff01");
        }
        finally {
            return loanBalance;
        }
    }

    public BigDecimal queryPreOccAmt2(String certCode, String cerType, String prdId) throws BizException {
        BigDecimal loanBalance = BigDecimal.ZERO;
        try {
            AccLoanVO accloanParam = new AccLoanVO();
            accloanParam.setCertCode(certCode);
            accloanParam.setCertType(cerType);
            accloanParam.setPrdId(prdId);
            loanBalance = this.accLoanService.queryPreOccAmt2(accloanParam);
            log.info("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u501f\u636e\u4f59\u989d\u4e3a" + loanBalance);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u67e5\u8be2\u501f\u636e\u4f59\u989d\u5931\u8d25\uff01");
        }
        finally {
            return loanBalance;
        }
    }

    public BigDecimal queryRecoverAmt(String certCode, String cerType, String prdId) throws BizException {
        BigDecimal recoverAmt = BigDecimal.ZERO;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("prdId", prdId);
            paramMap.put("certCode", certCode);
            paramMap.put("cerType", cerType);
            String bizDate = this.accLoanService.queryMaxBizdate(paramMap);
            String startTime = TimeUtil.getCurDate() + " 00:02:00";
            if (StringUtil.isNotEmpty((String)bizDate)) {
                startTime = TimeUtil.addDay((String)bizDate, (int)1);
            }
            String endTime = TimeUtil.getCurrentDateTime();
            paramMap.put("startTime", startTime);
            paramMap.put("endTime", endTime);
            recoverAmt = this.lmtRecoverRecordService.querRecoverAmt(paramMap);
            log.info("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u5f00\u59cb\u65f6\u95f4" + startTime + "\u7ed3\u675f\u65f6\u95f4" + endTime + "\u67e5\u8be2\u989d\u5ea6\u6062\u590d\u91d1\u989d\u4e3a" + recoverAmt.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + certCode + "\u8bc1\u4ef6\u53f7\u7801" + cerType + "\u989d\u5ea6\u6062\u590d\u91d1\u989d\u5931\u8d25\uff01");
        }
        finally {
            return recoverAmt;
        }
    }

    public boolean isDuring(NlsApplyInfoVO nlsApplyInfoVO) throws BizException {
        boolean isDuring = false;
        try {
            String prdId = this.queryPrdIdByLoanCate("2", "001", "00");
            BigDecimal duringAmt = this.queryDuringAmt(nlsApplyInfoVO.getCertCode(), nlsApplyInfoVO.getCertType(), prdId);
            duringAmt = nlsApplyInfoVO.getApplyAmt().subtract(duringAmt);
            if (duringAmt.compareTo(BigDecimal.ZERO) != 0) {
                isDuring = true;
                return isDuring;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + nlsApplyInfoVO.getCertCode() + "\u8bc1\u4ef6\u53f7\u7801" + nlsApplyInfoVO.getCertType() + "\u5224\u65ad\u662f\u5426\u5728\u9014\u5931\u8d25\uff01");
        }
        finally {
            return isDuring;
        }
    }

    public boolean isCreditDuring(String certType, String certCode, String applySeq) throws BizException {
        boolean isDuring = false;
        try {
            String prdId = this.queryPrdIdByLoanCate("2", "001", "00");
            List nlsCreditInfoVOS = this.nlsCreditInfoService.queryCreditDuring(certType, certCode, prdId, applySeq);
            if (nlsCreditInfoVOS.size() > 0) {
                isDuring = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + certType + "\u8bc1\u4ef6\u53f7\u7801" + certCode + "\u5224\u65ad\u662f\u5426\u5728\u9014\u6388\u4fe1\u5931\u8d25\uff01");
        }
        return isDuring;
    }

    public boolean yedIsDuring(NlsApplyInfoVO nlsApplyInfoVO) throws BizException {
        boolean isDuring = false;
        try {
            String prdId = this.queryPrdIdByLoanCate("2", "001", "00");
            NlsApplyInfoVO nlsApplyInfoVONew = new NlsApplyInfoVO();
            nlsApplyInfoVONew.setCertCode(nlsApplyInfoVO.getCertCode());
            nlsApplyInfoVONew.setCertType(nlsApplyInfoVO.getCertType());
            nlsApplyInfoVONew.setPrdId(prdId);
            Integer isDuringCount = this.nlsApplyInfoService.queryDuringCountYED(nlsApplyInfoVONew);
            if (isDuringCount > 0) {
                isDuring = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u8bc1\u4ef6\u7c7b\u578b" + nlsApplyInfoVO.getCertCode() + "\u8bc1\u4ef6\u53f7\u7801" + nlsApplyInfoVO.getCertType() + "\u5224\u65ad\u662f\u5426\u5728\u9014\u5931\u8d25\uff01");
        }
        return isDuring;
    }
}

