/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.zxbg;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.Try;
import com.irdstudio.cdp.pboc.service.facade.CreditQueryDetailService;
import com.irdstudio.cdp.pboc.service.facade.QueryZxFailRecordService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.facade.ZXJsonInfoService;
import com.irdstudio.cdp.pboc.service.vo.CreditQueryDetailVO;
import com.irdstudio.cdp.pboc.service.vo.QueryZxFailRecordVO;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.cdp.pboc.service.vo.ZXJsonInfoVO;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.esb.service.bo.req.ZXCXA01QueryReports;
import com.irdstudio.efp.esb.service.facade.zx.NewZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.zxbg.ZxbgQueryTaskService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="zxbgQueryTaskService")
public class ZxbgQueryTaskServiceImpl
implements ZxbgQueryTaskService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(ZxbgQueryTaskServiceImpl.class);
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    @Qualifier(value="zxJsonInfoService")
    private ZXJsonInfoService zxJsonInfoService;
    @Autowired
    @Qualifier(value="zxCXA01Service")
    private NewZXService<ZXCXA01QueryReports> zxCXA01Service;
    @Autowired
    @Qualifier(value="zxHtmlInfoService")
    private ZXHtmlInfoService zxHtmlInfoService;
    @Autowired
    @Qualifier(value="creditQueryDetailService")
    private CreditQueryDetailService creditQueryDetailService;
    @Autowired
    @Qualifier(value="yedUploadService")
    private YedUploadService yedUploadService;
    @Value(value="${yed_zxreport_save_path}")
    private String filePath;
    @Autowired
    @Qualifier(value="queryZxFailRecordService")
    private QueryZxFailRecordService queryZxFailRecordService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;

    public boolean doQuery() {
        logger.info("\u5f81\u4fe1\u62a5\u544a\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        List queryZxFailRecordVOS = this.queryZxFailRecordService.queryListByIsQuery();
        if (Objects.nonNull(queryZxFailRecordVOS) && queryZxFailRecordVOS.size() > 0) {
            logger.debug("\u5f85\u67e5\u8be2\u5f81\u4fe1\u62a5\u544a\u7684\u6570\u636e\u6761\u6570\u4e3a\uff1a" + queryZxFailRecordVOS.size());
            for (QueryZxFailRecordVO item : queryZxFailRecordVOS) {
                try {
                    if (this.zxQuery(item)) {
                        item.setIsUpdateSuccess("Y");
                    }
                    item.setIsQuerySuccess("Y");
                    item.setLastUpdateTime(TimeUtil.getCurrentDateTime());
                    this.queryZxFailRecordService.updateByPk(item);
                }
                catch (Exception e) {
                    logger.info("\u5f81\u4fe1\u62a5\u544a\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + item.getLmtApplySeq());
                    logger.error(Arrays.toString(e.getStackTrace()));
                }
            }
        } else {
            logger.info("\u5f53\u524d\u65e0\u6570\u636e\u9700\u8981\u67e5\u8be2\u5f81\u4fe1\u62a5\u544a\u3002");
        }
        logger.info("\u5f81\u4fe1\u62a5\u544a\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        return true;
    }

    private boolean zxQuery(QueryZxFailRecordVO invo) throws Exception {
        String applySeq = invo.getLmtApplySeq();
        try {
            String appNo = applySeq;
            logger.info("\u5f00\u59cb\u8fdb\u884c\u5f81\u4fe1\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7:" + appNo);
            String cusName = invo.getCusName();
            String certNo = invo.getCertCode();
            String certType = invo.getCertType();
            String authCd = appNo;
            String prdName = invo.getPrdName();
            String prdCode = invo.getPrdCode();
            String authDate = invo.getAuthDate();
            String authTm = DateUtility.formatDateTime19To14((String)authDate);
            String date = DateTool.getCurrentDate();
            String StopDate = TimeUtil.addDay((String)date, (int)90);
            List params = this.sCfgParamService.queryToZx();
            String RprtUsr = null;
            String RprtUsrBlngDept = null;
            String valiDay = null;
            for (SCfgParamVO param : params) {
                if (param.getParamKey().equals("ZX_RprtUsr")) {
                    RprtUsr = param.getParamValue();
                    continue;
                }
                if (param.getParamKey().equals("ZX_RprtUsrBlngDept")) {
                    RprtUsrBlngDept = param.getParamValue();
                    continue;
                }
                if (!param.getParamKey().equals("ZX_MS_VALID_DAY")) continue;
                valiDay = param.getParamValue();
            }
            String queryAppType = "05";
            String queryReason = "02";
            String queryType = "0";
            String authMd = "19";
            String crdtRprtQryMd = "1";
            ZXCXA01QueryReports ZXQueryReports = new ZXCXA01QueryReports.Builder().withQryAppTp("05").withRprtUsr(RprtUsr).withRprtUsrBlngDept(RprtUsrBlngDept).withCustNm(cusName).withIdentTp(certType).withIdentNo(certNo).withQryRsn("02").withQryTp("0").withAcqrngCustSrc("\u5e7f\u5dde\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8").withPdNm(prdName).withAuthMd("19").withCrdtRprtQryMd("1").withAuthTm(authTm).withAuthStrtDt(date).withAuthStopDt(StopDate).build();
            String reportId = null;
            ZXJsonInfoVO queryReportVo = new ZXJsonInfoVO();
            queryReportVo.setCertCode(certNo);
            List zxInfo = this.zxJsonInfoService.queryReportId(queryReportVo);
            if (zxInfo.size() > 0) {
                String reportTime = ((ZXJsonInfoVO)zxInfo.get(0)).getReportTime();
                reportTime = StringUtils.replace((String)reportTime, (String)".", (String)"-");
                logger.info("\u5f53\u524d\u7528\u6237\u5f81\u4fe1\u62a5\u544a\u65e5\u671f" + reportTime);
                int day = TimeUtil.compareDates((String)TimeUtil.addDay((String)reportTime, (int)Integer.parseInt(valiDay)), (String)DateTool.getCurrentDateTime());
                if (day < 0) {
                    try {
                        ZXVO zxvoJson = this.zxCXA01Service.Zxservice((Object)ZXQueryReports, params);
                        reportId = (String)zxvoJson.getResp();
                    }
                    catch (Exception e) {
                        throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                    }
                    logger.info("\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5b8c\u6210,\u6d41\u6c34\u53f7:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
                } else {
                    reportId = ((ZXJsonInfoVO)zxInfo.get(0)).getReportId();
                    logger.info("\u5f81\u4fe1\u62a5\u544a\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u67e5\u8be2\u5f81\u4fe1:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
                }
            } else {
                try {
                    ZXVO zxvoJson = this.zxCXA01Service.Zxservice((Object)ZXQueryReports, params);
                    reportId = (String)zxvoJson.getResp();
                }
                catch (Exception e) {
                    throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
                logger.info("\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5b8c\u6210,\u6d41\u6c34\u53f7:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
            }
            List zxHtmlInfoVOS = this.zxHtmlInfoService.queryAllZXHtmlReports(Arrays.asList(reportId));
            if (null == zxHtmlInfoVOS || zxHtmlInfoVOS.isEmpty()) {
                throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38");
            }
            String fpath = this.filePath + reportId + ".html";
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(fpath), "UTF-8");
            osw.write(((ZXHtmlInfoVO)zxHtmlInfoVOS.get(0)).getContent());
            osw.flush();
            osw.close();
            YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
            yedUploadRecordVO.setApplSeq(applySeq);
            yedUploadRecordVO.setCreateTime(new Date());
            yedUploadRecordVO.setDealType("1");
            yedUploadRecordVO.setFileType("Y03");
            yedUploadRecordVO.setFileUrl(fpath);
            yedUploadRecordVO.setPrdId(prdCode);
            yedUploadRecordVO.setUpErrMsg("");
            yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
            yedUploadRecordVO.setUpNum(Integer.valueOf(0));
            yedUploadRecordVO.setUpSta(Integer.valueOf(0));
            yedUploadRecordVO.setUpTime(new Date());
            this.yedUploadService.insert(yedUploadRecordVO);
            NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
            nlsCreditInfoVO.setLmtApplySeq(invo.getLmtApplySeq());
            NlsCreditInfoVO queryNlsCreditInfoVO = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
            CreditQueryDetailVO creditQueryDetailVO = new CreditQueryDetailVO();
            creditQueryDetailVO.setSerno(UUID.randomUUID().toString().replace("-", ""));
            creditQueryDetailVO.setCusId(queryNlsCreditInfoVO.getCusId());
            creditQueryDetailVO.setCusName(cusName);
            creditQueryDetailVO.setCertType(certType);
            creditQueryDetailVO.setCertCode(certNo);
            creditQueryDetailVO.setTransactionCode(applySeq);
            creditQueryDetailVO.setPrdCode(prdCode);
            creditQueryDetailVO.setPrdName(prdName);
            creditQueryDetailVO.setReportId(reportId);
            creditQueryDetailVO.setReportTime(TimeUtil.getCurrentDateTime());
            creditQueryDetailVO.setRequestTime(TimeUtil.getCurrentDateTime());
            creditQueryDetailVO.setZxOpId("admin");
            creditQueryDetailVO.setInputBrId(queryNlsCreditInfoVO.getMainBrId());
            creditQueryDetailVO.setFinaBrId(queryNlsCreditInfoVO.getChargeoffBrId());
            Optional.ofNullable(creditQueryDetailVO).ifPresent(Try.ofConsumer(arg_0 -> ((CreditQueryDetailService)this.creditQueryDetailService).insertCreditQueryDetailVO(arg_0)));
        }
        catch (IOException e) {
            logger.debug("\u5f81\u4fe1\u62a5\u544a\u5199\u5165\u670d\u52a1\u5668\u5931\u8d25" + invo.getLmtApplySeq());
            logger.error(Arrays.toString(e.getStackTrace()));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("\u5176\u4ed6\u5f02\u5e38" + invo.getLmtApplySeq());
            logger.error(Arrays.toString(e.getStackTrace()));
            throw new Exception(e);
        }
        return true;
    }
}

