/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.zxbg;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.Try;
import com.irdstudio.cdp.pboc.service.facade.CreditQueryDetailService;
import com.irdstudio.cdp.pboc.service.facade.QueryZxFailRecordService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.vo.CreditQueryDetailVO;
import com.irdstudio.cdp.pboc.service.vo.QueryZxFailRecordVO;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.zxbg.ZxbgUploadTaskService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="zxbgUploadTaskService")
public class ZxbgUploadTaskServiceImpl
implements ZxbgUploadTaskService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(ZxbgUploadTaskServiceImpl.class);
    @Autowired
    @Qualifier(value="queryZxFailRecordService")
    private QueryZxFailRecordService queryZxFailRecordService;
    @Autowired
    @Qualifier(value="zxHtmlInfoService")
    private ZXHtmlInfoService zxHtmlInfoService;
    @Value(value="${yed_zxreport_save_path}")
    private String filePath;
    @Autowired
    @Qualifier(value="creditQueryDetailService")
    private CreditQueryDetailService creditQueryDetailService;
    @Autowired
    @Qualifier(value="yedUploadService")
    private YedUploadService yedUploadService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;

    public boolean doUpload() {
        logger.info("\u5f81\u4fe1\u62a5\u544a\u5b9a\u65f6\u5199\u5165\u4efb\u52a1\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        List queryZxFailRecordVOS = this.queryZxFailRecordService.queryListByIsUpdate();
        if (Objects.nonNull(queryZxFailRecordVOS) && queryZxFailRecordVOS.size() > 0) {
            logger.debug("\u5f85\u5199\u5165\u78c1\u76d8\u5f81\u4fe1\u62a5\u544a\u7684\u6570\u636e\u6761\u6570\u4e3a\uff1a" + queryZxFailRecordVOS.size());
            for (QueryZxFailRecordVO item : queryZxFailRecordVOS) {
                boolean flag = this.writeFile(item);
                if (!flag) continue;
                item.setIsUpdateSuccess("Y");
                item.setLastUpdateTime(TimeUtil.getCurrentDateTime());
                this.queryZxFailRecordService.updateByPk(item);
            }
        } else {
            logger.info("\u5f53\u524d\u65e0\u5f81\u4fe1\u62a5\u544a\u9700\u8981\u5199\u5165\u78c1\u76d8\u3002");
        }
        logger.info("\u5f81\u4fe1\u62a5\u544a\u5b9a\u65f6\u5199\u5165\u4efb\u52a1\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        return true;
    }

    private boolean writeFile(QueryZxFailRecordVO invo) {
        ZXHtmlInfoVO zxHtmlInfoVO = new ZXHtmlInfoVO();
        zxHtmlInfoVO.setCertCode(invo.getCertCode());
        ZXHtmlInfoVO zxHtmlInfoVOS = this.zxHtmlInfoService.queryZXHtmlByCert(zxHtmlInfoVO);
        String fpath = this.filePath + zxHtmlInfoVOS.getReportId() + ".html";
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(fpath), "UTF-8");
            osw.write(zxHtmlInfoVOS.getContent());
            osw.flush();
            osw.close();
            YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
            yedUploadRecordVO.setApplSeq(invo.getLmtApplySeq());
            yedUploadRecordVO.setCreateTime(new Date());
            yedUploadRecordVO.setDealType("1");
            yedUploadRecordVO.setFileType("Y03");
            yedUploadRecordVO.setFileUrl(fpath);
            yedUploadRecordVO.setPrdId(invo.getPrdCode());
            yedUploadRecordVO.setUpErrMsg("");
            yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
            yedUploadRecordVO.setUpNum(Integer.valueOf(0));
            yedUploadRecordVO.setUpSta(Integer.valueOf(0));
            yedUploadRecordVO.setUpTime(new Date());
            this.yedUploadService.insert(yedUploadRecordVO);
            NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
            nlsCreditInfoVO.setLmtApplySeq(invo.getLmtApplySeq());
            NlsCreditInfoVO queryNlsCreditInfoVO = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
            CreditQueryDetailVO creditQueryDetailVO = new CreditQueryDetailVO();
            creditQueryDetailVO.setSerno(UUID.randomUUID().toString().replace("-", ""));
            creditQueryDetailVO.setCusId(queryNlsCreditInfoVO.getCusId());
            creditQueryDetailVO.setCusName(invo.getCusName());
            creditQueryDetailVO.setCertType(invo.getCertType());
            creditQueryDetailVO.setCertCode(invo.getCertCode());
            creditQueryDetailVO.setTransactionCode(invo.getLmtApplySeq());
            creditQueryDetailVO.setPrdCode(invo.getPrdCode());
            creditQueryDetailVO.setPrdName(invo.getPrdName());
            creditQueryDetailVO.setReportId(zxHtmlInfoVOS.getReportId());
            creditQueryDetailVO.setReportTime(TimeUtil.getCurrentDateTime());
            creditQueryDetailVO.setRequestTime(TimeUtil.getCurrentDateTime());
            creditQueryDetailVO.setZxOpId("admin");
            creditQueryDetailVO.setInputBrId(queryNlsCreditInfoVO.getMainBrId());
            creditQueryDetailVO.setFinaBrId(queryNlsCreditInfoVO.getChargeoffBrId());
            Optional.ofNullable(creditQueryDetailVO).ifPresent(Try.ofConsumer(arg_0 -> ((CreditQueryDetailService)this.creditQueryDetailService).insertCreditQueryDetailVO(arg_0)));
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u5f02\u5e38>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + invo.getLmtApplySeq());
            logger.error(Arrays.toString(e.getStackTrace()));
            return false;
        }
        catch (Exception e) {
            logger.error("\u5176\u4ed6\u5f02\u5e38>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + invo.getLmtApplySeq());
            logger.error(e + Arrays.toString(e.getStackTrace()));
            return false;
        }
        return true;
    }
}

