/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableDocument;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableTable;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableTableCell;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleHeaderFooterProperties;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;

public class StylableHeaderFooter
extends StylableTable
implements IMasterPageHeaderFooter {
    private final StylableDocument ownerDocument;
    private final boolean header;
    private final StylableTableCell tableCell;

    public StylableHeaderFooter(StylableDocument ownerDocument, boolean header) {
        super(ownerDocument, null, 1);
        this.ownerDocument = ownerDocument;
        this.header = header;
        this.tableCell = ownerDocument.createTableCell(this);
        this.tableCell.setBorder(0);
        this.tableCell.setPadding(0.0f);
    }

    public StylableTableCell getTableCell() {
        return this.tableCell;
    }

    @Override
    public void applyStyles(Style style) {
        StyleHeaderFooterProperties headerFooterProperties;
        StyleHeaderFooterProperties styleHeaderFooterProperties = headerFooterProperties = this.header ? style.getHeaderProperties() : style.getFooterProperties();
        if (headerFooterProperties != null) {
            Float marginTop;
            Float marginRight;
            Float marginLeft;
            Float marginBottom;
            Float margin;
            Float minHeight = headerFooterProperties.getMinHeight();
            if (minHeight != null) {
                this.tableCell.setMinimumHeight(minHeight.floatValue());
            }
            if ((margin = headerFooterProperties.getMargin()) != null) {
                this.tableCell.setPadding(margin.floatValue());
            }
            if ((marginBottom = headerFooterProperties.getMarginBottom()) != null) {
                this.tableCell.setPaddingBottom(marginBottom.floatValue());
            }
            if ((marginLeft = headerFooterProperties.getMarginLeft()) != null) {
                this.tableCell.setPaddingLeft(marginLeft.floatValue());
            }
            if ((marginRight = headerFooterProperties.getMarginRight()) != null) {
                this.tableCell.setPaddingRight(marginRight.floatValue());
            }
            if ((marginTop = headerFooterProperties.getMarginTop()) != null) {
                this.tableCell.setPaddingTop(marginTop.floatValue());
            }
        }
    }

    private void setWidthIfNecessary() {
        float headerFooterWidth = this.ownerDocument.right() - this.ownerDocument.left();
        if (this.getTotalWidth() != headerFooterWidth) {
            this.setTotalWidth(headerFooterWidth);
        }
    }

    public float getTotalHeight() {
        this.setWidthIfNecessary();
        return super.getRowHeight(0);
    }

    public void flush() {
        super.addCell((PdfPCell)this.tableCell);
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas) {
        this.setWidthIfNecessary();
        return super.writeSelectedRows(rowStart, rowEnd, xPos, yPos, canvas);
    }
}

