/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.factories.RomanAlphabetFactory;
import com.itextpdf.text.factories.RomanNumberFactory;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableDocument;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableList;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.StylableParagraph;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleListProperties;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleNumFormat;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleTextProperties;
import java.util.List;
import java.util.Map;

public class StylableHeading
extends StylableParagraph {
    private static final long serialVersionUID = 664309269352903329L;
    public static final String IMPLICIT_REFERENCE_SUFFIX = "|outline";
    private List<Integer> headingNumbering;

    public StylableHeading(StylableDocument ownerDocument, IStylableContainer parent, List<Integer> headingNumbering) {
        super(ownerDocument, parent);
        this.headingNumbering = headingNumbering;
    }

    public static int getFirst(Style style, int outlineLevel) {
        Integer startValue;
        StyleListProperties listProperties;
        Map<Integer, StyleListProperties> listPropertiesMap;
        int first = 1;
        Map<Integer, StyleListProperties> map = listPropertiesMap = style != null ? style.getOutlinePropertiesMap() : null;
        if (listPropertiesMap != null && (listProperties = StylableList.getListProperties(listPropertiesMap, outlineLevel)) != null && (startValue = listProperties.getStartValue()) != null) {
            first = startValue;
        }
        return first;
    }

    @Override
    public void applyStyles(Style style) {
        super.applyStyles(style);
        int outlineLevel = this.headingNumbering.size();
        Map<Integer, StyleListProperties> listPropertiesMap = style.getOutlinePropertiesMap();
        if (listPropertiesMap != null) {
            Integer displayLevels;
            int displayCount = 1;
            StyleListProperties listProperties = StylableList.getListProperties(listPropertiesMap, outlineLevel);
            if (listProperties != null && (displayLevels = listProperties.getDisplayLevels()) != null && displayLevels > 1) {
                displayCount = Math.min(displayLevels, outlineLevel);
            }
            this.addNumbering(listPropertiesMap, displayCount);
        }
        Chunk chunk = new Chunk("\t");
        chunk.setLocalDestination(StylableHeading.generateImplicitDestination(this.headingNumbering));
        this.addElement((Element)chunk);
    }

    private void addNumbering(Map<Integer, StyleListProperties> listPropertiesMap, int displayCount) {
        for (int i = 0; i < displayCount; ++i) {
            StyleListProperties listProperties = StylableList.getListProperties(listPropertiesMap, i + 1);
            int value = this.headingNumbering.get(i);
            if (listProperties == null) continue;
            Chunk chunk = this.formatNumber(listProperties, value);
            this.addElement((Element)chunk);
        }
    }

    private Chunk formatNumber(StyleListProperties listProperties, int value) {
        StyleNumFormat numFormat;
        Font font;
        Chunk symbol = new Chunk("", this.getFont());
        StyleTextProperties textProperties = listProperties.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            symbol.setFont(font);
        }
        if ((numFormat = listProperties.getNumFormat()) != null) {
            StringBuilder sbuf = new StringBuilder();
            String numPrefix = listProperties.getNumPrefix();
            if (numPrefix != null) {
                sbuf.append(numPrefix);
            }
            if (numFormat.isAlphabetical()) {
                sbuf.append(RomanAlphabetFactory.getString((int)value, (boolean)numFormat.isLowercase()));
            } else if (numFormat.isRoman()) {
                sbuf.append(RomanNumberFactory.getString((int)value, (boolean)numFormat.isLowercase()));
            } else {
                sbuf.append(value);
            }
            String numSuffix = listProperties.getNumSuffix();
            if (numSuffix != null) {
                sbuf.append(numSuffix);
            }
            symbol.append(sbuf.toString());
        }
        return symbol;
    }

    public static String generateImplicitDestination(String s) {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        StringBuilder sbuf = new StringBuilder();
        for (char ch : s.toCharArray()) {
            if (!Character.isDigit(ch) && ch != '.') break;
            sbuf.append(ch);
        }
        sbuf.append(IMPLICIT_REFERENCE_SUFFIX);
        return sbuf.toString();
    }

    private static String generateImplicitDestination(List<Integer> headingNumbering) {
        StringBuilder sbuf = new StringBuilder();
        for (Integer nr : headingNumbering) {
            sbuf.append(nr.toString());
            sbuf.append(".");
        }
        sbuf.append(IMPLICIT_REFERENCE_SUFFIX);
        return sbuf.toString();
    }
}

