/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableFactory;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleTextProperties;
import java.util.List;

public class StylablePhrase
extends Phrase
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylablePhrase(IStylableFactory ownerDocument, IStylableContainer parent) {
        this.parent = parent;
    }

    @Override
    public void addElement(Element element) {
        super.add(this.size(), element);
    }

    @Override
    public void applyStyles(Style style) {
        Font font;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            super.setFont(font);
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        boolean empty = true;
        List chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            if (chunk.getImage() != null || chunk.getContent() == null || chunk.getContent().length() <= 0) continue;
            empty = false;
            break;
        }
        if (empty) {
            super.add((Element)new Chunk("\t"));
        }
        return this;
    }
}

