/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.docx.docx4j.xhtml;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterNoEntriesSupport;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HtmlExporterNG2;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

public class Docx2XHTMLViaDocx4jConverter
extends AbstractConverterNoEntriesSupport
implements MimeMappingConstants {
    private static final Docx2XHTMLViaDocx4jConverter INSTANCE = new Docx2XHTMLViaDocx4jConverter();
    private static final Logger LOGGER = LogUtils.getLogger((String)Docx2XHTMLViaDocx4jConverter.class.getName());

    public static Docx2XHTMLViaDocx4jConverter getInstance() {
        return INSTANCE;
    }

    public void convert(InputStream in, OutputStream out, Options options) throws XDocConverterException {
        try {
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((InputStream)in);
            HtmlExporterNG2 exporter = new HtmlExporterNG2();
            StreamResult result = new StreamResult(out);
            exporter.html(wordMLPackage, (Result)result, this.toHtmlSettings(options));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new XDocConverterException((Throwable)e);
        }
    }

    public AbstractHtmlExporter.HtmlSettings toHtmlSettings(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(AbstractHtmlExporter.HtmlSettings.class);
        if (value instanceof AbstractHtmlExporter.HtmlSettings) {
            return (AbstractHtmlExporter.HtmlSettings)value;
        }
        return new AbstractHtmlExporter.HtmlSettings();
    }

    public MimeMapping getMimeMapping() {
        return XHTML_MIME_MAPPING;
    }
}

