/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.formatter.AbstractDocumentFormatter;
import fr.opensagres.xdocreport.template.formatter.DirectivesStack;
import fr.opensagres.xdocreport.template.formatter.IfDirective;
import fr.opensagres.xdocreport.template.formatter.LoopDirective;
import fr.opensagres.xdocreport.template.velocity.ModelFieldType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class VelocityDocumentFormatter
extends AbstractDocumentFormatter {
    private static final String EQUALS = "=";
    private static final String END_SET_DIRECTIVE = ")";
    private static final String START_SET_DIRECTIVE = "#set(";
    private static final String DOLLAR_START_BRACKET = "${";
    protected static final String ITEM_TOKEN = "item_";
    private static final String START_FOREACH_DIRECTIVE = "#foreach(";
    private static final String IN_DIRECTIVE = " in ";
    private static final String END_FOREACH_DIRECTIVE = "#{end}";
    private static final char DOLLAR_TOKEN = '$';
    private static final String START_IF_DIRECTIVE = "#if(";
    private static final String ELSE_DIRECTIVE = "#{else}";
    private static final String END_IF_DIRECTIVE = "#{end}";
    private static final String VELOCITY_COUNT = "$velocityCount";
    private static final String START_NOPARSE = "#[[";
    private static final String END_NOPARSE = "]]#";
    private static final String START_DEFINE_DIRECTIVE = "#define(";
    private static final Object CLOSE_DEFINE_DIRECTIVE = ")";
    private static final Object END_DEFINE_DIRECTIVE = "#{end}";

    public String formatAsFieldItemList(String content, String fieldName, boolean forceAsField) {
        Set<ModelFieldType> types = this.getModelFieldTypes(content, fieldName);
        if (types.isEmpty()) {
            if (forceAsField) {
                return '$' + this.getItemToken() + content;
            }
            return content;
        }
        int typesCount = types.size();
        String[] searchList = new String[typesCount];
        String[] replacementList = new String[typesCount];
        int i = 0;
        for (ModelFieldType type : types) {
            searchList[i] = type.getPrefix() + fieldName;
            replacementList[i] = type.getPrefix() + ITEM_TOKEN + fieldName;
            ++i;
        }
        return StringUtils.replaceEach((String)content, (String[])searchList, (String[])replacementList);
    }

    public String formatAsFieldItemList(String content, String fieldName) {
        return this.formatAsFieldItemList(content, fieldName, false);
    }

    public String getStartLoopDirective(String itemNameList, String listName) {
        StringBuilder result = new StringBuilder(START_FOREACH_DIRECTIVE);
        if (itemNameList.charAt(0) != '$') {
            result.append('$');
        }
        result.append(itemNameList);
        result.append(IN_DIRECTIVE);
        if (listName.charAt(0) != '$') {
            result.append('$');
        }
        result.append(listName);
        result.append(')');
        return result.toString();
    }

    public String getEndLoopDirective(String itemNameList) {
        return "#{end}";
    }

    public String getElseDirective() {
        return ELSE_DIRECTIVE;
    }

    protected boolean isModelField(String content, String fieldName) {
        return !this.getModelFieldTypes(content, fieldName).isEmpty();
    }

    private Set<ModelFieldType> getModelFieldTypes(String content, String fieldName) {
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptySet();
        }
        int startIndex = 0;
        EnumSet<ModelFieldType> result = EnumSet.noneOf(ModelFieldType.class);
        int index = -1;
        while ((index = content.indexOf(fieldName, startIndex)) != -1) {
            ModelFieldType fieldType = this.obtainModelFieldType(content, index);
            if (fieldType != null) {
                result.add(fieldType);
            }
            startIndex = index + fieldName.length();
        }
        return result;
    }

    private ModelFieldType obtainModelFieldType(String content, int index) {
        for (ModelFieldType type : ModelFieldType.values()) {
            String actualPrefix;
            String prefix = type.getPrefix();
            int prefixLength = prefix.length();
            if (index < prefixLength || !(actualPrefix = content.substring(index - prefixLength, index)).equals(prefix)) continue;
            return type;
        }
        return null;
    }

    protected String getItemToken() {
        return ITEM_TOKEN;
    }

    public String getFunctionDirective(boolean noescape, boolean encloseInDirective, String key, String methodName, String ... parameters) {
        StringBuilder directive = new StringBuilder();
        if (encloseInDirective) {
            directive.append(DOLLAR_START_BRACKET);
        }
        directive.append(key);
        directive.append('.');
        directive.append(methodName);
        directive.append('(');
        String p = null;
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                p = parameters[i];
                if (i > 0) {
                    directive.append(',');
                }
                p = this.addDollarIfNeed(p);
                directive.append(p);
            }
        }
        directive.append(')');
        if (encloseInDirective) {
            directive.append('}');
        }
        return directive.toString();
    }

    private String addDollarIfNeed(String p) {
        if (!p.startsWith("$") && (p.startsWith("___") || !p.startsWith("'") && !p.startsWith("\""))) {
            return "$" + p;
        }
        return p;
    }

    public String formatAsSimpleField(boolean noescape, boolean encloseInDirective, String ... fields) {
        StringBuilder field = new StringBuilder();
        if (encloseInDirective) {
            field.append('$');
        }
        for (int i = 0; i < fields.length; ++i) {
            if (i == 0) {
                field.append(fields[i]);
                continue;
            }
            field.append('.');
            String f = fields[i];
            field.append(f.substring(0, 1).toUpperCase());
            field.append(f.substring(1, f.length()));
        }
        return field.toString();
    }

    public String getStartIfDirective(String fieldName, boolean exists) {
        StringBuilder directive = new StringBuilder(START_IF_DIRECTIVE);
        if (fieldName.charAt(0) != '$') {
            directive.append('$');
        }
        directive.append(fieldName);
        directive.append(')');
        return directive.toString();
    }

    public String getEndIfDirective(String fieldName) {
        return "#{end}";
    }

    public String getLoopCountDirective(String fieldName) {
        return VELOCITY_COUNT;
    }

    public boolean containsInterpolation(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return false;
        }
        int dollarIndex = content.indexOf(36);
        return dollarIndex != -1;
    }

    public int extractListDirectiveInfo(String content, DirectivesStack directives, boolean dontRemoveListDirectiveInfo) {
        int startOfStartIfDirectiveIndex;
        int startOfEndListDirectiveIndex = content.indexOf("#{end}");
        int startOfStartListDirectiveIndex = content.indexOf(START_FOREACH_DIRECTIVE);
        AbstractDocumentFormatter.DirectiveToParse directiveToParse = this.getDirectiveToParse(startOfStartListDirectiveIndex, startOfEndListDirectiveIndex, startOfStartIfDirectiveIndex = content.indexOf(START_IF_DIRECTIVE), startOfEndListDirectiveIndex);
        if (directiveToParse == null) {
            return 0;
        }
        switch (directiveToParse) {
            case START_LOOP: {
                return this.parseStartLoop(content, directives, startOfStartListDirectiveIndex);
            }
            case START_IF: {
                return this.parseStartIf(content, directives, startOfStartIfDirectiveIndex);
            }
            case END_IF: 
            case END_LOOP: {
                return this.parseEndDirective(content, directives, dontRemoveListDirectiveInfo, startOfEndListDirectiveIndex);
            }
        }
        return 0;
    }

    public int parseEndDirective(String content, DirectivesStack directives, boolean dontRemoveListDirectiveInfo, int startOfEndListDirectiveIndex) {
        if (!dontRemoveListDirectiveInfo && !directives.isEmpty()) {
            directives.pop();
        }
        String afterEndList = content.substring("#{end}".length() + startOfEndListDirectiveIndex, content.length());
        int nbLoop = -1;
        return nbLoop += this.extractListDirectiveInfo(afterEndList, directives);
    }

    public int parseStartIf(String content, DirectivesStack directives, int startOfStartIfDirectiveIndex) {
        String contentWhichStartsWithIf = content.substring(startOfStartIfDirectiveIndex, content.length());
        int endOfStartIfDirectiveIndex = contentWhichStartsWithIf.indexOf(41);
        if (endOfStartIfDirectiveIndex == -1) {
            return 0;
        }
        String startIfDirective = contentWhichStartsWithIf.substring(0, endOfStartIfDirectiveIndex + 1);
        int nbIf = 1;
        directives.push((Object)new IfDirective(directives.peekOrNull(), startIfDirective, this.getEndIfDirective(null)));
        String afterIf = content.substring(startOfStartIfDirectiveIndex + startIfDirective.length(), content.length());
        return nbIf += this.extractListDirectiveInfo(afterIf, directives);
    }

    public int parseStartLoop(String content, DirectivesStack directives, int startOfStartListDirectiveIndex) {
        String contentWhichStartsWithList = content.substring(startOfStartListDirectiveIndex, content.length());
        int endOfStartListDirectiveIndex = contentWhichStartsWithList.indexOf(41);
        if (endOfStartListDirectiveIndex == -1) {
            return 0;
        }
        String startLoopDirective = contentWhichStartsWithList.substring(0, endOfStartListDirectiveIndex + 1);
        String insideLoop = startLoopDirective.substring(START_FOREACH_DIRECTIVE.length(), startLoopDirective.length());
        int indexBeforeIn = insideLoop.indexOf(" ");
        if (indexBeforeIn == -1) {
            return 0;
        }
        String afterItem = insideLoop.substring(indexBeforeIn, insideLoop.length());
        int indexAfterIn = afterItem.indexOf(IN_DIRECTIVE);
        if (indexAfterIn == -1) {
            return 0;
        }
        String item = insideLoop.substring(0, indexBeforeIn).trim();
        if (item.charAt(0) == '$') {
            item = item.substring(1, item.length());
        }
        if (StringUtils.isEmpty((String)item)) {
            return 0;
        }
        String afterIn = afterItem.substring(IN_DIRECTIVE.length(), afterItem.length());
        int endListIndex = afterIn.indexOf(41);
        if (endListIndex == -1) {
            return 0;
        }
        String sequence = afterIn.substring(0, endListIndex).trim();
        if (sequence.charAt(0) == '$') {
            sequence = sequence.substring(1, sequence.length());
        }
        if (StringUtils.isEmpty((String)sequence)) {
            return 0;
        }
        int nbLoop = 1;
        directives.push((Object)new LoopDirective(directives.peekOrNull(), startLoopDirective, this.getEndLoopDirective(null), sequence, item));
        String afterList = content.substring(startOfStartListDirectiveIndex + startLoopDirective.length(), content.length());
        return nbLoop += this.extractListDirectiveInfo(afterList, directives);
    }

    public String extractModelTokenPrefix(String fieldName) {
        String fieldNameWithoutDollar;
        int lastDotIndex;
        if (fieldName == null) {
            return null;
        }
        int dollarIndex = fieldName.indexOf(36);
        if (dollarIndex == -1) {
            return null;
        }
        int endIndex = fieldName.indexOf(32);
        if (endIndex != -1) {
            fieldName = fieldName.substring(0, fieldName.length());
        }
        if ((lastDotIndex = (fieldNameWithoutDollar = fieldName.substring(dollarIndex + 1, fieldName.length())).lastIndexOf(46)) == -1) {
            return fieldNameWithoutDollar;
        }
        return fieldNameWithoutDollar.substring(0, lastDotIndex);
    }

    public int getIndexOfScript(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        return fieldName.indexOf("#");
    }

    public String formatAsCallTextStyling(long variableIndex, String fieldName, String documentKind, String syntaxKind, boolean syntaxWithDirective, String elementId, String entryName) {
        StringBuilder newContent = new StringBuilder(START_SET_DIRECTIVE);
        newContent.append(this.formatAsSimpleField(true, new String[]{this.getVariableName(variableIndex)}));
        newContent.append(EQUALS);
        newContent.append(this.getFunctionDirective("___TextStylingRegistry", "transform", new String[]{fieldName, "\"" + syntaxKind + "\"", syntaxWithDirective ? "true" : "false", "\"" + documentKind + "\"", "\"" + elementId + "\"", "$___context", "\"" + entryName + "\""}));
        newContent.append(END_SET_DIRECTIVE);
        return newContent.toString();
    }

    public String formatAsTextStylingField(long variableIndex, String property) {
        return this.formatAsSimpleField(true, new String[]{this.getVariableName(variableIndex), property});
    }

    public boolean hasDirective(String characters) {
        return characters.indexOf("#") != -1;
    }

    public String getSetDirective(String name, String value, boolean valueIsField) {
        StringBuilder newContent = new StringBuilder(START_SET_DIRECTIVE);
        newContent.append(this.formatAsSimpleField(true, new String[]{name}));
        newContent.append(EQUALS);
        if (valueIsField) {
            newContent.append(this.formatAsSimpleField(true, new String[]{value}));
        } else {
            value = this.addDollarIfNeed(value);
            newContent.append(value);
        }
        newContent.append(END_SET_DIRECTIVE);
        return newContent.toString();
    }

    public String getStartNoParse() {
        return START_NOPARSE;
    }

    public String getEndNoParse() {
        return END_NOPARSE;
    }

    public String getDefineDirective(String name, String value) {
        StringBuilder newContent = new StringBuilder(START_DEFINE_DIRECTIVE);
        newContent.append(this.formatAsSimpleField(true, new String[]{name}));
        newContent.append(CLOSE_DEFINE_DIRECTIVE);
        newContent.append(value);
        newContent.append(END_DEFINE_DIRECTIVE);
        return newContent.toString();
    }
}

