/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.DetailsStatsTableComponent;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.GroupStatsPath;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.stats.StatsPath;
import io.gatling.charts.template.GroupDetailsPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Color$Requests$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005-3Q\u0001C\u0005\u0001\u0017EA\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\t7\u0001\u0011\t\u0011)A\u00059!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"B\u001e\u0001\t\u0003a\u0004\"B\"\u0001\t\u0003!%aG$s_V\u0004H)\u001a;bS2\u001c(+\u001a9peR<UM\\3sCR|'O\u0003\u0002\u000b\u0017\u00051!/\u001a9peRT!\u0001D\u0007\u0002\r\rD\u0017M\u001d;t\u0015\tqq\"A\u0004hCRd\u0017N\\4\u000b\u0003A\t!![8\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005I\u0011BA\u000b\n\u0005=\u0011V\r]8si\u001e+g.\u001a:bi>\u0014\u0018a\u0006:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]&s\u0007/\u001e;t\u0007\u0001\u0001\"aE\r\n\u0005iI!a\u0006*fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]&s\u0007/\u001e;t\u0003-\u0019\u0007.\u0019:ug\u001aKG.Z:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}Y\u0011AB2p]\u001aLw-\u0003\u0002\"=\tY1\t[1siN4\u0015\u000e\\3t\u0003A\u0019w.\u001c9p]\u0016tG\u000fT5ce\u0006\u0014\u0018\u0010\u0005\u0002%O5\tQE\u0003\u0002'\u0017\u0005I1m\\7q_:,g\u000e^\u0005\u0003Q\u0015\u0012\u0001cQ8na>tWM\u001c;MS\n\u0014\u0018M]=\u0002\u000f\rD\u0017M]:fiB\u00111&M\u0007\u0002Y)\u0011\u0011&\f\u0006\u0003]=\n1A\\5p\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!A\r\u0017\u0003\u000f\rC\u0017M]:fi\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"!N\u001d\u000e\u0003YR!aH\u001c\u000b\u0005aj\u0011\u0001B2pe\u0016L!A\u000f\u001c\u0003)I+\u0007o\u001c:ug\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q1QHP A\u0003\n\u0003\"a\u0005\u0001\t\u000bY1\u0001\u0019\u0001\r\t\u000bm1\u0001\u0019\u0001\u000f\t\u000b\t2\u0001\u0019A\u0012\t\u000b%2\u0001\u0019\u0001\u0016\t\u000bM2\u0001\u0019\u0001\u001b\u0002\u0011\u001d,g.\u001a:bi\u0016$\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0005+:LG\u000f")
public class GroupDetailsReportGenerator
extends ReportGenerator {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    @Override
    public void generate() {
        this.reportsGenerationInputs.logFileData().statsPaths().foreach((Function1 & Serializable)x0$1 -> {
            GroupDetailsReportGenerator.$anonfun$generate$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final Component cumulatedResponseTimeChartComponent$1(Group group$1) {
        Iterable<PercentilesVsTimePlot> dataSuccess = this.reportsGenerationInputs.logFileData().groupCumulatedResponseTimePercentilesOverTime((Status)OK$.MODULE$, group$1);
        Series<PercentilesVsTimePlot> seriesSuccess = new Series<PercentilesVsTimePlot>("Group Cumulated Response Time Percentiles over Time (OK)", dataSuccess, Color$Requests$.MODULE$.Percentiles());
        return this.componentLibrary.getPercentilesOverTimeComponent("Cumulated Response Time", this.reportsGenerationInputs.logFileData().runInfo().injectStart(), seriesSuccess);
    }

    private final Component cumulatedResponseTimeDistributionChartComponent$1(Group group$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileData().groupCumulatedResponseTimeDistribution(100, group$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq distributionSuccess = (Seq)tuple2._1();
        Seq distributionFailure = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distributionSuccess, (Object)distributionFailure);
        Seq distributionSuccess2 = (Seq)tuple22._1();
        Seq distributionFailure2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> distributionSeriesSuccess = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)distributionSuccess2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> distributionSeriesFailure = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)distributionFailure2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Group Cumulated Response Time", "Groups", distributionSeriesSuccess, distributionSeriesFailure);
    }

    private final Component durationChartComponent$1(Group group$1) {
        Iterable<PercentilesVsTimePlot> dataSuccess = this.reportsGenerationInputs.logFileData().groupDurationPercentilesOverTime((Status)OK$.MODULE$, group$1);
        Series<PercentilesVsTimePlot> seriesSuccess = new Series<PercentilesVsTimePlot>("Group Duration Percentiles over Time (OK)", dataSuccess, Color$Requests$.MODULE$.Percentiles());
        return this.componentLibrary.getPercentilesOverTimeComponent("Duration", this.reportsGenerationInputs.logFileData().runInfo().injectStart(), seriesSuccess);
    }

    private final Component durationDistributionChartComponent$1(Group group$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileData().groupDurationDistribution(100, group$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq distributionSuccess = (Seq)tuple2._1();
        Seq distributionFailure = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distributionSuccess, (Object)distributionFailure);
        Seq distributionSuccess2 = (Seq)tuple22._1();
        Seq distributionFailure2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> distributionSeriesSuccess = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)distributionSuccess2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> distributionSeriesFailure = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)distributionFailure2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Group Duration", "Groups", distributionSeriesSuccess, distributionSeriesFailure);
    }

    private final void generateDetailPage$1(String path, Group group) {
        GroupDetailsPageTemplate template = new GroupDetailsPageTemplate(this.reportsGenerationInputs.logFileData().runInfo(), group, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Group Duration Ranges", "groups", true), new DetailsStatsTableComponent(this.configuration.indicators())})), new ErrorsTableComponent(this.reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group))), this.durationDistributionChartComponent$1(group), this.durationChartComponent$1(group), this.cumulatedResponseTimeDistributionChartComponent$1(group), this.cumulatedResponseTimeChartComponent$1(group)}));
        new TemplateWriter(this.chartsFiles.groupFile(path)).writeToFile(template.getOutput(), this.charset);
    }

    public static final /* synthetic */ void $anonfun$generate$1(GroupDetailsReportGenerator $this, StatsPath x0$1) {
        StatsPath statsPath = x0$1;
        if (statsPath instanceof GroupStatsPath) {
            GroupStatsPath groupStatsPath = (GroupStatsPath)statsPath;
            Group group = groupStatsPath.group();
            $this.generateDetailPage$1(RequestPath$.MODULE$.path(group), group);
            return;
        }
    }

    public GroupDetailsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, Charset charset, ReportsConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.charset = charset;
        this.configuration = configuration;
    }
}

