/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import java.util.Locale;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E4Q!\u0004\b\u0003!aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tY\u0001\u0011\t\u0011)A\u0005?!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003/\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u001d)\u0005A1A\u0005\n\u0019CaA\u0014\u0001!\u0002\u00139\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u00079\u0002\u0001\u000b\u0011B)\t\u000bu\u0003A\u0011\t0\t\u000b}\u0003A\u0011\u00021\t\u000bA\u0004A\u0011\t0\u0003)\u0011K7\u000f\u001e:jEV$\u0018n\u001c8UK6\u0004H.\u0019;f\u0015\ty\u0001#\u0001\u0005uK6\u0004H.\u0019;f\u0015\t\t\"#\u0001\u0006iS\u001eD7\r[1siNT!a\u0005\u000b\u0002\r\rD\u0017M\u001d;t\u0015\t)b#A\u0004hCRd\u0017N\\4\u000b\u0003]\t!![8\u0014\u0005\u0001I\u0002C\u0001\u000e\u001c\u001b\u0005q\u0011B\u0001\u000f\u000f\u0005!!V-\u001c9mCR,\u0017!\u0002;ji2,7\u0001\u0001\t\u0003A%r!!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011r\u0012A\u0002\u001fs_>$hHC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tAS%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015&\u0003%I\u0018\t_5t\u001d\u0006lW-A\u0007tk\u000e\u001cWm]:TKJLWm\u001d\t\u0004_Q:dB\u0001\u00193\u001d\t\u0011\u0013'C\u0001'\u0013\t\u0019T%A\u0004qC\u000e\\\u0017mZ3\n\u0005U2$aA*fc*\u00111'\n\t\u0003qmj\u0011!\u000f\u0006\u0003uI\tQa\u001d;biNL!\u0001P\u001d\u0003#A+'oY3oiZ\u001bH+[7f!2|G/A\u0007gC&dWO]3TKJLWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0001\u000b%i\u0011#\u0011\u0005i\u0001\u0001\"B\u000f\u0006\u0001\u0004y\u0002\"\u0002\u0017\u0006\u0001\u0004y\u0002\"B\u0017\u0006\u0001\u0004q\u0003\"B\u001f\u0006\u0001\u0004q\u0013aC2p]R\f\u0017N\\3s\u0013\u0012,\u0012a\u0012\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bA\u0001\\1oO*\tA*\u0001\u0003kCZ\f\u0017B\u0001\u0016J\u00031\u0019wN\u001c;bS:,'/\u00133!\u0003)\u0019\u0017\r^3h_JLWm]\u000b\u0002#B\u0019!k\u0016-\u000e\u0003MS!\u0001V+\u0002\u0013%lW.\u001e;bE2,'B\u0001,&\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003kM\u0003\"!\u0017.\u000e\u0003\u0015J!aW\u0013\u0003\u0007%sG/A\u0006dCR,wm\u001c:jKN\u0004\u0013A\u00016t+\u0005y\u0012!\u0007:f]\u0012,'o\u0015;bG.,GmQ8mk6t7+\u001a:jKN$BaH1gQ\")!m\u0003a\u0001G\u000611/\u001a:jKN\u00042a\f38\u0013\t)gG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001597\u00021\u0001 \u0003\u0011q\u0017-\\3\t\u000b%\\\u0001\u0019\u00016\u0002\u000b\r|Gn\u001c:\u0011\u0005-tW\"\u00017\u000b\u00055\u0014\u0012\u0001B;uS2L!a\u001c7\u0003\u000b\r{Gn\u001c:\u0002\t!$X\u000e\u001c")
public final class DistributionTemplate
extends Template {
    private final String title;
    private final String yAxisName;
    private final Seq<PercentVsTimePlot> successSeries;
    private final Seq<PercentVsTimePlot> failureSeries;
    private final String containerId;
    private final Seq<Object> categories;

    private String containerId() {
        return this.containerId;
    }

    private Seq<Object> categories() {
        return this.categories;
    }

    @Override
    public String js() {
        return "\nnew Highcharts.Chart({\n  chart: {\n    renderTo: '" + this.containerId() + "',\n    type: 'column',\n    marginBottom: 60\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: 5,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.title + " Distribution</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false\n  },\n  xAxis: {\n    categories: ['" + this.categories().mkString("', '") + "'],\n    tickInterval: 20\n  },\n  yAxis: {\n    min: 0,\n    title: { text: 'Percentage of " + this.yAxisName + "' },\n    reversedStacks: false\n  },\n  tooltip: {\n    formatter: function() {\n      return '<b>'+ this.x +' ms</b><br/>'+\n      this.series.name +': '+ this.y +' %<br/>'+\n      'Total: '+ this.point.stackTotal + ' %';\n    }\n  },\n  plotOptions: {\n    series: {\n      groupPadding: 0,\n      stacking: 'normal',\n\t    shadow: true\n    }\n  },\n  series: [\n  \t{" + this.renderStackedColumnSeries((Iterable<PercentVsTimePlot>)this.successSeries, Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok()) + "},\n  \t{" + this.renderStackedColumnSeries((Iterable<PercentVsTimePlot>)this.failureSeries, Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko()) + "}\n  ]\n});\n";
    }

    private String renderStackedColumnSeries(Iterable<PercentVsTimePlot> series, String name, Color color) {
        return "\ntype: 'column',\ncolor: '" + color + "',\nname: '" + name + "',\ndata: [\n  " + ((IterableOnceOps)series.map((Function1 & Serializable)plot -> BoxesRunTime.boxToDouble((double)DistributionTemplate.$anonfun$renderStackedColumnSeries$1(plot)))).mkString(",") + "\n],\ntooltip: { yDecimals: 0, ySuffix: 'ms' }\n";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId() + "\" class=\"geant\"></div>\n            </div>\n";
    }

    public static final /* synthetic */ double $anonfun$renderStackedColumnSeries$1(PercentVsTimePlot plot) {
        return (double)((int)(plot.value() * (double)100)) / 100.0;
    }

    public DistributionTemplate(String title, String yAxisName, Seq<PercentVsTimePlot> successSeries, Seq<PercentVsTimePlot> failureSeries) {
        this.title = title;
        this.yAxisName = yAxisName;
        this.successSeries = successSeries;
        this.failureSeries = failureSeries;
        this.containerId = title.replace(" ", "").toLowerCase(Locale.ROOT) + "DistributionContainer";
        this.categories = (Seq)(successSeries.nonEmpty() ? successSeries : failureSeries).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.time()));
    }
}

