/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.utils;

import io.seata.saga.proctrl.ProcessContext;
import java.util.Collection;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class LoopContextHolder {
    private final AtomicInteger nrOfInstances = new AtomicInteger();
    private final AtomicInteger nrOfActiveInstances = new AtomicInteger();
    private final AtomicInteger nrOfCompletedInstances = new AtomicInteger();
    private volatile boolean failEnd = false;
    private volatile boolean completionConditionSatisfied = false;
    private final Stack<Integer> loopCounterStack = new Stack();
    private final Stack<Integer> forwardCounterStack = new Stack();
    private Collection collection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoopContextHolder getCurrent(ProcessContext context, boolean forceCreate) {
        LoopContextHolder loopContextHolder = (LoopContextHolder)context.getVariable("_current_loop_context_holder_");
        if (null == loopContextHolder && forceCreate) {
            ProcessContext processContext = context;
            synchronized (processContext) {
                loopContextHolder = (LoopContextHolder)context.getVariable("_current_loop_context_holder_");
                if (null == loopContextHolder) {
                    loopContextHolder = new LoopContextHolder();
                    context.setVariable("_current_loop_context_holder_", loopContextHolder);
                }
            }
        }
        return loopContextHolder;
    }

    public static void clearCurrent(ProcessContext context) {
        context.removeVariable("_current_loop_context_holder_");
    }

    public AtomicInteger getNrOfInstances() {
        return this.nrOfInstances;
    }

    public AtomicInteger getNrOfActiveInstances() {
        return this.nrOfActiveInstances;
    }

    public AtomicInteger getNrOfCompletedInstances() {
        return this.nrOfCompletedInstances;
    }

    public boolean isFailEnd() {
        return this.failEnd;
    }

    public void setFailEnd(boolean failEnd) {
        this.failEnd = failEnd;
    }

    public boolean isCompletionConditionSatisfied() {
        return this.completionConditionSatisfied;
    }

    public void setCompletionConditionSatisfied(boolean completionConditionSatisfied) {
        this.completionConditionSatisfied = completionConditionSatisfied;
    }

    public Stack<Integer> getLoopCounterStack() {
        return this.loopCounterStack;
    }

    public Stack<Integer> getForwardCounterStack() {
        return this.forwardCounterStack;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }
}

