/*
 * Decompiled with CFR 0.152.
 */
package mp.isrpapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mp.constant.IsrpConstant;
import mp.constant.UrlConstant;
import mp.isrpapi.IsrpUtil;
import mp.model.FileElementModel;
import mp.model.IsrpResult;
import mp.model.ResultModel;
import mp.model.TxnElementModel;
import mp.tools.StringUtil;
import org.apache.log4j.Logger;

public class BaseProcess {
    private static Logger logger = Logger.getLogger(BaseProcess.class);

    public Boolean httpSend(String urlStr, Map<String, String> textMap, StringBuffer resp) {
        return this.httpSend(urlStr, textMap, null, resp);
    }

    protected Boolean httpSend(String urlStr, Map<String, String> textMap, Hashtable<String, String> lis, StringBuffer resp) {
        boolean flag;
        String res;
        block17: {
            res = "";
            HttpURLConnection conn = null;
            flag = true;
            String BOUNDARY = "------1238217421187160";
            try {
                try {
                    URL url = new URL(urlStr);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Charset", "UTF-8");
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(30000);
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                    DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                    if (textMap != null) {
                        StringBuffer strBuf = new StringBuffer();
                        for (Map.Entry<String, String> entry : textMap.entrySet()) {
                            String inputName = entry.getKey();
                            String inputValue = entry.getValue();
                            if (inputValue == null) continue;
                            strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                            strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                            strBuf.append(inputValue);
                        }
                        ((OutputStream)out).write(strBuf.toString().getBytes("utf-8"));
                        strBuf = null;
                    }
                    if (lis != null && lis.size() > 0) {
                        StringBuffer strBuf;
                        Iterator<String> iter = lis.keySet().iterator();
                        String inputName = "files";
                        while (iter.hasNext()) {
                            String filename = iter.next().toString();
                            String filePath = lis.get(filename);
                            if (filePath == null) continue;
                            File file = new File(filePath);
                            if (StringUtil.isEmpty(filename)) {
                                filename = file.getName();
                            }
                            String contentType = filename.substring(filename.indexOf(".") + 1);
                            strBuf = new StringBuffer();
                            strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                            strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + filename + "\"\r\n");
                            strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                            ((OutputStream)out).write(strBuf.toString().getBytes());
                            DataInputStream in = new DataInputStream(new FileInputStream(file));
                            int bytes = 0;
                            byte[] bufferOut = new byte[1024];
                            while ((bytes = in.read(bufferOut)) != -1) {
                                ((OutputStream)out).write(bufferOut, 0, bytes);
                            }
                            in.close();
                        }
                        strBuf = null;
                    }
                    byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
                    ((OutputStream)out).write(endData);
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                    StringBuffer strBuf = new StringBuffer();
                    if (conn.getResponseCode() == 200) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            strBuf.append(line).append("\n");
                        }
                        res = strBuf.toString();
                        reader.close();
                        reader = null;
                    } else {
                        flag = false;
                        res = "\u8fde\u63a5\u5f02\u5e38\uff0c\u8fd4\u56de\u4ee3\u7801:" + conn.getResponseCode();
                    }
                    strBuf = null;
                }
                catch (Exception e) {
                    flag = false;
                    res = e.getMessage();
                    logger.error((Object)("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u9519\u3002" + urlStr));
                    e.printStackTrace();
                    if (conn != null) {
                        conn.disconnect();
                        conn = null;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    conn.disconnect();
                    conn = null;
                }
                throw throwable;
            }
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        resp.append(res);
        return flag;
    }

    protected Map<String, String> httpDownLoadFiles(Vector<String> urlList, String fileDir, StringBuffer resp) {
        ExecutorService pool = null;
        HttpURLConnection connection = null;
        HashMap<String, String> fileList = new HashMap<String, String>();
        try {
            try {
                int i = 0;
                while (i < urlList.size()) {
                    String url;
                    pool = Executors.newCachedThreadPool();
                    Future<HttpURLConnection> future = pool.submit(new Callable<HttpURLConnection>(url = String.valueOf(urlList.get(i)) + "&token=" + IsrpUtil.getToken()){
                        private final /* synthetic */ String val$url;
                        {
                            this.val$url = string;
                        }

                        @Override
                        public HttpURLConnection call() throws Exception {
                            HttpURLConnection connection = null;
                            connection = (HttpURLConnection)new URL(this.val$url).openConnection();
                            connection.setConnectTimeout(50000);
                            connection.setReadTimeout(50000);
                            connection.setDoInput(true);
                            connection.setDoOutput(true);
                            connection.setRequestMethod("GET");
                            connection.connect();
                            return connection;
                        }
                    });
                    connection = future.get();
                    if (connection.getResponseCode() == 200) {
                        String field = connection.getHeaderField("Content-Disposition");
                        if (field != null) {
                            String tmpStr1 = field.substring(field.indexOf("filename") + 9);
                            String fileName = new String(tmpStr1.getBytes("ISO-8859-1"), "GB2312");
                            if (!StringUtil.isEmpty(fileName = URLDecoder.decode(fileName, "UTF-8"))) {
                                this.writeFile(new BufferedInputStream(connection.getInputStream()), fileName, fileDir);
                                if (new File(String.valueOf(fileDir) + fileName).length() > 0L) {
                                    fileList.put(fileName, String.valueOf(fileDir) + fileName);
                                } else {
                                    new File(String.valueOf(fileDir) + fileName).delete();
                                }
                            }
                        } else {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                resp.append(line);
                            }
                            reader.close();
                            reader = null;
                        }
                    } else {
                        logger.error((Object)("\u8fde\u63a5\u5f02\u5e38\uff0c\u8fd4\u56de\u4ee3\u7801:" + connection.getResponseCode()));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e);
                if (connection != null) {
                    connection.disconnect();
                }
                if (pool != null) {
                    pool.shutdown();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (pool != null) {
                pool.shutdown();
            }
        }
        return fileList;
    }

    private String getFilename(String url) {
        return "".equals(url) || url == null ? "" : url.substring(url.lastIndexOf("=") + 1, url.length());
    }

    private void writeFile(BufferedInputStream bufferedInputStream, String filename, String fileDir) {
        File destfileFile = new File(String.valueOf(fileDir) + filename);
        if (destfileFile.exists()) {
            destfileFile.delete();
        }
        if (!destfileFile.getParentFile().exists()) {
            destfileFile.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(destfileFile);
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = bufferedInputStream.read(b, 0, b.length)) != -1) {
                    fileOutputStream.write(b, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String httpRec(String urlAddr, String imgPath) {
        try {
            URL url = new URL(urlAddr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/html");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Charset", "UTF-8");
            conn.connect();
            conn.setConnectTimeout(10000);
            OutputStream out = conn.getOutputStream();
            if (!StringUtil.isEmpty(imgPath)) {
                File file = new File(imgPath);
                DataInputStream in = new DataInputStream(new FileInputStream(file));
                int bytes = 0;
                byte[] buffer = new byte[1024];
                while ((bytes = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes);
                }
                in.close();
                out.flush();
                out.close();
            }
            StringBuffer resp = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                resp.append(line);
            }
            String respStr = resp.toString();
            conn.disconnect();
            return respStr;
        }
        catch (Exception e) {
            logger.error((Object)("\u53d1\u9001\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01" + e));
            e.printStackTrace();
            return null;
        }
    }

    protected String httpRec(String urlAddr, InputStream input) {
        try {
            URL url = new URL(urlAddr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/html");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.connect();
            conn.setConnectTimeout(10000);
            OutputStream out = conn.getOutputStream();
            DataInputStream in = new DataInputStream(input);
            int bytes = 0;
            byte[] buffer = new byte[1024];
            while ((bytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
            }
            in.close();
            out.flush();
            out.close();
            StringBuffer resp = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                resp.append(line);
            }
            String respStr = resp.toString();
            conn.disconnect();
            return respStr;
        }
        catch (Exception e) {
            logger.error((Object)("\u53d1\u9001\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01" + e));
            e.printStackTrace();
            return null;
        }
    }

    protected String httpRec(String imgUrl, String recUrl, StringBuffer resp) {
        String recStr;
        block14: {
            recStr = "";
            ExecutorService pool = null;
            HttpURLConnection connection = null;
            try {
                try {
                    pool = Executors.newCachedThreadPool();
                    final String url1 = String.valueOf(imgUrl) + "&token=" + IsrpUtil.getToken();
                    Future<HttpURLConnection> future = pool.submit(new Callable<HttpURLConnection>(){

                        @Override
                        public HttpURLConnection call() throws Exception {
                            HttpURLConnection connection = null;
                            connection = (HttpURLConnection)new URL(url1).openConnection();
                            connection.setConnectTimeout(50000);
                            connection.setReadTimeout(50000);
                            connection.setDoInput(true);
                            connection.setDoOutput(true);
                            connection.setRequestMethod("GET");
                            connection.connect();
                            return connection;
                        }
                    });
                    connection = future.get();
                    if (connection.getResponseCode() == 200) {
                        String field = connection.getHeaderField("Content-Disposition");
                        if (field != null) {
                            String tmpStr1 = field.substring(field.indexOf("filename") + 9);
                            String fileName = new String(tmpStr1.getBytes("ISO-8859-1"), "GB2312");
                            if (!StringUtil.isEmpty(fileName = URLDecoder.decode(fileName, "UTF-8"))) {
                                recUrl = String.valueOf(recUrl) + "&imgName=" + fileName;
                                recStr = this.httpRec(recUrl, connection.getInputStream());
                            }
                        } else {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                resp.append(line);
                            }
                            reader.close();
                            reader = null;
                        }
                        break block14;
                    }
                    logger.error((Object)("\u8fde\u63a5\u5f02\u5e38\uff0c\u8fd4\u56de\u4ee3\u7801:" + connection.getResponseCode()));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (pool != null) {
                        pool.shutdown();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                if (pool != null) {
                    pool.shutdown();
                }
            }
        }
        return recStr;
    }

    protected String getUuid() {
        UUID uuid = UUID.randomUUID();
        String uid = uuid.toString();
        uid = uid.toUpperCase();
        uid = uid.replaceAll("-", "");
        return uid;
    }

    protected ResultModel fileCheck(String filepath) {
        ResultModel rmodel = new ResultModel();
        File file = new File(filepath);
        if (!file.exists()) {
            String msg = "\u3010\u5f02\u5e38\u3011\u672c\u5730\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01\u6587\u4ef6\u8def\u5f84\uff1a" + filepath;
            rmodel.setReasonId("9999");
            rmodel.setMsg(msg);
            return rmodel;
        }
        long maxSize = Long.valueOf(IsrpUtil.getFileSize()) * 1024L;
        long i = file.length() / 1024L;
        if (i > maxSize) {
            String msg = "\u3010\u5f02\u5e38\u3011\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u5e73\u53f0\u5bf9\u672c\u7cfb\u7edf\u7684\u6700\u5927\u9650\u5236[" + IsrpUtil.getFileSize() + "]M\u3002";
            rmodel.setReasonId("9999");
            rmodel.setMsg(msg);
            return rmodel;
        }
        rmodel.setReasonId("0000");
        return rmodel;
    }

    protected ResultModel synFilesOperate(TxnElementModel txnElement, List<FileElementModel> fileElementList, StringBuffer resp) {
        StringBuffer respRes;
        String urlStr;
        JSONObject obj = new JSONObject();
        obj.put("txnModel", (Object)txnElement);
        if (fileElementList != null && !fileElementList.isEmpty()) {
            obj.put("fileModelList", fileElementList);
        }
        String str = obj.toJSONString();
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("jsonstr", str);
        Hashtable<String, String> list = new Hashtable<String, String>();
        String fileName = "";
        String filePath = "";
        if (fileElementList != null && !fileElementList.isEmpty()) {
            for (FileElementModel fe : fileElementList) {
                if (StringUtil.isEmpty(fe.getFilePath())) continue;
                fileName = fe.getFileName();
                filePath = fe.getFilePath();
                if (StringUtil.isEmpty(fe.getFileName())) {
                    filePath = filePath.replace("\\", File.separator);
                    fileName = fe.getFilePath().substring(filePath.lastIndexOf(File.separator) + 1);
                }
                list.put(fileName, filePath);
            }
        }
        if (this.httpSend(urlStr = String.valueOf(IsrpUtil.getIsrpURL()) + UrlConstant.URL_FILEINFO_OP, textMap, list, respRes = new StringBuffer()).booleanValue()) {
            ResultModel result = null;
            IsrpResult isrpResult = (IsrpResult)JSON.parseObject((String)respRes.toString(), IsrpResult.class);
            if (isrpResult.getReasonId().equals(IsrpConstant.SUCCESS)) {
                if (isrpResult.getObj() != null) {
                    System.out.print(String.valueOf(isrpResult.getObj().toString()) + "\n");
                    result = (ResultModel)JSON.parseObject((String)isrpResult.getObj().toString(), ResultModel.class);
                    resp.append(result.getMsg());
                    if (result.getReasonId().equals(IsrpConstant.SUCCESS)) {
                        return result;
                    }
                    return null;
                }
            } else {
                resp.append(isrpResult.getMsg());
            }
            return result;
        }
        System.out.print(respRes.toString());
        return null;
    }

    protected Map<String, String> synFilesLoad(List<String> imageIdList, String imageDisType, String dir, StringBuffer resp) {
        String urlStr = String.valueOf(IsrpUtil.getIsrpURL()) + UrlConstant.URL_FILE;
        Vector<String> urlList = new Vector<String>();
        for (String imageId : imageIdList) {
            String urlParam = String.valueOf(urlStr) + "?imageId=" + imageId + "&imageDisType=" + imageDisType + "&userId=" + IsrpUtil.getUserId();
            urlList.add(urlParam);
        }
        if (StringUtil.isEmpty(dir)) {
            SimpleDateFormat time = new SimpleDateFormat("yyyyMMdd");
            String workDate = time.format(new Date());
            dir = String.valueOf(IsrpUtil.getLocalWorkPath()) + workDate + File.separator + this.getUuid() + File.separator;
        } else if (!(dir = dir.replace("\\", "/")).endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        StringBuffer respbuf = new StringBuffer();
        Map<String, String> resMap = this.httpDownLoadFiles(urlList, dir, respbuf);
        if (respbuf.length() > 0) {
            List isrpResult = JSON.parseArray((String)("[" + respbuf.toString() + "]"), IsrpResult.class);
            resp.append(String.valueOf(((IsrpResult)isrpResult.get(0)).getReasonId()) + "||" + ((IsrpResult)isrpResult.get(0)).getMsg() + "\n");
            return null;
        }
        if (resMap != null && !resMap.isEmpty()) {
            resp.append(String.valueOf(IsrpConstant.SUCCESS) + "||" + "\u6210\u529f\u4e0b\u8f7d\u6587\u4ef6[" + resMap.size() + "]\u5f20\u3002");
        } else {
            resp.append(String.valueOf(IsrpConstant.FAIL) + "||" + "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u4e0b\u8f7d\u6587\u4ef60\u5f20\uff01");
        }
        return resMap;
    }
}

